/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.bv;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.trie4j.bv.SuccinctBitVector;

public class BytesRank0OnlySuccinctBitVector
implements Externalizable,
SuccinctBitVector {
    private static final int CACHE_WIDTH = 64;
    private byte[] vector;
    private int size;
    private int[] countCache0;
    private static final int[] MASKS = new int[]{128, 192, 224, 240, 248, 252, 254, 255};
    private static final byte[] BITS = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    private static final byte[] BITCOUNTS0 = new byte[]{8, 7, 7, 6, 7, 6, 6, 5, 7, 6, 6, 5, 6, 5, 5, 4, 7, 6, 6, 5, 6, 5, 5, 4, 6, 5, 5, 4, 5, 4, 4, 3, 7, 6, 6, 5, 6, 5, 5, 4, 6, 5, 5, 4, 5, 4, 4, 3, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 7, 6, 6, 5, 6, 5, 5, 4, 6, 5, 5, 4, 5, 4, 4, 3, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 5, 4, 4, 3, 4, 3, 3, 2, 4, 3, 3, 2, 3, 2, 2, 1, 7, 6, 6, 5, 6, 5, 5, 4, 6, 5, 5, 4, 5, 4, 4, 3, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 5, 4, 4, 3, 4, 3, 3, 2, 4, 3, 3, 2, 3, 2, 2, 1, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 5, 4, 4, 3, 4, 3, 3, 2, 4, 3, 3, 2, 3, 2, 2, 1, 5, 4, 4, 3, 4, 3, 3, 2, 4, 3, 3, 2, 3, 2, 2, 1, 4, 3, 3, 2, 3, 2, 2, 1, 3, 2, 2, 1, 2, 1, 1, 0};
    private static final byte[] BITCOUNTS1 = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    private static final long serialVersionUID = -7658605229245494623L;

    public BytesRank0OnlySuccinctBitVector() {
        this(16);
    }

    public BytesRank0OnlySuccinctBitVector(int initialCapacity) {
        this.vector = new byte[BytesRank0OnlySuccinctBitVector.containerCount(initialCapacity, 8)];
        this.countCache0 = new int[BytesRank0OnlySuccinctBitVector.containerCount(this.vector.length, 8)];
    }

    public BytesRank0OnlySuccinctBitVector(byte[] bytes, int bits) {
        this.size = bits;
        this.vector = Arrays.copyOf(bytes, BytesRank0OnlySuccinctBitVector.containerCount(bits, 8));
        this.countCache0 = new int[BytesRank0OnlySuccinctBitVector.containerCount(this.vector.length, 8)];
        int sum = BITCOUNTS0[bytes[0] & 0xFF];
        int n = this.vector.length;
        for (int i = 1; i < n; ++i) {
            if (i % 8 == 0) {
                this.countCache0[i / 8 - 1] = sum;
            }
            sum += BITCOUNTS0[bytes[i] & 0xFF];
        }
        if (this.countCache0.length > 0) {
            this.countCache0[n / 8] = sum;
        }
    }

    public BytesRank0OnlySuccinctBitVector(byte[] vector, int size, int[] countCache0) {
        this.vector = vector;
        this.size = size;
        this.countCache0 = countCache0;
    }

    public byte[] getVector() {
        return this.vector;
    }

    public int[] getCountCache0() {
        return this.countCache0;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        int n = Math.min(this.size, 32);
        for (int i = 0; i < n; ++i) {
            b.append((this.vector[i / 8] & 128 >> i % 8) != 0 ? "1" : "0");
        }
        return b.toString();
    }

    @Override
    public boolean get(int pos) {
        return this.isOne(pos);
    }

    @Override
    public boolean isZero(int pos) {
        return (this.vector[pos / 8] & BITS[pos % 8]) == 0;
    }

    @Override
    public boolean isOne(int pos) {
        return (this.vector[pos / 8] & BITS[pos % 8]) != 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void trimToSize() {
        int size;
        int vectorSize = this.size / 8 + 1;
        this.vector = Arrays.copyOf(this.vector, Math.min(this.vector.length, vectorSize));
        int blockSize = 8;
        int countCacheSize0 = size = vectorSize / blockSize + (vectorSize % blockSize != 0 ? 1 : 0);
        this.countCache0 = Arrays.copyOf(this.countCache0, Math.min(this.countCache0.length, countCacheSize0));
    }

    @Override
    public void append1() {
        int i = this.size / 8;
        int ci = this.size / 64;
        if (i >= this.vector.length) {
            this.extend();
        }
        if (this.size % 64 == 0 && ci > 0) {
            this.countCache0[ci] = this.countCache0[ci - 1];
        }
        int r = this.size % 8;
        int n = i;
        this.vector[n] = (byte)(this.vector[n] | BITS[r]);
        ++this.size;
    }

    @Override
    public void append0() {
        int i = this.size / 8;
        int ci = this.size / 64;
        if (i >= this.vector.length) {
            this.extend();
        }
        if (this.size % 64 == 0 && ci > 0) {
            this.countCache0[ci] = this.countCache0[ci - 1];
        }
        int n = ci;
        this.countCache0[n] = this.countCache0[n] + 1;
        ++this.size;
    }

    @Override
    public int select0(int num) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int next0(int count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int select1(int num) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int rank0(int pos) {
        int ret;
        int cn = pos / 64;
        if ((pos + 1) % 64 == 0) {
            return this.countCache0[cn];
        }
        ret = cn > 0 ? (ret = this.countCache0[cn - 1]) : 0;
        int n = pos / 8;
        for (int i = cn * 8; i < n; ++i) {
            ret += BITCOUNTS0[this.vector[i] & 0xFF];
        }
        return ret + BITCOUNTS0[(this.vector[n] | ~MASKS[pos % 8]) & 0xFF];
    }

    @Override
    public int rank1(int pos) {
        int cn = pos / 64;
        if ((pos + 1) % 64 == 0) {
            return (cn + 1) * 64 - this.countCache0[cn];
        }
        int ret = cn > 0 ? cn * 64 - this.countCache0[cn - 1] : 0;
        int n = pos / 8;
        for (int i = cn * 64 / 8; i < n; ++i) {
            ret += BITCOUNTS1[this.vector[i] & 0xFF];
        }
        return ret + BITCOUNTS1[this.vector[n] & 128 >> pos % 8 & 0xFF];
    }

    @Override
    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        this.size = in.readInt();
        this.vector = (byte[])in.readObject();
        this.countCache0 = (int[])in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.trimToSize();
        out.writeInt(this.size);
        out.writeObject(this.vector);
        out.writeObject(this.countCache0);
    }

    private static int containerCount(int size, int unitSize) {
        return size / unitSize + (size % unitSize != 0 ? 1 : 0);
    }

    private void extend() {
        int vectorSize = (int)((double)this.vector.length * 1.2) + 1;
        this.vector = Arrays.copyOf(this.vector, vectorSize);
        int blockSize = 8;
        int size = vectorSize / blockSize + (vectorSize % blockSize != 0 ? 1 : 0);
        this.countCache0 = Arrays.copyOf(this.countCache0, size);
    }
}

