/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.array;

import java.io.Serializable;
import java.util.Arrays;

public final class LongArray
implements Serializable {
    private static final long serialVersionUID = -9133624434714616987L;
    private static final int MAX_ARRAY_BITS = 30;
    private static final int MAX_ARRAY_SIZE = 0x40000000;
    long size = 0L;
    long[][] data;
    private long[] first;

    public LongArray(long initialCapacity) {
        this.allocFor(initialCapacity, null);
    }

    private void allocFor(long capacity, long[][] old) {
        int numOuter = LongArray.o(capacity) + 1;
        int numInner = LongArray.i(capacity);
        this.data = new long[numOuter][];
        for (int i = 0; i < numOuter; ++i) {
            int currSize;
            int n = currSize = i == numOuter - 1 ? numInner : 0x40000000;
            this.data[i] = old == null || i >= old.length ? new long[currSize] : (currSize == old[i].length ? old[i] : Arrays.copyOf(old[i], currSize));
            if (i != 0) continue;
            this.first = this.data[i];
        }
    }

    protected static final int o(long l) {
        return (int)(l >>> 30);
    }

    protected static final int i(long l) {
        return (int)(l & 0x3FFFFFFFL);
    }

    public void set(long pos, long val) {
        if (pos >= this.size) {
            throw new ArrayIndexOutOfBoundsException("" + pos);
        }
        this.setHelp(pos, val);
    }

    private void setHelp(long pos, long val) {
        this.data[LongArray.o((long)pos)][LongArray.i((long)pos)] = val;
    }

    private void incrementHelp(long pos, long val) {
        long[] lArray = this.data[LongArray.o(pos)];
        int n = LongArray.i(pos);
        lArray[n] = lArray[n] + val;
    }

    public void setAndGrowIfNeeded(long pos, long val) {
        this.ensureCapacity(pos + 1L);
        this.setGrowHelp(pos, val);
    }

    public void setAndGrowIfNeededFill(long pos, long val) {
        this.ensureCapacity(pos + 1L);
        long oldSize = this.size;
        this.size = Math.max(this.size, pos + 1L);
        for (long i = oldSize; i < this.size; ++i) {
            this.setHelp(i, val);
        }
    }

    private void setGrowHelp(long pos, long val) {
        this.size = Math.max(this.size, pos + 1L);
        this.setHelp(pos, val);
    }

    public void ensureCapacity(long minCapacity) {
        long oldCapacity = LongArray.sizeOf(this.data);
        if (minCapacity > oldCapacity) {
            long[][] oldData = this.data;
            long newCapacity = oldCapacity * 3L / 2L + 1L;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.allocFor(newCapacity, oldData);
        }
    }

    public long get(long pos) {
        assert (pos < this.size) : this.getClass().getName() + " array index out of bounds";
        return this.getHelp(pos);
    }

    private static long sizeOf(long[][] a) {
        long ret = 0L;
        for (int i = 0; i < a.length; ++i) {
            ret += (long)a[i].length;
        }
        return ret;
    }

    public void trim() {
        this.allocFor(this.size, this.data);
    }

    private long getHelp(long pos) {
        int i = LongArray.i(pos);
        int o = LongArray.o(pos);
        return o == 0 ? this.first[i] : this.data[o][i];
    }

    public static void main(String[] argv) {
        long mem = Runtime.getRuntime().maxMemory();
        System.out.println("VM size is " + mem);
        long pos = 0x3FFFFFF6L;
        LongArray b = new LongArray(pos + 1L);
        long val = 10000000000000L;
        b.setAndGrowIfNeeded(pos, 10000000000000L);
        long z = b.get(pos);
        assert (z == 10000000000000L);
        System.out.println("Finished with value " + z + " for " + 10000000000000L);
    }

    public long size() {
        return this.size;
    }

    public boolean add(long val) {
        this.setAndGrowIfNeeded(this.size, val);
        return true;
    }

    public boolean addWithFixedCapacity(long val) {
        this.setGrowHelp(this.size, val);
        return true;
    }

    public void shift(long src, long dest, int length) {
        if (length == 0) {
            return;
        }
        if (src == dest) {
            return;
        }
        assert (dest >= src);
        int oStart = LongArray.o(src);
        int oEnd = LongArray.o(src + (long)length);
        int oDestStart = LongArray.o(dest);
        int oDestEnd = LongArray.o(dest + (long)length);
        if (dest + (long)length >= this.size) {
            this.setAndGrowIfNeeded(dest + (long)length, 0L);
        }
        if (oStart != oEnd || oDestStart != oDestEnd) {
            for (long i = (long)(length - 1); i >= 0L; --i) {
                this.set(dest + i, this.get(src + i));
            }
        } else {
            System.arraycopy(this.data[LongArray.o(src)], LongArray.i(src), this.data[LongArray.o(dest)], LongArray.i(dest), length);
        }
    }

    public void trimToSize(long size_) {
        this.size = size_;
        this.allocFor(size_, this.data);
    }

    public void fill(long l, long n) {
        for (long i = 0L; i < n; ++i) {
            this.setAndGrowIfNeeded(i, l);
        }
    }

    public long linearSearch(long key, long rangeStart, long rangeEnd, long startIndex, long emptyKey, boolean returnFirstEmptyIndex) {
        long searchKey;
        long i;
        for (i = startIndex; i < rangeEnd; ++i) {
            searchKey = this.getHelp(i);
            if (searchKey == key) {
                return i;
            }
            if (searchKey != emptyKey) continue;
            return returnFirstEmptyIndex ? i : -1L;
        }
        for (i = rangeStart; i < startIndex; ++i) {
            searchKey = this.getHelp(i);
            if (searchKey == key) {
                return i;
            }
            if (searchKey != emptyKey) continue;
            return returnFirstEmptyIndex ? i : -1L;
        }
        return -1L;
    }

    public void incrementCount(long index, long count) {
        if (index >= this.size) {
            this.setAndGrowIfNeeded(index, count);
        } else {
            this.incrementHelp(index, count);
        }
    }

    public static final class StaticMethods {
        public static LongArray newLongArray(long maxKeySize, long maxNumKeys) {
            return StaticMethods.newLongArray(maxKeySize, maxNumKeys, 10L);
        }

        public static LongArray newLongArray(long maxKeySize, long maxNumKeys, long initCapacity) {
            return new LongArray(initCapacity);
        }
    }
}

