/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters4.xml.openxml;

import java.awt.Window;
import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.filters3.xml.openxml.EditOpenXMLOptionsDialog;
import org.omegat.filters3.xml.openxml.OpenXMLOptions;
import org.omegat.filters4.AbstractZipFilter;
import org.omegat.filters4.xml.openxml.OpenXmlFilter;
import org.omegat.util.Log;
import org.omegat.util.OStrings;

public class MsOfficeFileFilter
extends AbstractZipFilter {
    private String DOCUMENTS;
    private Pattern TRANSLATABLE;
    private static final Pattern DIGITS = Pattern.compile("(\\d+)\\.xml");

    private void defineDOCUMENTSOptions(Map<String, String> config) {
        this.DOCUMENTS = "(document\\d?\\.xml)";
        OpenXMLOptions options = new OpenXMLOptions(config);
        if (options.getTranslateComments()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(comments\\.xml)";
        }
        if (options.getTranslateFootnotes()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(footnotes\\.xml)";
        }
        if (options.getTranslateEndnotes()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(endnotes\\.xml)";
        }
        if (options.getTranslateHeaders()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(header\\d+\\.xml)";
        }
        if (options.getTranslateFooters()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(footer\\d+\\.xml)";
        }
        this.DOCUMENTS = this.DOCUMENTS + "|(sharedStrings\\.xml)";
        if (options.getTranslateExcelComments()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(comments\\d+\\.xml)";
        }
        this.DOCUMENTS = this.DOCUMENTS + "|(slide\\d+\\.xml)";
        if (options.getTranslateSlideMasters()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(slideMaster\\d+\\.xml)";
        }
        if (options.getTranslateSlideLayouts()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(slideLayout\\d+\\.xml)";
        }
        if (options.getTranslateSlideComments()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(notesSlide\\d+\\.xml)";
        }
        if (options.getTranslateDiagrams()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(data\\d+\\.xml)";
        }
        if (options.getTranslateCharts()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(chart\\d+\\.xml)";
        }
        if (options.getTranslateDrawings()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(drawing\\d+\\.xml)";
        }
        if (options.getTranslateSheetNames()) {
            this.DOCUMENTS = this.DOCUMENTS + "|(workbook\\.xml)";
        }
        this.DOCUMENTS = this.DOCUMENTS + "|(page\\d+\\.xml)";
        this.TRANSLATABLE = Pattern.compile(this.DOCUMENTS);
    }

    public MsOfficeFileFilter() {
        this.defineDOCUMENTSOptions(new HashMap<String, String>());
    }

    @Override
    public boolean isFileSupported(File inFile, Map<String, String> config, FilterContext context) {
        this.defineDOCUMENTSOptions(config);
        return super.isFileSupported(inFile, config, context);
    }

    @Override
    public String getFileFormatName() {
        return OStrings.getString("MSOFFICE4_FILTER_NAME");
    }

    @Override
    protected boolean requirePrevNextFields() {
        return true;
    }

    @Override
    protected boolean acceptInternalFile(ZipEntry entry, FilterContext fc) {
        return entry.getName().endsWith("document.xml") || entry.getName().endsWith("document2.xml") || entry.getName().endsWith("sharedStrings.xml") || entry.getName().endsWith("slide1.xml") || entry.getName().endsWith("page1.xml");
    }

    @Override
    protected boolean mustTranslateInternalFile(ZipEntry entry, boolean writeMode, FilterContext fc) {
        if (writeMode && entry.getName().contains("word") && entry.getName().contains("styles")) {
            return true;
        }
        return this.TRANSLATABLE.matcher(this.removePath(entry.getName())).matches();
    }

    @Override
    protected boolean mustDeleteInternalFile(ZipEntry entry, boolean writeMode, FilterContext context) {
        if (entry.getName().endsWith("comments.xml")) {
            return !this.DOCUMENTS.contains("comments");
        }
        return false;
    }

    private String removePath(String fileName) {
        if (fileName.lastIndexOf(47) >= 0) {
            fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
        }
        if (fileName.lastIndexOf(92) >= 0) {
            fileName = fileName.substring(fileName.lastIndexOf(92) + 1);
        }
        return fileName;
    }

    @Override
    protected Comparator<ZipEntry> getEntryComparator() {
        return (z1, z2) -> {
            int index2;
            int index1;
            String s1 = z1.getName();
            String s2 = z2.getName();
            String[] words1 = s1.split("\\d+\\.");
            String[] words2 = s2.split("\\d+\\.");
            if (words1.length > 1 && words2.length > 1 && words1[0].equals(words2[0])) {
                int number1 = 0;
                int number2 = 0;
                Matcher getDigits = DIGITS.matcher(s1);
                if (getDigits.find()) {
                    number1 = Integer.parseInt(getDigits.group(1));
                }
                if ((getDigits = DIGITS.matcher(s2)).find()) {
                    number2 = Integer.parseInt(getDigits.group(1));
                }
                if (number1 > number2) {
                    return 1;
                }
                if (number1 < number2) {
                    return -1;
                }
                return 0;
            }
            String shortname1 = this.removePath(words1[0]);
            String shortname2 = this.removePath(words2[0]);
            if (shortname1.indexOf("sharedStrings") >= 0 || shortname2.indexOf("sharedStrings") >= 0) {
                if (shortname2.indexOf("sharedStrings") >= 0) {
                    return 1;
                }
                return -1;
            }
            if (shortname1.endsWith(".xml")) {
                shortname1 = shortname1.substring(0, shortname1.lastIndexOf(46));
            }
            if (shortname2.endsWith(".xml")) {
                shortname2 = shortname2.substring(0, shortname2.lastIndexOf(46));
            }
            if ((index1 = this.DOCUMENTS.indexOf(shortname1)) > (index2 = this.DOCUMENTS.indexOf(shortname2))) {
                return 1;
            }
            if (index1 < index2) {
                return -1;
            }
            return s1.compareTo(s2);
        };
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.doc?"), new Instance("*.dotx"), new Instance("*.ppt?"), new Instance("*.vsdx")};
    }

    @Override
    public boolean hasOptions() {
        return true;
    }

    @Override
    public Map<String, String> changeOptions(Window parent, Map<String, String> currentOptions) {
        try {
            EditOpenXMLOptionsDialog dialog = new EditOpenXMLOptionsDialog(parent, currentOptions);
            dialog.setVisible(true);
            if (1 == dialog.getReturnStatus()) {
                return dialog.getOptions().getOptionsMap();
            }
            return null;
        }
        catch (Exception e) {
            Log.logErrorRB("HTML_EXC_EDIT_OPTIONS", new Object[0]);
            Log.log(e);
            return null;
        }
    }

    @Override
    protected OpenXmlFilter getFilter(ZipEntry ze) {
        OpenXmlFilter filter = new OpenXmlFilter(this.DOCUMENTS.contains("comments"));
        filter.setCallbacks(this.entryParseCallback, this.entryTranslateCallback);
        return filter;
    }
}

