/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.event.DockableStateWillChangeEvent;
import com.vlsolutions.swing.docking.event.DockableStateWillChangeListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.filelist.ProjectFilesListController;
import org.omegat.gui.main.MainWindow;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.UIDesignManager;
import org.openide.awt.Mnemonics;

public final class MainWindowUI {
    public static final String UI_LAYOUT_FILE = "uiLayout" + OStrings.getBrandingToken() + ".xml";

    private MainWindowUI() {
    }

    public static void createMainComponents(MainWindow mainWindow, Font font) {
        mainWindow.projWin = new ProjectFilesListController(mainWindow);
    }

    public static DockingDesktop initDocking(MainWindow mainWindow) {
        mainWindow.desktop = new DockingDesktop();
        mainWindow.desktop.addDockableStateWillChangeListener(new DockableStateWillChangeListener(){

            public void dockableStateWillChange(DockableStateWillChangeEvent event) {
                if (event.getFutureState().isClosed()) {
                    event.cancel();
                }
            }
        });
        return mainWindow.desktop;
    }

    public static void handlePerProjectLayouts(MainWindow mainWindow) {
        PerProjectLayoutHandler handler = new PerProjectLayoutHandler(mainWindow);
        CoreEvents.registerProjectChangeListener(handler);
        CoreEvents.registerApplicationEventListener(handler);
    }

    public static JPanel createStatusBar(MainWindow mainWindow) {
        mainWindow.statusLabel = new JLabel();
        mainWindow.progressLabel = new JLabel();
        mainWindow.lengthLabel = new JLabel();
        mainWindow.lockInsertLabel = new JLabel();
        Font defaultFont = mainWindow.statusLabel.getFont();
        float smallFontSize = (float)defaultFont.getSize() * 0.85f;
        mainWindow.statusLabel.setFont(defaultFont.deriveFont(smallFontSize));
        Border border = UIManager.getBorder("OmegaTStatusArea.border");
        StatusBarMode progressMode = Preferences.getPreferenceEnumDefault("sb_progress_mode", StatusBarMode.DEFAULT);
        String statusText = OStrings.getString("MW_PROGRESS_DEFAULT");
        String tooltipText = "MW_PROGRESS_TOOLTIP";
        if (progressMode == StatusBarMode.PERCENTAGE) {
            statusText = OStrings.getProgressBarDefaultPrecentageText();
            tooltipText = "MW_PROGRESS_TOOLTIP_PERCENTAGE";
        }
        Mnemonics.setLocalizedText((JLabel)mainWindow.progressLabel, (String)statusText);
        mainWindow.progressLabel.setToolTipText(OStrings.getString(tooltipText));
        mainWindow.progressLabel.setBorder(border);
        mainWindow.progressLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                StatusBarMode[] modes = StatusBarMode.values();
                StatusBarMode progressMode = Preferences.getPreferenceEnumDefault("sb_progress_mode", StatusBarMode.DEFAULT);
                progressMode = modes[(progressMode.ordinal() + 1) % modes.length];
                Preferences.setPreference("sb_progress_mode", (Object)progressMode);
                String statusText = OStrings.getString("MW_PROGRESS_DEFAULT");
                String tooltipText = "MW_PROGRESS_TOOLTIP";
                if (progressMode == StatusBarMode.PERCENTAGE) {
                    statusText = OStrings.getProgressBarDefaultPrecentageText();
                    tooltipText = "MW_PROGRESS_TOOLTIP_PERCENTAGE";
                }
                if (Core.getProject().isProjectLoaded()) {
                    ((EditorController)Core.getEditor()).showStat();
                } else {
                    Core.getMainWindow().showProgressMessage(statusText);
                }
                ((MainWindow)Core.getMainWindow()).setProgressToolTipText(OStrings.getString(tooltipText));
            }
        });
        Mnemonics.setLocalizedText((JLabel)mainWindow.lengthLabel, (String)OStrings.getString("MW_SEGMENT_LENGTH_DEFAULT"));
        mainWindow.lengthLabel.setToolTipText(OStrings.getString("MW_SEGMENT_LENGTH_TOOLTIP"));
        mainWindow.lengthLabel.setBorder(border);
        mainWindow.lengthLabel.setFocusable(false);
        JPanel statusPanel2 = new JPanel(new FlowLayout(2));
        statusPanel2.add(mainWindow.lockInsertLabel);
        statusPanel2.add(mainWindow.progressLabel);
        statusPanel2.add(mainWindow.lengthLabel);
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.add((Component)mainWindow.statusLabel, "Center");
        statusPanel.add((Component)statusPanel2, "East");
        statusPanel.setBorder(UIManager.getBorder("OmegaTMainWindowBottomMargin.border"));
        Color bgColor = UIManager.getColor("AutoHideButtonPanel.background");
        if (bgColor != null) {
            statusPanel.setBackground(bgColor);
            statusPanel2.setBackground(bgColor);
        }
        return statusPanel;
    }

    public static void initializeScreenLayout(MainWindow mainWindow) {
        Rectangle localAvailableSpace = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        int screenWidth = localAvailableSpace.width;
        int screenHeight = localAvailableSpace.height;
        int omegatWidth = 1500;
        int omegatHeight = 1080;
        if (omegatWidth > screenWidth) {
            omegatWidth = screenWidth;
        }
        if (omegatHeight > screenHeight) {
            omegatHeight = screenHeight;
        }
        int omegatLeftPosition = (screenWidth - omegatWidth) / 2;
        Rectangle defaultWindowSize = new Rectangle(omegatLeftPosition, 0, omegatWidth, omegatHeight);
        mainWindow.setBounds(defaultWindowSize);
        StaticUIUtils.persistGeometry(mainWindow, "screen");
        MainWindowUI.loadScreenLayoutFromPreferences(mainWindow);
        UIDesignManager.ensureDockablesVisible(mainWindow.desktop);
    }

    private static void loadScreenLayoutFromPreferences(MainWindow mainWindow) {
        File uiLayoutFile = new File(StaticUtils.getConfigDir(), UI_LAYOUT_FILE);
        if (uiLayoutFile.exists()) {
            MainWindowUI.loadScreenLayout(mainWindow, uiLayoutFile);
        } else {
            MainWindowUI.resetDesktopLayout(mainWindow);
        }
    }

    private static void loadScreenLayout(MainWindow mainWindow, File uiLayoutFile) {
        try (FileInputStream in = new FileInputStream(uiLayoutFile);){
            mainWindow.desktop.readXML((InputStream)in);
        }
        catch (Exception ex) {
            Log.log(ex);
            MainWindowUI.resetDesktopLayout(mainWindow);
        }
    }

    public static void saveScreenLayout(MainWindow mainWindow) {
        File uiLayoutFile = new File(StaticUtils.getConfigDir(), UI_LAYOUT_FILE);
        MainWindowUI.saveScreenLayout(mainWindow, uiLayoutFile);
    }

    private static void saveScreenLayout(MainWindow mainWindow, File uiLayoutFile) {
        try (FileOutputStream out = new FileOutputStream(uiLayoutFile);){
            mainWindow.desktop.writeXML((OutputStream)out);
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    public static void resetDesktopLayout(MainWindow mainWindow) {
        try (InputStream in = MainWindowUI.class.getResourceAsStream("DockingDefaults.xml");){
            mainWindow.desktop.readXML(in);
        }
        catch (Exception e) {
            Log.log(e);
        }
    }

    private static class PerProjectLayoutHandler
    implements IProjectEventListener,
    IApplicationEventListener {
        private final MainWindow mainWindow;
        private boolean didApplyPerProjectLayout = false;

        PerProjectLayoutHandler(MainWindow mainWindow) {
            this.mainWindow = mainWindow;
        }

        @Override
        public void onApplicationStartup() {
        }

        @Override
        public void onApplicationShutdown() {
            if (Core.getProject().isProjectLoaded() && this.didApplyPerProjectLayout) {
                MainWindowUI.loadScreenLayoutFromPreferences(this.mainWindow);
                this.didApplyPerProjectLayout = false;
            }
        }

        @Override
        public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
            if (eventType == IProjectEventListener.PROJECT_CHANGE_TYPE.CLOSE && this.didApplyPerProjectLayout) {
                MainWindowUI.loadScreenLayoutFromPreferences(this.mainWindow);
                this.didApplyPerProjectLayout = false;
                return;
            }
            if (!Core.getProject().isProjectLoaded()) {
                return;
            }
            File perProjLayout = this.getPerProjectLayout();
            if (!perProjLayout.isFile()) {
                return;
            }
            switch (eventType) {
                case LOAD: {
                    MainWindowUI.saveScreenLayout(this.mainWindow);
                    MainWindowUI.loadScreenLayout(this.mainWindow, perProjLayout);
                    this.didApplyPerProjectLayout = true;
                    break;
                }
                case SAVE: {
                    MainWindowUI.saveScreenLayout(this.mainWindow, perProjLayout);
                    break;
                }
            }
        }

        private File getPerProjectLayout() {
            return new File(Core.getProject().getProjectProperties().getProjectInternal(), UI_LAYOUT_FILE);
        }
    }

    public static enum StatusBarMode {
        DEFAULT,
        PERCENTAGE;

    }
}

