/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import com.datastax.driver.core.exceptions.AlreadyExistsException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.stress.settings.ConnectionAPI;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionCompaction;
import org.apache.cassandra.stress.settings.OptionReplication;
import org.apache.cassandra.stress.settings.OptionSimple;
import org.apache.cassandra.stress.settings.SettingsCommand;
import org.apache.cassandra.stress.settings.SettingsCommandUser;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.JavaDriverClient;
import org.apache.cassandra.stress.util.ResultLogger;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.utils.ByteBufferUtil;

public class SettingsSchema
implements Serializable {
    public static final String DEFAULT_VALIDATOR = "BytesType";
    private final String replicationStrategy;
    private final Map<String, String> replicationStrategyOptions;
    private final String compression;
    private final String compactionStrategy;
    private final Map<String, String> compactionStrategyOptions;
    public final String keyspace;

    public SettingsSchema(Options options, SettingsCommand command) {
        this.keyspace = command instanceof SettingsCommandUser ? ((SettingsCommandUser)command).profile.keyspaceName : options.keyspace.value();
        this.replicationStrategy = options.replication.getStrategy();
        this.replicationStrategyOptions = options.replication.getOptions();
        this.compression = options.compression.value();
        this.compactionStrategy = options.compaction.getStrategy();
        this.compactionStrategyOptions = options.compaction.getOptions();
    }

    public void createKeySpaces(StressSettings settings) {
        if (settings.mode.api != ConnectionAPI.JAVA_DRIVER_NATIVE) {
            this.createKeySpacesThrift(settings);
        } else {
            this.createKeySpacesNative(settings);
        }
    }

    public void createKeySpacesNative(StressSettings settings) {
        JavaDriverClient client = settings.getJavaDriverClient(false);
        try {
            client.execute(this.createKeyspaceStatementCQL3(), ConsistencyLevel.LOCAL_ONE);
            client.execute("USE \"" + this.keyspace + "\"", ConsistencyLevel.LOCAL_ONE);
            client.execute(this.createStandard1StatementCQL3(settings), ConsistencyLevel.LOCAL_ONE);
            client.execute(this.createCounter1StatementCQL3(settings), ConsistencyLevel.LOCAL_ONE);
            System.out.println(String.format("Created keyspaces. Sleeping %ss for propagation.", settings.node.nodes.size()));
            Thread.sleep((long)settings.node.nodes.size() * 1000L);
        }
        catch (AlreadyExistsException alreadyExistsException) {
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered exception creating schema", e);
        }
    }

    String createKeyspaceStatementCQL3() {
        StringBuilder b = new StringBuilder();
        b.append("CREATE KEYSPACE IF NOT EXISTS \"").append(this.keyspace).append("\" WITH replication = {'class': '").append(this.replicationStrategy).append("'");
        if (this.replicationStrategyOptions.isEmpty()) {
            b.append(", 'replication_factor': '1'}");
        } else {
            for (Map.Entry<String, String> entry : this.replicationStrategyOptions.entrySet()) {
                b.append(", '").append(entry.getKey()).append("' : '").append(entry.getValue()).append("'");
            }
            b.append("}");
        }
        b.append(" AND durable_writes = true;\n");
        return b.toString();
    }

    String createStandard1StatementCQL3(StressSettings settings) {
        StringBuilder b = new StringBuilder();
        b.append("CREATE TABLE IF NOT EXISTS ").append("standard1 (key blob PRIMARY KEY ");
        try {
            for (ByteBuffer byteBuffer : settings.columns.names) {
                b.append("\n, \"").append(ByteBufferUtil.string((ByteBuffer)byteBuffer)).append("\" blob");
            }
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
        b.append(") WITH COMPACT STORAGE AND compression = {");
        if (this.compression != null) {
            b.append("'sstable_compression' : '").append(this.compression).append("'");
        }
        b.append("}");
        if (this.compactionStrategy != null) {
            b.append(" AND compaction = { 'class' : '").append(this.compactionStrategy).append("'");
            for (Map.Entry entry : this.compactionStrategyOptions.entrySet()) {
                b.append(", '").append((String)entry.getKey()).append("' : '").append((String)entry.getValue()).append("'");
            }
            b.append("}");
        }
        b.append(";\n");
        return b.toString();
    }

    String createCounter1StatementCQL3(StressSettings settings) {
        StringBuilder b = new StringBuilder();
        b.append("CREATE TABLE IF NOT EXISTS ").append("counter1 (key blob PRIMARY KEY,");
        try {
            for (ByteBuffer byteBuffer : settings.columns.names) {
                b.append("\n, \"").append(ByteBufferUtil.string((ByteBuffer)byteBuffer)).append("\" counter");
            }
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
        b.append(") WITH COMPACT STORAGE AND compression = {");
        if (this.compression != null) {
            b.append("'sstable_compression' : '").append(this.compression).append("'");
        }
        b.append("}");
        if (this.compactionStrategy != null) {
            b.append(" AND compaction = { 'class' : '").append(this.compactionStrategy).append("'");
            for (Map.Entry entry : this.compactionStrategyOptions.entrySet()) {
                b.append(", '").append((String)entry.getKey()).append("' : '").append((String)entry.getValue()).append("'");
            }
            b.append("}");
        }
        b.append(";\n");
        return b.toString();
    }

    public void createKeySpacesThrift(StressSettings settings) {
        KsDef ksdef = new KsDef();
        CfDef standardCfDef = new CfDef(this.keyspace, "standard1");
        HashMap<String, String> compressionOptions = new HashMap<String, String>();
        if (this.compression != null) {
            compressionOptions.put("sstable_compression", this.compression);
        }
        String comparator = settings.columns.comparator;
        standardCfDef.setComparator_type(comparator).setDefault_validation_class(DEFAULT_VALIDATOR).setCompression_options(compressionOptions);
        for (int i = 0; i < settings.columns.names.size(); ++i) {
            standardCfDef.addToColumn_metadata(new ColumnDef(settings.columns.names.get(i), DEFAULT_VALIDATOR));
        }
        CfDef counterCfDef = new CfDef(this.keyspace, "counter1").setComparator_type(comparator).setDefault_validation_class("CounterColumnType").setCompression_options(compressionOptions);
        ksdef.setName(this.keyspace);
        ksdef.setStrategy_class(this.replicationStrategy);
        if (!this.replicationStrategyOptions.isEmpty()) {
            ksdef.setStrategy_options(this.replicationStrategyOptions);
        }
        if (this.compactionStrategy != null) {
            standardCfDef.setCompaction_strategy(this.compactionStrategy);
            counterCfDef.setCompaction_strategy(this.compactionStrategy);
            if (!this.compactionStrategyOptions.isEmpty()) {
                standardCfDef.setCompaction_strategy_options(this.compactionStrategyOptions);
                counterCfDef.setCompaction_strategy_options(this.compactionStrategyOptions);
            }
        }
        ksdef.setCf_defs(new ArrayList<CfDef>(Arrays.asList(standardCfDef, counterCfDef)));
        Cassandra.Client client = settings.getRawThriftClient(false);
        try {
            client.system_add_keyspace(ksdef);
            client.set_keyspace(this.keyspace);
            System.out.println(String.format("Created keyspaces. Sleeping %ss for propagation.", settings.node.nodes.size()));
            Thread.sleep((long)settings.node.nodes.size() * 1000L);
        }
        catch (InvalidRequestException e) {
            System.err.println("Unable to create stress keyspace: " + e.getWhy());
        }
        catch (Exception e) {
            System.err.println("!!!! " + e.getMessage());
        }
    }

    public void printSettings(ResultLogger out) {
        out.println("  Keyspace: " + this.keyspace);
        out.println("  Replication Strategy: " + this.replicationStrategy);
        out.println("  Replication Strategy Pptions: " + this.replicationStrategyOptions);
        out.println("  Table Compression: " + this.compression);
        out.println("  Table Compaction Strategy: " + this.compactionStrategy);
        out.println("  Table Compaction Strategy Options: " + this.compactionStrategyOptions);
    }

    public static SettingsSchema get(Map<String, String[]> clArgs, SettingsCommand command) {
        String[] params = clArgs.remove("-schema");
        if (params == null) {
            return new SettingsSchema(new Options(), command);
        }
        if (command instanceof SettingsCommandUser) {
            throw new IllegalArgumentException("-schema can only be provided with predefined operations insert, read, etc.; the 'user' command requires a schema yaml instead");
        }
        GroupedOptions options = GroupedOptions.select((String[])params, (GroupedOptions[])new Options[]{new Options()});
        if (options == null) {
            SettingsSchema.printHelp();
            System.out.println("Invalid -schema options provided, see output for valid options");
            System.exit(1);
        }
        return new SettingsSchema((Options)options, command);
    }

    public static void printHelp() {
        GroupedOptions.printOptions(System.out, "-schema", new Options());
    }

    public static Runnable helpPrinter() {
        return new Runnable(){

            @Override
            public void run() {
                SettingsSchema.printHelp();
            }
        };
    }

    private static final class Options
    extends GroupedOptions {
        final OptionReplication replication = new OptionReplication();
        final OptionCompaction compaction = new OptionCompaction();
        final OptionSimple keyspace = new OptionSimple("keyspace=", ".*", "keyspace1", "The keyspace name to use", false);
        final OptionSimple compression = new OptionSimple("compression=", ".*", null, "Specify the compression to use for sstable, default:no compression", false);

        private Options() {
        }

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.replication, this.keyspace, this.compaction, this.compression);
        }
    }
}

