package org.cdavies.itunes.hash;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import org.cdavies.itunes.utils.HexString;

public class Itunes4Hash implements ItunesHash {
	
	public static int HASH_SIZE = 32;
	
	private String _staticHash = null;
	private static String _appleCopyright = "Copyright 2003 Apple Computer, Inc.";
	
	public Itunes4Hash() throws NoSuchAlgorithmException {
		
		calculateStaticHash();
		
	}
	
	private void calculateStaticHash() throws NoSuchAlgorithmException {
		
		MessageDigest _md5sum = MessageDigest.getInstance("md5");
		
		StringBuffer _buf = new StringBuffer(8192);
		
		for (int i = 0; i < 256; i++) {
			
			if ((i & 0x80) != 0)
				_md5sum.update("Accept-Language".getBytes());
			else
				_md5sum.update("user-agent".getBytes());

			if ((i & 0x40) != 0)
				_md5sum.update("max-age".getBytes());
			else
				_md5sum.update("Authorization".getBytes());

			if ((i & 0x20) != 0)
				_md5sum.update("Client-DAAP-Version".getBytes());
			else
				_md5sum.update("Accept-Encoding".getBytes());

			if ((i & 0x10) != 0)
				_md5sum.update("daap.protocolversion".getBytes());
			else
				_md5sum.update("daap.songartist".getBytes());

			if ((i & 0x08) != 0)
				_md5sum.update("daap.songcomposer".getBytes());
			else
				_md5sum.update("daap.songdatemodified".getBytes());

			if ((i & 0x04) != 0)
				_md5sum.update("daap.songdiscnumber".getBytes());
			else
				_md5sum.update("daap.songdisabled".getBytes());

			if ((i & 0x02) != 0)
				_md5sum.update("playlist-item-spec".getBytes());
			else
				_md5sum.update("revision-number".getBytes());

			if ((i & 0x01) != 0)
				_md5sum.update("session-id".getBytes());
			else
				_md5sum.update("content-codes".getBytes());	
			
			
			_buf.append(HexString.bytesToHexString(_md5sum.digest()));
			
		}
		
		_staticHash = _buf.toString();
		
	}
	
	
	public String generateHash(String url, int accessIndex, int requestId) {
		
		if (_staticHash == null)
			return null;
		
		MessageDigest _md5sum;
		int _start = HASH_SIZE * accessIndex;
		int _end = _start + HASH_SIZE;
		
		try {
			
			_md5sum = MessageDigest.getInstance("md5");
			
		}
		catch (NoSuchAlgorithmException e) {
			
			/* Never reached */
			return null;
			
		}
		
		_md5sum.update(url.getBytes());
		_md5sum.update(_appleCopyright.getBytes());
		_md5sum.update(_staticHash.substring(_start, _end).getBytes());
		
		return HexString.bytesToHexString(_md5sum.digest());
		
	}
	
}
