/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.system.RemoteHostUtil;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentMode;
import com.jetbrains.plugins.webDeployment.DeploymentPathChecker;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ExecutionContextBase;
import com.jetbrains.plugins.webDeployment.IgnoreOverwritingStrategy;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.Connectable;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteDeploymentUtil {
    @NonNls
    private static final String NOT_EMPTY_URL = "http:///";

    @Nullable
    public static WebServerConfig getHost(@NotNull String hostId) {
        WebServerConfig host;
        if (hostId == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(0);
        }
        if ((host = GroupedServersConfigManager.getInstance(null).findServer(hostId)) == null) {
            RemoteHostUtil.LOG.debug("Cannot find host by id: " + hostId);
        }
        return host;
    }

    @NotNull
    public static WebServerConfig createSftpWebServerConfig(@NotNull String hostName, @NotNull SshConfig sshConfig) {
        if (hostName == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(1);
        }
        if (sshConfig == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(2);
        }
        return RemoteDeploymentUtil.createSftpWebServerConfig(sshConfig, hostName, WebServerConfig.getNextId());
    }

    @NotNull
    public static WebServerConfig createSftpWebServerConfig(@NotNull SshConfig sshConfig, @NotNull String hostName, @NotNull String hostId) {
        if (sshConfig == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(3);
        }
        if (hostName == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(4);
        }
        if (hostId == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(5);
        }
        WebServerConfig host = new WebServerConfig(hostId);
        String uniqueName = hostName + " (" + hostId + ")";
        host.setIsProjectLevel(false);
        host.setName(uniqueName);
        host.setUrl(NOT_EMPTY_URL);
        FileTransferConfig fileTransferConfig = RemoteDeploymentUtil.createTransferConfig(sshConfig);
        host.setFileTransferConfig(fileTransferConfig);
        WebServerConfig webServerConfig = host;
        if (webServerConfig == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(6);
        }
        return webServerConfig;
    }

    @NotNull
    public static FileTransferConfig createTransferConfig(@NotNull SshConfig sshConfig) {
        if (sshConfig == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(7);
        }
        FileTransferConfig fileTransferConfig = new FileTransferConfig();
        fileTransferConfig.setAccessType(AccessType.SFTP);
        fileTransferConfig.getAdvancedOptions().setUseRsync(SystemInfo.isUnix);
        fileTransferConfig.setSshConfig(sshConfig);
        FileTransferConfig fileTransferConfig2 = fileTransferConfig;
        if (fileTransferConfig2 == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(8);
        }
        return fileTransferConfig2;
    }

    @NotNull
    public static DeploymentPathMapping convert(@NotNull PathMappingSettings.PathMapping mapping) {
        if (mapping == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(9);
        }
        DeploymentPathMapping deploymentMapping = new DeploymentPathMapping();
        deploymentMapping.setLocalPath(mapping.getLocalRoot());
        deploymentMapping.setDeployPath(mapping.getRemoteRoot());
        DeploymentPathMapping deploymentPathMapping = deploymentMapping;
        if (deploymentPathMapping == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(10);
        }
        return deploymentPathMapping;
    }

    @Nullable
    public static PathMappingSettings.PathMapping convert(@NotNull DeploymentPathMapping mapping) {
        if (mapping == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(11);
        }
        if (mapping.getLocalPath() == null || mapping.getDeployPath() == null) {
            return null;
        }
        return new PathMappingSettings.PathMapping(mapping.getLocalPath(), mapping.getDeployPath());
    }

    public static CompletableFuture<Void> runUploadTask(@NotNull Project project, @NotNull WebServerConfig webServerConfig, @NotNull PublishConfig publishConfig) {
        if (project == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(12);
        }
        if (webServerConfig == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(13);
        }
        if (publishConfig == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(14);
        }
        Deployable server = Deployable.create((WebServerConfig)webServerConfig, (Project)project);
        String title = WDBundle.message((String)"upload.to", (Object[])new Object[]{StringUtil.notNullize((String)server.getName())});
        List roots = ContainerUtil.mapNotNull((Collection)publishConfig.getPathMappings(webServerConfig.getId()), it -> LocalFileSystem.getInstance().findFileByPath(it.getLocalPath()));
        UploadTask transferTask = new UploadTask(project, publishConfig, server, title, roots);
        FileTransferToolWindow.printWithTimestamp((Project)project, (Mappable)server, (String)title, (ConsoleViewContentType)ConsoleViewContentType.SYSTEM_OUTPUT, (PublishConfig.TraceLevel)publishConfig.getTraceLevel());
        return RemoteDeploymentUtil.runTaskAsynchronously(transferTask);
    }

    public static CompletableFuture<Void> downloadInternal(@NotNull Project project, @NotNull String hostId, @NotNull Deployable server, final @NotNull RemoteConnection connection, final @NotNull String remotePath, final @NotNull String localPath, final @NotNull IgnoreOverwritingStrategy ignoreOverwritingStrategy) {
        if (project == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(15);
        }
        if (hostId == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(16);
        }
        if (server == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(17);
        }
        if (connection == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(18);
        }
        if (remotePath == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(19);
        }
        if (localPath == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(20);
        }
        if (ignoreOverwritingStrategy == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(21);
        }
        PublishConfig publishConfig = PublishConfig.getInstance((Project)project).clone();
        publishConfig.setExcludedPaths(hostId, Collections.emptyList());
        String title = WDBundle.message((String)"download.from", (Object[])new Object[]{server.getName()});
        FileTransferToolWindow.printWithTimestamp((Project)project, (Mappable)server, (String)title, (ConsoleViewContentType)ConsoleViewContentType.SYSTEM_OUTPUT, (PublishConfig.TraceLevel)publishConfig.getTraceLevel());
        final DeploymentPathMapping deploymentMapping = new DeploymentPathMapping();
        deploymentMapping.setDeployPath(remotePath);
        deploymentMapping.setLocalPath(localPath);
        AbstractTransferTask task = new AbstractTransferTask(project, ConnectionOwnerFactory.createConnectionOwner((Project)project), false, publishConfig, server, title, true, true, true, ProjectDeploymentRevisionTracker.getInstance((Project)project)){

            protected void showBalloon(MessageType type, String text, boolean isSummary) {
                if (type == MessageType.INFO) {
                    return;
                }
                super.showBalloon(type, text, isSummary);
            }

            @NotNull
            protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) throws FileSystemException {
                context.setIgnoreOverwritingStrategy(ignoreOverwritingStrategy);
                FileObject source = connection.resolveFile(remotePath);
                FileObject target = DeploymentPathUtils.getLocalFile((String)localPath);
                ArrayList<TransferOperation> result = new ArrayList<TransferOperation>();
                DeploymentPathUtils.refreshRemoteFile((FileObject)source, (ExecutionContextBase)context);
                DeploymentPathUtils.ErrorsAndExclusions errors = new PathProcessor(context, result).processPath(source, target, deploymentMapping);
                return new TransferTask.ListBased.ResultWithErrors(result, errors);
            }

            protected RemoteConnection getExistingConnection() {
                return connection;
            }
        };
        return RemoteDeploymentUtil.runTaskAsynchronously(task);
    }

    @Nullable
    public static RemoteConnection getConnection(@NotNull Project project, @NotNull Deployable deployable) throws FileSystemException {
        RemoteConnectionManager manager;
        if (project == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(22);
        }
        if (deployable == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(23);
        }
        if ((manager = RemoteConnectionManager.getInstance()) == null) {
            return null;
        }
        @NlsSafe String title = "Getting files";
        return manager.openConnection(com.intellij.ssh.interaction.ConnectionOwnerFactory.createConnectionOwnerWithDialogMessages((Project)project), "Getting files", (Connectable)deployable, FileTransferConfig.Origin.Default, null, null);
    }

    @NotNull
    private static CompletableFuture<Void> runTaskAsynchronously(@NotNull AbstractTransferTask task) {
        if (task == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(24);
        }
        final ProgressIndicator currentProgressIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        Runnable runnable = () -> {
            final BackgroundableProcessIndicator pi = new BackgroundableProcessIndicator((Task.Backgroundable)task);
            pi.addStateDelegate((ProgressIndicatorEx)new ProgressIndicatorStub(){

                @Override
                public void checkCanceled() throws ProcessCanceledException {
                    try {
                        if (currentProgressIndicator != null) {
                            currentProgressIndicator.checkCanceled();
                        }
                    }
                    catch (ProcessCanceledException e) {
                        pi.cancel();
                        throw e;
                    }
                }
            });
            ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task, (ProgressIndicator)pi);
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            task.run((ProgressIndicator)new EmptyProgressIndicator());
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                RemoteDeploymentUtil.$$$reportNull$$$0(25);
            }
            return completableFuture;
        }
        ApplicationManager.getApplication().invokeLater(runnable);
        CompletableFuture<Void> completableFuture = task.getResult();
        if (completableFuture == null) {
            RemoteDeploymentUtil.$$$reportNull$$$0(26);
        }
        return completableFuture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 10, 25, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostId";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostName";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sshConfig";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/RemoteDeploymentUtil";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 12: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webServerConfig";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishConfig";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreOverwritingStrategy";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployable";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/RemoteDeploymentUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createSftpWebServerConfig";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTransferConfig";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "runTaskAsynchronously";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHost";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createSftpWebServerConfig";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 25: 
            case 26: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTransferConfig";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runUploadTask";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "downloadInternal";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getConnection";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "runTaskAsynchronously";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 10, 25, 26 -> new IllegalStateException(string);
        };
    }

    private static class UploadTask
    extends AbstractTransferTask {
        private final List<VirtualFile> myRoots;

        UploadTask(@NotNull Project project, @NotNull PublishConfig publishConfig, @NotNull Deployable server, @NlsContexts.ProgressTitle @NotNull String title, @NotNull List<VirtualFile> roots) {
            if (project == null) {
                UploadTask.$$$reportNull$$$0(0);
            }
            if (publishConfig == null) {
                UploadTask.$$$reportNull$$$0(1);
            }
            if (server == null) {
                UploadTask.$$$reportNull$$$0(2);
            }
            if (title == null) {
                UploadTask.$$$reportNull$$$0(3);
            }
            if (roots == null) {
                UploadTask.$$$reportNull$$$0(4);
            }
            super(project, ConnectionOwnerFactory.createConnectionOwner((Project)project), true, publishConfig, server, title, true, true, true, ProjectDeploymentRevisionTracker.getInstance((Project)project));
            this.myRoots = roots;
        }

        @NotNull
        protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) throws FileSystemException {
            TransferTask.ListBased.ResultWithErrors resultWithErrors = PublishActionUtil.scanFiles((ExecutionContext)context, this.myRoots);
            if (resultWithErrors == null) {
                UploadTask.$$$reportNull$$$0(5);
            }
            return resultWithErrors;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "publishConfig";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "server";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/system/RemoteDeploymentUtil$UploadTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/system/RemoteDeploymentUtil$UploadTask";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildOperationsList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    private static abstract class AbstractTransferTask
    extends TransferTask.ListBased {
        private final CompletableFuture<Void> myResult;

        protected AbstractTransferTask(@Nullable Project project, @NotNull ConnectionOwner connectionOwner, boolean serverSideModification, PublishConfig publishConfig, Deployable serverConfig, @NlsContexts.ProgressTitle String title, boolean updateLocalHistory, boolean background, boolean cancellable, @NotNull DeploymentRevisionTracker revisionTracker) {
            if (connectionOwner == null) {
                AbstractTransferTask.$$$reportNull$$$0(0);
            }
            if (revisionTracker == null) {
                AbstractTransferTask.$$$reportNull$$$0(1);
            }
            super(project, connectionOwner, serverSideModification, publishConfig, serverConfig, title, updateLocalHistory, background, cancellable, revisionTracker);
            this.myResult = new CompletableFuture();
        }

        public void onCancel() {
            try {
                super.onCancel();
            }
            finally {
                this.myResult.cancel(true);
            }
        }

        public void onSuccess() {
            try {
                super.onSuccess();
            }
            finally {
                this.myResult.complete(null);
            }
        }

        public void onThrowable(@NotNull Throwable error) {
            if (error == null) {
                AbstractTransferTask.$$$reportNull$$$0(2);
            }
            try {
                super.onThrowable(error);
            }
            finally {
                this.myResult.completeExceptionally(error);
            }
        }

        public void onFinished() {
            try {
                this.myResult.complete(null);
            }
            finally {
                super.onFinished();
            }
        }

        public CompletableFuture<Void> getResult() {
            return this.myResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connectionOwner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revisionTracker";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/system/RemoteDeploymentUtil$AbstractTransferTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onThrowable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ProgressIndicatorStub
    implements ProgressIndicatorEx {
        private ProgressIndicatorStub() {
        }

        public void checkCanceled() throws ProcessCanceledException {
        }

        public boolean isCanceled() {
            return false;
        }

        public final void cancel() {
        }

        public void addStateDelegate(@NotNull ProgressIndicatorEx delegate) {
            if (delegate == null) {
                ProgressIndicatorStub.$$$reportNull$$$0(0);
            }
        }

        public void finish(@NotNull TaskInfo task) {
            if (task == null) {
                ProgressIndicatorStub.$$$reportNull$$$0(1);
            }
        }

        public boolean isFinished(@NotNull TaskInfo task) {
            if (task == null) {
                ProgressIndicatorStub.$$$reportNull$$$0(2);
            }
            return false;
        }

        public boolean wasStarted() {
            return false;
        }

        public void processFinish() {
        }

        public void initStateFrom(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                ProgressIndicatorStub.$$$reportNull$$$0(3);
            }
        }

        public void start() {
        }

        public void stop() {
        }

        public boolean isRunning() {
            return false;
        }

        public void setText(String text) {
        }

        public String getText() {
            return null;
        }

        public void setText2(String text) {
        }

        public String getText2() {
            return null;
        }

        public double getFraction() {
            return 0.0;
        }

        public void setFraction(double fraction) {
        }

        public void pushState() {
        }

        public void popState() {
        }

        public boolean isModal() {
            return false;
        }

        @NotNull
        public ModalityState getModalityState() {
            ModalityState modalityState = ModalityState.nonModal();
            if (modalityState == null) {
                ProgressIndicatorStub.$$$reportNull$$$0(4);
            }
            return modalityState;
        }

        public void setModalityProgress(@Nullable ProgressIndicator modalityProgress) {
        }

        public boolean isIndeterminate() {
            return false;
        }

        public void setIndeterminate(boolean indeterminate) {
        }

        public boolean isPopupWasShown() {
            return false;
        }

        public boolean isShowing() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/system/RemoteDeploymentUtil$ProgressIndicatorStub";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/system/RemoteDeploymentUtil$ProgressIndicatorStub";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModalityState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addStateDelegate";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "finish";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isFinished";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "initStateFrom";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    public static class PathProcessor {
        private final ExecutionContext myContext;
        private final List<TransferOperation> myResult;
        private final DeploymentPathChecker myChecker = new DeploymentPathChecker();

        public PathProcessor(ExecutionContext context, List<TransferOperation> result) {
            this.myContext = context;
            this.myResult = result;
        }

        public DeploymentPathUtils.ErrorsAndExclusions processPath(FileObject source, FileObject target, DeploymentPathMapping mapping) throws FileSystemException {
            this.myChecker.initProcessing();
            boolean targetExists = target.exists();
            return this.process(source, target, targetExists, mapping);
        }

        private DeploymentPathUtils.ErrorsAndExclusions process(FileObject source, FileObject target, boolean targetExists, DeploymentPathMapping mapping) throws FileSystemException {
            String errorMessage = DeploymentPathUtils.getErrorMessageForUnsupportedName((FileName)source.getName(), (Mappable)this.myContext.getServer());
            if (errorMessage != null) {
                return DeploymentPathUtils.ErrorsAndExclusions.reportErrors(Collections.singletonList(errorMessage));
            }
            DeploymentPathUtils.refreshRemoteFile((FileObject)source, (ExecutionContextBase)this.myContext);
            DeploymentPathUtils.ErrorsAndExclusions errorsAndExclusions = new DeploymentPathUtils.ErrorsAndExclusions();
            if (errorsAndExclusions.addAll(this.storeCheckAndReportDuplicatePath(source))) {
                return errorsAndExclusions;
            }
            this.myContext.getProgressIndicator().checkCanceled();
            String sourcePath = this.myContext.isServerSideModification() ? DeploymentPathUtils.getLocalPath((FileObject)source) : this.myContext.getServer().getPresentablePath(source);
            this.myContext.getProgressIndicator().setText(WDBundle.message((String)"collecting.files.0", (Object[])new Object[]{sourcePath}));
            if (this.myContext.getConfig().isExcludedByName(sourcePath)) {
                return errorsAndExclusions;
            }
            DeploymentMode mode = this.myContext.getDeploymentMode();
            if (!source.exists()) {
                mode.sourceNotExist(target, this.myContext, this.myResult, true);
            } else if (source.getType() == FileType.FILE) {
                mode.sourceIsFile(source, target, this.myContext, this.myResult);
            } else {
                FileObject[] sourceChildren;
                if ((this.myContext.getConfig().isCreateEmptyDirectories() || this.myContext.getConfig().getFolderPermissions() != -1) && DeploymentPathUtils.getType((FileObject)target, (boolean)targetExists) != FileType.FOLDER) {
                    this.myResult.add((TransferOperation)new TransferOperation.CreateFolder(target));
                } else if (this.myContext.isServerSideModification() && DeploymentPathUtils.getType((FileObject)target, (boolean)targetExists) == FileType.FOLDER && this.myContext.getConfig().getFolderPermissions() != -1) {
                    this.myResult.add((TransferOperation)new TransferOperation.ChangePermissions(target));
                }
                for (FileObject sourceChild : sourceChildren = source.getType() == FileType.FOLDER ? DeploymentPathUtils.getChildren((FileObject)source) : DeploymentPathUtils.NO_CHILDREN) {
                    String sourceChildPath;
                    String nameErrorMessage = DeploymentPathUtils.getErrorMessageForUnsupportedName((FileName)sourceChild.getName(), (Mappable)this.myContext.getServer());
                    if (nameErrorMessage != null) {
                        errorsAndExclusions.addError(nameErrorMessage);
                        continue;
                    }
                    String string = sourceChildPath = this.myContext.isServerSideModification() ? DeploymentPathUtils.getLocalPath((FileObject)sourceChild) : this.myContext.getServer().getPresentablePath(sourceChild);
                    if (this.myContext.getConfig().isExcludedByName(sourceChildPath)) continue;
                    FileObject targetChild = this.myContext.isServerSideModification() ? this.myContext.findRemoteFile(mapping.mapToDeployPath(sourceChild, (Mappable)this.myContext.getServer()), DeploymentPathUtils.getType((FileObject)target, (boolean)targetExists) != FileType.IMAGINARY) : mapping.mapToLocalFile(sourceChild, (Mappable)this.myContext.getServer());
                    FileObject excludedChildFile = DeploymentPathUtils.getExcludedFile((ExecutionContext)this.myContext, (FileObject)sourceChild, (FileObject)targetChild);
                    if (excludedChildFile != null) {
                        boolean local = this.myContext.isServerSideModification() ? excludedChildFile == sourceChild : excludedChildFile == targetChild;
                        errorsAndExclusions.addExcludedPath(excludedChildFile, local, this.myContext);
                        continue;
                    }
                    try {
                        DeploymentPathUtils.ErrorsAndExclusions childErrorsAndExclusions = this.process(sourceChild, targetChild, DeploymentPathUtils.getType((FileObject)target, (boolean)targetExists) != FileType.IMAGINARY, mapping);
                        errorsAndExclusions.addAllPaths(childErrorsAndExclusions);
                    }
                    catch (FileSystemException e) {
                        if (PublishUtils.isFatal((Throwable)e)) {
                            throw e;
                        }
                        RemoteHostUtil.LOG.warn((Throwable)e);
                        errorsAndExclusions.addError(WDBundle.message((String)"failed.to.process", (Object[])new Object[]{sourceChildPath, PublishUtils.getMessage((Throwable)e, (boolean)false)}));
                    }
                }
                if (mode.isDeleteMissingItemsPossible(this.myContext)) {
                    FileObject[] targetChildren;
                    for (FileObject targetChild : targetChildren = DeploymentPathUtils.getType((FileObject)target, (boolean)targetExists) == FileType.FOLDER ? DeploymentPathUtils.getChildren((FileObject)target) : DeploymentPathUtils.NO_CHILDREN) {
                        PublishConfig publishConfig;
                        FileObject sourceChild;
                        if (this.myContext.getConfig().isExcludedByName(this.myContext.isServerSideModification() ? this.myContext.getServer().getPresentablePath(targetChild) : DeploymentPathUtils.getLocalPath((FileObject)targetChild))) continue;
                        if (this.myContext.isServerSideModification()) {
                            childMapping = this.myContext.getConfig().getNearestMappingDeploy2Local(targetChild, false, (Mappable)this.myContext.getServer());
                            if (childMapping.getFirst() == null && ((Boolean)childMapping.getSecond()).booleanValue()) {
                                errorsAndExclusions.addExcludedPath(targetChild, false, this.myContext);
                                continue;
                            }
                            if (mapping != childMapping.getFirst()) {
                                continue;
                            }
                        } else {
                            childMapping = this.myContext.getConfig().getNearestMappingForLocal(targetChild, false, true, false, (Mappable)this.myContext.getServer());
                            if (childMapping.getFirst() == null && ((Boolean)childMapping.getSecond()).booleanValue()) {
                                errorsAndExclusions.addExcludedPath(targetChild, true, this.myContext);
                                continue;
                            }
                            if (mapping != childMapping.getFirst()) continue;
                        }
                        if ((sourceChild = this.myContext.isServerSideModification() ? mapping.mapToLocalFile(targetChild, (Mappable)this.myContext.getServer()) : this.myContext.findRemoteFile(mapping.mapToDeployPath(targetChild, (Mappable)this.myContext.getServer()), DeploymentPathUtils.getType((FileObject)target, (boolean)targetExists) != FileType.IMAGINARY)).exists()) continue;
                        if (this.myContext.isServerSideModification()) {
                            childMapping = this.myContext.getConfig().getNearestMappingForLocal(sourceChild, false, true, false, (Mappable)this.myContext.getServer());
                            if (childMapping.getFirst() == null && ((Boolean)childMapping.getSecond()).booleanValue()) {
                                errorsAndExclusions.addExcludedPath(sourceChild, true, this.myContext);
                                continue;
                            }
                        } else {
                            childMapping = this.myContext.getConfig().getNearestMappingDeploy2Local(sourceChild, false, (Mappable)this.myContext.getServer());
                            if (childMapping.getFirst() == null && ((Boolean)childMapping.getSecond()).booleanValue()) {
                                errorsAndExclusions.addExcludedPath(sourceChild, false, this.myContext);
                                continue;
                            }
                        }
                        if (targetChild.getType() == FileType.FILE) {
                            mode.sourceNotExist(targetChild, this.myContext, this.myResult, false);
                            continue;
                        }
                        Pair descendantMappings = this.myContext.isServerSideModification() ? this.myContext.getConfig().getChildMappingsDeploy2Local(targetChild, (Mappable)this.myContext.getServer()) : this.myContext.getConfig().getChildMappingsForLocal(targetChild, true, false, (Mappable)this.myContext.getServer());
                        boolean canDelete = true;
                        for (DeploymentPathMapping descendantMapping : (List)descendantMappings.getFirst()) {
                            FileObject descendant = this.myContext.isServerSideModification() ? this.myContext.findRemoteFile(descendantMapping.getFullDeployPath((Mappable)this.myContext.getServer()), DeploymentPathUtils.getType((FileObject)target, (boolean)targetExists) != FileType.IMAGINARY) : DeploymentPathUtils.getLocalFile((String)descendantMapping.getLocalPath());
                            if (!descendant.exists()) continue;
                            canDelete = false;
                            break;
                        }
                        if (!canDelete) continue;
                        PublishConfig publishConfig2 = publishConfig = this.myContext.getProject() != null ? PublishConfig.getInstance((Project)this.myContext.getProject()) : this.myContext.getConfig();
                        this.myResult.add((TransferOperation)(publishConfig.isConfirmBeforeDeletion() ? new TransferOperation.UserConfirmedDelete(target, target.getType()) : new TransferOperation.Delete(target, target.getType() == FileType.FOLDER, true)));
                    }
                }
            }
            return errorsAndExclusions;
        }

        private DeploymentPathUtils.ErrorsAndExclusions storeCheckAndReportDuplicatePath(@NotNull FileObject source) {
            FileObject previousObject;
            if (source == null) {
                PathProcessor.$$$reportNull$$$0(0);
            }
            if ((previousObject = this.myChecker.getAlreadyProcessedFileObject(source)) != null) {
                @NonNls String errorMessage = "Skipping duplicate path: " + source.getName().getPath() + " looks like a recursive symlink to " + previousObject.getName().getPath();
                RemoteHostUtil.LOG.warn(errorMessage);
                return DeploymentPathUtils.ErrorsAndExclusions.reportErrors(Collections.singletonList(errorMessage));
            }
            return new DeploymentPathUtils.ErrorsAndExclusions();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/cidr/system/RemoteDeploymentUtil$PathProcessor", "storeCheckAndReportDuplicatePath"));
        }
    }
}

