/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger.backend;

import com.intellij.cidr.translateCode.CidrTranslateCodeService;
import com.intellij.cidr.translateCode.CidrTranslationCommand;
import com.intellij.cidr.translateCode.CidrTranslationResult;
import com.intellij.cidr.translateCode.CidrTranslationResultBuilder;
import com.intellij.cidr.translateCode.CidrTranslator;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.actions.CLionShowAssemblyFuncInfoProvider;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerModuleMemory;
import com.jetbrains.cidr.execution.debugger.memory.disasm.DisasmFileType;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0017J\b\u0010\f\u001a\u00020\u000bH\u0017J\b\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0018\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H&J \u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/cpp/execution/debugger/backend/CLionDebuggerFuncAsmTranslator;", "Lcom/intellij/cidr/translateCode/CidrTranslator;", "archType", "Lcom/jetbrains/cidr/ArchitectureType;", "funcInfo", "Lcom/jetbrains/cidr/cpp/actions/CLionShowAssemblyFuncInfoProvider$FuncInfo;", "<init>", "(Lcom/jetbrains/cidr/ArchitectureType;Lcom/jetbrains/cidr/cpp/actions/CLionShowAssemblyFuncInfoProvider$FuncInfo;)V", "getFuncInfo", "()Lcom/jetbrains/cidr/cpp/actions/CLionShowAssemblyFuncInfoProvider$FuncInfo;", "getName", "", "getPopupItemText", "getType", "getFailedNotificationText", "e", "Lcom/intellij/execution/ExecutionException;", "translate", "Lcom/intellij/cidr/translateCode/CidrTranslationResult;", "customCommand", "Lcom/intellij/cidr/translateCode/CidrTranslationCommand;", "(Lcom/intellij/cidr/translateCode/CidrTranslationCommand;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createDisasmCmd", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "createTranslationResult", "disasmResult", "Lcom/intellij/execution/process/ProcessOutput;", "builder", "Lcom/intellij/cidr/translateCode/CidrTranslationResultBuilder;", "isFailed", "", "intellij.clion.execution"})
public abstract class CLionDebuggerFuncAsmTranslator
implements CidrTranslator {
    @NotNull
    private final ArchitectureType archType;
    @NotNull
    private final CLionShowAssemblyFuncInfoProvider.FuncInfo funcInfo;

    public CLionDebuggerFuncAsmTranslator(@NotNull ArchitectureType archType, @NotNull CLionShowAssemblyFuncInfoProvider.FuncInfo funcInfo) {
        Intrinsics.checkNotNullParameter((Object)archType, (String)"archType");
        Intrinsics.checkNotNullParameter((Object)funcInfo, (String)"funcInfo");
        this.archType = archType;
        this.funcInfo = funcInfo;
    }

    @NotNull
    public final CLionShowAssemblyFuncInfoProvider.FuncInfo getFuncInfo() {
        return this.funcInfo;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = CLionExecutionBundle.message("asm.translator.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    public String getPopupItemText() {
        String string = CLionExecutionBundle.message("debug.asm.translator.popup.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getType() {
        return "cidr.debugger.asm";
    }

    @Nls
    @NotNull
    public String getFailedNotificationText(@NotNull ExecutionException e) {
        String string;
        String details;
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        String string2 = e.getMessage();
        if (string2 == null) {
            string2 = "";
        }
        if (!StringsKt.isBlank((CharSequence)(details = string2))) {
            Object[] objectArray = new Object[]{details};
            String string3 = CLionExecutionBundle.message("error.failed.to.get.assembly.with.details", objectArray);
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        } else {
            String string4 = CLionExecutionBundle.message("error.failed.to.get.assembly", new Object[0]);
            Intrinsics.checkNotNull((Object)string4);
            string = string4;
        }
        return string;
    }

    @Nullable
    public Object translate(@Nullable CidrTranslationCommand customCommand, @NotNull Continuation<? super CidrTranslationResult> $completion) throws ExecutionException {
        return CLionDebuggerFuncAsmTranslator.translate$suspendImpl(this, customCommand, $completion);
    }

    static /* synthetic */ Object translate$suspendImpl(CLionDebuggerFuncAsmTranslator $this, CidrTranslationCommand customCommand, Continuation<? super CidrTranslationResult> $completion) throws ExecutionException {
        ProcessOutput processOutput;
        GeneralCommandLine cmd = $this.createDisasmCmd();
        try {
            processOutput = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd);
        }
        catch (ExecutionException e) {
            CidrTranslateCodeService.LOG.debug("Disassembly command failed", (Throwable)e);
            throw e;
        }
        ProcessOutput disasmResult = processOutput;
        if (CidrTranslateCodeService.LOG.isDebugEnabled()) {
            String string = disasmResult.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
            String string2 = ((Object)StringsKt.trimEnd((CharSequence)string)).toString();
            String string3 = disasmResult.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getStderr(...)");
            CidrTranslateCodeService.LOG.debug("Disassembly finished\nstdout: " + string2 + "\nstderr: " + ((Object)StringsKt.trimEnd((CharSequence)string3)).toString() + "\nexit code: " + disasmResult.getExitCode());
        }
        if ($this.isFailed(disasmResult)) {
            String string = disasmResult.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
            DisasmFileType disasmFileType = DisasmFileType.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)disasmFileType, (String)"INSTANCE");
            return new CidrTranslationResult(string, (FileType)disasmFileType, CollectionsKt.emptyList(), null, null, null, 56, null);
        }
        DisasmFileType disasmFileType = DisasmFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)disasmFileType, (String)"INSTANCE");
        CidrTranslationResultBuilder builder = new CidrTranslationResultBuilder((FileType)disasmFileType, null, null, arg_0 -> CLionDebuggerFuncAsmTranslator.translate$lambda$0($this, arg_0), 6, null);
        return $this.createTranslationResult(disasmResult, builder, $this.funcInfo);
    }

    @NotNull
    public abstract GeneralCommandLine createDisasmCmd();

    @NotNull
    public abstract CidrTranslationResult createTranslationResult(@NotNull ProcessOutput var1, @NotNull CidrTranslationResultBuilder var2, @NotNull CLionShowAssemblyFuncInfoProvider.FuncInfo var3);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isFailed(@NotNull ProcessOutput disasmResult) {
        Intrinsics.checkNotNullParameter((Object)disasmResult, (String)"disasmResult");
        if (disasmResult.getExitCode() != 0) return true;
        String string = disasmResult.getStderr();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
        if (((CharSequence)string).length() <= 0) return false;
        return true;
    }

    private static final Unit translate$lambda$0(CLionDebuggerFuncAsmTranslator this$0, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = this$0.archType.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        it.putUserData(CidrDebuggerModuleMemory.DISASM_ARCH, (Object)string);
        return Unit.INSTANCE;
    }
}

