/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.gdbserver;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.icons.AllIcons;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.changes.RefreshablePanel;
import com.intellij.ui.AbstractTitledSeparatorWithIcon;
import com.intellij.ui.JBIntSpinner;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.ArrayUtil;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.execution.gdbserver.DownloadType;
import com.jetbrains.cidr.cpp.execution.gdbserver.GdbServerRunConfiguration;
import com.jetbrains.cidr.cpp.execution.gdbserver.RadioButtonPanel;
import com.jetbrains.cidr.cpp.execution.remote.DebuggerData;
import com.jetbrains.cidr.cpp.execution.remote.DebuggersComboBoxWithModel;
import com.jetbrains.cidr.ui.CidrProgramParametersPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.function.Predicate;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class GdbParametersPanel
extends CidrProgramParametersPanel {
    @NlsSafe
    private static final String GDB_SERVER_PATH = "/usr/bin/gdbserver";
    private RadioButtonPanel<DownloadType> myDownloadGroup;
    private DebuggersComboBoxWithModel myDebuggers;
    protected LabeledComponent<ComponentWithBrowseButton<JComboBox<?>>> myDebuggersComponent;
    protected LabeledComponent<RadioButtonPanel<DownloadType>> myDownloadComponent;
    protected TextFieldWithBrowseButton myGdbServerFileField;
    protected ExtendableTextField myGdbRemoteField;
    protected JBIntSpinner myDelayField;
    protected LabeledComponent<TextFieldWithBrowseButton> myGdbServerComponent;
    protected LabeledComponent<JBTextField> myGdbRemoteComponent;
    protected LabeledComponent<?> myDelayComponent;
    private AbstractTitledSeparatorWithIcon myOptionsSeparator;

    protected void initComponents() {
        this.myDebuggers = new DebuggersComboBoxWithModel(this.getProject(), true, true);
        this.myDebuggersComponent = LabeledComponent.create(this.myDebuggers.getComponent(), (String)CLionExecutionBundle.message("gdb", new Object[0]), (String)"West");
        this.myDownloadGroup = new RadioButtonPanel<DownloadType>(DownloadType.values());
        this.myDownloadComponent = LabeledComponent.create(this.myDownloadGroup, (String)CLionExecutionBundle.message("gdbserver.executable.download", new Object[0]), (String)"West");
        this.myGdbServerFileField = new TextFieldWithBrowseButton();
        ((JBTextField)this.myGdbServerFileField.getTextField()).getEmptyText().setText(GDB_SERVER_PATH);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withTitle(CLionExecutionBundle.message("gdbserver.select.executable", new Object[0]));
        this.myGdbServerFileField.addBrowseFolderListener(null, descriptor);
        this.myGdbServerComponent = LabeledComponent.create((JComponent)this.myGdbServerFileField, (String)CLionExecutionBundle.message("gdbserver.title", new Object[0]), (String)"West");
        this.myGdbRemoteField = new ExtendableTextField();
        this.myGdbRemoteField.getEmptyText().setText(CLionExecutionBundle.message("gdbRemote.command.hint", new Object[0]));
        this.myGdbRemoteComponent = LabeledComponent.create((JComponent)this.myGdbRemoteField, (String)CLionExecutionBundle.message("gdbRemote.command", new Object[0]), (String)"West");
        this.myDelayField = new JBIntSpinner(0, 0, 1000000, 500);
        this.myDelayField.setToolTipText(CLionExecutionBundle.message("gdbserver.startup.delay.text", new Object[0]));
        JPanel delayPanel = new JPanel((LayoutManager)new HorizontalLayout(0));
        delayPanel.add((Component)this.myDelayField, "LEFT");
        delayPanel.add((Component)new JBLabel(CLionExecutionBundle.message("gdbserver.startup.delay.label.ms", new Object[0])), "LEFT");
        this.myDelayComponent = LabeledComponent.create((JComponent)delayPanel, (String)CLionExecutionBundle.message("gdbserver.startup.delay.label", new Object[0]), (String)"West");
        this.myOptionsSeparator = new AbstractTitledSeparatorWithIcon(AllIcons.General.ArrowRight, AllIcons.General.ArrowDown, CLionExecutionBundle.message("gdbserver.options.advanced", new Object[0])){

            protected RefreshablePanel createPanel() {
                return new RefreshablePanel(){

                    public void refresh() {
                    }

                    public JPanel getPanel() {
                        return new JPanel();
                    }
                };
            }

            protected void initOnImpl() {
            }

            protected void onImpl() {
                GdbParametersPanel.this.onAdvancedPanelChanged(true);
            }

            protected void offImpl() {
                GdbParametersPanel.this.onAdvancedPanelChanged(false);
            }
        };
        super.initComponents();
        this.myProgramInputRedirectPanel.setVisible(false);
        this.myConsoleOptionsPanel.setVisible(false);
        this.myProgramParametersComponent.getLabel().setText(CLionExecutionBundle.message("gdbserver.arguments", new Object[0]));
        this.myOptionsSeparator.off();
    }

    protected void onAdvancedPanelChanged(boolean visible) {
        this.myWorkingDirectoryComponent.setVisible(visible);
        this.myEnvVariablesComponent.setVisible(visible);
        this.myElevationPanel.setVisible(visible);
        this.myDelayComponent.setVisible(visible);
    }

    protected void addComponents() {
        this.add((Component)this.myDownloadComponent);
        this.addCommonComponents();
        this.add((Component)this.myDelayComponent);
    }

    protected final void addCommonComponents() {
        this.add((Component)this.myGdbRemoteComponent);
        this.add((Component)this.myGdbServerComponent);
        super.addComponents();
        int indexOfAdvanced = ArrayUtil.indexOf((Object[])this.getComponents(), (Object)this.myWorkingDirectoryComponent);
        if (indexOfAdvanced != -1) {
            this.add((Component)this.myOptionsSeparator, indexOfAdvanced);
        }
    }

    protected void initMacroSupport() {
        super.initMacroSupport();
        GdbParametersPanel.addMacroSupport((ExtendableTextField)this.myGdbRemoteField);
        GdbParametersPanel.addMacroSupport((ExtendableTextField)((ExtendableTextField)this.myGdbServerFileField.getTextField()));
    }

    @NotNull
    protected Predicate<? super Macro> getCommonMacroFilter() {
        Predicate predicate = MacrosDialog.Filters.ALL;
        if (predicate == null) {
            GdbParametersPanel.$$$reportNull$$$0(0);
        }
        return predicate;
    }

    public void setAnchor(JComponent anchor) {
        super.setAnchor(anchor);
        this.myDebuggersComponent.setAnchor(anchor);
        this.myGdbServerComponent.setAnchor(anchor);
        this.myGdbRemoteComponent.setAnchor(anchor);
        this.myDelayComponent.setAnchor(anchor);
        this.myProgramParametersComponent.setAnchor(anchor);
        this.myDownloadComponent.setAnchor(anchor);
        this.myWorkingDirectoryComponent.setAnchor(anchor);
        this.myEnvVariablesComponent.setAnchor(anchor);
    }

    public void applyTo(@NotNull CommonProgramRunConfigurationParameters configuration) {
        if (configuration == null) {
            GdbParametersPanel.$$$reportNull$$$0(1);
        }
        super.applyTo(configuration);
        GdbServerRunConfiguration customGdbConfig = (GdbServerRunConfiguration)configuration;
        DebuggerData selectedDebugger = this.myDebuggers.getSelectedDebugger();
        customGdbConfig.setDebuggerData(selectedDebugger);
        customGdbConfig.setServerExecutable(this.myGdbServerFileField.getText());
        customGdbConfig.setGdbRemoteString(this.myGdbRemoteField.getText());
        customGdbConfig.setWarmUpMs(this.myDelayField.getNumber());
        customGdbConfig.setDownloadType(this.myDownloadGroup.getSelectedValue());
    }

    public void reset(@NotNull CommonProgramRunConfigurationParameters configuration) {
        if (configuration == null) {
            GdbParametersPanel.$$$reportNull$$$0(2);
        }
        super.reset(configuration);
        GdbServerRunConfiguration customGdbConfig = (GdbServerRunConfiguration)configuration;
        this.myDebuggers.resetModel(customGdbConfig.getDebuggerData());
        this.myGdbServerFileField.setText(customGdbConfig.getServerExecutable());
        this.myGdbRemoteField.setText(customGdbConfig.getGdbRemoteString());
        this.myDelayField.setValue((Object)customGdbConfig.getWarmUpMs());
        this.myDownloadGroup.setSelectedValue(customGdbConfig.getDownloadType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/gdbserver/GdbParametersPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonMacroFilter";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/gdbserver/GdbParametersPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

