/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.TtyConnector;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.DebugTargetsCounterUsagesCollector;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001,B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007H\u0016J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0016J\u0012\u0010\u001f\u001a\u00020\u00192\b\u0010\"\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0007H\u0016J\b\u0010&\u001a\u00020$H\u0016J\b\u0010'\u001a\u00020\u0005H\u0016J\b\u0010(\u001a\u00020\u0019H\u0016J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/TcpTtyConnector;", "Lcom/jediterm/terminal/TtyConnector;", "project", "Lcom/intellij/openapi/project/Project;", "hostName", "", "portNumber", "", "disposable", "Lcom/intellij/openapi/Disposable;", "errorLogger", "Lkotlin/Function1;", "", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;ILcom/intellij/openapi/Disposable;Lkotlin/jvm/functions/Function1;)V", "status", "Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/TcpTtyConnector$Status;", "socket", "Ljava/net/Socket;", "out", "Ljava/io/OutputStream;", "inp", "Ljava/io/Reader;", "ensureConnected", "", "read", "buf", "", "offset", "length", "write", "bytes", "", "string", "isConnected", "", "waitFor", "ready", "getName", "close", "resize", "termSize", "Lcom/jediterm/core/util/TermSize;", "Status", "intellij.clion.execution"})
public final class TcpTtyConnector
implements TtyConnector {
    @NotNull
    private final Project project;
    @NotNull
    private final String hostName;
    private final int portNumber;
    @NotNull
    private final Function1<Throwable, Object> errorLogger;
    @NotNull
    private volatile Status status;
    @Nullable
    private volatile Socket socket;
    @Nullable
    private volatile OutputStream out;
    @Nullable
    private volatile Reader inp;

    public TcpTtyConnector(@NotNull Project project, @NotNull String hostName, int portNumber, @NotNull Disposable disposable, @NotNull Function1<? super Throwable, ? extends Object> errorLogger) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(errorLogger, (String)"errorLogger");
        this.project = project;
        this.hostName = hostName;
        this.portNumber = portNumber;
        this.errorLogger = errorLogger;
        this.status = Status.NOT_OPEN;
        Disposer.register((Disposable)disposable, () -> TcpTtyConnector._init_$lambda$0(this));
    }

    private final synchronized void ensureConnected() {
        if (this.socket != null) {
            return;
        }
        try {
            this.socket = new Socket(this.hostName, this.portNumber);
            DebugTargetsCounterUsagesCollector.INSTANCE.consoleConnect(this.project, true);
            this.status = Status.OPEN;
            Socket socket = this.socket;
            Intrinsics.checkNotNull((Object)socket);
            this.out = socket.getOutputStream();
            Socket socket2 = this.socket;
            Intrinsics.checkNotNull((Object)socket2);
            this.inp = new InputStreamReader(socket2.getInputStream(), StandardCharsets.US_ASCII);
        }
        catch (IOException e) {
            if (this.status != Status.FAILED) {
                DebugTargetsCounterUsagesCollector.INSTANCE.consoleConnect(this.project, false);
            }
            this.status = Status.FAILED;
            this.errorLogger.invoke((Object)e);
        }
    }

    public int read(@NotNull char[] buf, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this.ensureConnected();
        while (this.status == Status.OPEN) {
            try {
                Socket socket = this.socket;
                boolean bl = socket != null ? socket.isConnected() : false;
                if (!bl) continue;
                Reader reader = this.inp;
                Intrinsics.checkNotNull((Object)reader);
                return reader.read(buf, offset, length);
            }
            catch (IOException e) {
                this.status = Status.FAILED;
                this.errorLogger.invoke((Object)e);
            }
        }
        return -1;
    }

    public void write(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.ensureConnected();
        try {
            OutputStream outputStream = this.out;
            if (outputStream != null) {
                outputStream.write(bytes);
            }
        }
        catch (IOException e) {
            this.status = Status.FAILED;
            this.errorLogger.invoke((Object)e);
        }
    }

    public void write(@Nullable String string) {
        CharSequence charSequence = string;
        if (!(charSequence == null || charSequence.length() == 0)) {
            charSequence = string;
            Charset charset = StandardCharsets.US_ASCII;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"US_ASCII");
            byte[] byArray = ((String)charSequence).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            this.write(byArray);
        }
    }

    public boolean isConnected() {
        Socket socket = this.socket;
        return socket != null ? socket.isConnected() : false;
    }

    public int waitFor() {
        return 0;
    }

    public boolean ready() {
        Reader reader = this.inp;
        return reader != null ? reader.ready() : false;
    }

    @NotNull
    public String getName() {
        return "127.0.0.1:" + this.portNumber;
    }

    public void close() {
        block0: {
            this.status = Status.CLOSED;
            Socket socket = this.socket;
            if (socket == null) break block0;
            socket.close();
        }
    }

    public void resize(@NotNull TermSize termSize) {
        Intrinsics.checkNotNullParameter((Object)termSize, (String)"termSize");
    }

    private static final void _init_$lambda$0(TcpTtyConnector this$0) {
        try {
            this$0.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/TcpTtyConnector$Status;", "", "<init>", "(Ljava/lang/String;I)V", "NOT_OPEN", "OPEN", "CLOSED", "FAILED", "intellij.clion.execution"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status NOT_OPEN = new Status();
        public static final /* enum */ Status OPEN = new Status();
        public static final /* enum */ Status CLOSED = new Status();
        public static final /* enum */ Status FAILED = new Status();
        private static final /* synthetic */ Status[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        @NotNull
        public static EnumEntries<Status> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = statusArray = new Status[]{Status.NOT_OPEN, Status.OPEN, Status.CLOSED, Status.FAILED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

