/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.manager;

import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.execution.CLionRunConfiguration;
import com.jetbrains.cidr.cpp.execution.manager.CLionRunConfigurationManagerHelper;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrOrderMerger;
import com.jetbrains.cidr.execution.ExecutableData;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@State(name="CMakeRunConfigurationManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class CLionRunConfigurationManager
implements PersistentStateComponent<Element> {
    private static final Logger LOGGER = Logger.getInstance(CLionRunConfigurationManager.class);
    @NonNls
    private static final String SHOULD_GENERATE_CONFIGS = "run.shouldGenerateConfigs";
    @NonNls
    private static final String SHOULD_DELETE_OBSOLETE_CONFIGS = "run.shouldDeleteObsoleteConfigs";
    private final Project myProject;
    @NotNull
    private volatile Set<BuildTargetData> myGeneratedConfigs = Collections.emptySet();

    @NotNull
    public static CLionRunConfigurationManager getInstance(@NotNull Project project) {
        if (project == null) {
            CLionRunConfigurationManager.$$$reportNull$$$0(0);
        }
        CLionRunConfigurationManager cLionRunConfigurationManager = (CLionRunConfigurationManager)project.getService(CLionRunConfigurationManager.class);
        if (cLionRunConfigurationManager == null) {
            CLionRunConfigurationManager.$$$reportNull$$$0(1);
        }
        return cLionRunConfigurationManager;
    }

    CLionRunConfigurationManager(Project project) {
        this.myProject = project;
    }

    public void updateRunConfigurations(@NotNull CLionRunConfigurationManagerHelper helper) {
        if (helper == null) {
            CLionRunConfigurationManager.$$$reportNull$$$0(2);
        }
        if (!this.isShouldGenerateConfigurations()) {
            return;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.updateRunConfigurations(helper, this.myGeneratedConfigs);
    }

    @TestOnly
    public void recreateRunConfigurations(@NotNull CLionRunConfigurationManagerHelper helper) {
        if (helper == null) {
            CLionRunConfigurationManager.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.updateRunConfigurations(helper, Collections.emptySet());
    }

    private void updateRunConfigurations(@NotNull CLionRunConfigurationManagerHelper helper, @NotNull Set<BuildTargetData> previouslyGenerated) {
        if (helper == null) {
            CLionRunConfigurationManager.$$$reportNull$$$0(4);
        }
        if (previouslyGenerated == null) {
            CLionRunConfigurationManager.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        UpdateSession session = new UpdateSession(helper, previouslyGenerated, this.isShouldDeleteObsoleteConfigurations());
        this.myGeneratedConfigs = Collections.unmodifiableSet(session.updateRunConfigurations());
    }

    @NotNull
    public static RunnerAndConfigurationSettings createRunConfiguration(@NotNull RunManagerEx runManager, @NotNull ConfigurationFactory factory, @NotNull String name, @NotNull BuildTargetAndConfigurationData data, @Nullable Ref<ExecutableData> executableData) {
        if (runManager == null) {
            CLionRunConfigurationManager.$$$reportNull$$$0(6);
        }
        if (factory == null) {
            CLionRunConfigurationManager.$$$reportNull$$$0(7);
        }
        if (name == null) {
            CLionRunConfigurationManager.$$$reportNull$$$0(8);
        }
        if (data == null) {
            CLionRunConfigurationManager.$$$reportNull$$$0(9);
        }
        RunnerAndConfigurationSettings result2 = runManager.createConfiguration(name, factory);
        CPPLog.LOG.assertTrue(result2.getConfiguration() instanceof CLionRunConfiguration);
        CLionRunConfiguration runConfig = (CLionRunConfiguration)result2.getConfiguration();
        runConfig.setTargetAndConfigurationData(data);
        if (executableData != null) {
            runConfig.setExecutableData((ExecutableData)executableData.get());
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = result2;
        if (runnerAndConfigurationSettings == null) {
            CLionRunConfigurationManager.$$$reportNull$$$0(10);
        }
        return runnerAndConfigurationSettings;
    }

    @Contract(pure=true)
    public boolean isShouldGenerateConfigurations() {
        return AdvancedSettings.getBoolean((String)SHOULD_GENERATE_CONFIGS);
    }

    @Contract(mutates="this")
    public void setShouldGenerateConfigurations(boolean shouldGenerateConfigs) {
        AdvancedSettings.setBoolean((String)SHOULD_GENERATE_CONFIGS, (boolean)shouldGenerateConfigs);
    }

    @Contract(pure=true)
    public boolean isShouldDeleteObsoleteConfigurations() {
        return AdvancedSettings.getBoolean((String)SHOULD_DELETE_OBSOLETE_CONFIGS);
    }

    @Contract(mutates="this")
    public void setShouldDeleteObsoleteConfigurations(boolean shouldDeleteObsoleteConfigs) {
        AdvancedSettings.setBoolean((String)SHOULD_DELETE_OBSOLETE_CONFIGS, (boolean)shouldDeleteObsoleteConfigs);
    }

    @NotNull
    public Element getState() {
        Element element = new Element("state");
        Element generatedElement = new Element("generated");
        element.addContent(generatedElement);
        for (BuildTargetData each : this.myGeneratedConfigs) {
            Element eachElement = new Element("config");
            generatedElement.addContent(eachElement);
            eachElement.setAttribute("projectName", each.projectName);
            eachElement.setAttribute("targetName", each.targetName);
        }
        Element element2 = element;
        if (element2 == null) {
            CLionRunConfigurationManager.$$$reportNull$$$0(11);
        }
        return element2;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            CLionRunConfigurationManager.$$$reportNull$$$0(12);
        }
        HashSet<BuildTargetData> loaded = new HashSet<BuildTargetData>();
        Element generatedElement = state.getChild("generated");
        if (generatedElement != null) {
            for (Element eachElement : generatedElement.getChildren("config")) {
                String projectName = eachElement.getAttributeValue("projectName");
                String targetName = eachElement.getAttributeValue("targetName");
                if (projectName == null || targetName == null) continue;
                loaded.add(new BuildTargetData(projectName, targetName));
            }
        }
        this.myGeneratedConfigs = Collections.unmodifiableSet(loaded);
    }

    public boolean getBoolean(@Nullable String attributeValue, boolean def) {
        return attributeValue == null ? def : Boolean.parseBoolean(attributeValue);
    }

    private static void debugIfEnabled(@NotNull @NotNull Supplier<@NotNull @NonNls String> lazyMessage) {
        if (lazyMessage == null) {
            CLionRunConfigurationManager.$$$reportNull$$$0(13);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(lazyMessage.get());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/manager/CLionRunConfigurationManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previouslyGenerated";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lazyMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/manager/CLionRunConfigurationManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createRunConfiguration";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 10: 
            case 11: {
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateRunConfigurations";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "recreateRunConfigurations";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createRunConfiguration";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "debugIfEnabled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 10, 11 -> new IllegalStateException(string);
        };
    }

    private class UpdateSession {
        @NotNull
        private final CLionRunConfigurationManagerHelper myHelper;
        private final boolean myShouldDeleteObsoleteConfigs;
        @NotNull
        private Set<BuildTargetData> myPreviouslyGenerated;
        @NotNull
        private final RunManagerImpl myRunManager;
        @NotNull
        private final CidrBuildConfigurationHelper<? extends CidrBuildConfiguration, ? extends CidrBuildTarget<?>> myBuildHelper;

        UpdateSession(@NotNull CLionRunConfigurationManagerHelper helper, Set<BuildTargetData> previouslyGenerated, boolean shouldDeleteObsoleteConfigs) {
            if (helper == null) {
                UpdateSession.$$$reportNull$$$0(0);
            }
            if (previouslyGenerated == null) {
                UpdateSession.$$$reportNull$$$0(1);
            }
            this.myHelper = helper;
            this.myShouldDeleteObsoleteConfigs = shouldDeleteObsoleteConfigs;
            this.myPreviouslyGenerated = previouslyGenerated;
            this.myRunManager = (RunManagerImpl)RunManagerEx.getInstanceEx((Project)CLionRunConfigurationManager.this.myProject);
            this.myBuildHelper = this.myHelper.getBuildHelper(CLionRunConfigurationManager.this.myProject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Set<BuildTargetData> updateRunConfigurations() {
            this.myRunManager.fireBeginUpdate();
            RunnerAndConfigurationSettings previouslySelectedConfiguration = this.myRunManager.getSelectedConfiguration();
            boolean needToRestoreSelection = previouslySelectedConfiguration != null || this.forEachConfiguration(this.myRunManager.getAllSettings(), it -> false);
            Set<BuildTargetData> result2 = this.doUpdateRunConfigurations();
            if (needToRestoreSelection && this.myRunManager.getSelectedConfiguration() == null) {
                this.selectConfiguration(previouslySelectedConfiguration);
            }
            Set<BuildTargetData> set = result2;
            Set<BuildTargetData> set2 = set;
            if (set2 == null) {
                UpdateSession.$$$reportNull$$$0(2);
            }
            return set2;
            finally {
                this.myRunManager.fireEndUpdate();
            }
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @NotNull
        private Set<BuildTargetData> doUpdateRunConfigurations() {
            Predicate<@NotNull RunnerAndConfigurationSettings> runConfigurationTypeFilter = this.myHelper.getRunConfigurationTypeFilter();
            List<@NotNull RunnerAndConfigurationSettings> originalOrder = this.myRunManager.getAllSettings().stream().filter(runConfigurationTypeFilter).toList();
            List allFactories = ContainerUtil.flatten((Iterable)ContainerUtil.map((Collection)ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList(), it -> Arrays.asList(it.getConfigurationFactories())));
            List templatesAndConfigurations = ContainerUtil.concat((List)ContainerUtil.map((Collection)allFactories, it -> this.myRunManager.getConfigurationTemplate(it)), (List)this.myRunManager.getAllSettings());
            this.forEachSettingsAndConfiguration(templatesAndConfigurations, it -> {
                this.updateProjectName((RunnerAndConfigurationSettings)it.first, (CLionRunConfiguration)it.second);
                this.updateBuildConfiguration((RunnerAndConfigurationSettings)it.first, (CLionRunConfiguration)it.second);
                return true;
            });
            this.myPreviouslyGenerated = this.updateProjectName(this.myPreviouslyGenerated);
            HashSet<BuildTargetData> generated = new HashSet<BuildTargetData>(this.myPreviouslyGenerated);
            HashSet targetsWithRunConfiguration = new HashSet(ContainerUtil.map(this.myPreviouslyGenerated, data -> data.targetName));
            MultiMap deletedTargetsWithConfigurations = new MultiMap();
            HashSet<String> existingRunConfigurationNames = new HashSet<String>();
            this.forEachSettingsAndConfiguration(this.myRunManager.getAllSettings(), it -> {
                existingRunConfigurationNames.add(((RunnerAndConfigurationSettings)it.first).getName());
                BuildTargetAndConfigurationData data = ((CLionRunConfiguration)it.second).getTargetAndConfigurationData();
                if (data != null && data.target != null) {
                    generated.add(data.target);
                    targetsWithRunConfiguration.add(data.target.targetName);
                    deletedTargetsWithConfigurations.putValue((Object)data.target, (Object)((RunnerAndConfigurationSettings)it.first));
                }
                return true;
            });
            List buildTargets = this.myBuildHelper.getTargets();
            for (CidrBuildTarget buildTarget : buildTargets) {
                BuildTargetData buildTargetData = new BuildTargetData(buildTarget);
                deletedTargetsWithConfigurations.remove((Object)buildTargetData);
                String name = buildTarget.getName();
                if (targetsWithRunConfiguration.contains(name) || !existingRunConfigurationNames.add(name)) continue;
                CidrBuildConfiguration buildConfiguration = UpdateSession.getDefaultBuildConfiguration(this.myBuildHelper, buildTarget);
                RunnerAndConfigurationSettings newConfig = CLionRunConfigurationManager.createRunConfiguration((RunManagerEx)this.myRunManager, this.myHelper.getConfigurationFactory(this.myBuildHelper, buildTarget), name, new BuildTargetAndConfigurationData(buildTargetData, buildConfiguration == null ? null : buildConfiguration.getName()), buildTarget.isExecutable() ? Ref.create((Object)new ExecutableData(buildTargetData)) : null);
                if (this.myRunManager.findConfigurationByTypeAndName(newConfig.getType(), newConfig.getName()) != null) continue;
                this.myRunManager.addConfiguration(newConfig);
                ContainerUtil.addIfNotNull(generated, (Object)buildTargetData);
            }
            if (this.myShouldDeleteObsoleteConfigs) {
                this.removeConfigurationsForDeletedTargets(this.myPreviouslyGenerated, (MultiMap<BuildTargetData, RunnerAndConfigurationSettings>)deletedTargetsWithConfigurations, generated);
            }
            if (!this.myHelper.canSortRunConfigurations()) {
                HashSet<BuildTargetData> hashSet = generated;
                if (hashSet == null) {
                    UpdateSession.$$$reportNull$$$0(3);
                }
                return hashSet;
            }
            @NlsSafe List configsNamesOrder = ContainerUtil.mapNotNull(originalOrder, each -> each.getConfiguration() instanceof CLionRunConfiguration ? each.getName() : null);
            @NlsSafe List order = CidrOrderMerger.mergeWithOriginalOrderPrecedence((List)configsNamesOrder, (List)ContainerUtil.map((Collection)buildTargets, CidrBuildTarget::getName), (boolean)false);
            String helperClassName = this.myHelper.getClass().getSimpleName();
            if (order.isEmpty()) {
                CLionRunConfigurationManager.debugIfEnabled(() -> String.format("No custom order to sort %d run configuration(s) using helper class: %s", this.myRunManager.getAllConfigurationsList().size(), helperClassName));
                HashSet<BuildTargetData> hashSet = generated;
                if (hashSet == null) {
                    UpdateSession.$$$reportNull$$$0(4);
                }
                return hashSet;
            }
            @NlsSafe Object2IntOpenHashMap orderIndices = new Object2IntOpenHashMap();
            int i = 0;
            for (String each2 : order) {
                orderIndices.put((Object)each2, i++);
            }
            CLionRunConfigurationManager.debugIfEnabled(() -> this.lambda$doUpdateRunConfigurations$8((Object2IntMap)orderIndices, helperClassName));
            this.myRunManager.setOrder((arg_0, arg_1) -> UpdateSession.lambda$doUpdateRunConfigurations$9(runConfigurationTypeFilter, (Object2IntMap)orderIndices, arg_0, arg_1));
            HashSet<BuildTargetData> hashSet = generated;
            if (hashSet == null) {
                UpdateSession.$$$reportNull$$$0(5);
            }
            return hashSet;
        }

        @Nullable
        private static CidrBuildConfiguration getDefaultBuildConfiguration(@NotNull CidrBuildConfigurationHelper buildHelper, @NotNull CidrBuildTarget buildTarget) {
            if (buildHelper == null) {
                UpdateSession.$$$reportNull$$$0(6);
            }
            if (buildTarget == null) {
                UpdateSession.$$$reportNull$$$0(7);
            }
            return buildHelper.getDefaultConfiguration(buildTarget);
        }

        private void updateBuildConfiguration(@NotNull RunnerAndConfigurationSettings settings, @NotNull CLionRunConfiguration<?, ?> config) {
            if (settings == null) {
                UpdateSession.$$$reportNull$$$0(8);
            }
            if (config == null) {
                UpdateSession.$$$reportNull$$$0(9);
            }
            this.myHelper.updateBuildConfiguration(this.myRunManager, this.myBuildHelper, settings, config);
        }

        @NotNull
        private Set<BuildTargetData> updateProjectName(@NotNull Set<BuildTargetData> original) {
            if (original == null) {
                UpdateSession.$$$reportNull$$$0(10);
            }
            String projectName = this.myHelper.getProjectName(CLionRunConfigurationManager.this.myProject);
            Set set = ContainerUtil.map2Set(original, it -> new BuildTargetData(projectName, it.targetName));
            if (set == null) {
                UpdateSession.$$$reportNull$$$0(11);
            }
            return set;
        }

        private void updateProjectName(@NotNull RunnerAndConfigurationSettings settings, @NotNull CLionRunConfiguration<?, ?> config) {
            ExecutableData executableData;
            if (settings == null) {
                UpdateSession.$$$reportNull$$$0(12);
            }
            if (config == null) {
                UpdateSession.$$$reportNull$$$0(13);
            }
            boolean changed = false;
            String projectName = this.myHelper.getProjectName(CLionRunConfigurationManager.this.myProject);
            BuildTargetAndConfigurationData data = config.getTargetAndConfigurationData();
            if (data != null && data.target != null && !Objects.equals(data.target.projectName, projectName)) {
                config.setTargetAndConfigurationData(new BuildTargetAndConfigurationData(projectName, data.target.targetName, data.configurationName));
                changed = true;
            }
            if ((executableData = config.getExecutableData()) != null && executableData.target != null && !Objects.equals(executableData.target.projectName, projectName)) {
                config.setExecutableData(new ExecutableData(new BuildTargetData(projectName, executableData.target.targetName)));
                changed = true;
            }
            if (changed) {
                this.myRunManager.fireRunConfigurationChanged(settings);
            }
        }

        private void removeConfigurationsForDeletedTargets(@NotNull Set<BuildTargetData> previouslyGenerated, @NotNull MultiMap<BuildTargetData, RunnerAndConfigurationSettings> deletedTargets, @NotNull Set<BuildTargetData> generated) {
            if (previouslyGenerated == null) {
                UpdateSession.$$$reportNull$$$0(14);
            }
            if (deletedTargets == null) {
                UpdateSession.$$$reportNull$$$0(15);
            }
            if (generated == null) {
                UpdateSession.$$$reportNull$$$0(16);
            }
            for (Map.Entry each : deletedTargets.entrySet()) {
                BuildTargetData buildTarget = (BuildTargetData)each.getKey();
                generated.remove(buildTarget);
                if (!previouslyGenerated.contains(buildTarget)) continue;
                for (RunnerAndConfigurationSettings eachSettings : (Collection)each.getValue()) {
                    if (!StringUtil.equals((CharSequence)eachSettings.getName(), (CharSequence)buildTarget.targetName)) continue;
                    CLionRunConfiguration eachConfig = (CLionRunConfiguration)eachSettings.getConfiguration();
                    BuildTargetAndConfigurationData configData = eachConfig.getTargetAndConfigurationData();
                    ConfigurationFactory configFactory = eachConfig.getFactory();
                    if (configFactory == null) continue;
                    RunnerAndConfigurationSettings template = CLionRunConfigurationManager.createRunConfiguration((RunManagerEx)this.myRunManager, configFactory, buildTarget.targetName, new BuildTargetAndConfigurationData(buildTarget, configData == null ? null : configData.configurationName), (Ref<ExecutableData>)Ref.create((Object)eachConfig.getExecutableData()));
                    RunConfiguration templateConfig = template.getConfiguration();
                    Element eachConfigState = new Element("state");
                    eachConfig.writeExternal(eachConfigState);
                    Element templateState = new Element("state");
                    templateConfig.writeExternal(templateState);
                    if (!JDOMUtil.writeElement((Element)eachConfigState).equals(JDOMUtil.writeElement((Element)templateState))) continue;
                    this.myRunManager.removeConfiguration(eachSettings);
                }
            }
        }

        private void selectConfiguration(@Nullable RunnerAndConfigurationSettings previouslySelected) {
            if (previouslySelected != null && this.myRunManager.findSettings(previouslySelected.getConfiguration()) != null) {
                this.myRunManager.setSelectedConfiguration(previouslySelected);
            }
            ArrayList configurations = new ArrayList();
            List configs = ContainerUtil.flatten((Iterable)ContainerUtil.map((Collection)ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList(), it -> this.myRunManager.getConfigurationSettingsList(it)));
            if (configs.isEmpty()) {
                return;
            }
            this.forEachSettingsAndConfiguration(configs, it -> {
                configurations.add((Pair<RunnerAndConfigurationSettings, CLionRunConfiguration<?, ?>>)it);
                return true;
            });
            configurations.sort(this.myHelper.getConfigurationsComparator());
            if (!configurations.isEmpty()) {
                this.myRunManager.setSelectedConfiguration((RunnerAndConfigurationSettings)((Pair)configurations.get((int)0)).first);
            } else {
                this.myRunManager.setSelectedConfiguration((RunnerAndConfigurationSettings)configs.get(0));
            }
        }

        private boolean forEachConfiguration(@NotNull Iterable<RunnerAndConfigurationSettings> configurations, @NotNull Processor<CLionRunConfiguration<?, ?>> processor) {
            if (configurations == null) {
                UpdateSession.$$$reportNull$$$0(17);
            }
            if (processor == null) {
                UpdateSession.$$$reportNull$$$0(18);
            }
            return this.forEachSettingsAndConfiguration(configurations, it -> processor.process((Object)((CLionRunConfiguration)it.second)));
        }

        private boolean forEachSettingsAndConfiguration(@NotNull Iterable<RunnerAndConfigurationSettings> configurations, @NotNull Processor<Pair<RunnerAndConfigurationSettings, CLionRunConfiguration<?, ?>>> processor) {
            if (configurations == null) {
                UpdateSession.$$$reportNull$$$0(19);
            }
            if (processor == null) {
                UpdateSession.$$$reportNull$$$0(20);
            }
            Predicate<RunnerAndConfigurationSettings> predicate = this.myHelper.getRunConfigurationsFilter();
            for (RunnerAndConfigurationSettings each : configurations) {
                RunConfiguration runConfig;
                if (!predicate.test(each) || processor.process((Object)Pair.create((Object)each, (Object)((CLionRunConfiguration)(runConfig = each.getConfiguration()))))) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ int lambda$doUpdateRunConfigurations$9(Predicate runConfigurationTypeFilter, Object2IntMap orderIndices, RunnerAndConfigurationSettings o1, RunnerAndConfigurationSettings o2) {
            boolean rightNotIndexed;
            ConfigurationType o1type = o1.getConfiguration().getType();
            ConfigurationType o2type = o2.getConfiguration().getType();
            @NlsSafe String o1Name = o1.getName();
            @NlsSafe String o2Name = o2.getName();
            if (!o1type.equals(o2type)) {
                @NonNls String o1TypeId = o1type.getId();
                @NonNls String o2TypeId = o2type.getId();
                throw new IllegalStateException(String.format("Comparing configurations of different types: %s[%s] != %s[%s]", o1TypeId, o1type.getDisplayName(), o2TypeId, o2type.getDisplayName()));
            }
            if (!runConfigurationTypeFilter.test(o1) && !runConfigurationTypeFilter.test(o2)) {
                return 0;
            }
            boolean leftNotIndexed = !orderIndices.containsKey((Object)o1Name);
            boolean bl = rightNotIndexed = !orderIndices.containsKey((Object)o2Name);
            if (leftNotIndexed && rightNotIndexed) {
                throw new IllegalStateException(String.format("Configurations with unique names: \"%s\" (left) and \"%s\" (right) are not indexed", o1Name, o2Name));
            }
            if (leftNotIndexed) {
                throw new IllegalStateException(String.format("Configuration with unique name: \"%s\" (left) is not indexed", o1Name));
            }
            if (rightNotIndexed) {
                throw new IllegalStateException(String.format("Configuration with unique name: \"%s\" (right) is not indexed", o2Name));
            }
            return Integer.compare(orderIndices.getInt((Object)o1Name), orderIndices.getInt((Object)o2Name));
        }

        private /* synthetic */ String lambda$doUpdateRunConfigurations$8(Object2IntMap orderIndices, String helperClassName) {
            return String.format("About to sort %d run configuration(s); custom index size: %d; helper class: %s", this.myRunManager.getAllConfigurationsList().size(), orderIndices.size(), helperClassName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previouslyGenerated";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/execution/manager/CLionRunConfigurationManager$UpdateSession";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildHelper";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildTarget";
                    break;
                }
                case 8: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 9: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deletedTargets";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generated";
                    break;
                }
                case 17: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurations";
                    break;
                }
                case 18: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/execution/manager/CLionRunConfigurationManager$UpdateSession";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "updateRunConfigurations";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doUpdateRunConfigurations";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "updateProjectName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 11: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefaultBuildConfiguration";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "updateBuildConfiguration";
                    break;
                }
                case 10: 
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "updateProjectName";
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "removeConfigurationsForDeletedTargets";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "forEachConfiguration";
                    break;
                }
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "forEachSettingsAndConfiguration";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5, 11 -> new IllegalStateException(string);
            };
        }
    }
}

