/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.compiler.CUDAToolkitInfo;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesProvider;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.UnknownCompilerKind;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class OCCompilerFeatures {
    public static final Type<OCLanguageStandard> LANGUAGE_STANDARD = new Type<OCLanguageStandard>(){

        public String toString() {
            return "LANGUAGE_STANDARD";
        }

        @Override
        @NotNull
        public OCLanguageStandard getDefault() {
            OCLanguageStandard oCLanguageStandard = OCLanguageStandard.CPP98;
            if (oCLanguageStandard == null) {
                1.$$$reportNull$$$0(0);
            }
            return oCLanguageStandard;
        }

        @Override
        @NotNull
        public OCLanguageStandard compute(@NotNull OCCompilerFeaturesProvider provider) {
            if (provider == null) {
                1.$$$reportNull$$$0(1);
            }
            OCLanguageStandard oCLanguageStandard = provider.getLanguageStandard();
            if (oCLanguageStandard == null) {
                1.$$$reportNull$$$0(2);
            }
            return oCLanguageStandard;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefault";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compute";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    };
    public static final short BIT_8 = 1;
    public static final short BIT_16 = 2;
    public static final short BIT_32 = 4;
    public static final short BIT_64 = 8;
    public static final short BIT_128 = 16;
    public static final Type<String> CLANG_TARGET = new Type<String>(){

        public String toString() {
            return "CLANG_TARGET";
        }

        @Override
        @NotNull
        public String getDefault() {
            return "";
        }
    };
    public static final Type<Boolean> IS_MODULE = new Type<Boolean>(){

        public String toString() {
            return "IS_MODULE";
        }

        @Override
        @NotNull
        public Boolean getDefault() {
            Boolean bl = false;
            if (bl == null) {
                3.$$$reportNull$$$0(0);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$3", "getDefault"));
        }
    };
    public static final Type<Boolean> HAS_STD_MODULE_SEARCH_PATHS = new Type<Boolean>(){

        public String toString() {
            return "HAS_STD_MODULE_SEARCH_PATHS";
        }

        @Override
        @NotNull
        public Boolean getDefault() {
            Boolean bl = false;
            if (bl == null) {
                4.$$$reportNull$$$0(0);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$4", "getDefault"));
        }
    };
    public static final Type<CUDAToolkitInfo> CUDA_TOOLKIT = new Type<CUDAToolkitInfo>(){

        public String toString() {
            return "CUDA_TOOLKIT";
        }

        @Override
        @NotNull
        public CUDAToolkitInfo getDefault() {
            return new CUDAToolkitInfo("", false);
        }
    };
    @TestOnly
    private static final Key<Map<Type, Object>> ENABLED_FEATURES = Key.create((String)"ENABLED_FEATURES");

    @Nullable
    public static <T> T getForTests(@NotNull Project project, @NotNull Type<T> type) {
        Map features;
        if (project == null) {
            OCCompilerFeatures.$$$reportNull$$$0(0);
        }
        if (type == null) {
            OCCompilerFeatures.$$$reportNull$$$0(1);
        }
        return (features = (Map)ENABLED_FEATURES.get((UserDataHolder)project)) == null ? null : (T)features.get(type);
    }

    @TestOnly
    public static <T> void set(@NotNull Project project, Type<T> feature, T value) {
        ConcurrentHashMap<Type<T>, T> enabledFeatures;
        if (project == null) {
            OCCompilerFeatures.$$$reportNull$$$0(2);
        }
        if ((enabledFeatures = (ConcurrentHashMap<Type<T>, T>)ENABLED_FEATURES.get((UserDataHolder)project)) == null) {
            enabledFeatures = new ConcurrentHashMap<Type<T>, T>();
            project.putUserData(ENABLED_FEATURES, enabledFeatures);
        }
        enabledFeatures.put(feature, value);
    }

    @TestOnly
    public static void resetFeatures(@NotNull Project project) {
        if (project == null) {
            OCCompilerFeatures.$$$reportNull$$$0(3);
        }
        project.putUserData(ENABLED_FEATURES, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getForTests";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "set";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resetFeatures";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Type<T>
    extends Serializable {
        @NotNull
        public T getDefault();

        @Nullable
        default public T compute(@NotNull OCCompilerFeaturesProvider provider) {
            if (provider == null) {
                Type.$$$reportNull$$$0(0);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Type", "compute"));
        }
    }

    public static enum HostCompilerKind implements Type<OCCompilerKind>
    {
        HOST_COMPILER_KIND(UnknownCompilerKind.INSTANCE);

        @NotNull
        private final OCCompilerKind myHostCompilerKind;

        private HostCompilerKind(OCCompilerKind hostCompilerKind) {
            if (hostCompilerKind == null) {
                HostCompilerKind.$$$reportNull$$$0(0);
            }
            this.myHostCompilerKind = hostCompilerKind;
        }

        @Override
        @NotNull
        public OCCompilerKind getDefault() {
            UnknownCompilerKind unknownCompilerKind = UnknownCompilerKind.INSTANCE;
            if (unknownCompilerKind == null) {
                HostCompilerKind.$$$reportNull$$$0(1);
            }
            return unknownCompilerKind;
        }

        @Override
        @NotNull
        public OCCompilerKind compute(@NotNull OCCompilerFeaturesProvider provider) {
            if (provider == null) {
                HostCompilerKind.$$$reportNull$$$0(2);
            }
            OCCompilerKind oCCompilerKind = this.myHostCompilerKind;
            if (oCCompilerKind == null) {
                HostCompilerKind.$$$reportNull$$$0(3);
            }
            return oCCompilerKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hostCompilerKind";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$HostCompilerKind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$HostCompilerKind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefault";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static enum HostCompilerFlags implements Type<CidrCompilerSwitches>
    {
        HOST_COMPILER_FLAGS(CidrCompilerSwitches.EMPTY);

        @NotNull
        private final CidrCompilerSwitches myHostCompilerSwitches;

        private HostCompilerFlags(CidrCompilerSwitches hostCompilerSwitches) {
            if (hostCompilerSwitches == null) {
                HostCompilerFlags.$$$reportNull$$$0(0);
            }
            this.myHostCompilerSwitches = hostCompilerSwitches;
        }

        @Override
        @NotNull
        public CidrCompilerSwitches getDefault() {
            CidrCompilerSwitches cidrCompilerSwitches = CidrCompilerSwitches.EMPTY;
            if (cidrCompilerSwitches == null) {
                HostCompilerFlags.$$$reportNull$$$0(1);
            }
            return cidrCompilerSwitches;
        }

        @Override
        @NotNull
        public CidrCompilerSwitches compute(@NotNull OCCompilerFeaturesProvider provider) {
            if (provider == null) {
                HostCompilerFlags.$$$reportNull$$$0(2);
            }
            CidrCompilerSwitches cidrCompilerSwitches = this.myHostCompilerSwitches;
            if (cidrCompilerSwitches == null) {
                HostCompilerFlags.$$$reportNull$$$0(3);
            }
            return cidrCompilerSwitches;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hostCompilerSwitches";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$HostCompilerFlags";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$HostCompilerFlags";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefault";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static enum Diagnostic implements Type<DiagnosticLevel>
    {
        MISSING_RETURN_FROM_NON_VOID(DiagnosticLevel.WARNING),
        FOLDING_CONSTANT(DiagnosticLevel.ERROR);

        @NotNull
        private final DiagnosticLevel myDefault;

        private Diagnostic(DiagnosticLevel def) {
            if (def == null) {
                Diagnostic.$$$reportNull$$$0(0);
            }
            this.myDefault = def;
        }

        @Override
        @NotNull
        public DiagnosticLevel getDefault() {
            DiagnosticLevel diagnosticLevel = this.myDefault;
            if (diagnosticLevel == null) {
                Diagnostic.$$$reportNull$$$0(1);
            }
            return diagnosticLevel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "def";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Diagnostic";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Diagnostic";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefault";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static enum DiagnosticLevel {
        DISABLED,
        WARNING,
        ERROR;


        public boolean isEnabled() {
            return this != DISABLED;
        }
    }

    public static enum TypeSize implements Type<Short>
    {
        BOOL(1),
        CHAR(1),
        CHAR8_T(1),
        CHAR16_T(2),
        CHAR32_T(4),
        WCHAR_T(4),
        SHORT(2),
        INT(4),
        LONG(4),
        SIZE_T(INT),
        PTRDIFF_T(SIZE_T),
        POINTER(SIZE_T),
        LONG_LONG(8),
        INT128_T(16),
        FLOAT(4),
        DOUBLE(8),
        LONG_DOUBLE(8);

        @Nullable
        private final TypeSize myBaseType;
        private final short myDefault;

        private TypeSize(short def) {
            this.myBaseType = null;
            this.myDefault = def;
        }

        private TypeSize(TypeSize baseType) {
            if (baseType == null) {
                TypeSize.$$$reportNull$$$0(0);
            }
            this.myBaseType = baseType;
            this.myDefault = this.myBaseType.getDefault();
        }

        @Override
        @NotNull
        public Short getDefault() {
            Short s = this.myDefault;
            if (s == null) {
                TypeSize.$$$reportNull$$$0(1);
            }
            return s;
        }

        @Override
        @Nullable
        public Short compute(@NotNull OCCompilerFeaturesProvider provider) {
            if (provider == null) {
                TypeSize.$$$reportNull$$$0(2);
            }
            if (this.myBaseType != null) {
                return provider.getCompilerFeature(this.myBaseType);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$TypeSize";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$TypeSize";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefault";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Feature implements Type<Boolean>
    {
        HAS_BUILTIN,
        HAS_FEATURE,
        HAS_EXTENSION,
        HAS_HAS_INCLUDE_NEXT,
        C_STATIC_ASSERT(OCLanguageStandard.C11),
        CXX_BUILTIN_WCHAR(OCLanguageStandard.CPP98),
        CXX_EXCEPTIONS(OCLanguageStandard.CPP98),
        CXX_BUILTIN_CHAR16(OCLanguageStandard.CPP11),
        CXX_BUILTIN_CHAR32(OCLanguageStandard.CPP11),
        CXX_AUTO_TYPE(OCLanguageStandard.CPP11),
        CXX_NOEXCEPT(OCLanguageStandard.CPP11),
        CXX_EXPLICIT_CONVERSION_OPERATORS(OCLanguageStandard.CPP11),
        CXX_DELEGATING_CONSTRUCTORS(OCLanguageStandard.CPP11),
        CXX_DEFAULTED_AND_DELETED_FUNCTIONS(OCLanguageStandard.CPP11),
        CXX_OVERRIDE_CONTROL(OCLanguageStandard.CPP11),
        CXX_GENERALIZED_INITIALIZERS(OCLanguageStandard.CPP11),
        CXX_NULLPTR(OCLanguageStandard.CPP11),
        CXX_NONSTATIC_MEMBER_INIT(OCLanguageStandard.CPP11),
        CXX_LAMBDAS(OCLanguageStandard.CPP11),
        CXX_RAW_STRING_LITERALS(OCLanguageStandard.CPP11),
        CXX_USER_LITERALS(OCLanguageStandard.CPP11),
        CXX_ATTRIBUTES(OCLanguageStandard.CPP11),
        CXX_CONSTEXPR(OCLanguageStandard.CPP11),
        CXX_CONSTEXPR_VOID(OCLanguageStandard.CPP14),
        CXX_RELAXED_CONSTEXPR(OCLanguageStandard.CPP14),
        CXX_HAS_IMPLICIT_CONST_ON_CONSTEXPR_MEMBER(OCLanguageStandard.CPP11, OCLanguageStandard.CPP14),
        CXX_BINARY_LITERALS(OCLanguageStandard.CPP14),
        CXX_RETURN_TYPE_DEDUCTION(OCLanguageStandard.CPP14),
        CXX_GENERIC_LAMBDAS(OCLanguageStandard.CPP14),
        CXX_STRING_BUILTINS(OCLanguageStandard.CPP17),
        CXX_STRUCTURED_BINDINGS(OCLanguageStandard.CPP17),
        CXX_CTAD(OCLanguageStandard.CPP17),
        CXX_GUARANTEED_COPY_ELISION(OCLanguageStandard.CPP17),
        CXX_AGGREGATES_WITH_BASE_CLASSES(OCLanguageStandard.CPP17),
        CXX_INLINE_VARIABLES(OCLanguageStandard.CPP17),
        CXX_CONSTEXPR_IF(OCLanguageStandard.CPP17),
        CXX_IF_INITIALIZERS(OCLanguageStandard.CPP17),
        CXX_NESTED_NAMESPACES(OCLanguageStandard.CPP17),
        CXX_HAS_AUTO_WITH_LIST_INIT_FIX(OCLanguageStandard.CPP11),
        CXX_BUILTIN_IS_CONSTANT_EVALUATED(OCLanguageStandard.CPP20),
        CXX_OBJECT_TEMPLATE_PARAMETERS(OCLanguageStandard.CPP20),
        CXX_CONSTEVAL(OCLanguageStandard.CPP20),
        CXX_CONSTINIT(OCLanguageStandard.CPP20),
        CXX_USING_ENUM(OCLanguageStandard.CPP20),
        CXX_DEFAULT_CONSTRUCTIBLE_AND_ASSIGNABLE_STATELESS_LAMBDAS(OCLanguageStandard.CPP20),
        CXX_THREE_WAY_COMPARISON(OCLanguageStandard.CPP20),
        CXX_CTAD_FOR_AGGREGATES_AND_TYPE_ALIASES(OCLanguageStandard.CPP20),
        CXX_PROHIBIT_AGGREGATES_WITH_USER_DECLARED_CONSTRUCTORS(OCLanguageStandard.CPP20),
        CXX_AGGREGATE_PAREN_INIT(OCLanguageStandard.CPP20),
        CXX_RANGE_FOR_INITIALIZERS(OCLanguageStandard.CPP20),
        CXX_BUILTIN_CHAR8(OCLanguageStandard.CPP20),
        CXX_COROUTINES(OCLanguageStandard.CPP20),
        CXX_CONCEPTS(OCLanguageStandard.CPP20),
        CXX_CPP_20_STRUCTURED_BINDINGS(OCLanguageStandard.CPP20),
        CXX_CPP_20_TEMPLATE_FUNCTIONS_DISAMBIGUATION(OCLanguageStandard.CPP20),
        CXX_TYPE_INFO_IN_GLOBAL_NAMESPACE,
        CXX_MS_ALLOW_BINDING_RVALUE_TO_LVALUE_REFERENCE,
        CXX_MS_PREFER_COPY_CTOR_OVER_USER_DEFINED,
        CXX_ALTERNATIVE_OPERATORS,
        MS_TRADITIONAL_PREPROCESSOR,
        C_VARIABLE_DECLARATION_RULES_ARE_C89_COMPATIBLE,
        C_NULLPTR(OCLanguageStandard.C23),
        C_AUTO_TYPE(OCLanguageStandard.C23),
        C_CONSTEXPR(OCLanguageStandard.C23),
        BUILTIN_BIT_CAST(OCLanguageStandard.CPP20),
        BUILTIN_SOURCE_LOCATION(OCLanguageStandard.CPP20),
        CXX_EXPLICIT_THIS_PARAMETER(OCLanguageStandard.CPP23),
        OBJC_ARC,
        OBJC_BOOL,
        OBJC_DEFAULT_SYNTHESIZE_PROPERTIES,
        OBJC_PROPERTY_EXPLICIT_ATOMIC,
        OBJC_INSTANCETYPE,
        OBJC_SUBSCRIPTING,
        OBJC_ARRAY_LITERALS,
        OBJC_DICTIONARY_LITERALS,
        OBJC_CLASS_PROPERTY,
        UNDERLYING_TYPE,
        IS_BASE_OF,
        NULLABILITY,
        NULLABILITY_NULLABLE_RESULT,
        GCC_AUTO_TYPE,
        BUILTIN_AVAILABLE,
        IS_TARGET_ARCH,
        IS_TARGET_VENDOR,
        IS_TARGET_OS,
        IS_TARGET_ENVIRONMENT,
        IS_TARGET_VARIANT_OS,
        IS_TARGET_VARIANT_ENVIRONMENT,
        DATA_PLACEMENT_OPERATOR,
        EXPERIMENTAL_LIBRARY,
        MS_EXTENSIONS{

            @Override
            @NotNull
            public Boolean compute(@NotNull OCCompilerFeaturesProvider provider) {
                if (provider == null) {
                    1.$$$reportNull$$$0(0);
                }
                Boolean bl = provider.areMSExtensionsEnabled();
                if (bl == null) {
                    1.$$$reportNull$$$0(1);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "provider";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Feature$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Feature$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "compute";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "compute";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }
        ,
        IS_GNU_COMPATIBLE{

            @Override
            @NotNull
            public Boolean compute(@NotNull OCCompilerFeaturesProvider provider) {
                if (provider == null) {
                    2.$$$reportNull$$$0(0);
                }
                Boolean bl = provider.isGNUCompatible();
                if (bl == null) {
                    2.$$$reportNull$$$0(1);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "provider";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Feature$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Feature$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "compute";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "compute";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }
        ,
        GNU_EXTENSIONS{

            @Override
            @NotNull
            public Boolean compute(@NotNull OCCompilerFeaturesProvider provider) {
                if (provider == null) {
                    3.$$$reportNull$$$0(0);
                }
                Boolean bl = provider.areGNUExtensionsEnabled();
                if (bl == null) {
                    3.$$$reportNull$$$0(1);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "provider";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Feature$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Feature$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "compute";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "compute";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };

        @Nullable
        private final OCLanguageStandard myAvailableInStandard;
        @Nullable
        private final OCLanguageStandard myAvailableUntilStandard;

        private Feature() {
            this(null);
        }

        private Feature(OCLanguageStandard availableInStandard) {
            this.myAvailableInStandard = availableInStandard;
            this.myAvailableUntilStandard = null;
        }

        private Feature(OCLanguageStandard sinceStandard, OCLanguageStandard untilStandard) {
            this.myAvailableInStandard = sinceStandard;
            this.myAvailableUntilStandard = untilStandard;
        }

        @Override
        @NotNull
        public Boolean getDefault() {
            if (this.myAvailableUntilStandard != null && LANGUAGE_STANDARD.getDefault().supports(this.myAvailableUntilStandard)) {
                Boolean bl = false;
                if (bl == null) {
                    Feature.$$$reportNull$$$0(0);
                }
                return bl;
            }
            Boolean bl = this.myAvailableInStandard != null && LANGUAGE_STANDARD.getDefault().supports(this.myAvailableInStandard);
            if (bl == null) {
                Feature.$$$reportNull$$$0(1);
            }
            return bl;
        }

        @Override
        @Nullable
        public Boolean compute(@NotNull OCCompilerFeaturesProvider provider) {
            if (provider == null) {
                Feature.$$$reportNull$$$0(2);
            }
            OCLanguageStandard standard = (OCLanguageStandard)ObjectUtils.notNull((Object)provider.getCompilerFeature(LANGUAGE_STANDARD), (Object)LANGUAGE_STANDARD.getDefault());
            if (this.myAvailableUntilStandard != null && standard.supports(this.myAvailableUntilStandard)) {
                return false;
            }
            if (this.myAvailableInStandard != null) {
                return standard.supports(this.myAvailableInStandard);
            }
            return null;
        }

        @Nullable
        public OCLanguageStandard getAvailableInStandard() {
            return this.myAvailableInStandard;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Feature";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefault";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Feature";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static enum TypeTrait implements Type<Boolean>
    {
        IS_ARRAY("__is_array"),
        IS_UNBOUNDED_ARRAY("__is_unbounded_array"),
        IS_FUNCTION("__is_function"),
        IS_OBJECT("__is_object"),
        IS_LITERAL("__is_literal"),
        IS_POINTER("__is_pointer"),
        IS_MEMBER_POINTER("__is_member_pointer"),
        IS_MEMBER_FUNCTION_POINTER("__is_member_function_pointer"),
        IS_MEMBER_OBJECT_POINTER("__is_member_object_pointer"),
        IS_REFERENCE("__is_reference"),
        IS_LVALUE_REFERENCE("__is_lvalue_reference"),
        IS_RVALUE_REFERENCE("__is_rvalue_reference"),
        IS_CONST("__is_const"),
        IS_VOLATILE("__is_volatile"),
        IS_NULLPTR("__is_nullptr"),
        IS_SCALAR("__is_scalar"),
        IS_ARITHMETIC("__is_arithmetic"),
        IS_COMPOUND("__is_compound"),
        IS_FUNDAMENTAL("__is_fundamental"),
        IS_COMPLETE_TYPE("__is_complete_type"),
        IS_SIGNED("__is_signed"),
        IS_UNSIGNED("__is_unsigned"),
        IS_VOID("__is_void"),
        IS_INTEGRAL("__is_integral"),
        IS_FLOATING_POINT("__is_floating_point"),
        ADD_POINTER("__add_pointer"),
        ADD_LVALUE_REFERENCE("__add_lvalue_reference"),
        ADD_RVALUE_REFERENCE("__add_rvalue_reference"),
        DECAY("__decay"),
        MAKE_SIGNED("__make_signed"),
        MAKE_UNSIGNED("__make_unsigned"),
        REMOVE_CONST("__remove_const"),
        REMOVE_VOLATILE("__remove_volatile"),
        REMOVE_CV("__remove_cv"),
        REMOVE_CVREF("__remove_cvref"),
        REMOVE_REFERENCE("__remove_reference"),
        REMOVE_REFERENCE_T("__remove_reference_t"),
        REMOVE_POINTER("__remove_pointer"),
        REMOVE_EXTENT("__remove_extent"),
        REMOVE_ALL_EXTENTS("__remove_all_extents"),
        IS_CONVERTIBLE("__is_convertible"),
        IS_NOTHROW_CONVERTIBLE("__is_nothrow_convertible"),
        IS_SAME("__is_same"),
        IS_SAME_AS("__is_same_as"),
        MAKE_INTEGER_SEQ("__make_integer_seq"),
        TYPE_PACK_ELEMENT("__type_pack_element"),
        INTEGER_PACK("__integer_pack");

        @NotNull
        @NonNls
        private final String mySpelling;

        private TypeTrait(String spelling) {
            if (spelling == null) {
                TypeTrait.$$$reportNull$$$0(0);
            }
            this.mySpelling = spelling;
        }

        @Override
        @NotNull
        public Boolean getDefault() {
            Boolean bl = false;
            if (bl == null) {
                TypeTrait.$$$reportNull$$$0(1);
            }
            return bl;
        }

        @NotNull
        @NonNls
        public String getSpelling() {
            String string = this.mySpelling;
            if (string == null) {
                TypeTrait.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        @NonNls
        public String toString() {
            String string = this.getSpelling();
            if (string == null) {
                TypeTrait.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "spelling";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$TypeTrait";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$TypeTrait";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefault";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSpelling";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

