/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.PathTree;
import com.jetbrains.cidr.PathTreeBase;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeadersSearchPathTree
extends PathTree<HeadersSearchPathTree, HeadersSearchPath> {
    @Nullable
    private final HeadersSearchPathTree myParent;
    @NotNull
    private final List<HeadersSearchPath> myCompactedPaths = new ArrayList<HeadersSearchPath>();

    public HeadersSearchPathTree() {
        this(null);
    }

    private HeadersSearchPathTree(@Nullable HeadersSearchPathTree parent) {
        super(Registry.is((String)"cidr.strict.dotdot.resolution.in.header.search.paths", (boolean)true));
        this.myParent = parent;
    }

    @NotNull
    protected HeadersSearchPathTree createNewTree(@Nullable HeadersSearchPathTree parent) {
        return new HeadersSearchPathTree(parent);
    }

    public void addSearchPathCompacting(@NotNull HeadersSearchPath path) {
        if (path == null) {
            HeadersSearchPathTree.$$$reportNull$$$0(0);
        }
        String filePath = path.getPath();
        HeadersSearchPathTree visitedAncestorTree = (HeadersSearchPathTree)this.getSubTree(filePath, PathTreeBase.SearchStrategy.DEEPEST_EXISTING_PREFIX);
        while (visitedAncestorTree != null) {
            for (HeadersSearchPath visitedPath : visitedAncestorTree.getItems()) {
                if (path.getKind() != visitedPath.getKind() || path.isFrameworksSearchPath() != visitedPath.isFrameworksSearchPath() || !visitedPath.isRecursive() && !path.equals(visitedPath)) continue;
                return;
            }
            visitedAncestorTree = visitedAncestorTree.myParent;
        }
        this.addItem(filePath, path);
        this.myCompactedPaths.add(path);
    }

    public void addSearchPathsCompacting(@NotNull Collection<HeadersSearchPath> paths) {
        if (paths == null) {
            HeadersSearchPathTree.$$$reportNull$$$0(1);
        }
        for (HeadersSearchPath path : paths) {
            this.addSearchPathCompacting(path);
        }
    }

    @NotNull
    public List<HeadersSearchPath> getCompactedPaths() {
        List<HeadersSearchPath> list = Collections.unmodifiableList(this.myCompactedPaths);
        if (list == null) {
            HeadersSearchPathTree.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchPathTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchPathTree";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompactedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addSearchPathCompacting";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addSearchPathsCompacting";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

