/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.inspection.grammar;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.ide.inspection.grammar.GrazieInspection;
import com.intellij.grazie.text.CheckerRunner;
import com.intellij.grazie.text.TextChecker;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.text.TextProblem;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spellchecker.ui.SpellCheckingEditorCustomization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/GrazieInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getDisplayName", "", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Companion", "intellij.grazie.core"})
public final class GrazieInspection
extends LocalInspectionTool
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MAX_TEXT_LENGTH_IN_PSI_ELEMENT = 50000;
    private static final int MAX_TEXT_LENGTH_IN_FILE = 200000;
    @NotNull
    private static final Lazy<Boolean> hasSpellChecking$delegate = LazyKt.lazy(GrazieInspection::hasSpellChecking_delegate$lambda$0);

    @NotNull
    public String getDisplayName() {
        return GrazieBundle.message("grazie.grammar.inspection.grammar.text", new Object[0]);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file = psiFile;
        if (Companion.ignoreGrammarChecking(file) || InspectionProfileManager.hasTooLowSeverity((LocalInspectionToolSession)session, (LocalInspectionTool)this)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        List<TextChecker> checkers = TextChecker.allCheckers();
        Set<TextContent.TextDomain> checkedDomains = Companion.checkedDomains();
        Function1<PsiElement, Boolean> areChecksDisabled = Companion.getDisabledChecker(file);
        return new PsiElementVisitor(areChecksDisabled, checkedDomains, session, checkers, isOnTheFly, holder){
            final /* synthetic */ Function1<PsiElement, Boolean> $areChecksDisabled;
            final /* synthetic */ Set<TextContent.TextDomain> $checkedDomains;
            final /* synthetic */ LocalInspectionToolSession $session;
            final /* synthetic */ List<TextChecker> $checkers;
            final /* synthetic */ boolean $isOnTheFly;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$areChecksDisabled = $areChecksDisabled;
                this.$checkedDomains = $checkedDomains;
                this.$session = $session;
                this.$checkers = $checkers;
                this.$isOnTheFly = $isOnTheFly;
                this.$holder = $holder;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof PsiWhiteSpace || ((Boolean)this.$areChecksDisabled.invoke((Object)element)).booleanValue()) {
                    return;
                }
                List<TextContent> list = TextExtractor.findUniqueTextsAt(element, this.$checkedDomains);
                Intrinsics.checkNotNullExpressionValue(list, (String)"findUniqueTextsAt(...)");
                List<TextContent> texts = list;
                if (GrazieInspection.Companion.skipCheckingTooLargeTexts(texts)) {
                    return;
                }
                TextRange textRange = this.$session.getPriorityRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getPriorityRange(...)");
                for (TextContent extracted : GrazieInspection.Companion.sortByPriority(texts, textRange)) {
                    CheckerRunner runner = new CheckerRunner(extracted);
                    List<TextChecker> list2 = this.$checkers;
                    Intrinsics.checkNotNull(list2);
                    runner.run(list2, (Function1<? super TextProblem, Unit>)((Function1)arg_0 -> buildVisitor.1.visitElement$lambda$0(runner, this.$isOnTheFly, this.$holder, arg_0)));
                }
            }

            private static final Unit visitElement$lambda$0(CheckerRunner $runner, boolean $isOnTheFly, ProblemsHolder $holder, TextProblem problem) {
                Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
                Iterable $this$forEach$iv = $runner.toProblemDescriptors(problem, $isOnTheFly);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ProblemDescriptor p0 = (ProblemDescriptor)element$iv;
                    boolean bl = false;
                    $holder.registerProblem(p0);
                }
                return Unit.INSTANCE;
            }
        };
    }

    private static final boolean hasSpellChecking_delegate$lambda$0() {
        boolean bl;
        try {
            Class.forName("com.intellij.spellchecker.ui.SpellCheckingEditorCustomization");
            bl = true;
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final Set<TextContent> findAllTextContents(@NotNull FileViewProvider vp, @NotNull Set<? extends TextContent.TextDomain> domains) {
        return Companion.findAllTextContents(vp, domains);
    }

    @JvmStatic
    public static final boolean skipCheckingTooLargeTexts(@NotNull List<? extends TextContent> texts) {
        return Companion.skipCheckingTooLargeTexts(texts);
    }

    @JvmStatic
    public static final boolean ignoreGrammarChecking(@NotNull PsiFile file) {
        return Companion.ignoreGrammarChecking(file);
    }

    @JvmStatic
    @NotNull
    public static final Set<TextContent.TextDomain> checkedDomains() {
        return Companion.checkedDomains();
    }

    @JvmStatic
    @NotNull
    public static final Function1<PsiElement, Boolean> getDisabledChecker(@NotNull PsiFile file) {
        return Companion.getDisabledChecker(file);
    }

    @JvmStatic
    @NotNull
    public static final List<TextContent> sortByPriority(@NotNull List<? extends TextContent> texts, @NotNull TextRange priorityRange) {
        return Companion.sortByPriority(texts, priorityRange);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\"B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000eH\u0007J\u0016\u0010\u0014\u001a\u00020\b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u000eH\u0007J\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\b0\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J$\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\u0006\u0010 \u001a\u00020!H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006#"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Companion;", "", "<init>", "()V", "MAX_TEXT_LENGTH_IN_PSI_ELEMENT", "", "MAX_TEXT_LENGTH_IN_FILE", "hasSpellChecking", "", "getHasSpellChecking", "()Z", "hasSpellChecking$delegate", "Lkotlin/Lazy;", "findAllTextContents", "", "Lcom/intellij/grazie/text/TextContent;", "vp", "Lcom/intellij/psi/FileViewProvider;", "domains", "Lcom/intellij/grazie/text/TextContent$TextDomain;", "skipCheckingTooLargeTexts", "texts", "", "ignoreGrammarChecking", "file", "Lcom/intellij/psi/PsiFile;", "isSpellCheckingDisabled", "checkedDomains", "getDisabledChecker", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "sortByPriority", "priorityRange", "Lcom/intellij/openapi/util/TextRange;", "TextContentRelatedData", "intellij.grazie.core"})
    @SourceDebugExtension(value={"SMAP\nGrazieInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieInspection.kt\ncom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n1#2:162\n1056#3:163\n*S KotlinDebug\n*F\n+ 1 GrazieInspection.kt\ncom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Companion\n*L\n139#1:163\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean getHasSpellChecking() {
            Lazy lazy = hasSpellChecking$delegate;
            return (Boolean)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final Set<TextContent> findAllTextContents(@NotNull FileViewProvider vp, @NotNull Set<? extends TextContent.TextDomain> domains) {
            Intrinsics.checkNotNullParameter((Object)vp, (String)"vp");
            Intrinsics.checkNotNullParameter(domains, (String)"domains");
            Set allContents = new HashSet();
            for (Object e : vp.getAllFiles()) {
                Iterator iterator;
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                PsiFile root = (PsiFile)e;
                Intrinsics.checkNotNullExpressionValue((Object)SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)root)).iterator(), (String)"iterator(...)");
                while (iterator.hasNext()) {
                    PsiElement element = (PsiElement)iterator.next();
                    if (element.getFirstChild() != null) continue;
                    List<TextContent> list = TextExtractor.findTextsAt(element, domains);
                    Intrinsics.checkNotNullExpressionValue(list, (String)"findTextsAt(...)");
                    allContents.addAll((Collection)list);
                }
            }
            return allContents;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final boolean skipCheckingTooLargeTexts(@NotNull List<? extends TextContent> texts) {
            int n;
            int n2;
            Object object2;
            Intrinsics.checkNotNullParameter(texts, (String)"texts");
            if (texts.isEmpty()) {
                return false;
            }
            Iterable iterable = texts;
            int n3 = 0;
            for (Object object2 : iterable) {
                void it;
                TextContent textContent = (TextContent)object2;
                n2 = n3;
                boolean bl = false;
                n = it.length();
                n3 = n2 + n;
            }
            if (n3 > 50000) {
                return true;
            }
            PsiFile psiFile = texts.get(0).getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            PsiFile file = psiFile;
            if (file.getTextLength() <= 200000) {
                return false;
            }
            Set<TextContent> allInFile = ((TextContentRelatedData)CachedValuesManager.getProjectPsiDependentCache((PsiElement)((PsiElement)file), arg_0 -> Companion.skipCheckingTooLargeTexts$lambda$2(arg_0 -> Companion.skipCheckingTooLargeTexts$lambda$1(file, arg_0), arg_0))).getContents();
            Set<TextContent.TextDomain> checkedDomains = this.checkedDomains();
            object2 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)allInFile), arg_0 -> Companion.skipCheckingTooLargeTexts$lambda$3(checkedDomains, arg_0));
            int n4 = 0;
            for (Object e : object2) {
                void it;
                TextContent textContent = (TextContent)e;
                n2 = n4;
                boolean bl = false;
                n = it.length();
                n4 = n2 + n;
            }
            return n4 > 200000;
        }

        @JvmStatic
        public final boolean ignoreGrammarChecking(@NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return this.getHasSpellChecking() && this.isSpellCheckingDisabled(file);
        }

        private final boolean isSpellCheckingDisabled(PsiFile file) {
            return SpellCheckingEditorCustomization.isSpellCheckingDisabled((PsiFile)file);
        }

        @JvmStatic
        @NotNull
        public final Set<TextContent.TextDomain> checkedDomains() {
            EnumSet<Enum> result = EnumSet.of((Enum)TextContent.TextDomain.PLAIN_TEXT);
            if (GrazieConfig.Companion.get().getCheckingContext().isCheckInStringLiteralsEnabled()) {
                result.add(TextContent.TextDomain.LITERALS);
            }
            if (GrazieConfig.Companion.get().getCheckingContext().isCheckInCommentsEnabled()) {
                result.add(TextContent.TextDomain.COMMENTS);
            }
            if (GrazieConfig.Companion.get().getCheckingContext().isCheckInDocumentationEnabled()) {
                result.add(TextContent.TextDomain.DOCUMENTATION);
            }
            Intrinsics.checkNotNull(result);
            return result;
        }

        @JvmStatic
        @NotNull
        public final Function1<PsiElement, Boolean> getDisabledChecker(@NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Language language = file.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
            Language fileLanguage = language;
            Set<Language> supportedLanguages = TextExtractor.getSupportedLanguages();
            Set<String> disabledLanguages = GrazieConfig.Companion.get().getCheckingContext().getEffectivelyDisabledLanguageIds();
            return arg_0 -> Companion.getDisabledChecker$lambda$5(fileLanguage, supportedLanguages, disabledLanguages, arg_0);
        }

        @JvmStatic
        @NotNull
        public final List<TextContent> sortByPriority(@NotNull List<? extends TextContent> texts, @NotNull TextRange priorityRange) {
            Intrinsics.checkNotNullParameter(texts, (String)"texts");
            Intrinsics.checkNotNullParameter((Object)priorityRange, (String)"priorityRange");
            Iterable $this$sortedBy$iv = texts;
            boolean $i$f$sortedBy = false;
            return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(priorityRange){
                final /* synthetic */ TextRange $priorityRange$inlined;
                {
                    this.$priorityRange$inlined = textRange;
                }

                public final int compare(T a, T b) {
                    TextContent text = (TextContent)a;
                    boolean bl = false;
                    TextRange textRange = text.textRangeToFile(new TextRange(0, text.length()));
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"textRangeToFile(...)");
                    TextRange textRangeInFile = textRange;
                    text = (TextContent)b;
                    Comparable comparable = Integer.valueOf(textRangeInFile.contains(this.$priorityRange$inlined) ? 0 : (textRangeInFile.intersects(this.$priorityRange$inlined) ? 1 : 2));
                    bl = false;
                    TextRange textRange2 = text.textRangeToFile(new TextRange(0, text.length()));
                    Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"textRangeToFile(...)");
                    textRangeInFile = textRange2;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(textRangeInFile.contains(this.$priorityRange$inlined) ? 0 : (textRangeInFile.intersects(this.$priorityRange$inlined) ? 1 : 2)));
                }
            });
        }

        private static final TextContentRelatedData skipCheckingTooLargeTexts$lambda$1(PsiFile $file, PsiFile it) {
            FileViewProvider fileViewProvider = it.getViewProvider();
            Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"getViewProvider(...)");
            Set<TextContent.TextDomain> set = TextContent.TextDomain.ALL;
            Intrinsics.checkNotNullExpressionValue(set, (String)"ALL");
            Set<TextContent> contents = Companion.findAllTextContents(fileViewProvider, set);
            return new TextContentRelatedData($file, contents);
        }

        private static final TextContentRelatedData skipCheckingTooLargeTexts$lambda$2(Function1 $tmp0, Object p0) {
            return (TextContentRelatedData)$tmp0.invoke(p0);
        }

        private static final boolean skipCheckingTooLargeTexts$lambda$3(Set $checkedDomains, TextContent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return $checkedDomains.contains((Object)it.getDomain());
        }

        private static final boolean getDisabledChecker$lambda$5(Language $fileLanguage, Set $supportedLanguages, Set $disabledLanguages, PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Language lang = element.getLanguage();
            if ($fileLanguage.isKindOf(lang)) {
                lang = $fileLanguage;
            }
            while (lang != null && !$supportedLanguages.contains(lang)) {
                lang = lang.getBaseLanguage();
            }
            return lang != null && $disabledLanguages.contains(lang.getID());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\t\u0010\r\u001a\u00020\u0003H\u00c2\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Companion$TextContentRelatedData;", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "contents", "", "Lcom/intellij/grazie/text/TextContent;", "<init>", "(Lcom/intellij/psi/PsiFile;Ljava/util/Set;)V", "getContents", "()Ljava/util/Set;", "toString", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "intellij.grazie.core"})
        @SourceDebugExtension(value={"SMAP\nGrazieInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieInspection.kt\ncom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Companion$TextContentRelatedData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n1563#2:162\n1634#2,3:163\n1563#2:166\n1634#2,3:167\n1563#2:170\n1634#2,3:171\n1563#2:174\n1634#2,3:175\n*S KotlinDebug\n*F\n+ 1 GrazieInspection.kt\ncom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Companion$TextContentRelatedData\n*L\n153#1:162\n153#1:163,3\n154#1:166\n154#1:167,3\n154#1:170\n154#1:171,3\n156#1:174\n156#1:175,3\n*E\n"})
        public static final class TextContentRelatedData {
            @NotNull
            private final PsiFile psiFile;
            @NotNull
            private final Set<TextContent> contents;

            public TextContentRelatedData(@NotNull PsiFile psiFile, @NotNull Set<? extends TextContent> contents) {
                Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                Intrinsics.checkNotNullParameter(contents, (String)"contents");
                this.psiFile = psiFile;
                this.contents = contents;
            }

            @NotNull
            public final Set<TextContent> getContents() {
                return this.contents;
            }

            @NotNull
            public String toString() {
                Collection<Language> collection;
                TextContent it;
                Collection collection2;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                FileType fileType = this.psiFile.getViewProvider().getVirtualFile().getFileType();
                Language language = this.psiFile.getLanguage();
                List list = this.psiFile.getViewProvider().getAllFiles();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllFiles(...)");
                Iterable iterable = list;
                Language language2 = language;
                FileType fileType2 = fileType;
                boolean $i$f$map = false;
                void var3_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    PsiFile psiFile = (PsiFile)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(it.getLanguage());
                }
                collection2 = (List)destination$iv$iv;
                $this$map$iv = this.contents;
                collection2 = CollectionsKt.toSet((Iterable)collection2);
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (TextContent)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((Language)it.getCommonParent());
                }
                collection = (List)destination$iv$iv;
                $this$map$iv = collection;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (PsiElement)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getLanguage());
                }
                collection = (List)destination$iv$iv;
                return "[fileType = " + fileType2 + ", fileLanguage = " + language2 + ", viewProviderLanguages = " + (Set)collection2 + ", parentLanguages = " + CollectionsKt.toSet((Iterable)collection) + ",";
            }

            private final PsiFile component1() {
                return this.psiFile;
            }

            @NotNull
            public final Set<TextContent> component2() {
                return this.contents;
            }

            @NotNull
            public final TextContentRelatedData copy(@NotNull PsiFile psiFile, @NotNull Set<? extends TextContent> contents) {
                Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                Intrinsics.checkNotNullParameter(contents, (String)"contents");
                return new TextContentRelatedData(psiFile, contents);
            }

            public static /* synthetic */ TextContentRelatedData copy$default(TextContentRelatedData textContentRelatedData, PsiFile psiFile, Set set, int n, Object object) {
                if ((n & 1) != 0) {
                    psiFile = textContentRelatedData.psiFile;
                }
                if ((n & 2) != 0) {
                    set = textContentRelatedData.contents;
                }
                return textContentRelatedData.copy(psiFile, set);
            }

            public int hashCode() {
                int result = this.psiFile.hashCode();
                result = result * 31 + ((Object)this.contents).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TextContentRelatedData)) {
                    return false;
                }
                TextContentRelatedData textContentRelatedData = (TextContentRelatedData)other;
                if (!Intrinsics.areEqual((Object)this.psiFile, (Object)textContentRelatedData.psiFile)) {
                    return false;
                }
                return Intrinsics.areEqual(this.contents, textContentRelatedData.contents);
            }
        }
    }
}

