/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrTestEventProcessor {
    @NotNull
    private final String myLocationProtocol;

    public CidrTestEventProcessor(@NotNull String locationProtocol) {
        if (locationProtocol == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(0);
        }
        this.myLocationProtocol = locationProtocol;
    }

    @NotNull
    public List<ServiceMessageBuilder> suiteStarted(@NlsSafe @NotNull String name, @NonNls @NotNull String location) {
        if (name == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(1);
        }
        if (location == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(2);
        }
        List<ServiceMessageBuilder> list = this.suiteStarted(name, null, null, location, null);
        if (list == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<ServiceMessageBuilder> suiteStarted(@NlsSafe @NotNull String name, @NonNls @Nullable String parentId, @NonNls @Nullable String nodeId, @NotNull String location, @Nullable String metainfo) {
        if (name == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(4);
        }
        if (location == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(5);
        }
        List<ServiceMessageBuilder> list = this.doSuiteStarted(name, parentId, nodeId, location, metainfo);
        if (list == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    protected List<ServiceMessageBuilder> doSuiteStarted(@NlsSafe @NotNull String name, @NonNls @Nullable String parentId, @NonNls @Nullable String nodeId, @NonNls @NotNull String location, @NonNls @Nullable String metainfo) {
        if (name == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(7);
        }
        if (location == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(8);
        }
        List<ServiceMessageBuilder> list = Collections.singletonList(CidrTestEventProcessor.setParentNodeId(parentId, CidrTestEventProcessor.setNodeId(nodeId, this.setLocation(location, CidrTestEventProcessor.setMetainfo(metainfo, ServiceMessageBuilder.testSuiteStarted((String)name))))));
        if (list == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<ServiceMessageBuilder> suiteFinished(@NlsSafe @NotNull String name) {
        if (name == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(10);
        }
        List<ServiceMessageBuilder> list = this.suiteFinished(name, null);
        if (list == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public List<ServiceMessageBuilder> suiteFinished(@NlsSafe @NotNull String name, @NonNls @Nullable String nodeId) {
        if (name == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(12);
        }
        List<ServiceMessageBuilder> list = Collections.singletonList(CidrTestEventProcessor.setNodeId(nodeId, ServiceMessageBuilder.testSuiteFinished((String)name)));
        if (list == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public List<ServiceMessageBuilder> testStarted(@NlsSafe @NotNull String testName, @NonNls @NotNull String location) {
        if (testName == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(14);
        }
        if (location == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(15);
        }
        List<ServiceMessageBuilder> list = this.testStarted(testName, null, null, location, null);
        if (list == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public List<ServiceMessageBuilder> testStarted(@NlsSafe @NotNull String testName, @NonNls @Nullable String parentId, @NonNls @Nullable String nodeId, @NonNls @NotNull String location, @NonNls @Nullable String metainfo) {
        if (testName == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(17);
        }
        if (location == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(18);
        }
        List<ServiceMessageBuilder> list = this.doTestStarted(testName, parentId, nodeId, location, metainfo);
        if (list == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    protected List<ServiceMessageBuilder> doTestStarted(@NlsSafe @NotNull String testName, @NonNls @Nullable String parentId, @NonNls @Nullable String nodeId, @NonNls @NotNull String location, @NonNls @Nullable String metainfo) {
        if (testName == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(20);
        }
        if (location == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(21);
        }
        List<ServiceMessageBuilder> list = Collections.singletonList(CidrTestEventProcessor.setParentNodeId(parentId, CidrTestEventProcessor.setNodeId(nodeId, this.setLocation(location, CidrTestEventProcessor.setMetainfo(metainfo, ServiceMessageBuilder.testStarted((String)testName))))));
        if (list == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    public List<ServiceMessageBuilder> testFinished(@NlsSafe @NotNull String testName, @NonNls @NotNull String duration, boolean success) {
        if (testName == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(23);
        }
        if (duration == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(24);
        }
        List<ServiceMessageBuilder> list = this.testFinished(testName, duration, success, false);
        if (list == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(25);
        }
        return list;
    }

    @NotNull
    public List<ServiceMessageBuilder> testFinished(@NlsSafe @NotNull String testName, @NonNls @NotNull String duration, boolean success, boolean ignored) {
        if (testName == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(26);
        }
        if (duration == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(27);
        }
        List<ServiceMessageBuilder> list = this.testFinished(testName, null, duration, success, ignored);
        if (list == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    public List<ServiceMessageBuilder> testFinished(@NlsSafe @NotNull String testName, @NonNls @Nullable String nodeId, @NonNls @NotNull String duration, boolean success) {
        if (testName == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(29);
        }
        if (duration == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(30);
        }
        List<ServiceMessageBuilder> list = this.doTestFinished(testName, nodeId, duration, "", success, false);
        if (list == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(31);
        }
        return list;
    }

    @NotNull
    public List<ServiceMessageBuilder> testFinished(@NlsSafe @NotNull String testName, @NonNls @Nullable String nodeId, @NonNls @NotNull String duration, boolean success, boolean ignore) {
        if (testName == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(32);
        }
        if (duration == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(33);
        }
        List<ServiceMessageBuilder> list = this.doTestFinished(testName, nodeId, duration, "", success, ignore);
        if (list == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(34);
        }
        return list;
    }

    @NotNull
    public List<ServiceMessageBuilder> testFinished(@NlsSafe @NotNull String testName, @NonNls @Nullable String nodeId, @NonNls @NotNull String duration, @NonNls @NotNull String withMessageAsReason, boolean success, boolean ignore) {
        if (testName == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(35);
        }
        if (duration == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(36);
        }
        if (withMessageAsReason == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(37);
        }
        List<ServiceMessageBuilder> list = this.doTestFinished(testName, nodeId, duration, withMessageAsReason, success, ignore);
        if (list == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(38);
        }
        return list;
    }

    @NotNull
    protected List<ServiceMessageBuilder> doTestFinished(@NlsSafe @NotNull String testName, @NonNls @Nullable String nodeId, @NonNls @NotNull String duration, @NonNls @NotNull String withMessageAsReason, boolean success, boolean ignored) {
        if (testName == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(39);
        }
        if (duration == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(40);
        }
        if (withMessageAsReason == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(41);
        }
        ServiceMessageBuilder statusMessage = null;
        if (!success) {
            statusMessage = ServiceMessageBuilder.testFailed((String)testName);
        } else if (ignored) {
            statusMessage = ServiceMessageBuilder.testIgnored((String)testName);
        }
        ServiceMessageBuilder finishMessage = CidrTestEventProcessor.setNodeId(nodeId, CidrTestEventProcessor.setDuration(duration, ServiceMessageBuilder.testFinished((String)testName)));
        if (statusMessage == null) {
            List<ServiceMessageBuilder> list = Collections.singletonList(finishMessage);
            if (list == null) {
                CidrTestEventProcessor.$$$reportNull$$$0(42);
            }
            return list;
        }
        CidrTestEventProcessor.setNodeId(nodeId, CidrTestEventProcessor.setMessage(withMessageAsReason, statusMessage));
        List<ServiceMessageBuilder> list = Arrays.asList(statusMessage, finishMessage);
        if (list == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(43);
        }
        return list;
    }

    @NotNull
    public List<ServiceMessageBuilder> testUnitIgnore(@NlsSafe @NotNull String testName, @NonNls @Nullable String nodeId, @NonNls @Nullable String ignoreComment) {
        if (testName == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(44);
        }
        List<ServiceMessageBuilder> list = Collections.singletonList(CidrTestEventProcessor.setNodeId(nodeId, CidrTestEventProcessor.setMessage(ignoreComment, ServiceMessageBuilder.testIgnored((String)testName))));
        if (list == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(45);
        }
        return list;
    }

    @NotNull
    public List<ServiceMessageBuilder> testErrOut(@NlsSafe @NotNull String testName, @NlsSafe @NotNull String output) {
        if (testName == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(46);
        }
        if (output == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(47);
        }
        List<ServiceMessageBuilder> list = this.testErrOut(testName, null, output);
        if (list == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(48);
        }
        return list;
    }

    @NotNull
    public List<ServiceMessageBuilder> testErrOut(@NlsSafe @NotNull String testName, @NonNls @Nullable String nodeId, @NlsSafe @NotNull String output) {
        if (testName == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(49);
        }
        if (output == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(50);
        }
        List<ServiceMessageBuilder> list = Collections.singletonList(CidrTestEventProcessor.setNodeId(nodeId, ServiceMessageBuilder.testStdErr((String)testName).addAttribute("out", output)));
        if (list == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(51);
        }
        return list;
    }

    @NotNull
    public List<ServiceMessageBuilder> testStdOut(@NlsSafe @NotNull String testName, @NonNls @Nullable String nodeId, @NlsSafe @NotNull String output) {
        if (testName == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(52);
        }
        if (output == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(53);
        }
        List<ServiceMessageBuilder> list = Collections.singletonList(CidrTestEventProcessor.setNodeId(nodeId, ServiceMessageBuilder.testStdOut((String)testName).addAttribute("out", output)));
        if (list == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(54);
        }
        return list;
    }

    @NotNull
    public List<ServiceMessageBuilder> testErrOut(@NlsSafe @NotNull String testName, @NonNls @Nullable String nodeId, @NotNull Key outputType, @NlsSafe @NotNull String output) {
        if (testName == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(55);
        }
        if (outputType == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(56);
        }
        if (output == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(57);
        }
        List<ServiceMessageBuilder> list = Collections.singletonList(CidrTestEventProcessor.setNodeId(nodeId, ServiceMessageBuilder.testStdErr((String)testName).addAttribute("out", output).addAttribute("textAttributes", outputType.toString())));
        if (list == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(58);
        }
        return list;
    }

    @NotNull
    public List<ServiceMessageBuilder> testStdOut(@NlsSafe @NotNull String testName, @NonNls @Nullable String nodeId, @NotNull Key outputType, @NlsSafe @NotNull String output) {
        if (testName == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(59);
        }
        if (outputType == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(60);
        }
        if (output == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(61);
        }
        List<ServiceMessageBuilder> list = Collections.singletonList(CidrTestEventProcessor.setNodeId(nodeId, ServiceMessageBuilder.testStdOut((String)testName).addAttribute("out", output).addAttribute("textAttributes", outputType.toString())));
        if (list == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(62);
        }
        return list;
    }

    @NotNull
    private ServiceMessageBuilder setLocation(@NonNls @Nullable String location, @NotNull ServiceMessageBuilder builder) {
        if (builder == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(63);
        }
        if (location == null) {
            ServiceMessageBuilder serviceMessageBuilder = builder;
            if (serviceMessageBuilder == null) {
                CidrTestEventProcessor.$$$reportNull$$$0(64);
            }
            return serviceMessageBuilder;
        }
        ServiceMessageBuilder serviceMessageBuilder = builder.addAttribute("locationHint", this.myLocationProtocol + "://" + location);
        if (serviceMessageBuilder == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(65);
        }
        return serviceMessageBuilder;
    }

    @NotNull
    private static ServiceMessageBuilder setMetainfo(@NonNls @Nullable String nodeId, @NotNull ServiceMessageBuilder builder) {
        if (builder == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(66);
        }
        ServiceMessageBuilder serviceMessageBuilder = CidrTestEventProcessor.addParamIfNeed("metainfo", nodeId, builder);
        if (serviceMessageBuilder == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(67);
        }
        return serviceMessageBuilder;
    }

    @NotNull
    private static ServiceMessageBuilder setNodeId(@NonNls @Nullable String nodeId, @NotNull ServiceMessageBuilder builder) {
        if (builder == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(68);
        }
        ServiceMessageBuilder serviceMessageBuilder = CidrTestEventProcessor.addParamIfNeed("nodeId", nodeId, builder);
        if (serviceMessageBuilder == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(69);
        }
        return serviceMessageBuilder;
    }

    @NotNull
    private static ServiceMessageBuilder setParentNodeId(@NonNls @Nullable String parentNodeId, @NotNull ServiceMessageBuilder builder) {
        if (builder == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(70);
        }
        ServiceMessageBuilder serviceMessageBuilder = CidrTestEventProcessor.addParamIfNeed("parentNodeId", parentNodeId, builder);
        if (serviceMessageBuilder == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(71);
        }
        return serviceMessageBuilder;
    }

    @NotNull
    private static ServiceMessageBuilder setMessage(@NlsSafe @Nullable String message, @NotNull ServiceMessageBuilder builder) {
        if (builder == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(72);
        }
        ServiceMessageBuilder serviceMessageBuilder = CidrTestEventProcessor.addParamIfNeed("message", message, builder);
        if (serviceMessageBuilder == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(73);
        }
        return serviceMessageBuilder;
    }

    @NotNull
    private static ServiceMessageBuilder setDuration(@NonNls @Nullable String duration, @NotNull ServiceMessageBuilder builder) {
        if (builder == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(74);
        }
        ServiceMessageBuilder serviceMessageBuilder = CidrTestEventProcessor.addParamIfNeed("duration", duration, builder);
        if (serviceMessageBuilder == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(75);
        }
        return serviceMessageBuilder;
    }

    private static ServiceMessageBuilder addParamIfNeed(@NonNls @NotNull String attrName, @NlsSafe @Nullable String value, @NotNull ServiceMessageBuilder builder) {
        if (attrName == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(76);
        }
        if (builder == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(77);
        }
        if (value == null) {
            return builder;
        }
        return builder.addAttribute(attrName, value);
    }

    @Nullable
    public Matcher hideOutputMatcher(@NlsSafe @NotNull String text) {
        if (text == null) {
            CidrTestEventProcessor.$$$reportNull$$$0(78);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 9, 11, 13, 16, 19, 22, 25, 28, 31, 34, 38, 42, 43, 45, 48, 51, 54, 58, 62, 64, 65, 67, 69, 71, 73, 75 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationProtocol";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 31: 
            case 34: 
            case 38: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 58: 
            case 62: 
            case 64: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 73: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor";
                break;
            }
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 35: 
            case 39: 
            case 44: 
            case 46: 
            case 49: 
            case 52: 
            case 55: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 24: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duration";
                break;
            }
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "withMessageAsReason";
                break;
            }
            case 47: 
            case 50: 
            case 53: 
            case 57: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 56: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 63: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 74: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestEventProcessor";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "suiteStarted";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doSuiteStarted";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "suiteFinished";
                break;
            }
            case 16: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "testStarted";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "doTestStarted";
                break;
            }
            case 25: 
            case 28: 
            case 31: 
            case 34: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "testFinished";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "doTestFinished";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "testUnitIgnore";
                break;
            }
            case 48: 
            case 51: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "testErrOut";
                break;
            }
            case 54: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "testStdOut";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "setLocation";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "setMetainfo";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "setNodeId";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "setParentNodeId";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "setMessage";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "setDuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "suiteStarted";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 31: 
            case 34: 
            case 38: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 58: 
            case 62: 
            case 64: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 73: 
            case 75: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doSuiteStarted";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "suiteFinished";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "testStarted";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doTestStarted";
                break;
            }
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "testFinished";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "doTestFinished";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "testUnitIgnore";
                break;
            }
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "testErrOut";
                break;
            }
            case 52: 
            case 53: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "testStdOut";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "setLocation";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "setMetainfo";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "setNodeId";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "setParentNodeId";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "setMessage";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "setDuration";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "addParamIfNeed";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "hideOutputMatcher";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 9, 11, 13, 16, 19, 22, 25, 28, 31, 34, 38, 42, 43, 45, 48, 51, 54, 58, 62, 64, 65, 67, 69, 71, 73, 75 -> new IllegalStateException(string);
        };
    }
}

