/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.DimensionService;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TextFieldWithStoredHistory;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIndexerCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangIndexerCustomCommandDialog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdIndexerPanelKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.CmdAndArg;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.IndexAppState;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u0018H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangIndexerCustomCommandDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "appState", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/IndexAppState;", "isStateful", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/IndexAppState;Z)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getAppState", "()Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/IndexAppState;", "()Z", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "cmdAndArg", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/CmdAndArg;", "getCmdAndArg", "()Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/CmdAndArg;", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "executeCommand", "intellij.cidr.clangd.toolwindow"})
final class ClangIndexerCustomCommandDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final IndexAppState appState;
    private final boolean isStateful;
    private DialogPanel panel;
    @NotNull
    private final CmdAndArg cmdAndArg;

    public ClangIndexerCustomCommandDialog(@NotNull Project project, @NotNull IndexAppState appState, boolean isStateful) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)appState, (String)"appState");
        super(project, true, DialogWrapper.IdeModalityType.MODELESS);
        this.project = project;
        this.appState = appState;
        this.isStateful = isStateful;
        this.cmdAndArg = new CmdAndArg(null, null, 3, null);
        this.setTitle("Specify indexer command");
        this.setOKButtonText("Execute");
        this.init();
        this.initValidation();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final IndexAppState getAppState() {
        return this.appState;
    }

    public final boolean isStateful() {
        return this.isStateful;
    }

    @NotNull
    public final CmdAndArg getCmdAndArg() {
        return this.cmdAndArg;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        Dimension dimension;
        this.panel = BuilderKt.panel(arg_0 -> ClangIndexerCustomCommandDialog.createCenterPanel$lambda$7(this, arg_0));
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        if ((dimension = DimensionService.getInstance().getSize("ClangIndexerCommandDialog", this.project)) == null) {
            JBDimension jBDimension = JBUI.size((int)640, (int)480);
            Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"size(...)");
            dimension = (Dimension)jBDimension;
        }
        dialogPanel.setPreferredSize(dimension);
        DialogPanel dialogPanel2 = this.panel;
        if (dialogPanel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel2 = null;
        }
        return (JComponent)dialogPanel2;
    }

    protected void doOKAction() {
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        dialogPanel.apply();
        super.doOKAction();
        this.executeCommand();
    }

    private final void executeCommand() {
        ConsoleView consoleView = this.appState.getAppConsoleView();
        if (consoleView == null) {
            ClangdIndexerPanelKt.access$showNotification(this.project, "Indexer App Console is not created yet!");
            return;
        }
        ConsoleView appConsoleView = consoleView;
        ClangdIndexerPanelKt.access$runIndexerCommand(this.project, appConsoleView, this.isStateful, new ClangIndexerCommand(this.cmdAndArg.getCommand(), this.cmdAndArg.getArguments()));
    }

    private static final ValidationInfo createCenterPanel$validator(ValidationInfoBuilder $this$createCenterPanel_u24validator, JTextField it, String message) {
        CharSequence charSequence = it.getText();
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? $this$createCenterPanel_u24validator.error(message) : null;
    }

    private static final ValidationInfo createCenterPanel$lambda$7$lambda$3$lambda$0(ValidationInfoBuilder $this$validationOnInput, TextFieldWithStoredHistory it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JTextField jTextField = it.getTextEditor();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"getTextEditor(...)");
        return ClangIndexerCustomCommandDialog.createCenterPanel$validator($this$validationOnInput, jTextField, "Command shouldn't be empty");
    }

    private static final ValidationInfo createCenterPanel$lambda$7$lambda$3$lambda$1(ValidationInfoBuilder $this$validationOnApply, TextFieldWithStoredHistory it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JTextField jTextField = it.getTextEditor();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"getTextEditor(...)");
        return ClangIndexerCustomCommandDialog.createCenterPanel$validator($this$validationOnApply, jTextField, "Command shouldn't be empty");
    }

    private static final Unit createCenterPanel$lambda$7$lambda$3$lambda$2(TextFieldWithStoredHistory $textField) {
        $textField.addCurrentTextToHistory();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7$lambda$3(ClangIndexerCustomCommandDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldWithStoredHistory textField = new TextFieldWithStoredHistory("CLANG_INDEXER_COMMAND_FIELD");
        $this$row.cell((JComponent)textField).align((Align)AlignX.FILL.INSTANCE).bind((Function1)createCenterPanel.1.1.1.INSTANCE, (Function2)createCenterPanel.1.1.2.INSTANCE, MutablePropertyKt.toMutableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.cmdAndArg){

            public Object get() {
                return ((CmdAndArg)this.receiver).getCommand();
            }

            public void set(Object value) {
                ((CmdAndArg)this.receiver).setCommand((String)value);
            }
        }))).validationOnInput(ClangIndexerCustomCommandDialog::createCenterPanel$lambda$7$lambda$3$lambda$0).validationOnApply(ClangIndexerCustomCommandDialog::createCenterPanel$lambda$7$lambda$3$lambda$1).onApply(() -> ClangIndexerCustomCommandDialog.createCenterPanel$lambda$7$lambda$3$lambda$2(textField)).focused();
        return Unit.INSTANCE;
    }

    private static final String createCenterPanel$lambda$7$lambda$6$lambda$4(EditorTextField editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        String string = editor.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final Unit createCenterPanel$lambda$7$lambda$6$lambda$5(EditorTextField editor, String text) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        editor.setText(text);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7$lambda$6(ClangIndexerCustomCommandDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        EditorTextField textEditor = new EditorTextField(this$0.project, (FileType)PlainTextFileType.INSTANCE);
        textEditor.setOneLineMode(false);
        textEditor.setFontInheritedFromLAF(false);
        textEditor.setFont(EditorUtil.getEditorFont());
        $this$row.cell((JComponent)textEditor).align(Align.FILL).label("Arguments:", LabelPosition.TOP).bind(ClangIndexerCustomCommandDialog::createCenterPanel$lambda$7$lambda$6$lambda$4, ClangIndexerCustomCommandDialog::createCenterPanel$lambda$7$lambda$6$lambda$5, MutablePropertyKt.toMutableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.cmdAndArg){

            public Object get() {
                return ((CmdAndArg)this.receiver).getArguments();
            }

            public void set(Object value) {
                ((CmdAndArg)this.receiver).setArguments((String)value);
            }
        })));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7(ClangIndexerCustomCommandDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.row("Command:", arg_0 -> ClangIndexerCustomCommandDialog.createCenterPanel$lambda$7$lambda$3(this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ClangIndexerCustomCommandDialog.createCenterPanel$lambda$7$lambda$6(this$0, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }
}

