/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdIndexerPanel;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdPanelKt;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ShowClangdToolWindowAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "intellij.cidr.clangd.toolwindow"})
public final class ShowClangdToolWindowAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Companion.createOrGetClangdToolWindow(project2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ShowClangdToolWindowAction$Companion;", "", "<init>", "()V", "createOrGetClangdToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "project", "Lcom/intellij/openapi/project/Project;", "showAndSelectIndexerOpts", "", "intellij.cidr.clangd.toolwindow"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ToolWindow createOrGetClangdToolWindow(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ToolWindowManager twManager = ToolWindowManager.Companion.getInstance(project);
            ToolWindow toolWindow = twManager.getToolWindow("clangd");
            if (toolWindow == null) {
                return null;
            }
            ToolWindow window = toolWindow;
            window.setIcon(AllIcons.General.InspectionsEye);
            if (window.getContentManager().getContentCount() == 0) {
                ContentManager contentManager = window.getContentManager();
                Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
                ClangdPanelKt.createPanels(project, contentManager);
            }
            if (!window.isAvailable()) {
                window.setAvailable(true);
            }
            if (!window.isActive()) {
                window.activate(null);
            }
            return window;
        }

        public final void showAndSelectIndexerOpts(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ToolWindow toolWindow = this.createOrGetClangdToolWindow(project);
            if (toolWindow == null) {
                return;
            }
            ToolWindow toolWindow2 = toolWindow;
            Content indexerPanelContent = toolWindow2.getContentManager().findContent(ClangdBundle.message((String)"language.cpp.clangd.info.panel.indexing.title", (Object[])new Object[0]));
            toolWindow2.getContentManager().setSelectedContent(indexerPanelContent);
            JComponent jComponent = indexerPanelContent.getComponent();
            Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdIndexerPanel");
            ((ClangdIndexerPanel)((Object)jComponent)).selectIndexerOpts();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

