/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.javascript.BasicJavaScriptStubElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptParserBundle;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSParsingContextUtil;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructureLeaf;
import com.intellij.lang.javascript.parsing.modifiers.JSOneOfModifiersStructure;
import com.intellij.lang.javascript.parsing.modifiers.JSOrderedModifiersStructure;
import com.intellij.lang.typescript.BasicTypeScriptStubElementTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u0016\u0018\u0000 .*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001.B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0004J\b\u0010\u000f\u001a\u00020\fH\u0014J\u001e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0004J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0014J\b\u0010\u0016\u001a\u00020\bH\u0004J\u001e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0004J\b\u0010\u001c\u001a\u00020\fH\u0014J\u0012\u0010\u001d\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0019H\u0014J\u0018\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010 \u001a\u00020\bH\u0004J\b\u0010!\u001a\u00020\bH\u0014J\b\u0010\"\u001a\u00020\fH\u0014J \u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010 \u001a\u00020\bH\u0004J\b\u0010%\u001a\u00020\fH\u0014J\b\u0010&\u001a\u00020\bH\u0014J\b\u0010'\u001a\u00020\bH\u0016J\u0010\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\nH\u0014J\u0012\u0010*\u001a\u00020\b2\b\u0010+\u001a\u0004\u0018\u00010\u0019H\u0014R\u0014\u0010\u0018\u001a\u00020\u00198DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010,\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u001b\u00a8\u0006/"}, d2={"Lcom/intellij/lang/ecmascript6/parsing/ES6StatementParser;", "P", "Lcom/intellij/lang/ecmascript6/parsing/ES6Parser;", "Lcom/intellij/lang/javascript/parsing/StatementParser;", "parser", "<init>", "(Lcom/intellij/lang/ecmascript6/parsing/ES6Parser;)V", "parseDialectSpecificSourceElements", "", "marker", "Lcom/intellij/lang/PsiBuilder$Marker;", "parseSourceElement", "", "parseStatement", "parseEnumNoMarker", "parseClassMember", "parseStandardClassMember", "classMember", "modifiersParseResults", "Ljava/util/EnumSet;", "Lcom/intellij/lang/javascript/parsing/modifiers/JSModifiersStructure$JSModifiersParseResult;", "parseClassMemberModifiers", "parseStaticBlock", "parseNamedClassMember", "fieldStatementElementType", "Lcom/intellij/psi/tree/IElementType;", "getFieldStatementElementType", "()Lcom/intellij/psi/tree/IElementType;", "parseMemberPropertyWithBrackets", "isPossibleMemberFunctionStart", "lookahead", "parseMemberFunction", "skipName", "parserMemberFunctionName", "checkMemberFunctionSuffix", "parseMemberVariable", "variable", "parseMemberVariableName", "parseReferenceListMember", "parseForLoopHeader", "parseES6DecoratorDeclaration", "decoratorMark", "isPossibleStartStatementModifier", "token", "fieldElementType", "getFieldElementType", "Companion", "intellij.javascript.parser"})
public class ES6StatementParser<P extends ES6Parser>
extends StatementParser<P> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final JSModifiersStructure CLASS_MEMBER_MODIFIERS_STRUCTURE;
    @NotNull
    private static final Predicate<PsiBuilder> IS_MEMBER_NAME_START;

    public ES6StatementParser(@NotNull P parser) {
        Intrinsics.checkNotNullParameter(parser, (String)"parser");
        super((JavaScriptParser)parser);
    }

    @Override
    protected boolean parseDialectSpecificSourceElements(@NotNull PsiBuilder.Marker marker) {
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        if (this.builder.getTokenType() == JSTokenTypes.ENUM_KEYWORD) {
            this.parseEnumNoMarker(marker);
            return true;
        }
        return false;
    }

    @Deprecated(message="Use `parseStatement()` instead.", replaceWith=@ReplaceWith(expression="parseStatement", imports={}))
    public final void parseSourceElement() {
        this.parseStatement();
    }

    @Override
    public void parseStatement() {
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.ENUM_KEYWORD) {
            PsiBuilder.Marker marker = this.startAttributeListOwner();
            this.parseEnumNoMarker(marker);
            return;
        }
        if (tokenType == JSTokenTypes.IMPORT_KEYWORD && this.builder.lookAhead(1) != JSTokenTypes.LPAR && this.builder.lookAhead(1) != JSTokenTypes.DOT) {
            this.parseES6ImportStatement();
            return;
        }
        if (tokenType == JSTokenTypes.EXPORT_KEYWORD && this.tryParseES6ExportStatement()) {
            return;
        }
        super.parseStatement();
    }

    protected final void parseEnumNoMarker(@NotNull PsiBuilder.Marker marker) {
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        StatementParser.LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.ENUM_KEYWORD);
        this.builder.advanceLexer();
        if (this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.advanceLexer();
        } else {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.name", new Object[0]));
            if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
                marker.done(BasicJavaScriptStubElementTypes.TYPESCRIPT_ENUM);
                return;
            }
        }
        if (!JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.LBRACE, "javascript.parser.message.expected.lbrace")) {
            marker.done(BasicJavaScriptStubElementTypes.TYPESCRIPT_ENUM);
            return;
        }
        PsiBuilder.Marker marker2 = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker2, (String)"mark(...)");
        PsiBuilder.Marker varStatement = marker2;
        boolean isDeclarationEmpty = true;
        while (!this.builder.eof() && this.builder.getTokenType() != JSTokenTypes.RBRACE) {
            if (ES6StatementParser.isPropertyNameStart(this.builder.getTokenType())) {
                PsiBuilder.Marker variable;
                Intrinsics.checkNotNullExpressionValue((Object)this.builder.mark(), (String)"mark(...)");
                ((ES6Parser)this.parser).getExpressionParser().parsePropertyName();
                if (this.builder.getTokenType() == JSTokenTypes.EQ) {
                    this.parseVariableInitializer(false);
                }
                variable.done(BasicTypeScriptStubElementTypes.TYPESCRIPT_ENUM_FIELD);
                variable.setCustomEdgeTokenBinders(JavaScriptParserBase.INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
                isDeclarationEmpty = false;
                if (this.builder.getTokenType() != JSTokenTypes.COMMA) break;
                this.builder.advanceLexer();
                continue;
            }
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.property.name", new Object[0]));
            this.builder.advanceLexer();
            break;
        }
        if (isDeclarationEmpty) {
            varStatement.drop();
        } else {
            varStatement.done(BasicTypeScriptStubElementTypes.ENUM_FIELD_STATEMENT);
            varStatement.setCustomEdgeTokenBinders(JavaScriptParserBase.INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.trailingCommentsBinder((TokenSet)JSTokenTypes.END_OF_LINE_COMMENTS));
        }
        if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
            this.builder.advanceLexer();
        }
        JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.RBRACE, "javascript.parser.message.expected.rbrace");
        marker.done(BasicJavaScriptStubElementTypes.TYPESCRIPT_ENUM);
        marker.setCustomEdgeTokenBinders(JavaScriptParserBase.INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    @Override
    protected void parseClassMember() {
        boolean bl;
        if (this.parseStaticBlock()) {
            return;
        }
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker classMember = marker;
        int classMemberOffset = this.builder.getCurrentOffset();
        if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
            classMember.drop();
            this.parseEmptyStatement();
            return;
        }
        EnumSet<JSModifiersStructure.JSModifiersParseResult> modifiersParseResults = this.parseClassMemberModifiers();
        EnumSet<JSModifiersStructure.JSModifiersParseResult> savedContext = JSParsingContextUtil.saveAndUpdateParsingContext(modifiersParseResults, this.builder);
        this.parseStandardClassMember(classMember, modifiersParseResults);
        JSParsingContextUtil.restoreParsingContext(savedContext, this.builder);
        boolean bl2 = bl = this.builder.getCurrentOffset() > classMemberOffset;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    protected final void parseStandardClassMember(@NotNull PsiBuilder.Marker classMember, @NotNull EnumSet<JSModifiersStructure.JSModifiersParseResult> modifiersParseResults) {
        Intrinsics.checkNotNullParameter((Object)classMember, (String)"classMember");
        Intrinsics.checkNotNullParameter(modifiersParseResults, (String)"modifiersParseResults");
        if (((ES6Parser)this.parser).getExpressionParser().isPropertyNameStart(this.builder.getTokenType())) {
            this.parseNamedClassMember(classMember, modifiersParseResults);
        } else {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.statement", new Object[0]));
            if (!modifiersParseResults.contains((Object)JSModifiersStructure.JSModifiersParseResult.LEXER_ADVANCED)) {
                this.builder.advanceLexer();
            }
            classMember.drop();
        }
    }

    @NotNull
    protected EnumSet<JSModifiersStructure.JSModifiersParseResult> parseClassMemberModifiers() {
        return this.parser.parseModifiers(CLASS_MEMBER_MODIFIERS_STRUCTURE, false, IS_MEMBER_NAME_START);
    }

    protected final boolean parseStaticBlock() {
        if (this.builder.getTokenType() == JSTokenTypes.STATIC_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.LBRACE) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker marker2 = marker;
            PsiBuilder.Marker marker3 = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker3, (String)"mark(...)");
            PsiBuilder.Marker attributeList = marker3;
            this.builder.advanceLexer();
            attributeList.done(((ES6Parser)this.parser).getFunctionParser().getAttributeListElementType());
            this.parseBlock();
            marker2.done(BasicJavaScriptStubElementTypes.STATIC_BLOCK);
            return true;
        }
        return false;
    }

    protected final void parseNamedClassMember(@NotNull PsiBuilder.Marker classMember, @NotNull EnumSet<JSModifiersStructure.JSModifiersParseResult> modifiersParseResults) {
        boolean shouldBeFunc;
        Intrinsics.checkNotNullParameter((Object)classMember, (String)"classMember");
        Intrinsics.checkNotNullParameter(modifiersParseResults, (String)"modifiersParseResults");
        IElementType lookahead = this.builder.lookAhead(1);
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker mark = marker;
        boolean skipName = false;
        IElementType nextToken = this.builder.getTokenType();
        boolean bl = shouldBeFunc = !(nextToken != JSTokenTypes.LBRACKET && !this.isIdentifierToken(nextToken) && !JSKeywordSets.PROPERTY_NAMES.contains(nextToken) && !JSTokenTypes.LITERALS.contains(nextToken) || !modifiersParseResults.contains((Object)JSModifiersStructure.JSModifiersParseResult.ASYNC_FOUND) && !modifiersParseResults.contains((Object)JSModifiersStructure.JSModifiersParseResult.MULT_FOUND) && !modifiersParseResults.contains((Object)JSModifiersStructure.JSModifiersParseResult.GET_SET_FOUND));
        if (nextToken == JSTokenTypes.LBRACKET) {
            this.parseMemberPropertyWithBrackets();
            skipName = true;
            lookahead = this.builder.getTokenType();
        }
        if (this.isPossibleMemberFunctionStart(lookahead) || shouldBeFunc) {
            mark.drop();
            EnumSet<JSModifiersStructure.JSModifiersParseResult> savedContext = JSParsingContextUtil.saveAndUpdateParsingContext(modifiersParseResults, this.builder);
            this.parseMemberFunction(classMember, skipName);
            JSParsingContextUtil.restoreParsingContext(savedContext, this.builder);
        } else {
            this.parseMemberVariable(mark, classMember, skipName);
        }
    }

    @NotNull
    protected final IElementType getFieldStatementElementType() {
        return BasicJavaScriptStubElementTypes.FIELD_STATEMENT;
    }

    protected void parseMemberPropertyWithBrackets() {
        ((ES6Parser)this.parser).getExpressionParser().parsePropertyName();
    }

    protected boolean isPossibleMemberFunctionStart(@Nullable IElementType lookahead) {
        return JSTokenTypes.LPAR == lookahead || JSTokenTypes.LT == lookahead;
    }

    protected final void parseMemberFunction(@NotNull PsiBuilder.Marker classMember, boolean skipName) {
        Intrinsics.checkNotNullParameter((Object)classMember, (String)"classMember");
        if (!skipName) {
            this.parserMemberFunctionName();
        }
        FunctionParser functionParser = ((ES6Parser)this.parser).getFunctionParser();
        functionParser.parseParameterList(false);
        ((ES6Parser)this.parser).getTypeParser().tryParseType();
        if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
            ((ES6Parser)this.parser).getStatementParser().parseFunctionBody();
        } else {
            this.checkMemberFunctionSuffix();
        }
        this.checkForSemicolon();
        classMember.done(functionParser.getFunctionDeclarationElementType());
        classMember.setCustomEdgeTokenBinders(JavaScriptParserBase.INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    protected boolean parserMemberFunctionName() {
        boolean nameParsed = ((ES6Parser)this.parser).getFunctionParser().parseFunctionName(true, FunctionParser.Context.PROPERTY);
        if (!nameParsed) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.function.name", new Object[0]));
            return false;
        }
        return true;
    }

    protected void checkMemberFunctionSuffix() {
        JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.SEMICOLON, "javascript.parser.message.expected.lbrace.or.semicolon");
    }

    protected final void parseMemberVariable(@NotNull PsiBuilder.Marker variable, @NotNull PsiBuilder.Marker classMember, boolean skipName) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)classMember, (String)"classMember");
        if (!skipName) {
            this.parseMemberVariableName();
        }
        ((ES6Parser)this.parser).getTypeParser().tryParseType();
        if (this.builder.getTokenType() == JSTokenTypes.EQ) {
            this.parseVariableInitializer(true);
        }
        variable.done(this.getFieldElementType());
        variable.setCustomEdgeTokenBinders(JavaScriptParserBase.INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        this.forceCheckForSemicolon();
        classMember.done(this.getFieldStatementElementType());
        classMember.setCustomEdgeTokenBinders(JavaScriptParserBase.INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    protected void parseMemberVariableName() {
        ((ES6Parser)this.parser).getExpressionParser().parsePropertyName();
    }

    @Override
    protected boolean parseReferenceListMember() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker refMember = marker;
        ExpressionParser expressionParser = ((ES6Parser)this.parser).getExpressionParser();
        EnumSet<Enum> enumSet = EnumSet.of((Enum)ExpressionParser.ParseLeftHandSideExpressionOptions.IS_IN_EXTENDS_OR_IMPLEMENTS_LIST);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
        boolean result = expressionParser.parseLeftHandSideExpression((Set<ExpressionParser.ParseLeftHandSideExpressionOptions>)enumSet);
        if (result) {
            ((ES6Parser)this.parser).getTypeParser().tryParseTypeArgumentList(false, true, true);
            refMember.done(BasicJavaScriptStubElementTypes.EXTENDS_LIST_MEMBER);
        } else {
            refMember.drop();
        }
        return result;
    }

    @Override
    public boolean parseForLoopHeader() {
        StatementParser.LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.FOR_KEYWORD);
        if (this.builder.lookAhead(1) == JSTokenTypes.AWAIT_KEYWORD) {
            this.builder.advanceLexer();
            this.builder.advanceLexer();
            return this.parseForLoopHeaderCondition();
        }
        return super.parseForLoopHeader();
    }

    @Override
    protected void parseES6DecoratorDeclaration(@NotNull PsiBuilder.Marker decoratorMark) {
        Intrinsics.checkNotNullParameter((Object)decoratorMark, (String)"decoratorMark");
        StatementParser.LOG.assertTrue(JSTokenTypes.DECORATOR_KEYWORD == this.builder.getTokenType());
        this.builder.advanceLexer();
        if (this.builder.getTokenType() != JSTokenTypes.AT) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.at", new Object[0]));
            decoratorMark.drop();
            return;
        }
        FunctionParser.MethodEmptiness methodsMustBeEmpty = (FunctionParser.MethodEmptiness)((Object)this.builder.getUserData(FunctionParser.methodsEmptinessKey));
        this.builder.advanceLexer();
        if (!((ES6Parser)this.parser).getFunctionParser().parseFunctionName(false, FunctionParser.Context.SOURCE_ELEMENT)) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.name", new Object[0]));
            IElementType type = this.builder.getTokenType();
            if (type != JSTokenTypes.LBRACE && type != JSTokenTypes.LPAR && (methodsMustBeEmpty == null || type != JSTokenTypes.SEMICOLON)) {
                decoratorMark.drop();
                return;
            }
        }
        ((ES6Parser)this.parser).getTypeParser().tryParseTypeParameterList();
        if (this.builder.getTokenType() == JSTokenTypes.LPAR) {
            ((ES6Parser)this.parser).getFunctionParser().parseParameterList(false);
        }
        if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
            if (methodsMustBeEmpty != null) {
                if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
                    this.builder.advanceLexer();
                }
                decoratorMark.done(BasicJavaScriptStubElementTypes.ES6_DECORATOR_DECLARATION);
                return;
            }
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.lbrace", new Object[0]));
            decoratorMark.drop();
            return;
        }
        this.builder.advanceLexer();
        ((ES6Parser)this.parser).getFunctionParser().tryParseES7Decorators();
        if (this.builder.getTokenType() != JSTokenTypes.RBRACE) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.rbrace", new Object[0]));
        } else {
            this.builder.advanceLexer();
        }
        decoratorMark.done(BasicJavaScriptStubElementTypes.ES6_DECORATOR_DECLARATION);
    }

    @Override
    protected boolean isPossibleStartStatementModifier(@Nullable IElementType token) {
        if (token == JSTokenTypes.ASYNC_KEYWORD) {
            return this.builder.lookAhead(1) == JSTokenTypes.FUNCTION_KEYWORD;
        }
        return super.isPossibleStartStatementModifier(token);
    }

    @NotNull
    public IElementType getFieldElementType() {
        return BasicJavaScriptStubElementTypes.FIELD;
    }

    private static final boolean IS_MEMBER_NAME_START$lambda$0(PsiBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IElementType token = it.getTokenType();
        return JSKeywordSets.PROPERTY_NAMES.contains(token) || token == JSTokenTypes.MULT || token == JSTokenTypes.LBRACKET;
    }

    @JvmStatic
    protected static final boolean isPropertyNameStart(@Nullable IElementType t) {
        return Companion.isPropertyNameStart(t);
    }

    static {
        JSModifiersStructure[] jSModifiersStructureArray = new JSModifiersStructure[6];
        IElementType[] iElementTypeArray = new IElementType[]{JSTokenTypes.PRIVATE_KEYWORD, JSTokenTypes.PUBLIC_KEYWORD};
        jSModifiersStructureArray[0] = new JSOneOfModifiersStructure(iElementTypeArray);
        iElementTypeArray = new IElementType[]{JSTokenTypes.STATIC_KEYWORD, JSTokenTypes.ASYNC_KEYWORD};
        jSModifiersStructureArray[1] = new JSOneOfModifiersStructure(iElementTypeArray);
        iElementTypeArray = new IElementType[]{JSTokenTypes.ASYNC_KEYWORD, JSTokenTypes.STATIC_KEYWORD};
        jSModifiersStructureArray[2] = new JSOneOfModifiersStructure(iElementTypeArray);
        jSModifiersStructureArray[3] = new JSModifiersStructureLeaf(JSTokenTypes.ACCESSOR_KEYWORD, false, 2, null);
        iElementTypeArray = new IElementType[]{JSTokenTypes.GET_KEYWORD, JSTokenTypes.SET_KEYWORD};
        jSModifiersStructureArray[4] = new JSOneOfModifiersStructure(iElementTypeArray);
        jSModifiersStructureArray[5] = new JSModifiersStructureLeaf(JSTokenTypes.MULT, false, 2, null);
        CLASS_MEMBER_MODIFIERS_STRUCTURE = new JSOrderedModifiersStructure(jSModifiersStructureArray);
        IS_MEMBER_NAME_START = ES6StatementParser::IS_MEMBER_NAME_START$lambda$0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/lang/ecmascript6/parsing/ES6StatementParser$Companion;", "", "<init>", "()V", "CLASS_MEMBER_MODIFIERS_STRUCTURE", "Lcom/intellij/lang/javascript/parsing/modifiers/JSModifiersStructure;", "IS_MEMBER_NAME_START", "Ljava/util/function/Predicate;", "Lcom/intellij/lang/PsiBuilder;", "isPropertyNameStart", "", "t", "Lcom/intellij/psi/tree/IElementType;", "intellij.javascript.parser"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        protected final boolean isPropertyNameStart(@Nullable IElementType t) {
            return JSKeywordSets.IDENTIFIER_NAMES.contains(t) || t == JSTokenTypes.STRING_LITERAL || t == JSTokenTypes.NUMERIC_LITERAL || t == JSTokenTypes.LBRACKET;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

