/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.langSwitcher;

import com.intellij.clion.langSwitcher.CLionABTestLauncherKt;
import com.intellij.clion.langSwitcher.CLionLanguagePluginKind;
import com.intellij.diagnostic.VMOptions;
import com.intellij.internal.statistic.DeviceIdManager;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.util.io.NioFiles;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0011\u001a\u00020\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\b\u0010\u001b\u001a\u00020\u0018H\u0002R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\t\u001a\u0004\b\u000b\u0010\u0007R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/clion/langSwitcher/CLionABTestLauncher;", "", "<init>", "()V", "useDeviceId", "", "getUseDeviceId", "()Z", "useDeviceId$delegate", "Lkotlin/Lazy;", "alwaysEnableRadler", "getAlwaysEnableRadler", "alwaysEnableRadler$delegate", "AB_MARKER_FILE_NAME", "", "DO_TEST_FOR_NEW_USERS", "DO_TEST_FOR_OLD_USERS", "enabled", "configsImported", "", "getMarkerFilePath", "Ljava/nio/file/Path;", "setLanguagePlugin", "langPlugin", "Lcom/intellij/clion/langSwitcher/CLionLanguagePluginKind;", "chooseLanguagePlugin", "chooseWithRandom", "chooseWithDeviceId", "intellij.clion.langSwitcher"})
@SourceDebugExtension(value={"SMAP\nCLionABTestLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CLionABTestLauncher.kt\ncom/intellij/clion/langSwitcher/CLionABTestLauncher\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,110:1\n83#2,3:111\n83#2,3:114\n*S KotlinDebug\n*F\n+ 1 CLionABTestLauncher.kt\ncom/intellij/clion/langSwitcher/CLionABTestLauncher\n*L\n65#1:111,3\n102#1:114,3\n*E\n"})
public final class CLionABTestLauncher {
    @NotNull
    public static final CLionABTestLauncher INSTANCE = new CLionABTestLauncher();
    @NotNull
    private static final Lazy useDeviceId$delegate = LazyKt.lazy(CLionABTestLauncher::useDeviceId_delegate$lambda$0);
    @NotNull
    private static final Lazy alwaysEnableRadler$delegate = LazyKt.lazy(CLionABTestLauncher::alwaysEnableRadler_delegate$lambda$1);
    @NotNull
    private static final String AB_MARKER_FILE_NAME = "clion.ab.set.txt";
    private static final boolean DO_TEST_FOR_NEW_USERS = true;
    private static final boolean DO_TEST_FOR_OLD_USERS = false;

    private CLionABTestLauncher() {
    }

    private final boolean getUseDeviceId() {
        Lazy lazy = useDeviceId$delegate;
        return (Boolean)lazy.getValue();
    }

    private final boolean getAlwaysEnableRadler() {
        Lazy lazy = alwaysEnableRadler$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean enabled() {
        String string = "true";
        String string2 = System.getProperty("clion.ab.test", "false");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        return string.contentEquals(string2);
    }

    public final void configsImported() {
        CLionABTestLauncherKt.access$getLog$p().debug("AB test enabled = " + this.enabled());
        if (!this.enabled()) {
            return;
        }
        if (ConfigImportHelper.isNewUser()) {
            this.setLanguagePlugin(this.chooseLanguagePlugin());
        } else {
            if (ConfigImportHelper.isFirstSession()) {
                // empty if block
            }
            CLionABTestLauncherKt.access$getLog$p().info("skipped setting of language plugin: not a new user and not a first sessionA/B test for new users = true, A/B test for old users = false");
        }
    }

    @NotNull
    public final Path getMarkerFilePath() {
        Path path = VMOptions.getUserOptionsFile();
        if (path == null) {
            path = PathManager.getConfigDir().resolve(AB_MARKER_FILE_NAME);
        }
        Path userOptionsFile = path;
        Path path2 = userOptionsFile.getParent().resolve(AB_MARKER_FILE_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    private final void setLanguagePlugin(CLionLanguagePluginKind langPlugin) {
        if (VMOptions.canWriteOptions()) {
            Object object;
            CLionABTestLauncherKt.access$getLog$p().info("setting language plugin = " + langPlugin.name());
            String suppressedSetId = langPlugin.getSuppressedSetId();
            System.setProperty("idea.suppressed.plugins.set.selector", suppressedSetId);
            VMOptions.setOption((String)"-Didea.suppressed.plugins.set.selector=", (String)suppressedSetId);
            Logger $this$runAndLogException$iv = CLionABTestLauncherKt.access$getLog$p();
            boolean $i$f$runAndLogException = false;
            Logger logger = $this$runAndLogException$iv;
            try {
                Logger $this$runAndLogException_u24lambda_u240$iv = logger;
                boolean bl = false;
                boolean bl2 = false;
                Path markerFilePath = INSTANCE.getMarkerFilePath();
                NioFiles.createDirectories((Path)markerFilePath.getParent());
                OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE};
                object = Result.constructor-impl((Object)Files.write(markerFilePath, (Iterable<? extends CharSequence>)CollectionsKt.listOf((Object)langPlugin.name()), openOptionArray));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
        } else {
            CLionABTestLauncherKt.access$getLog$p().info("skipped setting of language plugin: cannot write options");
        }
    }

    private final CLionLanguagePluginKind chooseLanguagePlugin() {
        String string = "Classic";
        String string2 = System.getProperty("CLION_AB_PLUGIN", "");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        if (string.contentEquals(string2)) {
            return CLionLanguagePluginKind.Classic;
        }
        string = "Radler";
        String string3 = System.getProperty("CLION_AB_PLUGIN", "");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProperty(...)");
        if (string.contentEquals(string3)) {
            return CLionLanguagePluginKind.Radler;
        }
        if (this.getAlwaysEnableRadler()) {
            return CLionLanguagePluginKind.Radler;
        }
        if (this.getUseDeviceId()) {
            return this.chooseWithDeviceId();
        }
        return this.chooseWithRandom();
    }

    private final CLionLanguagePluginKind chooseWithRandom() {
        double fate = Random.Default.nextDouble();
        CLionLanguagePluginKind chosenPlugin = fate >= 0.5 ? CLionLanguagePluginKind.Radler : CLionLanguagePluginKind.Classic;
        CLionABTestLauncherKt.access$getLog$p().info("Random number is " + fate + " => " + chosenPlugin.name() + " was chosen");
        return chosenPlugin;
    }

    private final CLionLanguagePluginKind chooseWithDeviceId() {
        Object object;
        Logger $this$runAndLogException$iv = CLionABTestLauncherKt.access$getLog$p();
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            object = Result.constructor-impl((Object)DeviceIdManager.getOrGenerateId((DeviceIdManager.DeviceIdToken)new DeviceIdManager.DeviceIdToken(){}, (String)"FUS"));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        String string = (String)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
        if (string == null) {
            return CLionLanguagePluginKind.Classic;
        }
        String deviceId2 = string;
        int rawHash = deviceId2.hashCode();
        CLionLanguagePluginKind chosenPlugin = rawHash % 2 == 0 ? CLionLanguagePluginKind.Radler : CLionLanguagePluginKind.Classic;
        CLionABTestLauncherKt.access$getLog$p().info("Device hash is " + rawHash + " % 2 = " + rawHash % 2 + " => " + chosenPlugin.name() + " was chosen");
        return chosenPlugin;
    }

    private static final boolean useDeviceId_delegate$lambda$0() {
        String string = "true";
        String string2 = System.getProperty("clion.ab.test.useDeviceId", "true");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        return string.contentEquals(string2);
    }

    private static final boolean alwaysEnableRadler_delegate$lambda$1() {
        String string = "true";
        String string2 = System.getProperty("clion.ab.test.alwaysEnableRadler", "true");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        return string.contentEquals(string2);
    }
}

