/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.langSwitcher.welcomeScreen;

import com.intellij.clion.langSwitcher.CLionLangSwitcherBundle;
import com.intellij.clion.langSwitcher.CLionLanguagePluginKind;
import com.intellij.clion.langSwitcher.actions.CLionToNovaSwitcherAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.BannerStartPagePromoter;
import com.intellij.openapi.wm.StartPagePromoter;
import com.intellij.util.IconUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u000b\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0007R\u0014\u0010\u0012\u001a\u00020\u00138TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u00138TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015R \u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001b0\u001dX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Lcom/intellij/clion/langSwitcher/welcomeScreen/CLionNovaPromoInRecentProjects;", "Lcom/intellij/openapi/wm/BannerStartPagePromoter;", "<init>", "()V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "getDefaultFontSize", "", "getScaledIcon", "promoImage", "getPromoImage", "getPriorityLevel", "", "canCreatePromo", "", "isEmptyState", "headerLabel", "", "getHeaderLabel", "()Ljava/lang/String;", "description", "getDescription", "actionLabel", "getActionLabel", "runAction", "", "closeAction", "Lkotlin/Function1;", "Ljavax/swing/JPanel;", "getCloseAction", "()Lkotlin/jvm/functions/Function1;", "Companion", "intellij.clion.langSwitcher"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nCLionNovaPromoInRecentProjects.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CLionNovaPromoInRecentProjects.kt\ncom/intellij/clion/langSwitcher/welcomeScreen/CLionNovaPromoInRecentProjects\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,100:1\n14#2:101\n*S KotlinDebug\n*F\n+ 1 CLionNovaPromoInRecentProjects.kt\ncom/intellij/clion/langSwitcher/welcomeScreen/CLionNovaPromoInRecentProjects\n*L\n96#1:101\n*E\n"})
public final class CLionNovaPromoInRecentProjects
extends BannerStartPagePromoter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Icon icon = IconLoader.getIcon((String)"/artwork/promoNova.png", CLionNovaPromoInRecentProjects.class);
    @NotNull
    private final Function1<JPanel, Unit> closeAction;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String PROMO_IS_HIDDEN_KEY = "clion.nova.hide.welcome.screen.promo";
    @NotNull
    public static final String RESTORE_PROMO_ON_RESTART_REGISTRY_KEY = "clion.nova.promo.restore.on.restart";

    public CLionNovaPromoInRecentProjects() {
        if (Registry.Companion.is(RESTORE_PROMO_ON_RESTART_REGISTRY_KEY, false)) {
            PropertiesComponent.getInstance().setValue(PROMO_IS_HIDDEN_KEY, null);
        }
        this.closeAction = CLionNovaPromoInRecentProjects::closeAction$lambda$0;
    }

    @NotNull
    public final Icon getIcon() {
        return this.icon;
    }

    private final float getDefaultFontSize() {
        JLabel label = new JLabel();
        return label.getFontMetrics(label.getFont()).getFont().getSize2D();
    }

    private final Icon getScaledIcon(Icon icon) {
        float fontSize = this.getDefaultFontSize();
        return IconUtil.scale((Icon)icon, null, (float)(fontSize * (float)7 / (float)icon.getIconHeight()));
    }

    @NotNull
    protected Icon getPromoImage() {
        return this.getScaledIcon(this.icon);
    }

    public int getPriorityLevel() {
        return StartPagePromoter.PRIORITY_LEVEL_HIGH - 10;
    }

    public boolean canCreatePromo(boolean isEmptyState) {
        if (CLionLanguagePluginKind.Companion.isCurrentNova()) {
            LOG.info("No promo, already Nova");
            return false;
        }
        Path novaSettingsPath = CLionLanguagePluginKind.Companion.getNovaSettingsPath();
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(novaSettingsPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LOG.info("No promo, Nova was enabled before (settings found at " + novaSettingsPath + ")");
            return false;
        }
        if (PropertiesComponent.getInstance().getBoolean(PROMO_IS_HIDDEN_KEY, false)) {
            LOG.info("No promo, it was hidden (restore with clion.nova.promo.restore.on.restart registry key)");
            return false;
        }
        LOG.info("Showing Nova promotion");
        return true;
    }

    @NotNull
    protected String getHeaderLabel() {
        return CLionLangSwitcherBundle.message("promo.nova.header.label", new Object[0]);
    }

    @NotNull
    protected String getDescription() {
        return CLionLangSwitcherBundle.message("promo.nova.description", new Object[0]);
    }

    @NotNull
    protected String getActionLabel() {
        return CLionLangSwitcherBundle.message("promo.nova.action.label", new Object[0]);
    }

    protected void runAction() {
        CLionToNovaSwitcherAction action = new CLionToNovaSwitcherAction();
        AnActionEvent anActionEvent = AnActionEvent.createEvent((AnAction)((AnAction)action), (DataContext)DataContext.EMPTY_CONTEXT, null, (String)"CLionNovaPromoInRecentProjects", (ActionUiKind)((ActionUiKind)ActionUiKind.TOOLBAR), null);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
        AnActionEvent event = anActionEvent;
        action.actionPerformed(event);
    }

    @NotNull
    protected Function1<JPanel, Unit> getCloseAction() {
        return this.closeAction;
    }

    private static final Unit closeAction$lambda$0(JPanel promoPanel) {
        Intrinsics.checkNotNullParameter((Object)promoPanel, (String)"promoPanel");
        PropertiesComponent.getInstance().setValue(PROMO_IS_HIDDEN_KEY, true);
        promoPanel.setVisible(false);
        promoPanel.revalidate();
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CLionNovaPromoInRecentProjects.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/clion/langSwitcher/welcomeScreen/CLionNovaPromoInRecentProjects$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "PROMO_IS_HIDDEN_KEY", "", "RESTORE_PROMO_ON_RESTART_REGISTRY_KEY", "intellij.clion.langSwitcher"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

