/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.microservices.express;

import com.intellij.javascript.microservices.express.ExpressMapping;
import com.intellij.javascript.microservices.express.ExpressModel;
import com.intellij.javascript.microservices.express.ExpressUrlTargetInfo;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.EndpointsUrlTargetProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.SearchScopeEndpointsFilter;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import icons.JavaScriptLanguageIcons;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00132\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0003H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006#"}, d2={"Lcom/intellij/javascript/microservices/express/ExpressEndpointsProvider;", "Lcom/intellij/microservices/endpoints/EndpointsUrlTargetProvider;", "Lcom/intellij/psi/PsiFile;", "Lcom/intellij/javascript/microservices/express/ExpressMapping;", "<init>", "()V", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "project", "Lcom/intellij/openapi/project/Project;", "getEndpointGroups", "", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getEndpoints", "group", "isValidEndpoint", "", "endpoint", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getDocumentationElement", "Lcom/intellij/psi/PsiElement;", "getUrlTargetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "intellij.javascript.langInjection"})
public final class ExpressEndpointsProvider
implements EndpointsUrlTargetProvider<PsiFile, ExpressMapping> {
    @NotNull
    private final EndpointType endpointType = EndpointTypes.HTTP_SERVER_TYPE;
    @NotNull
    private final FrameworkPresentation presentation = new FrameworkPresentation("Express", "Express", JavaScriptLanguageIcons.Nodejs.Express);

    @NotNull
    public EndpointType getEndpointType() {
        return this.endpointType;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ExpressModel.INSTANCE.hasExpressJs$intellij_javascript_langInjection(project) ? EndpointsProvider.Status.HAS_ENDPOINTS : EndpointsProvider.Status.UNAVAILABLE;
    }

    @NotNull
    public Iterable<PsiFile> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (!(filter instanceof SearchScopeEndpointsFilter)) {
            return CollectionsKt.emptyList();
        }
        if (!ExpressModel.INSTANCE.hasExpressJs$intellij_javascript_langInjection(project)) {
            return CollectionsKt.emptyList();
        }
        return ExpressModel.INSTANCE.getEndpointGroups$intellij_javascript_langInjection(project, ((SearchScopeEndpointsFilter)filter).getTransitiveSearchScope());
    }

    @NotNull
    public Iterable<ExpressMapping> getEndpoints(@NotNull PsiFile group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Project project = group.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return ExpressModel.INSTANCE.getEndpoints$intellij_javascript_langInjection(project, group);
    }

    public boolean isValidEndpoint(@NotNull PsiFile group, @NotNull ExpressMapping endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        JSLiteralExpression jSLiteralExpression = (JSLiteralExpression)endpoint.getPointer().getElement();
        return jSLiteralExpression != null ? jSLiteralExpression.isValid() : false;
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull PsiFile group, @NotNull ExpressMapping endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return (ItemPresentation)new HttpMethodPresentation(endpoint.getFullPath(), CollectionsKt.toList((Iterable)endpoint.getMethods()), endpoint.getSource(), JavaScriptLanguageIcons.Nodejs.Express, null, 16, null);
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ModificationTracker modificationTracker = PsiManager.getInstance((Project)project).getModificationTracker().forLanguage((Language)JavascriptLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)modificationTracker, (String)"forLanguage(...)");
        return modificationTracker;
    }

    @Nullable
    public PsiElement getDocumentationElement(@NotNull PsiFile group, @NotNull ExpressMapping endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint.getPointer().getElement();
    }

    @NotNull
    public Iterable<UrlTargetInfo> getUrlTargetInfo(@NotNull PsiFile group, @NotNull ExpressMapping endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        JSLiteralExpression jSLiteralExpression = (JSLiteralExpression)endpoint.getPointer().getElement();
        if (jSLiteralExpression == null) {
            return CollectionsKt.emptyList();
        }
        JSLiteralExpression endpointElement = jSLiteralExpression;
        return CollectionsKt.listOf((Object)new ExpressUrlTargetInfo(UrlConstants.HTTP_SCHEMES, CollectionsKt.listOf((Object)new Authority.Exact("localhost:3000")), endpoint.getPath(), endpoint.getMethods(), (PsiElement)endpointElement));
    }
}

