/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.commonjs;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSNamedExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSDocModulesIndex;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class CommonJSUtil {
    private static final Logger LOG = Logger.getInstance(CommonJSUtil.class);
    public static final String MJS_EXTENSION = "mjs";
    public static final String MJS_WITH_DOT_EXTENSION = ".mjs";
    public static final String CJS_EXTENSION = "cjs";
    private static final Condition<JSPsiElementBase> EXPORTED_ELEMENTS_FILTER = element2 -> !(element2 instanceof JSNamedExpression);
    @NotNull
    private static final @NotNull String @NotNull [] MODULE_EXPORTS_COMPONENTS = new String[]{"module", "exports"};

    public static boolean calculateIsRequireCall(@NotNull JSCallExpression callExpression) {
        JSReferenceExpression methodExpression;
        if (callExpression == null) {
            CommonJSUtil.$$$reportNull$$$0(0);
        }
        return (methodExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSReferenceExpression.class)) != null && callExpression.getArguments().length == 1 && methodExpression.getQualifier() == null && "require".equals(methodExpression.getReferenceName());
    }

    @Nullable
    public static String getModulePathIfRequireCall(@NotNull JSCallExpression call) {
        if (call == null) {
            CommonJSUtil.$$$reportNull$$$0(1);
        }
        if (!call.isRequireCall()) {
            return null;
        }
        JSExpression[] arguments = call.getArguments();
        if (arguments.length != 1) {
            return null;
        }
        JSExpression argument = arguments[0];
        if (!(argument instanceof JSLiteralExpression) || !((JSLiteralExpression)argument).isQuotedLiteral()) {
            return null;
        }
        return ((JSLiteralExpression)argument).getStringValue();
    }

    @NotNull
    public static String unifyModuleName(@NotNull String text) {
        if (text == null) {
            CommonJSUtil.$$$reportNull$$$0(2);
        }
        String string = "module:" + CommonJSUtil.unifyModuleNameShortened(text);
        if (string == null) {
            CommonJSUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String unifyModuleNameShortened(@NotNull String text) {
        if (text == null) {
            CommonJSUtil.$$$reportNull$$$0(4);
        }
        String toProcess = JSStringUtil.unquoteAndUnescapeStringLiteralValue(text);
        String string = toProcess = JSStringUtil.wrapQualifiedNameComponent(toProcess);
        if (string == null) {
            CommonJSUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static Collection<PsiElement> resolveJSDocCommentModules(@NotNull PsiElement context2, @NotNull String moduleNameWithoutPrefix) {
        if (context2 == null) {
            CommonJSUtil.$$$reportNull$$$0(6);
        }
        if (moduleNameWithoutPrefix == null) {
            CommonJSUtil.$$$reportNull$$$0(7);
        }
        HashSet<PsiElement> result2 = new HashSet<PsiElement>();
        for (PsiElement psiElement : CommonJSUtil.resolveJSDocCommentsWithModuleTag(context2, moduleNameWithoutPrefix)) {
            result2.add((PsiElement)psiElement.getContainingFile());
        }
        HashSet<PsiElement> hashSet = result2;
        if (hashSet == null) {
            CommonJSUtil.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @NotNull
    public static Collection<JSDocComment> resolveJSDocCommentsWithModuleTag(@NotNull PsiElement context2, @NotNull String moduleNameWithoutPrefix) {
        if (context2 == null) {
            CommonJSUtil.$$$reportNull$$$0(9);
        }
        if (moduleNameWithoutPrefix == null) {
            CommonJSUtil.$$$reportNull$$$0(10);
        }
        GlobalSearchScope scope2 = JSResolveUtil.getResolveScope(context2);
        Collection collection = StubIndex.getElements(JSDocModulesIndex.KEY, (Object)moduleNameWithoutPrefix, (Project)context2.getProject(), (GlobalSearchScope)scope2, JSDocComment.class);
        if (collection == null) {
            CommonJSUtil.$$$reportNull$$$0(11);
        }
        return collection;
    }

    public static Collection<JSFile> resolveReferencedElements(@NotNull PsiElement context2, @NotNull String path2) {
        if (context2 == null) {
            CommonJSUtil.$$$reportNull$$$0(12);
        }
        if (path2 == null) {
            CommonJSUtil.$$$reportNull$$$0(13);
        }
        return JSFileReferencesUtil.resolveModuleReference((PsiElement)context2.getContainingFile(), path2).stream().filter(el -> el instanceof JSFile).map(el -> (JSFile)el).collect(Collectors.toList());
    }

    public static boolean isExportNamespace(@Nullable JSNamespace namespace) {
        return namespace != null && CommonJSUtil.isExportNamespace(namespace.getQualifiedName());
    }

    public static boolean isExportNamespace(@Nullable JSQualifiedName qName) {
        if (qName == null) {
            return false;
        }
        String name = qName.getName();
        JSQualifiedName parent = qName.getParent();
        if ("exports".equals(name)) {
            return parent == null || "module".equals(parent.getName()) && parent.getParent() == null;
        }
        if ("default".equals(name)) {
            return parent == null;
        }
        return false;
    }

    public static boolean isModuleExportsNamespace(@Nullable JSQualifiedName name) {
        return name != null && ((JSQualifiedNameImpl)name).matches(MODULE_EXPORTS_COMPONENTS);
    }

    public static boolean isExportsDefinition(@Nullable PsiElement element2) {
        if (!(element2 instanceof JSDefinitionExpression)) {
            return false;
        }
        String name = ((JSDefinitionExpression)element2).getQualifiedName();
        return name != null && name.equals("exports");
    }

    public static boolean isModuleExportsAssigmentTarget(@NotNull JSElementBase element2) {
        if (element2 == null) {
            CommonJSUtil.$$$reportNull$$$0(14);
        }
        if (!"exports".equals(element2.getName())) {
            return false;
        }
        JSNamespace jsNamespace = element2.getJSNamespace();
        JSQualifiedName qName = jsNamespace.getQualifiedName();
        return qName != null && "module".equals(qName.getName()) && qName.getParent() == null && jsNamespace.getJSContext() == JSContext.STATIC;
    }

    @NotNull
    public static Collection<PsiElement> findReferencedModulesIfRequireCall(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            CommonJSUtil.$$$reportNull$$$0(15);
        }
        if (!callExpression.isRequireCall()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                CommonJSUtil.$$$reportNull$$$0(16);
            }
            return list;
        }
        JSExpression[] arguments = callExpression.getArguments();
        if (arguments.length > 0 && arguments[0] instanceof JSLiteralExpression) {
            Collection<PsiElement> collection = JSFileReferencesUtil.resolveModuleReferences((PsiElement)arguments[0]);
            if (collection == null) {
                CommonJSUtil.$$$reportNull$$$0(17);
            }
            return collection;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            CommonJSUtil.$$$reportNull$$$0(18);
        }
        return list;
    }

    @Nullable
    public static PsiElement findReferencedModuleIfRequireCall(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            CommonJSUtil.$$$reportNull$$$0(19);
        }
        return (PsiElement)ContainerUtil.getFirstItem(CommonJSUtil.findReferencedModulesIfRequireCall(callExpression));
    }

    @Nullable
    public static JSRequireCallExpressionType getTypeIfRequireCall(@NotNull JSCallExpression requireCall) {
        String path2;
        if (requireCall == null) {
            CommonJSUtil.$$$reportNull$$$0(20);
        }
        if ((path2 = CommonJSUtil.getModulePathIfRequireCall(requireCall)) == null) {
            return null;
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)requireCall, DialectDetector.isJavaScript((PsiElement)requireCall));
        return new JSRequireCallExpressionType(path2, typeSource);
    }

    public static @Unmodifiable @NotNull List<JSPsiElementBase> getModuleExports(@NotNull JSExecutionScope module) {
        if (module == null) {
            CommonJSUtil.$$$reportNull$$$0(21);
        }
        if (module instanceof TypeScriptModule) {
            List<JSPsiElementBase> list = Collections.emptyList();
            if (list == null) {
                CommonJSUtil.$$$reportNull$$$0(22);
            }
            return list;
        }
        if (!(module instanceof JSFile) && !ES6PsiUtil.isEmbeddedModule(module)) {
            LOG.error((Throwable)new IllegalStateException("Expected JSFile or an embedded module"));
            List<JSPsiElementBase> list = Collections.emptyList();
            if (list == null) {
                CommonJSUtil.$$$reportNull$$$0(23);
            }
            return list;
        }
        if (DumbService.isDumb((Project)module.getProject())) {
            List<JSPsiElementBase> list = Collections.emptyList();
            if (list == null) {
                CommonJSUtil.$$$reportNull$$$0(24);
            }
            return list;
        }
        List<JSPsiElementBase> candidates = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit("module.exports", module.getContainingFile());
        Condition filter = module instanceof JSFile ? EXPORTED_ELEMENTS_FILTER : element2 -> EXPORTED_ELEMENTS_FILTER.value(element2) && PsiTreeUtil.isContextAncestor((PsiElement)module, (PsiElement)element2, (boolean)false);
        List list = ContainerUtil.filter(candidates, (Condition)filter);
        if (list == null) {
            CommonJSUtil.$$$reportNull$$$0(25);
        }
        return list;
    }

    public static boolean isExportedWithModuleExports(@NotNull JSPsiElementBase element2) {
        JSFile file;
        if (element2 == null) {
            CommonJSUtil.$$$reportNull$$$0(26);
        }
        if ((file = (JSFile)ObjectUtils.tryCast((Object)element2.getContainingFile(), JSFile.class)) == null) {
            return false;
        }
        JSModuleStatusOwner.ModuleStatus status = file.getModuleStatus();
        if (status == JSModuleStatusOwner.ModuleStatus.NONE || status == JSModuleStatusOwner.ModuleStatus.ES6) {
            return false;
        }
        Boolean value = (Boolean)CachedValuesManager.getCachedValue((PsiElement)element2, () -> {
            boolean result2 = CommonJSUtil.isExportedWithModuleExportsInCommonJS(element2, file);
            return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{element2});
        });
        return value != null && value != false;
    }

    private static boolean isExportedWithModuleExportsInCommonJS(@NotNull JSPsiElementBase element2, @NotNull JSFile commonJSFile) {
        if (element2 == null) {
            CommonJSUtil.$$$reportNull$$$0(27);
        }
        if (commonJSFile == null) {
            CommonJSUtil.$$$reportNull$$$0(28);
        }
        List<JSPsiElementBase> exports = CommonJSUtil.getModuleExports(commonJSFile);
        String name = element2.getName();
        for (JSPsiElementBase export : exports) {
            PsiElement resolved;
            String ref2;
            if (!(export instanceof JSDefinitionExpression)) continue;
            JSExpression stub = ((JSDefinitionExpression)export).getInitializerOrStub();
            if (element2 == stub) {
                return true;
            }
            if (name == null || !Objects.equals(name, ref2 = JSPsiImplUtils.getInitializerReference((JSDefinitionExpression)export)) || (resolved = JSStubBasedPsiTreeUtil.resolveLocally(name, (PsiElement)export)) != element2) continue;
            return true;
        }
        return false;
    }

    public static boolean isMjsFile(@NotNull PsiFile file) {
        if (file == null) {
            CommonJSUtil.$$$reportNull$$$0(29);
        }
        return MJS_EXTENSION.equals(FileUtilRt.getExtension((String)file.getName()));
    }

    public static boolean isCjsFile(@NotNull PsiFile file) {
        if (file == null) {
            CommonJSUtil.$$$reportNull$$$0(30);
        }
        return CJS_EXTENSION.equals(FileUtilRt.getExtension((String)file.getName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 8, 11, 16, 17, 18, 22, 23, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/commonjs/CommonJSUtil";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNameWithoutPrefix";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 14: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requireCall";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonJSFile";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/commonjs/CommonJSUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "unifyModuleName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "unifyModuleNameShortened";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveJSDocCommentModules";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveJSDocCommentsWithModuleTag";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferencedModulesIfRequireCall";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleExports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateIsRequireCall";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getModulePathIfRequireCall";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unifyModuleName";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unifyModuleNameShortened";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveJSDocCommentModules";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveJSDocCommentsWithModuleTag";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferencedElements";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isModuleExportsAssigmentTarget";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findReferencedModulesIfRequireCall";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findReferencedModuleIfRequireCall";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTypeIfRequireCall";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getModuleExports";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isExportedWithModuleExports";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isExportedWithModuleExportsInCommonJS";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isMjsFile";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isCjsFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 8, 11, 16, 17, 18, 22, 23, 24, 25 -> new IllegalStateException(string);
        };
    }
}

