/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.service.JSEditorService;
import com.intellij.lang.javascript.service.JSLanguageServiceUpdateContext;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0007JH\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120\u000f2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0000\u0012\u00020\n0\tH\u0002J\u0016\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0010JH\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120\u000f2\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0000\u0012\u00020\n0\tH\u0002J&\u0010\u0019\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001a2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\nJ\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\nH\u0007J,\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100 2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0000\u0012\u00020\n0\tH\u0007\u00a8\u0006!"}, d2={"Lcom/intellij/lang/javascript/service/JSHighlightingInfoBuilder;", "", "<init>", "()V", "createUpdateContext", "Lcom/intellij/lang/javascript/service/JSLanguageServiceUpdateContext;", "project", "Lcom/intellij/openapi/project/Project;", "unsavedAndOpenedFilesFilter", "Ljava/util/function/Predicate;", "Lcom/intellij/openapi/vfs/VirtualFile;", "contextFile", "fillByOpenedEditors", "", "nameToContent", "", "Lcom/intellij/openapi/editor/Document;", "nameToTimestamps", "", "filesFilter", "getTimestamp", "openedFile", "document", "fillByUnsavedDocuments", "filter", "getModuleInfo", "Lcom/intellij/openapi/util/Pair;", "", "file", "toPath", "configFile", "getFilteredOpenedFiles", "", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSHighlightingInfoBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSHighlightingInfoBuilder.kt\ncom/intellij/lang/javascript/service/JSHighlightingInfoBuilder\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,122:1\n30#2,2:123\n536#3:125\n521#3,6:126\n*S KotlinDebug\n*F\n+ 1 JSHighlightingInfoBuilder.kt\ncom/intellij/lang/javascript/service/JSHighlightingInfoBuilder\n*L\n119#1:123,2\n120#1:125\n120#1:126,6\n*E\n"})
public final class JSHighlightingInfoBuilder {
    @NotNull
    public static final JSHighlightingInfoBuilder INSTANCE = new JSHighlightingInfoBuilder();

    private JSHighlightingInfoBuilder() {
    }

    @RequiresReadLock
    @NotNull
    public final JSLanguageServiceUpdateContext createUpdateContext(@NotNull Project project, @NotNull Predicate<? super VirtualFile> unsavedAndOpenedFilesFilter, @Nullable VirtualFile contextFile) {
        Document contextDocument;
        PsiFile contextPsiFile;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(unsavedAndOpenedFilesFilter, (String)"unsavedAndOpenedFilesFilter");
        Map nameToUnsavedContent = new HashMap();
        Map nameToOpenContent = new HashMap();
        Map nameToTimestamps = new HashMap();
        this.fillByUnsavedDocuments(project, nameToUnsavedContent, nameToTimestamps, unsavedAndOpenedFilesFilter);
        this.fillByOpenedEditors(project, nameToOpenContent, nameToTimestamps, unsavedAndOpenedFilesFilter);
        if (contextFile != null && !nameToUnsavedContent.containsKey(contextFile) && !nameToOpenContent.containsKey(contextFile) && (contextPsiFile = PsiManager.getInstance((Project)project).findFile(contextFile)) != null && (contextDocument = PsiDocumentManager.getInstance((Project)project).getDocument(contextPsiFile)) != null) {
            nameToTimestamps.put(contextFile, this.getTimestamp(contextFile, contextDocument));
        }
        return new JSLanguageServiceUpdateContext(nameToUnsavedContent, nameToOpenContent, nameToTimestamps);
    }

    private final void fillByOpenedEditors(Project project, Map<VirtualFile, Document> nameToContent, Map<VirtualFile, Long> nameToTimestamps, Predicate<? super VirtualFile> filesFilter) {
        Map<VirtualFile, Document> filteredFiles = this.getFilteredOpenedFiles(project, filesFilter);
        for (Map.Entry<VirtualFile, Document> entry : filteredFiles.entrySet()) {
            VirtualFile processedOpenedFile = entry.getKey();
            Document document = entry.getValue();
            nameToContent.put(processedOpenedFile, document);
            if (nameToTimestamps.containsKey(processedOpenedFile)) continue;
            long processedStamp = this.getTimestamp(processedOpenedFile, document);
            nameToTimestamps.put(processedOpenedFile, processedStamp);
        }
    }

    public final long getTimestamp(@NotNull VirtualFile openedFile, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)openedFile, (String)"openedFile");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        long processedStamp = openedFile.getModificationStamp();
        long processedDocumentModificationStamp = document.getModificationStamp();
        if (processedStamp < processedDocumentModificationStamp) {
            processedStamp = processedDocumentModificationStamp;
        }
        return processedStamp;
    }

    private final void fillByUnsavedDocuments(Project project, Map<VirtualFile, Document> nameToContent, Map<VirtualFile, Long> nameToTimestamps, Predicate<? super VirtualFile> filter) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager manager = fileDocumentManager;
        GlobalSearchScope globalSearchScope = ProjectScope.getAllScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getAllScope(...)");
        GlobalSearchScope scope2 = globalSearchScope;
        for (Document document : manager.getUnsavedDocuments()) {
            VirtualFile virtualFile = manager.getFile(document);
            if (virtualFile == null || !filter.test((VirtualFile)virtualFile) || !scope2.accept(virtualFile)) continue;
            nameToContent.put(virtualFile, document);
            nameToTimestamps.put(virtualFile, document.getModificationStamp());
        }
    }

    @NotNull
    public final Pair<String, String> getModuleInfo(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex projectFileIndex2 = projectFileIndex;
        VirtualFile contentRoot = projectFileIndex2.getContentRootForFile(file);
        String contentRootPath = null;
        if (contentRoot != null) {
            contentRootPath = JSLanguageServiceUtil.normalizeNameAndPath(contentRoot.getPath());
        }
        VirtualFile sourceRoot = projectFileIndex2.getSourceRootForFile(file);
        String sourceRootPath = null;
        if (sourceRoot != null) {
            sourceRootPath = JSLanguageServiceUtil.normalizeNameAndPath(sourceRoot.getPath());
        }
        Pair pair = Pair.create((Object)contentRootPath, sourceRootPath);
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
        return pair;
    }

    @JvmStatic
    @NotNull
    public static final String toPath(@NotNull VirtualFile configFile) {
        Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
        String string = FileUtil.toSystemDependentName((String)configFile.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @NotNull
    public final Map<VirtualFile, Document> getFilteredOpenedFiles(@NotNull Project project, @NotNull Predicate<? super VirtualFile> filesFilter) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(filesFilter, (String)"filesFilter");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service22 = false;
        Class<JSEditorService> serviceClass$iv = JSEditorService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Map<VirtualFile, Document> map2 = ((JSEditorService)object).getOpenedDocuments();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"getOpenedDocuments(...)");
        Map<VirtualFile, Document> $this$filter$iv = map2;
        boolean $i$f$filter = false;
        Map<VirtualFile, Document> $i$f$service22 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!filesFilter.test((VirtualFile)it.getKey())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }
}

