/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.meson.execution.build;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.cpp.execution.CLionRunConfiguration;
import com.jetbrains.cidr.cpp.execution.compound.CidrCompoundConfigurationContextBase;
import com.jetbrains.cidr.cpp.execution.compound.CidrCompoundRunConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrRunConfigurationUtil;
import com.jetbrains.cidr.execution.build.CidrBuildConfigurationProvider;
import com.jetbrains.cidr.meson.execution.build.MesonBuildConfiguration;
import com.jetbrains.cidr.meson.execution.run.MesonCompoundConfigurationContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/meson/execution/build/MesonBuildConfigurationProvider;", "Lcom/jetbrains/cidr/execution/build/CidrBuildConfigurationProvider;", "<init>", "()V", "getBuildableConfigurations", "", "Lcom/jetbrains/cidr/execution/CidrBuildConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "getCleanableConfigurations", "getSelectedBuildConfigurations", "Lcom/jetbrains/cidr/meson/execution/build/MesonBuildConfigurationProvider$BuildConfigurations;", "BuildConfigurations", "intellij.clion.meson"})
public final class MesonBuildConfigurationProvider
implements CidrBuildConfigurationProvider {
    @NotNull
    public List<CidrBuildConfiguration> getBuildableConfigurations(@NotNull Project project) {
        List list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        BuildConfigurations buildConfigurations = this.getSelectedBuildConfigurations(project);
        if (buildConfigurations == null) {
            return CollectionsKt.emptyList();
        }
        BuildConfigurations configurations = buildConfigurations;
        if (Intrinsics.areEqual((Object)configurations.getBuild(), (Object)configurations.getRun())) {
            list = CollectionsKt.listOf((Object)configurations.getBuild());
        } else {
            Object[] objectArray = new MesonBuildConfiguration[]{configurations.getBuild(), configurations.getRun()};
            list = CollectionsKt.listOfNotNull((Object[])objectArray);
        }
        return list;
    }

    @NotNull
    public List<CidrBuildConfiguration> getCleanableConfigurations(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        BuildConfigurations buildConfigurations = this.getSelectedBuildConfigurations(project);
        if (buildConfigurations == null) {
            return CollectionsKt.emptyList();
        }
        BuildConfigurations configurations = buildConfigurations;
        return CollectionsKt.listOf((Object)configurations.getBuild());
    }

    private final BuildConfigurations getSelectedBuildConfigurations(Project project) {
        CidrCompoundConfigurationContextBase.ExecutableConfiguration executableConfiguration;
        CidrCompoundConfigurationContextBase.ExecutableConfiguration executableConfiguration2;
        MesonBuildConfiguration mesonBuildConfiguration;
        CidrCompoundRunConfiguration compoundConfiguration = (CidrCompoundRunConfiguration)CidrRunConfigurationUtil.getSelectedRunConfiguration((Project)project, CidrCompoundRunConfiguration.class);
        CidrCompoundRunConfiguration cidrCompoundRunConfiguration = compoundConfiguration;
        if (!Intrinsics.areEqual((Object)(cidrCompoundRunConfiguration != null && (cidrCompoundRunConfiguration = cidrCompoundRunConfiguration.getContext()) != null ? cidrCompoundRunConfiguration.getId() : null), (Object)"MesonCompoundConfigurationContext")) {
            return null;
        }
        MesonCompoundConfigurationContext configurationContext = new MesonCompoundConfigurationContext();
        try {
            mesonBuildConfiguration = (MesonBuildConfiguration)configurationContext.getBuildConfiguration((CLionRunConfiguration)compoundConfiguration);
        }
        catch (CidrCompoundConfigurationContextBase.BuildConfigurationProblemException ex) {
            mesonBuildConfiguration = null;
        }
        MesonBuildConfiguration buildConfiguration = mesonBuildConfiguration;
        if (buildConfiguration == null) {
            return null;
        }
        try {
            executableConfiguration2 = configurationContext.getExecutableConfiguration(project, compoundConfiguration.getExecutableData(), buildConfiguration, buildConfiguration.getProfileName());
        }
        catch (CidrCompoundConfigurationContextBase.BuildConfigurationProblemException e) {
            executableConfiguration2 = null;
        }
        CidrCompoundConfigurationContextBase.ExecutableConfiguration executableConfiguration3 = executableConfiguration = executableConfiguration2;
        return new BuildConfigurations(buildConfiguration, executableConfiguration3 != null ? (MesonBuildConfiguration)executableConfiguration3.getBuildConfiguration() : null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/meson/execution/build/MesonBuildConfigurationProvider$BuildConfigurations;", "", "build", "Lcom/jetbrains/cidr/meson/execution/build/MesonBuildConfiguration;", "run", "<init>", "(Lcom/jetbrains/cidr/meson/execution/build/MesonBuildConfiguration;Lcom/jetbrains/cidr/meson/execution/build/MesonBuildConfiguration;)V", "getBuild", "()Lcom/jetbrains/cidr/meson/execution/build/MesonBuildConfiguration;", "getRun", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.clion.meson"})
    private static final class BuildConfigurations {
        @NotNull
        private final MesonBuildConfiguration build;
        @Nullable
        private final MesonBuildConfiguration run;

        public BuildConfigurations(@NotNull MesonBuildConfiguration build, @Nullable MesonBuildConfiguration run) {
            Intrinsics.checkNotNullParameter((Object)build, (String)"build");
            this.build = build;
            this.run = run;
        }

        @NotNull
        public final MesonBuildConfiguration getBuild() {
            return this.build;
        }

        @Nullable
        public final MesonBuildConfiguration getRun() {
            return this.run;
        }

        @NotNull
        public final MesonBuildConfiguration component1() {
            return this.build;
        }

        @Nullable
        public final MesonBuildConfiguration component2() {
            return this.run;
        }

        @NotNull
        public final BuildConfigurations copy(@NotNull MesonBuildConfiguration build, @Nullable MesonBuildConfiguration run) {
            Intrinsics.checkNotNullParameter((Object)build, (String)"build");
            return new BuildConfigurations(build, run);
        }

        public static /* synthetic */ BuildConfigurations copy$default(BuildConfigurations buildConfigurations, MesonBuildConfiguration mesonBuildConfiguration, MesonBuildConfiguration mesonBuildConfiguration2, int n, Object object) {
            if ((n & 1) != 0) {
                mesonBuildConfiguration = buildConfigurations.build;
            }
            if ((n & 2) != 0) {
                mesonBuildConfiguration2 = buildConfigurations.run;
            }
            return buildConfigurations.copy(mesonBuildConfiguration, mesonBuildConfiguration2);
        }

        @NotNull
        public String toString() {
            return "BuildConfigurations(build=" + this.build + ", run=" + this.run + ")";
        }

        public int hashCode() {
            int result2 = this.build.hashCode();
            result2 = result2 * 31 + (this.run == null ? 0 : this.run.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BuildConfigurations)) {
                return false;
            }
            BuildConfigurations buildConfigurations = (BuildConfigurations)other;
            if (!Intrinsics.areEqual((Object)this.build, (Object)buildConfigurations.build)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.run, (Object)buildConfigurations.run);
        }
    }
}

