/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.meson.project;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.Version;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.external.system.model.ExternalModule;
import com.jetbrains.cidr.meson.MesonUtil;
import com.jetbrains.cidr.meson.MesonUtilKt;
import com.jetbrains.cidr.meson.execution.build.MesonBuildConfiguration;
import com.jetbrains.cidr.meson.execution.build.MesonBuildTarget;
import com.jetbrains.cidr.meson.project.MesonExternalProjectData;
import com.jetbrains.cidr.meson.project.MesonModelManagerKt;
import com.jetbrains.cidr.meson.settings.MesonProjectSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 22\u00020\u0001:\u000501234B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0002J\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u0004\u0018\u00010\u000e2\u0006\u0010$\u001a\u00020\u001aJ\u0016\u0010%\u001a\u00020\u001e2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002J\u0018\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0016\u0010)\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020/2\u0006\u0010,\u001a\u00020-R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u000e0\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/jetbrains/cidr/meson/project/MesonModelManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "modelChangeLock", "Ljava/util/concurrent/locks/ReentrantLock;", "isInitialized", "", "value", "", "Lcom/jetbrains/cidr/meson/execution/build/MesonBuildTarget;", "targets", "getTargets", "()Ljava/util/List;", "version", "Lcom/intellij/openapi/util/Version;", "getVersion", "()Lcom/intellij/openapi/util/Version;", "setVersion", "(Lcom/intellij/openapi/util/Version;)V", "resolveConfigurationsMapping", "", "", "isNotFirstInitialization", "Ljava/util/concurrent/atomic/AtomicBoolean;", "skipUpdateNotificationOnNotFirstInitialization", "", "body", "Lkotlin/Function0;", "getState", "Lcom/jetbrains/cidr/meson/project/MesonModelManager$State;", "findTarget", "resolveConfigurationId", "processImport", "projectData", "", "Lcom/jetbrains/cidr/meson/project/MesonExternalProjectData;", "safelySubscribe", "connection", "Lcom/intellij/util/messages/SimpleMessageBusConnection;", "listener", "Lcom/jetbrains/cidr/meson/project/MesonModelManager$Listener;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "State", "Listener", "Companion", "MesonExternalProjectDataService", "MesonExternalProjectDataLoader", "intellij.clion.meson"})
@SourceDebugExtension(value={"SMAP\nMesonModelManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MesonModelManager.kt\ncom/jetbrains/cidr/meson/project/MesonModelManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,247:1\n1#2:248\n1563#3:249\n1634#3,3:250\n774#3:253\n865#3,2:254\n1208#3,2:256\n1236#3,4:258\n*S KotlinDebug\n*F\n+ 1 MesonModelManager.kt\ncom/jetbrains/cidr/meson/project/MesonModelManager\n*L\n127#1:249\n127#1:250,3\n129#1:253\n129#1:254,2\n130#1:256,2\n130#1:258,4\n*E\n"})
public final class MesonModelManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ReentrantLock modelChangeLock;
    private boolean isInitialized;
    @NotNull
    private List<? extends MesonBuildTarget> targets;
    @NotNull
    private Version version;
    @NotNull
    private Map<String, ? extends MesonBuildTarget> resolveConfigurationsMapping;
    @NotNull
    private AtomicBoolean isNotFirstInitialization;
    @NotNull
    private static final Version UNKNOWN_VERSION = new Version(0, 0, 0);

    public MesonModelManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.modelChangeLock = new ReentrantLock();
        this.targets = CollectionsKt.emptyList();
        this.version = UNKNOWN_VERSION;
        this.resolveConfigurationsMapping = MapsKt.emptyMap();
        this.isNotFirstInitialization = new AtomicBoolean(false);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final List<MesonBuildTarget> getTargets() {
        return this.targets;
    }

    @NotNull
    public final Version getVersion() {
        return this.version;
    }

    public final void setVersion(@NotNull Version version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"<set-?>");
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void skipUpdateNotificationOnNotFirstInitialization(Function0<Unit> body) {
        this.isNotFirstInitialization.set(true);
        try {
            body.invoke();
        }
        finally {
            this.isNotFirstInitialization.set(false);
        }
    }

    @NotNull
    public final State getState() {
        return new State(CollectionsKt.toList((Iterable)this.targets), new Version(this.version.major, this.version.minor, this.version.bugfix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final MesonBuildTarget findTarget(@NotNull String resolveConfigurationId) {
        MesonBuildTarget mesonBuildTarget;
        Intrinsics.checkNotNullParameter((Object)resolveConfigurationId, (String)"resolveConfigurationId");
        Lock lock = this.modelChangeLock;
        lock.lock();
        try {
            boolean bl = false;
            mesonBuildTarget = this.resolveConfigurationsMapping.get(resolveConfigurationId);
        }
        finally {
            lock.unlock();
        }
        return mesonBuildTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void processImport(Collection<MesonExternalProjectData> projectData) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object object;
        void $this$mapTo$iv$iv;
        if (!(projectData.size() <= 1)) {
            boolean $i$a$-require-MesonModelManager$processImport$22 = false;
            String $i$a$-require-MesonModelManager$processImport$22 = "Only one Meson profile is currently supported";
            throw new IllegalArgumentException($i$a$-require-MesonModelManager$processImport$22.toString());
        }
        Listener publisher = (Listener)this.project.getMessageBus().syncPublisher(Listener.Companion.getTOPIC());
        State oldState = this.getState();
        MesonExternalProjectData mesonExternalProjectData = (MesonExternalProjectData)CollectionsKt.firstOrNull((Iterable)projectData);
        if (mesonExternalProjectData == null) {
            return;
        }
        MesonExternalProjectData data = mesonExternalProjectData;
        Object object2 = (MesonProjectSettings)((Object)CollectionsKt.firstOrNull((Iterable)MesonUtil.INSTANCE.linkedProjectSettings(this.project)));
        if (object2 == null || (object2 = object2.profile()) == null) {
            return;
        }
        Object profile = object2;
        Iterable $this$map$iv = data.getTargets();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MesonExternalProjectData.Target target = (MesonExternalProjectData.Target)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(MesonModelManagerKt.access$asBuildTarget((MesonExternalProjectData.Target)it, (MesonProjectSettings.MesonProfile)profile, this.project));
        }
        List newTargets = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)MesonModelManagerKt.access$allTarget((MesonProjectSettings.MesonProfile)profile, this.project));
        Iterable $i$f$map22 = newTargets;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MesonBuildTarget it = (MesonBuildTarget)element$iv$iv;
            boolean bl = false;
            MesonBuildConfiguration mesonBuildConfiguration = (MesonBuildConfiguration)CollectionsKt.firstOrNull(it.getBuildConfigurations());
            if (!((mesonBuildConfiguration != null ? mesonBuildConfiguration.getResolveConfigurationId() : null) != null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associateBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            MesonBuildTarget bl = (MesonBuildTarget)element$iv$iv;
            object = destination$iv$iv3;
            boolean bl2 = false;
            String string = ((MesonBuildConfiguration)CollectionsKt.first(it.getBuildConfigurations())).getResolveConfigurationId();
            Intrinsics.checkNotNull((Object)string);
            object.put(string, element$iv$iv);
        }
        Map newMapping = destination$iv$iv3;
        Version version = data.getMesonVersion();
        Intrinsics.checkNotNull((Object)version);
        Version newVersion = version;
        Lock lock = this.modelChangeLock;
        lock.lock();
        try {
            boolean bl = false;
            boolean isUpdate = this.isInitialized;
            this.targets = newTargets;
            this.resolveConfigurationsMapping = newMapping;
            this.version = newVersion;
            this.isInitialized = true;
            if (isUpdate) {
                publisher.onModelChanged(oldState, this.getState());
            } else {
                State newState = this.getState();
                publisher.onModelInitialized(newState);
                if (!this.isNotFirstInitialization.get()) {
                    publisher.onModelChanged(oldState, newState);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void safelySubscribe(SimpleMessageBusConnection connection, Listener listener2) {
        Lock lock = this.modelChangeLock;
        lock.lock();
        try {
            boolean bl = false;
            connection.subscribe(Listener.Companion.getTOPIC(), (Object)listener2);
            if (this.isInitialized) {
                listener2.onModelInitialized(this.getState());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public final void safelySubscribe(@NotNull CoroutineScope coroutineScope, @NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        SimpleMessageBusConnection connection = this.project.getMessageBus().connect(coroutineScope);
        this.safelySubscribe(connection, listener2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/meson/project/MesonModelManager$Companion;", "", "<init>", "()V", "UNKNOWN_VERSION", "Lcom/intellij/openapi/util/Version;", "getUNKNOWN_VERSION", "()Lcom/intellij/openapi/util/Version;", "getInstance", "Lcom/jetbrains/cidr/meson/project/MesonModelManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clion.meson"})
    @SourceDebugExtension(value={"SMAP\nMesonModelManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MesonModelManager.kt\ncom/jetbrains/cidr/meson/project/MesonModelManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,247:1\n30#2,2:248\n*S KotlinDebug\n*F\n+ 1 MesonModelManager.kt\ncom/jetbrains/cidr/meson/project/MesonModelManager$Companion\n*L\n53#1:248,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Version getUNKNOWN_VERSION() {
            return UNKNOWN_VERSION;
        }

        @NotNull
        public final MesonModelManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<MesonModelManager> serviceClass$iv = MesonModelManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (MesonModelManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cidr/meson/project/MesonModelManager$Listener;", "", "onModelChanged", "", "oldState", "Lcom/jetbrains/cidr/meson/project/MesonModelManager$State;", "newState", "onModelInitialized", "Companion", "intellij.clion.meson"})
    public static interface Listener {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        default public void onModelChanged(@NotNull State oldState, @NotNull State newState) {
            Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
            Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        }

        default public void onModelInitialized(@NotNull State newState) {
            Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/meson/project/MesonModelManager$Listener$Companion;", "", "<init>", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/jetbrains/cidr/meson/project/MesonModelManager$Listener;", "getTOPIC", "()Lcom/intellij/util/messages/Topic;", "intellij.clion.meson"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Topic<Listener> TOPIC;

            private Companion() {
            }

            @NotNull
            public final Topic<Listener> getTOPIC() {
                return TOPIC;
            }

            static {
                $$INSTANCE = new Companion();
                TOPIC = new Topic(Listener.class.getName(), Listener.class);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/meson/project/MesonModelManager$MesonExternalProjectDataLoader;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clion.meson"})
    @SourceDebugExtension(value={"SMAP\nMesonModelManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MesonModelManager.kt\ncom/jetbrains/cidr/meson/project/MesonModelManager$MesonExternalProjectDataLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,247:1\n1617#2,9:248\n1869#2:257\n1870#2:259\n1626#2:260\n1374#2:261\n1460#2,5:262\n1374#2:267\n1460#2,5:268\n1374#2:273\n1460#2,5:274\n1563#2:279\n1634#2,3:280\n1#3:258\n*S KotlinDebug\n*F\n+ 1 MesonModelManager.kt\ncom/jetbrains/cidr/meson/project/MesonModelManager$MesonExternalProjectDataLoader\n*L\n199#1:248,9\n199#1:257\n199#1:259\n199#1:260\n201#1:261\n201#1:262,5\n202#1:267\n202#1:268,5\n203#1:273\n203#1:274,5\n204#1:279\n204#1:280,3\n199#1:258\n*E\n"})
    public static final class MesonExternalProjectDataLoader
    implements ProjectActivity {
        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            ProjectDataManager projectDataManager = ProjectDataManager.getInstance();
            ExternalProjectsManager.getInstance((Project)project).runWhenInitialized(() -> MesonExternalProjectDataLoader.execute$lambda$6(project, projectDataManager));
            return Unit.INSTANCE;
        }

        private static final Unit execute$lambda$6$lambda$5(MesonModelManager $modelManager, List $toImport) {
            $modelManager.processImport($toImport);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final void execute$lambda$6(Project $project, ProjectDataManager $projectDataManager) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable list$iv$iv;
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            void $this$mapNotNullTo$iv$iv;
            MesonModelManager modelManager = Companion.getInstance($project);
            Collection collection = $projectDataManager.getExternalProjectsData($project, MesonUtilKt.getID());
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getExternalProjectsData(...)");
            Collection projectInfos = collection;
            Iterable $this$mapNotNull$iv = projectInfos;
            boolean $i$f$mapNotNull22 = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                DataNode it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                ExternalProjectInfo it = (ExternalProjectInfo)element$iv$iv;
                boolean bl2 = false;
                if (it.getExternalProjectStructure() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List projectDataNodes = (List)destination$iv$iv;
            Iterable $i$f$mapNotNull22 = projectDataNodes;
            boolean $i$f$flatMap = false;
            destination$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                DataNode projectDataNode = (DataNode)element$iv$iv;
                boolean bl = false;
                Collection collection2 = ExternalSystemApiUtil.findAll((DataNode)projectDataNode, (Key)ProjectKeys.MODULE);
                Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"findAll(...)");
                list$iv$iv = collection2;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv2;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv2 = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                DataNode moduleDataNode = (DataNode)element$iv$iv;
                boolean bl = false;
                Collection collection3 = ExternalSystemApiUtil.findAll((DataNode)moduleDataNode, (Key)ExternalModule.OC_MODULE_KEY);
                Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"findAll(...)");
                list$iv$iv = collection3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv2;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv2 = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                DataNode externalModuleNode = (DataNode)element$iv$iv;
                boolean bl = false;
                Collection collection4 = ExternalSystemApiUtil.findAll((DataNode)externalModuleNode, MesonExternalProjectData.Companion.getDATA_KEY());
                Intrinsics.checkNotNullExpressionValue((Object)collection4, (String)"findAll(...)");
                list$iv$iv = collection4;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                list$iv$iv = (DataNode)item$iv$iv;
                Collection collection5 = destination$iv$iv2;
                boolean bl = false;
                collection5.add((MesonExternalProjectData)it.getData());
            }
            List toImport = (List)destination$iv$iv2;
            modelManager.skipUpdateNotificationOnNotFirstInitialization((Function0<Unit>)() -> MesonExternalProjectDataLoader.execute$lambda$6$lambda$5(modelManager, toImport));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J6\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/meson/project/MesonModelManager$MesonExternalProjectDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lcom/jetbrains/cidr/meson/project/MesonExternalProjectData;", "Ljava/lang/Module;", "<init>", "()V", "postProcess", "", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "intellij.clion.meson"})
    @SourceDebugExtension(value={"SMAP\nMesonModelManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MesonModelManager.kt\ncom/jetbrains/cidr/meson/project/MesonModelManager$MesonExternalProjectDataService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,247:1\n1563#2:248\n1634#2,3:249\n*S KotlinDebug\n*F\n+ 1 MesonModelManager.kt\ncom/jetbrains/cidr/meson/project/MesonModelManager$MesonExternalProjectDataService\n*L\n185#1:248\n185#1:249,3\n*E\n"})
    public static final class MesonExternalProjectDataService
    extends AbstractProjectDataService<MesonExternalProjectData, Module> {
        /*
         * WARNING - void declaration
         */
        public void postProcess(@NotNull Collection<? extends DataNode<MesonExternalProjectData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(toImport, (String)"toImport");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
            MesonModelManager modelManager = Companion.getInstance(project);
            Iterable iterable = toImport;
            MesonModelManager mesonModelManager = modelManager;
            boolean $i$f$map = false;
            void var8_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DataNode dataNode = (DataNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object object = it.getData();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
                collection.add((MesonExternalProjectData)object);
            }
            mesonModelManager.processImport((List)destination$iv$iv);
        }

        @NotNull
        public Key<MesonExternalProjectData> getTargetDataKey() {
            return MesonExternalProjectData.Companion.getDATA_KEY();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/meson/project/MesonModelManager$State;", "", "targets", "", "Lcom/jetbrains/cidr/meson/execution/build/MesonBuildTarget;", "version", "Lcom/intellij/openapi/util/Version;", "<init>", "(Ljava/util/List;Lcom/intellij/openapi/util/Version;)V", "getTargets", "()Ljava/util/List;", "getVersion", "()Lcom/intellij/openapi/util/Version;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.clion.meson"})
    public static final class State {
        @NotNull
        private final List<MesonBuildTarget> targets;
        @NotNull
        private final Version version;

        public State(@NotNull List<? extends MesonBuildTarget> targets, @NotNull Version version) {
            Intrinsics.checkNotNullParameter(targets, (String)"targets");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            this.targets = targets;
            this.version = version;
        }

        @NotNull
        public final List<MesonBuildTarget> getTargets() {
            return this.targets;
        }

        @NotNull
        public final Version getVersion() {
            return this.version;
        }

        @NotNull
        public final List<MesonBuildTarget> component1() {
            return this.targets;
        }

        @NotNull
        public final Version component2() {
            return this.version;
        }

        @NotNull
        public final State copy(@NotNull List<? extends MesonBuildTarget> targets, @NotNull Version version) {
            Intrinsics.checkNotNullParameter(targets, (String)"targets");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return new State(targets, version);
        }

        public static /* synthetic */ State copy$default(State state, List list, Version version, int n, Object object) {
            if ((n & 1) != 0) {
                list = state.targets;
            }
            if ((n & 2) != 0) {
                version = state.version;
            }
            return state.copy(list, version);
        }

        @NotNull
        public String toString() {
            return "State(targets=" + this.targets + ", version=" + this.version + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.targets).hashCode();
            result2 = result2 * 31 + this.version.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (!Intrinsics.areEqual(this.targets, state.targets)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.version, (Object)state.version);
        }
    }
}

