/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.meson.project.resolver;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.external.system.model.ExternalModule;
import com.jetbrains.cidr.external.system.model.impl.ExternalFileConfigurationBuilder;
import com.jetbrains.cidr.external.system.model.impl.ExternalLanguageConfigurationBuilder;
import com.jetbrains.cidr.external.system.model.impl.ExternalModuleBuilder;
import com.jetbrains.cidr.external.system.model.impl.ExternalResolveConfigurationBuilder;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerResolver;
import com.jetbrains.cidr.lang.workspace.compiler.UnknownCompilerKind;
import com.jetbrains.cidr.meson.bundle.MesonBundle;
import com.jetbrains.cidr.meson.fus.MesonEventsUsagesCollectorKt;
import com.jetbrains.cidr.meson.project.MesonExternalProjectData;
import com.jetbrains.cidr.meson.project.resolver.MesonEventDataKt;
import com.jetbrains.cidr.meson.project.resolver.MesonIntrospectionConverterKt;
import com.jetbrains.cidr.meson.project.resolver.MesonResolverContext;
import com.jetbrains.cidr.meson.project.resolver.model.MesonCompilerId;
import com.jetbrains.cidr.meson.project.resolver.model.MesonIntroCompilers;
import com.jetbrains.cidr.meson.project.resolver.model.MesonIntroLanguage;
import com.jetbrains.cidr.meson.project.resolver.model.MesonIntroTargets;
import com.jetbrains.cidr.meson.project.resolver.model.MesonIntrospection;
import com.jetbrains.cidr.meson.settings.MesonProjectSettings;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u000289B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0\u000bH\u0002J$\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0\u000bH\u0002J<\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00152\b\u0010%\u001a\u0004\u0018\u00010&2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0\u000bH\u0002J*\u0010'\u001a\u00020\u001d2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00152\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u00162\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010.\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020,H\u0002J$\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u00020\u001d2\u0012\b\u0002\u00101\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001502H\u0002J\u0015\u00103\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0001\u00a2\u0006\u0002\b4R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u00105\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b8AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u0006:"}, d2={"Lcom/jetbrains/cidr/meson/project/resolver/MesonIntrospectionConverter;", "", "resolverContext", "Lcom/jetbrains/cidr/meson/project/resolver/MesonResolverContext;", "environment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "buildDirectory", "Ljava/nio/file/Path;", "<init>", "(Lcom/jetbrains/cidr/meson/project/resolver/MesonResolverContext;Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;Ljava/nio/file/Path;)V", "compilers", "", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "Lcom/jetbrains/cidr/meson/project/resolver/MesonIntrospectionConverter$CompilerInfo;", "convert", "Lcom/jetbrains/cidr/meson/project/resolver/MesonIntrospectionConverter$Model;", "introspection", "Lcom/jetbrains/cidr/meson/project/resolver/model/MesonIntrospection;", "convertModule", "Lcom/jetbrains/cidr/external/system/model/ExternalModule;", "convertBuildTargets", "", "Lcom/jetbrains/cidr/meson/project/MesonExternalProjectData$Target;", "readCompilersInfo", "", "readIntroCompilers", "introCompilers", "Lcom/jetbrains/cidr/meson/project/resolver/model/MesonIntroCompilers;", "executablesCache", "", "readTargetsCompilers", "introTargets", "Lcom/jetbrains/cidr/meson/project/resolver/model/MesonIntroTargets;", "readCompiler", "mesonLanguage", "Lcom/jetbrains/cidr/meson/project/resolver/model/MesonIntroLanguage;", "mesonCompilerCommand", "mesonCompilerId", "Lcom/jetbrains/cidr/meson/project/resolver/model/MesonCompilerId;", "resolveCompilerExecutable", "compilerCommand", "cache", "Lcom/jetbrains/cidr/external/system/model/impl/ExternalResolveConfigurationBuilder;", "target", "Lcom/jetbrains/cidr/meson/project/resolver/model/MesonIntroTargets$Target;", "convertBuildTarget", "createConfigurationId", "debug", "message", "lazyDebugValues", "Lkotlin/Function0;", "testReadCompilersInfo", "testReadCompilersInfo$intellij_clion_meson", "testCompilers", "getTestCompilers$intellij_clion_meson", "()Ljava/util/Map;", "Model", "CompilerInfo", "intellij.clion.meson"})
@SourceDebugExtension(value={"SMAP\nMesonIntrospectionConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MesonIntrospectionConverter.kt\ncom/jetbrains/cidr/meson/project/resolver/MesonIntrospectionConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,436:1\n1563#2:437\n1634#2,3:438\n1761#2,3:447\n1374#2:450\n1460#2,5:451\n1869#2,2:457\n77#3:441\n97#3,5:442\n1#4:456\n*S KotlinDebug\n*F\n+ 1 MesonIntrospectionConverter.kt\ncom/jetbrains/cidr/meson/project/resolver/MesonIntrospectionConverter\n*L\n93#1:437\n93#1:438,3\n143#1:447,3\n164#1:450\n164#1:451,5\n334#1:457,2\n143#1:441\n143#1:442,5\n*E\n"})
public final class MesonIntrospectionConverter {
    @NotNull
    private final MesonResolverContext resolverContext;
    @NotNull
    private final CPPEnvironment environment;
    @NotNull
    private final Path buildDirectory;
    @NotNull
    private final Map<OCLanguageKind, CompilerInfo> compilers;

    public MesonIntrospectionConverter(@NotNull MesonResolverContext resolverContext, @NotNull CPPEnvironment environment, @NotNull Path buildDirectory) {
        Intrinsics.checkNotNullParameter((Object)resolverContext, (String)"resolverContext");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)buildDirectory, (String)"buildDirectory");
        this.resolverContext = resolverContext;
        this.environment = environment;
        this.buildDirectory = buildDirectory;
        this.compilers = new LinkedHashMap();
    }

    @NotNull
    public final Model convert(@NotNull MesonIntrospection introspection) {
        Intrinsics.checkNotNullParameter((Object)introspection, (String)"introspection");
        MesonIntrospectionConverter.debug$default(this, "Parsing meson introspection", null, 2, null);
        ExternalModule module = this.convertModule(introspection);
        List<MesonExternalProjectData.Target> targets = this.convertBuildTargets(introspection);
        return new Model(module, targets);
    }

    private final ExternalModule convertModule(MesonIntrospection introspection) {
        MesonIntrospectionConverter.debug$default(this, "Parsing ExternalModule", null, 2, null);
        ExternalModuleBuilder module = new ExternalModuleBuilder();
        if (introspection.getTargets().getTargets().isEmpty()) {
            MesonEventDataKt.warn(this.resolverContext, MesonBundle.message("converter.no.targets", new Object[0]));
            return module.invoke();
        }
        this.readCompilersInfo(introspection);
        for (MesonIntroTargets.Target target : introspection.getTargets().getTargets()) {
            ExternalResolveConfigurationBuilder resolveConfiguration = this.convert(target);
            module.withResolveConfiguration(resolveConfiguration.invoke());
        }
        return module.invoke();
    }

    /*
     * WARNING - void declaration
     */
    private final List<MesonExternalProjectData.Target> convertBuildTargets(MesonIntrospection introspection) {
        void $this$mapTo$iv$iv;
        MesonIntrospectionConverter.debug$default(this, "Parsing MesonExternalProjectData.Target", null, 2, null);
        Iterable $this$map$iv = introspection.getTargets().getTargets();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MesonIntroTargets.Target target = (MesonIntroTargets.Target)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.convertBuildTarget((MesonIntroTargets.Target)it));
        }
        return (List)destination$iv$iv;
    }

    private final void readCompilersInfo(MesonIntrospection introspection) {
        HashMap executablesCache = new HashMap();
        MesonIntroCompilers introCompilers = introspection.getCompilers();
        if (introCompilers != null) {
            this.readIntroCompilers(introCompilers, executablesCache);
        }
        this.readTargetsCompilers(introspection.getTargets(), executablesCache);
        if (MesonIntrospectionConverterKt.access$getLOG$p().isDebugEnabled()) {
            for (Map.Entry<OCLanguageKind, CompilerInfo> entry : this.compilers.entrySet()) {
                OCLanguageKind language = entry.getKey();
                CompilerInfo compilerInfo = entry.getValue();
                this.debug("Parsed compiler", () -> MesonIntrospectionConverter.readCompilersInfo$lambda$1(language, compilerInfo));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void readIntroCompilers(MesonIntroCompilers introCompilers, Map<String, String> executablesCache) {
        compilerSelectionPolicy = this.resolverContext.getProjectSettings().profile().getCompilerInfoSelection();
        switch (WhenMappings.$EnumSwitchMapping$0[compilerSelectionPolicy.ordinal()]) {
            case 1: {
                MesonIntrospectionConverterKt.access$getLOG$p().info("User forced build compiler selection.");
                v0 = TuplesKt.to((Object)compilerSelectionPolicy, introCompilers.getBuildCompilers());
                break;
            }
            case 2: {
                MesonIntrospectionConverterKt.access$getLOG$p().info("User forced host compiler selection.");
                v0 = TuplesKt.to((Object)compilerSelectionPolicy, introCompilers.getHostCompilers());
                break;
            }
            case 3: {
                $this$flatMap$iv = introCompilers.getHostCompilers();
                $i$f$flatMap = false;
                var9_7 = $this$flatMap$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$flatMapTo = false;
                var12_11 = $this$flatMapTo$iv$iv.entrySet().iterator();
                while (var12_11.hasNext()) {
                    it = element$iv$iv = var12_11.next();
                    $i$a$-flatMap-MesonIntrospectionConverter$readIntroCompilers$1 = false;
                    list$iv$iv = ((MesonIntroCompilers.Compiler)it.getValue()).getCompilerCommand();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$any$iv = (List)destination$iv$iv;
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl30
                v1 = false;
                ** GOTO lbl37
lbl30:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (String)element$iv;
                    $i$a$-any-MesonIntrospectionConverter$readIntroCompilers$2 = false;
                    if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"--sysroot", (boolean)false, (int)2, null)) continue;
                    v1 = true;
                    ** GOTO lbl37
                }
                v1 = false;
lbl37:
                // 3 sources

                if (v1) {
                    MesonIntrospectionConverterKt.access$getLOG$p().info("Cross-compilation with sysroot detected. Selected host compilers to resolve");
                    v0 = TuplesKt.to((Object)MesonProjectSettings.MesonProfile.CompilerInfoSelection.HOST, introCompilers.getHostCompilers());
                    break;
                }
                v0 = TuplesKt.to((Object)MesonProjectSettings.MesonProfile.CompilerInfoSelection.BUILD, introCompilers.getBuildCompilers());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        var4_16 = v0;
        usedPolicy = (MesonProjectSettings.MesonProfile.CompilerInfoSelection)var4_16.component1();
        selectedCompilers = (Map)var4_16.component2();
        MesonEventsUsagesCollectorKt.getCOMPILER_POLICY().log((Object)compilerSelectionPolicy, (Object)usedPolicy);
        for (Map.Entry<K, V> var8_6 : selectedCompilers.entrySet()) {
            mesonLanguage = (MesonIntroLanguage)var8_6.getKey();
            mesonCompiler = (MesonIntroCompilers.Compiler)var8_6.getValue();
            this.readCompiler(mesonLanguage, mesonCompiler.getCompilerCommand(), mesonCompiler.getId(), executablesCache);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void readTargetsCompilers(MesonIntroTargets introTargets, Map<String, String> executablesCache) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = introTargets.getTargets();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            MesonIntroTargets.Target it = (MesonIntroTargets.Target)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getSources();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        for (MesonIntroTargets.Target.Sources mesonSources : (List)destination$iv$iv) {
            this.readCompiler(mesonSources.getLanguage(), mesonSources.getCompilerCommand(), null, executablesCache);
        }
    }

    private final void readCompiler(MesonIntroLanguage mesonLanguage, List<String> mesonCompilerCommand, MesonCompilerId mesonCompilerId, Map<String, String> executablesCache) {
        this.debug("Parsing compiler info", () -> MesonIntrospectionConverter.readCompiler$lambda$5(mesonLanguage, mesonCompilerCommand, mesonCompilerId));
        if (mesonLanguage instanceof MesonIntroLanguage.Unknown) {
            return;
        }
        OCLanguageKind languageKind = MesonIntrospectionConverterKt.access$getOcLanguageKind(mesonLanguage);
        if (languageKind == null) {
            MesonIntrospectionConverterKt.access$getLOG$p().warn("Unsupported language is used in project: " + mesonLanguage);
            return;
        }
        this.compilers.computeIfAbsent(languageKind, arg_0 -> MesonIntrospectionConverter.readCompiler$lambda$7(arg_0 -> MesonIntrospectionConverter.readCompiler$lambda$6(mesonCompilerCommand, this, executablesCache, mesonCompilerId, arg_0), arg_0));
    }

    private final String resolveCompilerExecutable(List<String> compilerCommand, Map<String, String> cache) {
        if (!(!((Collection)compilerCommand).isEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String compilerExecutable = MesonIntrospectionConverterKt.getCompilerExecutable(compilerCommand);
        if (compilerExecutable == null) {
            Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)compilerCommand, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)};
            MesonIntrospectionConverterKt.access$fail(this.resolverContext, MesonBundle.message("converter.failed.to.find.compiler.executable", objectArray));
            throw new KotlinNothingValueException();
        }
        String string = cache.computeIfAbsent(compilerExecutable, arg_0 -> MesonIntrospectionConverter.resolveCompilerExecutable$lambda$9(arg_0 -> MesonIntrospectionConverter.resolveCompilerExecutable$lambda$8(this, compilerExecutable, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"computeIfAbsent(...)");
        return string;
    }

    private final ExternalResolveConfigurationBuilder convert(MesonIntroTargets.Target target) {
        MesonIntrospectionConverter.debug$default(this, "Parsing target info: name=" + target.getName(), null, 2, null);
        String string = this.createConfigurationId(target);
        String string2 = target.getName();
        File file = this.buildDirectory.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        ExternalResolveConfigurationBuilder configuration = new ExternalResolveConfigurationBuilder(string, string2, file).withToolchainName(this.environment.getToolchain().getName());
        Set languages = new LinkedHashSet();
        for (MesonIntroTargets.Target.Sources mesonSources : target.getSources()) {
            CompilerInfo compilerInfo;
            OCLanguageKind languageKind;
            if (MesonIntrospectionConverterKt.access$getOcLanguageKind(mesonSources.getLanguage()) == null || this.compilers.get(languageKind) == null) continue;
            if (languages.contains(languageKind)) {
                MesonIntrospectionConverterKt.access$getLOG$p().error("Multiple source groups for a single language " + languageKind + " in target " + target.getName());
                continue;
            }
            languages.add(languageKind);
            List<String> switchesAdditionalCommand = MesonIntrospectionConverterKt.getCompilerSwitches(mesonSources.getCompilerCommand());
            ExternalLanguageConfigurationBuilder languageConfiguration = new ExternalLanguageConfigurationBuilder(languageKind).withCompilerKind(compilerInfo.getKind()).withCompilerExecutable(new File(compilerInfo.getPath())).withCompilerSwitches(CollectionsKt.plus((Collection)mesonSources.getParameters(), (Iterable)switchesAdditionalCommand));
            configuration.withLanguageConfiguration(languageConfiguration.invoke());
            this.debug("Parsed language configuration for target " + target.getName(), () -> MesonIntrospectionConverter.convert$lambda$10(languageConfiguration));
            for (String sourceFile : CollectionsKt.plus((Collection)mesonSources.getSourceFiles(), (Iterable)mesonSources.getGeneratedSourceFiles())) {
                File localFile = new File(this.environment.toLocalPath(this.buildDirectory.toFile(), sourceFile));
                ExternalFileConfigurationBuilder fileConfiguration = new ExternalFileConfigurationBuilder(localFile, languageKind);
                configuration.withFileConfiguration(fileConfiguration.invoke());
                this.debug("Parsed file configuration for target " + target.getName(), () -> MesonIntrospectionConverter.convert$lambda$11(fileConfiguration));
            }
        }
        return configuration;
    }

    private final MesonExternalProjectData.Target convertBuildTarget(MesonIntroTargets.Target target) {
        String string;
        MesonExternalProjectData.Target.Type targetType = MesonIntrospectionConverterKt.access$getTargetType(target.getType());
        if (targetType == MesonExternalProjectData.Target.Type.Executable) {
            String string2 = (String)CollectionsKt.firstOrNull(target.getOutputFiles());
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                string = this.environment.toLocalPath(it);
            } else {
                string = null;
            }
        } else {
            string = null;
        }
        String outputFile = string;
        String resolveConfigurationId = this.createConfigurationId(target);
        return new MesonExternalProjectData.Target(target.getName(), targetType, outputFile, resolveConfigurationId);
    }

    private final String createConfigurationId(MesonIntroTargets.Target target) {
        return ApplicationManager.getApplication().isUnitTestMode() ? target.getName() + "@" + target.getType().getType() : target.getId();
    }

    private final void debug(String message, Function0<? extends List<?>> lazyDebugValues) {
        if (!MesonIntrospectionConverterKt.access$getLOG$p().isDebugEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder("Profile '" + this.resolverContext.getProjectSettings().profile().getName() + "': ");
        sb.append(message);
        List debugValues = (List)lazyDebugValues.invoke();
        if (!((Collection)debugValues).isEmpty()) {
            sb.append(" (" + debugValues.size() + "):");
            Iterable $this$forEach$iv = debugValues;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                sb.append("\n  " + it);
            }
        }
        MesonIntrospectionConverterKt.access$getLOG$p().debug(sb.toString());
    }

    static /* synthetic */ void debug$default(MesonIntrospectionConverter mesonIntrospectionConverter, String string, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = MesonIntrospectionConverter::debug$lambda$13;
        }
        mesonIntrospectionConverter.debug(string, function0);
    }

    @TestOnly
    public final void testReadCompilersInfo$intellij_clion_meson(@NotNull MesonIntrospection introspection) {
        Intrinsics.checkNotNullParameter((Object)introspection, (String)"introspection");
        this.readCompilersInfo(introspection);
    }

    @TestOnly
    @NotNull
    public final Map<OCLanguageKind, CompilerInfo> getTestCompilers$intellij_clion_meson() {
        return this.compilers;
    }

    private static final List readCompilersInfo$lambda$1(OCLanguageKind $language, CompilerInfo $compilerInfo) {
        Object[] objectArray = new Object[]{$language, $compilerInfo};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final List readCompiler$lambda$5(MesonIntroLanguage $mesonLanguage, List $mesonCompilerCommand, MesonCompilerId $mesonCompilerId) {
        Object[] objectArray = new Object[]{$mesonLanguage, $mesonCompilerCommand, $mesonCompilerId};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final CompilerInfo readCompiler$lambda$6(List $mesonCompilerCommand, MesonIntrospectionConverter this$0, Map $executablesCache, MesonCompilerId $mesonCompilerId, OCLanguageKind it) {
        MesonCompilerId compilerKind;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($mesonCompilerCommand.isEmpty()) {
            MesonIntrospectionConverterKt.access$fail(this$0.resolverContext, MesonBundle.message("model.compiler.exe.empty.error", new Object[0]));
            throw new KotlinNothingValueException();
        }
        String compilerExecutable = this$0.resolveCompilerExecutable($mesonCompilerCommand, $executablesCache);
        MesonCompilerId mesonCompilerId = $mesonCompilerId;
        if (mesonCompilerId == null || (mesonCompilerId = MesonIntrospectionConverterKt.access$getOcCompilerKind(mesonCompilerId)) == null) {
            mesonCompilerId = (OCCompilerKind)UnknownCompilerKind.INSTANCE;
        }
        if ((compilerKind = mesonCompilerId) instanceof UnknownCompilerKind) {
            Project project = this$0.resolverContext.getProject();
            Path path = Path.of(compilerExecutable, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            compilerKind = OCCompilerResolver.Companion.resolve(project, path, (CidrToolEnvironment)this$0.environment);
            if (compilerKind instanceof UnknownCompilerKind) {
                Object[] objectArray = new Object[]{CollectionsKt.last((List)$mesonCompilerCommand)};
                MesonEventDataKt.warn(this$0.resolverContext, MesonBundle.message("converter.unknown.compiler.executable", objectArray));
            }
        }
        return new CompilerInfo((OCCompilerKind)compilerKind, compilerExecutable);
    }

    private static final CompilerInfo readCompiler$lambda$7(Function1 $tmp0, Object p0) {
        return (CompilerInfo)$tmp0.invoke(p0);
    }

    private static final String resolveCompilerExecutable$lambda$8(MesonIntrospectionConverter this$0, String $compilerExecutable, String it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            CPPEnvironment.ExecutablePathResult executablePathResult = this$0.environment.resolveEnvPathToLocalExecutable(this$0.buildDirectory, $compilerExecutable);
            Intrinsics.checkNotNullExpressionValue((Object)executablePathResult, (String)"resolveEnvPathToLocalExecutable(...)");
            CPPEnvironment.ExecutablePathResult resolveResult = executablePathResult;
            String string2 = resolveResult.path;
            if (string2 == null) {
                string2 = $compilerExecutable;
            }
            string = string2;
        }
        catch (Exception e) {
            string = $compilerExecutable;
        }
        return string;
    }

    private static final String resolveCompilerExecutable$lambda$9(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final List convert$lambda$10(ExternalLanguageConfigurationBuilder $languageConfiguration) {
        return CollectionsKt.listOf((Object)$languageConfiguration.invoke());
    }

    private static final List convert$lambda$11(ExternalFileConfigurationBuilder $fileConfiguration) {
        return CollectionsKt.listOf((Object)$fileConfiguration.invoke());
    }

    private static final List debug$lambda$13() {
        return CollectionsKt.emptyList();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/meson/project/resolver/MesonIntrospectionConverter$CompilerInfo;", "", "kind", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerKind;", "path", "", "<init>", "(Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerKind;Ljava/lang/String;)V", "getKind", "()Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerKind;", "getPath", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.clion.meson"})
    public static final class CompilerInfo {
        @NotNull
        private final OCCompilerKind kind;
        @NotNull
        private final String path;

        public CompilerInfo(@NotNull OCCompilerKind kind, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.kind = kind;
            this.path = path;
        }

        @NotNull
        public final OCCompilerKind getKind() {
            return this.kind;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final OCCompilerKind component1() {
            return this.kind;
        }

        @NotNull
        public final String component2() {
            return this.path;
        }

        @NotNull
        public final CompilerInfo copy(@NotNull OCCompilerKind kind, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new CompilerInfo(kind, path);
        }

        public static /* synthetic */ CompilerInfo copy$default(CompilerInfo compilerInfo, OCCompilerKind oCCompilerKind, String string, int n, Object object) {
            if ((n & 1) != 0) {
                oCCompilerKind = compilerInfo.kind;
            }
            if ((n & 2) != 0) {
                string = compilerInfo.path;
            }
            return compilerInfo.copy(oCCompilerKind, string);
        }

        @NotNull
        public String toString() {
            return "CompilerInfo(kind=" + this.kind + ", path=" + this.path + ")";
        }

        public int hashCode() {
            int result2 = this.kind.hashCode();
            result2 = result2 * 31 + this.path.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CompilerInfo)) {
                return false;
            }
            CompilerInfo compilerInfo = (CompilerInfo)other;
            if (!Intrinsics.areEqual((Object)this.kind, (Object)compilerInfo.kind)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.path, (Object)compilerInfo.path);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/meson/project/resolver/MesonIntrospectionConverter$Model;", "", "module", "Lcom/jetbrains/cidr/external/system/model/ExternalModule;", "targets", "", "Lcom/jetbrains/cidr/meson/project/MesonExternalProjectData$Target;", "<init>", "(Lcom/jetbrains/cidr/external/system/model/ExternalModule;Ljava/util/List;)V", "getModule", "()Lcom/jetbrains/cidr/external/system/model/ExternalModule;", "getTargets", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.clion.meson"})
    public static final class Model {
        @NotNull
        private final ExternalModule module;
        @NotNull
        private final List<MesonExternalProjectData.Target> targets;

        public Model(@NotNull ExternalModule module, @NotNull List<MesonExternalProjectData.Target> targets) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter(targets, (String)"targets");
            this.module = module;
            this.targets = targets;
        }

        @NotNull
        public final ExternalModule getModule() {
            return this.module;
        }

        @NotNull
        public final List<MesonExternalProjectData.Target> getTargets() {
            return this.targets;
        }

        @NotNull
        public final ExternalModule component1() {
            return this.module;
        }

        @NotNull
        public final List<MesonExternalProjectData.Target> component2() {
            return this.targets;
        }

        @NotNull
        public final Model copy(@NotNull ExternalModule module, @NotNull List<MesonExternalProjectData.Target> targets) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter(targets, (String)"targets");
            return new Model(module, targets);
        }

        public static /* synthetic */ Model copy$default(Model model, ExternalModule externalModule, List list, int n, Object object) {
            if ((n & 1) != 0) {
                externalModule = model.module;
            }
            if ((n & 2) != 0) {
                list = model.targets;
            }
            return model.copy(externalModule, list);
        }

        @NotNull
        public String toString() {
            return "Model(module=" + this.module + ", targets=" + this.targets + ")";
        }

        public int hashCode() {
            int result2 = this.module.hashCode();
            result2 = result2 * 31 + ((Object)this.targets).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Model)) {
                return false;
            }
            Model model = (Model)other;
            if (!Intrinsics.areEqual((Object)this.module, (Object)model.module)) {
                return false;
            }
            return Intrinsics.areEqual(this.targets, model.targets);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MesonProjectSettings.MesonProfile.CompilerInfoSelection.values().length];
            try {
                nArray[MesonProjectSettings.MesonProfile.CompilerInfoSelection.BUILD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MesonProjectSettings.MesonProfile.CompilerInfoSelection.HOST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MesonProjectSettings.MesonProfile.CompilerInfoSelection.AUTOMATICALLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

