/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.meson.psi.util;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.meson.psi.ArgumentList;
import com.jetbrains.cidr.meson.psi.KeywordArgument;
import com.jetbrains.cidr.meson.psi.MesonArgument;
import com.jetbrains.cidr.meson.psi.MesonExpression;
import com.jetbrains.cidr.meson.psi.MesonFunctionExpression;
import com.jetbrains.cidr.meson.psi.MesonMethodExpression;
import com.jetbrains.cidr.meson.psi.MesonStringLiteral;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0004\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001\u001a\n\u0010\t\u001a\u00020\n*\u00020\u000b\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\u000b\u00a8\u0006\r"}, d2={"unescapeMesonString", "", "text", "toUserString", "Lcom/jetbrains/cidr/meson/psi/MesonStringLiteral;", "getKeywordArgument", "Lcom/jetbrains/cidr/meson/psi/MesonExpression;", "Lcom/jetbrains/cidr/meson/psi/ArgumentList;", "key", "isMethod", "", "Lcom/jetbrains/cidr/meson/psi/MesonFunctionExpression;", "getFunctionName", "intellij.clion.meson"})
@SourceDebugExtension(value={"SMAP\nMesonPSIUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MesonPSIUtils.kt\ncom/jetbrains/cidr/meson/psi/util/MesonPSIUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n295#2,2:137\n*S KotlinDebug\n*F\n+ 1 MesonPSIUtils.kt\ncom/jetbrains/cidr/meson/psi/util/MesonPSIUtilsKt\n*L\n127#1:137,2\n*E\n"})
public final class MesonPSIUtilsKt {
    @NotNull
    public static final String unescapeMesonString(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (StringsKt.startsWith$default((String)text, (String)"'''", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)text, (String)"'''", (boolean)false, (int)2, null) && text.length() >= 6) {
            return ((Object)text.subSequence(3, text.length() - 3)).toString();
        }
        String string = StringUtil.unquoteString((String)text, (char)'\'');
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unquoteString(...)");
        String s = string;
        StringBuilder buffer = new StringBuilder();
        int length = s.length();
        int count = 0;
        int radix = 0;
        int suffixLen = 0;
        boolean decode = false;
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            switch (ch) {
                case '\'': {
                    StringBuilder stringBuilder = buffer.append('\'');
                    break;
                }
                case '\\': {
                    StringBuilder stringBuilder = buffer.append('\\');
                    break;
                }
                case 'a': {
                    StringBuilder stringBuilder = buffer.append('\u0007');
                    break;
                }
                case 'b': {
                    StringBuilder stringBuilder = buffer.append('\b');
                    break;
                }
                case 'f': {
                    StringBuilder stringBuilder = buffer.append('\f');
                    break;
                }
                case 'n': {
                    StringBuilder stringBuilder = buffer.append('\n');
                    break;
                }
                case 'r': {
                    StringBuilder stringBuilder = buffer.append('\r');
                    break;
                }
                case 't': {
                    StringBuilder stringBuilder = buffer.append('\t');
                    break;
                }
                case 'v': {
                    StringBuilder stringBuilder = buffer.append('\u000b');
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    count = 3;
                    radix = 8;
                    suffixLen = 0;
                    decode = true;
                    StringBuilder stringBuilder = Unit.INSTANCE;
                    break;
                }
                case 'x': {
                    count = 2;
                    radix = 16;
                    suffixLen = 1;
                    decode = true;
                    StringBuilder stringBuilder = Unit.INSTANCE;
                    break;
                }
                case 'u': {
                    count = 4;
                    radix = 16;
                    suffixLen = 1;
                    decode = true;
                    StringBuilder stringBuilder = Unit.INSTANCE;
                    break;
                }
                case 'U': {
                    count = 8;
                    radix = 16;
                    suffixLen = 1;
                    decode = true;
                    StringBuilder stringBuilder = Unit.INSTANCE;
                    break;
                }
                default: {
                    buffer.append('\\');
                    StringBuilder stringBuilder = buffer.append(ch);
                }
            }
            if (decode) {
                decode = false;
                boolean arbitraryLength = count == -1;
                StringBuilder sb = new StringBuilder(arbitraryLength ? 8 : count);
                for (int pos = idx + suffixLen; pos < length && (arbitraryLength || count > 0); ++pos) {
                    char chl = s.charAt(pos);
                    if (!(radix == 16 && StringUtil.isHexDigit((char)chl) || radix == 8 && StringUtil.isOctalDigit((char)chl))) break;
                    sb.append(chl);
                    if (arbitraryLength) continue;
                    --count;
                }
                if (sb.length() != 0) {
                    try {
                        StringBuilder stringBuilder;
                        String string2 = sb.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                        int code = Integer.parseInt(string2, CharsKt.checkRadix((int)radix));
                        if (Character.isValidCodePoint(code)) {
                            idx += sb.length() + suffixLen - 1;
                            stringBuilder = buffer.append(Character.toChars(code));
                        } else {
                            stringBuilder = buffer.append('\\').append(ch);
                        }
                        StringBuilder stringBuilder2 = stringBuilder;
                    }
                    catch (NumberFormatException e) {
                        StringBuilder stringBuilder = buffer.append('\\').append(ch);
                    }
                } else {
                    buffer.append('\\').append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
        String string3 = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    @NotNull
    public static final String toUserString(@NotNull MesonStringLiteral $this$toUserString) {
        Intrinsics.checkNotNullParameter((Object)$this$toUserString, (String)"<this>");
        String string = $this$toUserString.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return MesonPSIUtilsKt.unescapeMesonString(string);
    }

    @Nullable
    public static final MesonExpression getKeywordArgument(@NotNull ArgumentList $this$getKeywordArgument, @NotNull String key) {
        Object v2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$getKeywordArgument, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            List<MesonArgument> list = $this$getKeywordArgument.getMesonArgumentList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getMesonArgumentList(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MesonArgument it = (MesonArgument)element$iv;
                boolean bl = false;
                KeywordArgument keywordArgument = it instanceof KeywordArgument ? (KeywordArgument)it : null;
                if (!Intrinsics.areEqual((Object)(keywordArgument != null && (keywordArgument = keywordArgument.getKeyIdentifier()) != null ? keywordArgument.getText() : null), (Object)key)) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        Object var3_8 = v2;
        KeywordArgument keywordArgument = var3_8 instanceof KeywordArgument ? (KeywordArgument)var3_8 : null;
        return keywordArgument != null ? keywordArgument.getMesonExpression() : null;
    }

    public static final boolean isMethod(@NotNull MesonFunctionExpression $this$isMethod) {
        Intrinsics.checkNotNullParameter((Object)$this$isMethod, (String)"<this>");
        return $this$isMethod.getParent() instanceof MesonMethodExpression;
    }

    @NotNull
    public static final String getFunctionName(@NotNull MesonFunctionExpression $this$getFunctionName) {
        Intrinsics.checkNotNullParameter((Object)$this$getFunctionName, (String)"<this>");
        String string = $this$getFunctionName.getFunctionIdentifier().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }
}

