/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.meson.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.jetbrains.cidr.meson.bundle.MesonBundle;
import com.jetbrains.cidr.meson.settings.MesonProjectSettings;
import com.jetbrains.cidr.meson.settings.MesonSettings;
import com.jetbrains.cidr.meson.settings.MesonSettingsListener;
import com.jetbrains.cidr.meson.settings.MesonToolchainsListener;
import com.jetbrains.cidr.meson.ui.MesonProfileConfigurable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/cidr/meson/ui/MesonConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectSettings", "Lcom/jetbrains/cidr/meson/settings/MesonProjectSettings;", "profileConfigurable", "Lcom/jetbrains/cidr/meson/ui/MesonProfileConfigurable;", "createComponent", "Ljavax/swing/JComponent;", "isModified", "", "reset", "", "apply", "disposeUIResources", "getDisplayName", "", "getId", "getHelpTopic", "intellij.clion.meson"})
@SourceDebugExtension(value={"SMAP\nMesonConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MesonConfigurable.kt\ncom/jetbrains/cidr/meson/ui/MesonConfigurable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n774#2:80\n865#2,2:81\n1#3:83\n*S KotlinDebug\n*F\n+ 1 MesonConfigurable.kt\ncom/jetbrains/cidr/meson/ui/MesonConfigurable\n*L\n53#1:80\n53#1:81,2\n*E\n"})
public final class MesonConfigurable
implements SearchableConfigurable {
    @NotNull
    private final Project project;
    @Nullable
    private MesonProjectSettings projectSettings;
    @Nullable
    private MesonProfileConfigurable profileConfigurable;

    public MesonConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        MesonSettings mesonSettings = MesonSettings.Companion.getInstance(this.project);
        Collection collection = mesonSettings.getLinkedProjectsSettings();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getLinkedProjectsSettings(...)");
        MesonProjectSettings mesonProjectSettings = (MesonProjectSettings)((Object)CollectionsKt.firstOrNull((Iterable)collection));
        MesonProjectSettings mesonProjectSettings2 = this.projectSettings = mesonProjectSettings != null ? mesonProjectSettings.clone() : null;
        if (this.projectSettings != null) {
            MesonProjectSettings mesonProjectSettings3 = this.projectSettings;
            Intrinsics.checkNotNull((Object)((Object)mesonProjectSettings3));
            this.profileConfigurable = new MesonProfileConfigurable(mesonProjectSettings3.profile(), this.project);
        } else {
            this.profileConfigurable = null;
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public JComponent createComponent() {
        MesonToolchainsListener.Companion.pauseListener();
        Object object = this.profileConfigurable;
        if (object == null || (object = object.createComponent()) == null) {
            JBPanelWithEmptyText jBPanelWithEmptyText = new JBPanelWithEmptyText().withEmptyText(MesonBundle.message("settings.global.configurable.empty.text", new Object[0]));
            Intrinsics.checkNotNullExpressionValue((Object)jBPanelWithEmptyText, (String)"withEmptyText(...)");
            object = (JComponent)jBPanelWithEmptyText;
        }
        return object;
    }

    public boolean isModified() {
        MesonProfileConfigurable mesonProfileConfigurable = this.profileConfigurable;
        return mesonProfileConfigurable != null ? mesonProfileConfigurable.isModified() : false;
    }

    public void reset() {
        block0: {
            MesonProfileConfigurable mesonProfileConfigurable = this.profileConfigurable;
            if (mesonProfileConfigurable == null) break block0;
            mesonProfileConfigurable.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void apply() {
        void $this$filterTo$iv$iv;
        MesonProfileConfigurable profileConfigurable = this.profileConfigurable;
        MesonProjectSettings projectSettings = null;
        projectSettings = this.projectSettings;
        if (projectSettings == null || profileConfigurable == null) {
            return;
        }
        profileConfigurable.apply();
        this.projectSettings = projectSettings = projectSettings.clone(CollectionsKt.listOf((Object)profileConfigurable.getProfile()));
        MesonSettings systemSettings = MesonSettings.Companion.getInstance(this.project);
        Collection collection = systemSettings.getLinkedProjectsSettings();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getLinkedProjectsSettings(...)");
        Collection oldProjectSettingsList = collection;
        Iterable $this$filter$iv = oldProjectSettingsList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MesonProjectSettings it = (MesonProjectSettings)((Object)element$iv$iv);
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getExternalProjectPath(), (Object)projectSettings.getExternalProjectPath()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List newProjectSettingsList = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)((Object)projectSettings));
        ExternalSystemSettingsListener externalSystemSettingsListener = systemSettings.getPublisher();
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemSettingsListener, (String)"getPublisher(...)");
        MesonSettingsListener publisher = (MesonSettingsListener)externalSystemSettingsListener;
        publisher.onBulkChangeStart();
        try {
            systemSettings.setLinkedProjectsSettings(newProjectSettingsList);
        }
        finally {
            publisher.onBulkChangeEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeUIResources() {
        try {
            MesonProfileConfigurable mesonProfileConfigurable = this.profileConfigurable;
            if (mesonProfileConfigurable != null) {
                MesonProfileConfigurable it = mesonProfileConfigurable;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
        }
        finally {
            MesonToolchainsListener.Companion.unpauseListener();
        }
    }

    @NotNull
    public String getDisplayName() {
        return MesonBundle.message("meson", new Object[0]);
    }

    @NotNull
    public String getId() {
        return "MesonSettings";
    }

    @NotNull
    public String getHelpTopic() {
        return "reference.build.meson";
    }
}

