/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.coverage;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.coverage.CMakeCoverageRunner;
import com.jetbrains.cidr.execution.coverage.CidrCoverageDataFileProvider;
import com.jetbrains.cidr.execution.coverage.CidrCoverageUtil;
import com.jetbrains.cidr.execution.coverage.gcov.GCovUtils;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/cpp/execution/coverage/CMakeGCovCoverageDataFileProvider;", "Lcom/jetbrains/cidr/execution/coverage/CidrCoverageDataFileProvider;", "<init>", "()V", "isAvailable", "", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "coverageRunnerId", "", "getLocalCoverageDataPath", "isCoverageDataExist", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "deleteCoverageData", "", "intellij.clion.coverage"})
public final class CMakeGCovCoverageDataFileProvider
extends CidrCoverageDataFileProvider {
    public boolean isAvailable(@NotNull RunConfiguration configuration, @NotNull String coverageRunnerId) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)coverageRunnerId, (String)"coverageRunnerId");
        return configuration instanceof CMakeAppRunConfiguration && (Intrinsics.areEqual((Object)coverageRunnerId, (Object)"gcov") || Intrinsics.areEqual((Object)coverageRunnerId, (Object)CMakeCoverageRunner.Companion.getID()));
    }

    @Nullable
    public String getLocalCoverageDataPath(@NotNull RunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        CMakeAppRunConfiguration.BuildAndRunConfigurations buildAndRunConfigurations = CMakeAppRunConfiguration.getSelectedBuildAndRunConfigurations((Project)configuration.getProject());
        Object runConfiguration = buildAndRunConfigurations != null ? buildAndRunConfigurations.getRunConfiguration() : null;
        Object object = runConfiguration;
        return object != null && (object = object.getConfigurationGenerationDir()) != null ? ((File)object).getAbsolutePath() : null;
    }

    public boolean isCoverageDataExist(@NotNull RunConfiguration configuration, @NotNull CidrToolEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        HostMachine host = environment.getHostMachine();
        String string = this.getLocalCoverageDataPath(configuration);
        if (string != null) {
            String localDir = string;
            boolean bl = false;
            Path path = host.getPath(localDir, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
            Path dirPath = path;
            Intrinsics.checkNotNull((Object)host);
            return CollectionsKt.any((Iterable)GCovUtils.Companion.getGCovOrGCDAFiles(host, dirPath, true));
        }
        return false;
    }

    public void deleteCoverageData(@NotNull RunConfiguration configuration, @NotNull CidrToolEnvironment environment) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            String string = this.getLocalCoverageDataPath(configuration);
            if (string == null) break block0;
            String localDir = string;
            boolean bl = false;
            Path path = environment.getHostMachine().getPath(localDir, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
            Path dirPath = path;
            HostMachine hostMachine = environment.getHostMachine();
            Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"getHostMachine(...)");
            String[] stringArray = new String[]{".gcov", ".gcda"};
            CidrCoverageUtil.Companion.deleteFilesWithExtensionsInBatchMode(hostMachine, dirPath, true, stringArray);
        }
    }
}

