/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system.remote.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.remote.RemoteCredentials;
import com.intellij.util.AsyncProducer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.system.RemoteUtil;
import com.jetbrains.cidr.system.remote.CredentialsDeployable;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.ServerBrowserDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteBrowseActionListener
implements ActionListener {
    @NlsContexts.DialogTitle
    @NotNull
    private final String myTitle;
    @NotNull
    private final JComponent myComponent;
    @NotNull
    private final TextComponentAccessor myAccessor;
    @NotNull
    private final AsyncProducer<RemoteCredentials> mySdkDataProducer;
    @Nullable
    private final Consumer<String> myPathConsumer;

    public RemoteBrowseActionListener(@NotNull JComponent component, @NotNull TextComponentAccessor accessor, @NlsContexts.DialogTitle @NotNull String title, @NotNull AsyncProducer<RemoteCredentials> sdkDataProducer, @Nullable Consumer<String> pathConsumer) {
        if (component == null) {
            RemoteBrowseActionListener.$$$reportNull$$$0(0);
        }
        if (accessor == null) {
            RemoteBrowseActionListener.$$$reportNull$$$0(1);
        }
        if (title == null) {
            RemoteBrowseActionListener.$$$reportNull$$$0(2);
        }
        if (sdkDataProducer == null) {
            RemoteBrowseActionListener.$$$reportNull$$$0(3);
        }
        this.myComponent = component;
        this.myAccessor = accessor;
        this.myTitle = title;
        this.mySdkDataProducer = sdkDataProducer;
        this.myPathConsumer = pathConsumer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.mySdkDataProducer.produce(credentials -> {
            if (RemoteUtil.checkConnection((RemoteCredentials)credentials)) {
                UIUtil.invokeLaterIfNeeded(() -> {
                    WebServerConfig.RemotePath path;
                    ServerBrowserDialog d = RemoteBrowseActionListener.showBrowseRemoteDialog(this.myTitle, this.myComponent, this.myAccessor, false, (Deployable)RemoteBrowseActionListener.createDeployable(credentials));
                    if (d.isOK() && (path = d.getPath()) != null) {
                        String remotePath = path.path;
                        this.myAccessor.setText((Component)this.myComponent, remotePath);
                        if (this.myPathConsumer != null) {
                            this.myPathConsumer.accept(remotePath);
                        }
                    }
                });
            }
        });
    }

    public static void addBrowseRemoteHostAction(@NlsContexts.DialogTitle @NotNull String title, @NotNull ComponentWithBrowseButton browsableComponent, @NotNull JComponent textComponent, @NotNull TextComponentAccessor accessor, @NotNull AsyncProducer<RemoteCredentials> producer, @Nullable Consumer<String> pathConsumer) {
        if (title == null) {
            RemoteBrowseActionListener.$$$reportNull$$$0(4);
        }
        if (browsableComponent == null) {
            RemoteBrowseActionListener.$$$reportNull$$$0(5);
        }
        if (textComponent == null) {
            RemoteBrowseActionListener.$$$reportNull$$$0(6);
        }
        if (accessor == null) {
            RemoteBrowseActionListener.$$$reportNull$$$0(7);
        }
        if (producer == null) {
            RemoteBrowseActionListener.$$$reportNull$$$0(8);
        }
        browsableComponent.addActionListener((ActionListener)new RemoteBrowseActionListener(textComponent, accessor, title, producer, pathConsumer));
    }

    private static ServerBrowserDialog showBrowseRemoteDialog(@NlsContexts.DialogTitle @NotNull String title, @NotNull JComponent component, @NotNull TextComponentAccessor accessor, boolean foldersOnly, @NotNull Deployable deployable) {
        if (title == null) {
            RemoteBrowseActionListener.$$$reportNull$$$0(9);
        }
        if (component == null) {
            RemoteBrowseActionListener.$$$reportNull$$$0(10);
        }
        if (accessor == null) {
            RemoteBrowseActionListener.$$$reportNull$$$0(11);
        }
        if (deployable == null) {
            RemoteBrowseActionListener.$$$reportNull$$$0(12);
        }
        WebServerConfig.RemotePath initialPath = new WebServerConfig.RemotePath(accessor.getText((Component)component));
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)component));
        ServerBrowserDialog d = project != null ? new ServerBrowserDialog(project, deployable, title, foldersOnly, FileTransferConfig.Origin.Default, initialPath) : new ServerBrowserDialog((Component)component, deployable, title, foldersOnly, FileTransferConfig.Origin.Default, initialPath);
        d.show();
        return d;
    }

    private static CredentialsDeployable createDeployable(@NotNull RemoteCredentials cre) {
        if (cre == null) {
            RemoteBrowseActionListener.$$$reportNull$$$0(13);
        }
        CredentialsDeployable config = new CredentialsDeployable(cre);
        config.setName("Remote host");
        return config;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkDataProducer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browsableComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cre";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/system/remote/ui/RemoteBrowseActionListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addBrowseRemoteHostAction";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "showBrowseRemoteDialog";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "createDeployable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

