/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class FormatterTestCase
extends LightPlatformTestCase {
    protected boolean doReformatRangeTest;
    protected TextRange myTextRange;
    protected EditorImpl myEditor;
    protected PsiFile myFile;
    private final Disposable myBeforeParentDisposeDisposable = Disposer.newDisposable();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        FormatterTestCase.assertFalse((boolean)CodeStyle.usesOwnSettings((Project)this.getProject()));
    }

    protected void doTest(String resultNumber) throws Exception {
        this.doTestForResult(this.getTestName(true), resultNumber);
    }

    protected void doTest() throws Exception {
        this.doTest(null);
    }

    private void doTestForResult(String testName, String resultNumber) throws Exception {
        this.doTest(testName + "." + this.getFileExtension(), testName + "_after." + this.getFileExtension(), resultNumber);
    }

    protected void doTest(String fileNameBefore, String fileNameAfter, String resultNumber) throws Exception {
        this.doTextTest(this.loadFile(fileNameBefore, null), this.loadFile(fileNameAfter, resultNumber));
    }

    protected final void doTest(@NonNls String fileNameBefore, @NonNls String fileNameAfter) throws Exception {
        this.doTextTest(this.loadFile(fileNameBefore + "." + this.getFileExtension(), null), this.loadFile(fileNameAfter + "." + this.getFileExtension(), null));
    }

    protected void doTextTest(String text2, String textAfter) {
        String fileName = "before." + this.getFileExtension();
        PsiFile file = this.createFileFromText(text2, fileName, PsiFileFactory.getInstance((Project)this.getProject()));
        this.checkDocument(file, text2, textAfter);
    }

    protected PsiFile createFileFromText(String text2, String fileName, PsiFileFactory fileFactory) {
        return fileFactory.createFileFromText(fileName, this.getFileType(fileName), (CharSequence)text2, LocalTimeCounter.currentTime(), true, false);
    }

    protected FileType getFileType(String fileName) {
        return FileTypeManager.getInstance().getFileTypeByFileName(fileName);
    }

    @Override
    @NotNull
    public final Disposable getTestRootDisposable() {
        Disposable disposable = this.myBeforeParentDisposeDisposable;
        if (disposable == null) {
            FormatterTestCase.$$$reportNull$$$0(0);
        }
        return disposable;
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            if (this.myFile != null) {
                ((UndoManagerImpl)UndoManager.getInstance((Project)this.getProject())).clearUndoRedoQueueInTests(this.myFile.getVirtualFile());
                FileEditorManager.getInstance((Project)this.getProject()).closeFile(this.myFile.getVirtualFile());
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        this.myEditor = null;
        this.myFile = null;
        try {
            Disposer.dispose((Disposable)this.myBeforeParentDisposeDisposable);
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected boolean doCheckDocumentUpdate() {
        return false;
    }

    protected void checkDocument(PsiFile file, String text2, String textAfter) {
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file);
        assert (document != null);
        if (this.doCheckDocumentUpdate()) {
            EditorImpl editor2 = (EditorImpl)FileEditorManager.getInstance((Project)this.getProject()).openTextEditor(new OpenFileDescriptor(this.getProject(), file.getVirtualFile(), 0), false);
            assert (editor2 != null);
            if (this.myFile != null) {
                FileEditorManager.getInstance((Project)this.getProject()).closeFile(this.myFile.getVirtualFile());
            }
            this.myEditor = editor2;
            this.myFile = file;
        }
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> {
            document.replaceString(0, document.getTextLength(), (CharSequence)text2);
            PsiDocumentManager.getInstance((Project)this.getProject()).commitDocument(document);
            FormatterTestCase.assertEquals((String)file.getText(), (String)document.getText());
            try {
                if (this.doReformatRangeTest) {
                    CodeStyleManager.getInstance((Project)this.getProject()).reformatRange((PsiElement)file, file.getTextRange().getStartOffset(), file.getTextRange().getEndOffset());
                } else if (this.myTextRange != null) {
                    CodeStyleManager.getInstance((Project)this.getProject()).reformatText(file, this.myTextRange.getStartOffset(), this.myTextRange.getEndOffset());
                } else {
                    CodeStyleManager.getInstance((Project)this.getProject()).reformatText(file, file.getTextRange().getStartOffset(), file.getTextRange().getEndOffset());
                }
            }
            catch (IncorrectOperationException e) {
                FormatterTestCase.fail();
            }
        });
        FormatterTestCase.assertEquals((String)textAfter, (String)document.getText());
        PsiDocumentManager.getInstance((Project)this.getProject()).commitDocument(document);
        FormatterTestCase.assertEquals((String)textAfter, (String)file.getText());
    }

    protected void performFormatting(PsiFile file) {
        try {
            if (this.myTextRange == null) {
                CodeStyleManager.getInstance((Project)this.getProject()).reformat((PsiElement)file);
            } else {
                CodeStyleManager.getInstance((Project)this.getProject()).reformatRange((PsiElement)file, this.myTextRange.getStartOffset(), this.myTextRange.getEndOffset());
            }
        }
        catch (IncorrectOperationException e) {
            FormatterTestCase.fail();
        }
    }

    protected void performFormattingWithDocument(PsiFile file) {
        try {
            if (this.myTextRange == null) {
                CodeStyleManager.getInstance((Project)this.getProject()).reformatText(file, 0, file.getTextLength());
            } else {
                CodeStyleManager.getInstance((Project)this.getProject()).reformatText(file, this.myTextRange.getStartOffset(), this.myTextRange.getEndOffset());
            }
        }
        catch (IncorrectOperationException e) {
            FormatterTestCase.fail();
        }
    }

    protected String loadFile(String name, String resultNumber) throws Exception {
        String fullName = this.getTestDataPath() + File.separatorChar + this.getBasePath() + File.separatorChar + name;
        String text2 = FileUtil.loadFile((File)new File(fullName));
        text2 = StringUtil.convertLineSeparators((String)text2);
        if (resultNumber == null) {
            return this.prepareText(text2);
        }
        String beginLine = "<<<" + resultNumber + ">>>";
        String endLine = "<<</" + resultNumber + ">>>";
        int beginPos = text2.indexOf(beginLine);
        FormatterTestCase.assertTrue((beginPos >= 0 ? 1 : 0) != 0);
        int endPos = text2.indexOf(endLine);
        FormatterTestCase.assertTrue((endPos >= 0 ? 1 : 0) != 0);
        return this.prepareText(text2.substring(beginPos + beginLine.length(), endPos).trim());
    }

    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath();
    }

    protected String prepareText(String text2) {
        return text2;
    }

    protected abstract String getBasePath();

    protected abstract String getFileExtension();

    protected CommonCodeStyleSettings getSettings(Language language) {
        return CodeStyle.getSettings((Project)this.getProject()).getCommonSettings(language);
    }

    protected CodeStyleSettings getSettings() {
        return CodeStyle.getSettings((Project)this.getProject());
    }

    protected void doSanityTest(boolean formatWithPsi) throws IOException, IncorrectOperationException {
        File sanityDirectory = new File(this.getTestDataPath() + File.separatorChar + this.getBasePath(), "sanity");
        File[] subFiles = sanityDirectory.listFiles();
        ArrayList failedFiles = new ArrayList();
        if (subFiles != null) {
            for (File subFile : subFiles) {
                this.doSanityTestForFile(subFile, failedFiles, formatWithPsi);
            }
            if (!failedFiles.isEmpty()) {
                FormatterTestCase.fail((String)("Failed for files: " + FormatterTestCase.composeMessage(failedFiles)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSanityTestForFile(File subFile, List<? super File> failedFiles, boolean formatWithPsi) throws IOException, IncorrectOperationException {
        if (subFile.isFile() && subFile.getName().endsWith(this.getFileExtension())) {
            byte[] bytes = FileUtil.loadFileBytes((File)subFile);
            String text2 = new String(bytes, Charsets.UTF_8);
            String fileName = "before." + this.getFileExtension();
            PsiFile file = PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText(fileName, this.getFileType(fileName), (CharSequence)StringUtil.convertLineSeparators((String)text2), LocalTimeCounter.currentTime(), true);
            try {
                CommandProcessor.getInstance().executeCommand(this.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> {
                    try {
                        if (formatWithPsi) {
                            this.performFormatting(file);
                        } else {
                            this.performFormattingWithDocument(file);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        failedFiles.add(subFile);
                    }
                    System.out.println(subFile.getPath() + ": finished");
                }), "", null);
            }
            finally {
                VirtualFile virtualFile = file.getVirtualFile();
                if (virtualFile != null) {
                    ((UndoManagerImpl)UndoManager.getInstance((Project)this.getProject())).clearUndoRedoQueueInTests(virtualFile);
                    ((UndoManagerImpl)UndoManager.getGlobalInstance()).clearUndoRedoQueueInTests(virtualFile);
                }
            }
        }
    }

    private static String composeMessage(List<? extends File> failedFiles) {
        StringBuilder result = new StringBuilder();
        for (File file : failedFiles) {
            result.append(file.getPath());
            result.append("\n");
        }
        return result.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/FormatterTestCase", "getTestRootDisposable"));
    }
}

