/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.inlays;

import com.intellij.codeInsight.daemon.impl.HintRenderer;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.platform.testFramework.core.FileComparisonFailedError;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.utils.inlays.CaretAndInlaysInfo;
import com.intellij.testFramework.utils.inlays.InlayInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.ComparisonFailure;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\u0013\u001a\u00020\u0007J6\u0010\u0014\u001a\u00020\u00072\u0016\u0010\r\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0016\u0010\u0011\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0004\u0012\u00020\u00120\u000eJ\u0016\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010JH\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00102\u0016\u0010\r\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0016\u0010\u0011\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0004\u0012\u00020\u00120\u000eH\u0002J>\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0016\u0010\r\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0016\u0010\u0011\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0004\u0012\u00020\u00120\u000eH\u0002J\u000e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eJ \u0010\u001f\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0004\u0012\u00020\u00120\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsChecker;", "", "myFixture", "Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;", "<init>", "(Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;)V", "setUp", "", "tearDown", "manager", "Lcom/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager;", "getManager", "()Lcom/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager;", "inlayPresenter", "Lkotlin/Function1;", "Lcom/intellij/openapi/editor/Inlay;", "", "inlayFilter", "", "checkParameterHints", "checkInlays", "verifyInlaysAndCaretInfo", "expectedInlaysAndCaret", "Lcom/intellij/testFramework/utils/inlays/CaretAndInlaysInfo;", "originalText", "getActualInlays", "", "Lcom/intellij/testFramework/utils/inlays/InlayInfo;", "extractInlaysAndCaretInfo", "document", "Lcom/intellij/openapi/editor/Document;", "removeText", "realStartOffset", "", "matchedLength", "Companion", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nInlayParameterHintsTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlayParameterHintsTest.kt\ncom/intellij/testFramework/utils/inlays/InlayHintsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,183:1\n1761#2,3:184\n1869#2,2:187\n360#2,7:189\n1869#2,2:196\n774#2:198\n865#2,2:199\n1563#2:201\n1634#2,3:202\n1056#2:205\n967#2,7:206\n1869#2,2:213\n*S KotlinDebug\n*F\n+ 1 InlayParameterHintsTest.kt\ncom/intellij/testFramework/utils/inlays/InlayHintsChecker\n*L\n67#1:184,3\n69#1:187,2\n81#1:189,7\n87#1:196,2\n118#1:198\n118#1:199,2\n119#1:201\n119#1:202,3\n131#1:205\n154#1:206,7\n155#1:213,2\n*E\n"})
public final class InlayHintsChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CodeInsightTestFixture myFixture;
    @NotNull
    private final ParameterHintsPresentationManager manager;
    @NotNull
    private final Function1<Inlay<?>, String> inlayPresenter;
    @NotNull
    private final Function1<Inlay<?>, Boolean> inlayFilter;
    @NotNull
    private static final Pattern pattern;
    @NotNull
    private static final ParameterNameHintsSettings default;

    public InlayHintsChecker(@NotNull CodeInsightTestFixture myFixture) {
        Intrinsics.checkNotNullParameter((Object)myFixture, (String)"myFixture");
        this.myFixture = myFixture;
        ParameterHintsPresentationManager parameterHintsPresentationManager = ParameterHintsPresentationManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)parameterHintsPresentationManager, (String)"getInstance(...)");
        this.manager = parameterHintsPresentationManager;
        this.inlayPresenter = InlayHintsChecker::inlayPresenter$lambda$0;
        this.inlayFilter = arg_0 -> InlayHintsChecker.inlayFilter$lambda$1(this, arg_0);
    }

    public final void setUp() {
    }

    public final void tearDown() {
        ParameterNameHintsSettings hintSettings = ParameterNameHintsSettings.Companion.getInstance();
        hintSettings.loadState(default.getState());
    }

    @NotNull
    public final ParameterHintsPresentationManager getManager() {
        return this.manager;
    }

    public final void checkParameterHints() {
        this.checkInlays(this.inlayPresenter, this.inlayFilter);
    }

    public final void checkInlays(@NotNull Function1<? super Inlay<?>, String> inlayPresenter, @NotNull Function1<? super Inlay<?>, Boolean> inlayFilter) {
        Intrinsics.checkNotNullParameter(inlayPresenter, (String)"inlayPresenter");
        Intrinsics.checkNotNullParameter(inlayFilter, (String)"inlayFilter");
        PsiFile psiFile = this.myFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile file = psiFile;
        Document document = this.myFixture.getDocument(file);
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String originalText = string;
        Intrinsics.checkNotNull((Object)document);
        CaretAndInlaysInfo expectedInlaysAndCaret = this.extractInlaysAndCaretInfo(document);
        this.myFixture.doHighlighting();
        this.verifyInlaysAndCaretInfo(expectedInlaysAndCaret, originalText, inlayPresenter, inlayFilter);
    }

    public final void verifyInlaysAndCaretInfo(@NotNull CaretAndInlaysInfo expectedInlaysAndCaret, @NotNull String originalText) {
        Intrinsics.checkNotNullParameter((Object)expectedInlaysAndCaret, (String)"expectedInlaysAndCaret");
        Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
        this.verifyInlaysAndCaretInfo(expectedInlaysAndCaret, originalText, this.inlayPresenter, this.inlayFilter);
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyInlaysAndCaretInfo(CaretAndInlaysInfo expectedInlaysAndCaret, String originalText, Function1<? super Inlay<?>, String> inlayPresenter, Function1<? super Inlay<?>, Boolean> inlayFilter) {
        block17: {
            List<InlayInfo> actual;
            Document document;
            PsiFile file;
            block16: {
                boolean bl;
                block14: {
                    PsiFile psiFile = this.myFixture.getFile();
                    Intrinsics.checkNotNull((Object)psiFile);
                    file = psiFile;
                    document = this.myFixture.getDocument(file);
                    actual = this.getActualInlays(inlayPresenter, inlayFilter);
                    List<InlayInfo> expected = expectedInlaysAndCaret.getInlays();
                    if (expectedInlaysAndCaret.getInlays().size() != actual.size()) break block16;
                    Iterable $this$any$iv = CollectionsKt.zip((Iterable)actual, (Iterable)expected);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Iterator element$iv : $this$any$iv) {
                            Pair it = (Pair)element$iv;
                            boolean bl2 = false;
                            if (!(!Intrinsics.areEqual((Object)it.getFirst(), (Object)it.getSecond()))) continue;
                            bl = true;
                            break block14;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block17;
            }
            List entries = new ArrayList();
            Iterable $this$forEach$iv = actual;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$verifyInlaysAndCaretInfo_u24lambda_u244_u24lambda_u243;
                InlayInfo it = (InlayInfo)element$iv;
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder stringBuilder2 = stringBuilder;
                Integer n = it.getOffset();
                List list = entries;
                boolean bl3 = false;
                $this$verifyInlaysAndCaretInfo_u24lambda_u244_u24lambda_u243.append("<");
                $this$verifyInlaysAndCaretInfo_u24lambda_u244_u24lambda_u243.append(it.getHighlighted() ? "H" : "h");
                $this$verifyInlaysAndCaretInfo_u24lambda_u244_u24lambda_u243.append(it.getCurrent() ? "INT" : "int");
                $this$verifyInlaysAndCaretInfo_u24lambda_u244_u24lambda_u243.append(" text=\"");
                $this$verifyInlaysAndCaretInfo_u24lambda_u244_u24lambda_u243.append(it.getText());
                $this$verifyInlaysAndCaretInfo_u24lambda_u244_u24lambda_u243.append("\"/>");
                Unit unit = Unit.INSTANCE;
                String string = stringBuilder.toString();
                Integer n2 = n;
                list.add(new Pair((Object)n2, (Object)string));
            }
            if (expectedInlaysAndCaret.getCaretOffset() != null) {
                int n;
                int actualInlaysBeforeCaret;
                int actualCaretOffset;
                block15: {
                    actualCaretOffset = this.myFixture.getEditor().getCaretModel().getOffset();
                    actualInlaysBeforeCaret = this.myFixture.getEditor().getCaretModel().getVisualPosition().column - this.myFixture.getEditor().offsetToVisualPosition((int)actualCaretOffset).column;
                    List $this$indexOfFirst$iv = entries;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$indexOfFirst$iv) {
                        Pair it = (Pair)item$iv;
                        boolean bl = false;
                        if (((Number)it.getFirst()).intValue() == actualCaretOffset) {
                            n = index$iv;
                            break block15;
                        }
                        ++index$iv;
                    }
                    n = -1;
                }
                int first = n;
                int insertIndex = first == -1 ? -CollectionsKt.binarySearch$default((List)entries, (int)0, (int)0, arg_0 -> InlayHintsChecker.verifyInlaysAndCaretInfo$lambda$6(actualCaretOffset, arg_0), (int)3, null) - 1 : first + actualInlaysBeforeCaret;
                entries.add(insertIndex, new Pair((Object)actualCaretOffset, (Object)"<caret>"));
            }
            StringBuilder proposedText = new StringBuilder(document.getText());
            Iterable $this$forEach$iv2 = CollectionsKt.asReversedMutable((List)entries);
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                proposedText.insert(((Number)it.getFirst()).intValue(), (String)it.getSecond());
            }
            String string = (String)VfsTestUtil.TEST_DATA_FILE_PATH.get((UserDataHolder)file.getVirtualFile());
            if (string != null) {
                String originalPath = string;
                boolean bl = false;
                String string2 = proposedText.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                throw new FileComparisonFailedError("Hints differ", originalText, string2, originalPath, null, 16, null);
            }
            throw new ComparisonFailure("Hints differ", originalText, proposedText.toString());
        }
        if (expectedInlaysAndCaret.getCaretOffset() != null) {
            Assert.assertEquals((String)"Unexpected caret offset", (Object)expectedInlaysAndCaret.getCaretOffset(), (Object)this.myFixture.getEditor().getCaretModel().getOffset());
            VisualPosition visualPosition = this.myFixture.getEditor().offsetToVisualPosition(expectedInlaysAndCaret.getCaretOffset().intValue());
            Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"offsetToVisualPosition(...)");
            VisualPosition position = visualPosition;
            Assert.assertEquals((String)"Unexpected caret visual position", (Object)new VisualPosition(position.line, position.column + expectedInlaysAndCaret.getInlaysBeforeCaret()), (Object)this.myFixture.getEditor().getCaretModel().getVisualPosition());
            SelectionModel selectionModel = this.myFixture.getEditor().getSelectionModel();
            Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
            SelectionModel selectionModel2 = selectionModel;
            if (expectedInlaysAndCaret.getSelection() == null) {
                Assert.assertFalse((boolean)selectionModel2.hasSelection());
            } else {
                Assert.assertEquals((String)"Unexpected selection", (Object)expectedInlaysAndCaret.getSelection(), (Object)new TextRange(selectionModel2.getSelectionStart(), selectionModel2.getSelectionEnd()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<InlayInfo> getActualInlays(Function1<? super Inlay<?>, String> inlayPresenter, Function1<? super Inlay<?>, Boolean> inlayFilter) {
        void $this$sortedBy$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Inlay it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Editor editor2 = this.myFixture.getEditor();
        List list = editor2.getInlayModel().getInlineElementsInRange(0, editor2.getDocument().getTextLength());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInlineElementsInRange(...)");
        Collection collection = list;
        List list2 = editor2.getInlayModel().getAfterLineEndElementsInRange(0, editor2.getDocument().getTextLength());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAfterLineEndElementsInRange(...)");
        Collection collection2 = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        List list3 = editor2.getInlayModel().getBlockElementsInRange(0, editor2.getDocument().getTextLength());
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getBlockElementsInRange(...)");
        List allInlays = CollectionsKt.plus((Collection)collection2, (Iterable)list3);
        ParameterHintsPresentationManager hintManager = ParameterHintsPresentationManager.getInstance();
        Iterable iterable = CollectionsKt.filterNotNull((Iterable)allInlays);
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Inlay)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)inlayFilter.invoke((Object)it)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Inlay)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            boolean isHighlighted = false;
            boolean isCurrent = false;
            if (hintManager.isParameterHint(it)) {
                isHighlighted = hintManager.isHighlighted(it);
                isCurrent = hintManager.isCurrent(it);
            } else {
                isHighlighted = false;
                isCurrent = false;
            }
            collection3.add(new InlayInfo(it.getOffset(), (String)inlayPresenter.invoke((Object)it), isHighlighted, isCurrent));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                InlayInfo it = (InlayInfo)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getOffset());
                it = (InlayInfo)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getOffset()));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CaretAndInlaysInfo extractInlaysAndCaretInfo(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text2 = string;
        Matcher matcher = pattern.matcher(text2);
        List inlays = new ArrayList();
        int extractedLength = 0;
        Integer caretOffset = null;
        int inlaysBeforeCaret = 0;
        Integer selectionStart = null;
        Integer selectionEnd = null;
        while (matcher.find()) {
            int start = matcher.start();
            int matchedLength = matcher.end() - start;
            int realStartOffset = start - extractedLength;
            if (matcher.group(1) != null) {
                void $this$forEach$iv;
                Iterable $this$takeWhile$iv;
                caretOffset = realStartOffset;
                var13_13 = CollectionsKt.asReversedMutable((List)inlays);
                boolean $i$f$takeWhile = false;
                ArrayList list$iv = new ArrayList();
                for (Object item$iv : $this$takeWhile$iv) {
                    InlayInfo it = (InlayInfo)item$iv;
                    boolean bl = false;
                    if (!(it.getOffset() == caretOffset.intValue())) break;
                    list$iv.add(item$iv);
                }
                $this$takeWhile$iv = list$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    InlayInfo it = (InlayInfo)element$iv;
                    boolean bl = false;
                    ++inlaysBeforeCaret;
                }
            } else if (matcher.group(2) != null) {
                selectionStart = realStartOffset;
            } else if (matcher.group(3) != null) {
                selectionEnd = realStartOffset;
            } else {
                var13_13 = inlays;
                String string2 = matcher.group(5);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
                String string3 = matcher.group(4);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group(...)");
                boolean bl = StringsKt.startsWith$default((String)string3, (String)"H", (boolean)false, (int)2, null);
                String string4 = matcher.group(4);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"group(...)");
                var13_13.add(new InlayInfo(realStartOffset, string2, bl, StringsKt.endsWith$default((String)string4, (String)"INT", (boolean)false, (int)2, null)));
            }
            this.removeText(document, realStartOffset, matchedLength);
            extractedLength += matcher.end() - start;
        }
        return new CaretAndInlaysInfo(caretOffset, inlaysBeforeCaret, selectionStart == null || selectionEnd == null ? null : new TextRange(selectionStart.intValue(), selectionEnd.intValue()), inlays);
    }

    private final void removeText(Document document, int realStartOffset, int matchedLength) {
        WriteCommandAction.runWriteCommandAction((Project)this.myFixture.getProject(), () -> InlayHintsChecker.removeText$lambda$14(document, realStartOffset, matchedLength));
    }

    private static final String inlayPresenter$lambda$0(Inlay it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EditorCustomElementRenderer editorCustomElementRenderer = it.getRenderer();
        Intrinsics.checkNotNull((Object)editorCustomElementRenderer, (String)"null cannot be cast to non-null type com.intellij.codeInsight.daemon.impl.HintRenderer");
        String string = ((HintRenderer)editorCustomElementRenderer).getText();
        if (string == null) {
            throw new IllegalArgumentException("No text set to hint");
        }
        return string;
    }

    private static final boolean inlayFilter$lambda$1(InlayHintsChecker this$0, Inlay it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.manager.isParameterHint(it);
    }

    private static final int verifyInlaysAndCaretInfo$lambda$6(int $actualCaretOffset, Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Number)it.getFirst()).intValue() - $actualCaretOffset;
    }

    private static final void removeText$lambda$14(Document $document, int $realStartOffset, int $matchedLength) {
        $document.replaceString($realStartOffset, $realStartOffset + $matchedLength, (CharSequence)"");
    }

    static {
        Pattern pattern = Pattern.compile("(<caret>)|(<selection>)|(</selection>)|<(hint|HINT|Hint|hINT)\\s+text=\"([^\n\r]+?(?=\"\\s*/>))\"\\s*/>");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        InlayHintsChecker.pattern = pattern;
        default = new ParameterNameHintsSettings();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsChecker$Companion;", "", "<init>", "()V", "pattern", "Ljava/util/regex/Pattern;", "getPattern", "()Ljava/util/regex/Pattern;", "default", "Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings;", "intellij.platform.testFramework"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pattern getPattern() {
            return pattern;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

