/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.extractor.differ.DifferBase;
import com.intellij.psi.codeStyle.extractor.differ.LangCodeStyleExtractor;
import com.intellij.psi.codeStyle.extractor.processor.BruteForceProcessor;
import com.intellij.psi.codeStyle.extractor.processor.GenProcessor;
import com.intellij.psi.codeStyle.extractor.values.Generation;
import com.intellij.psi.codeStyle.extractor.values.Gens;
import com.intellij.psi.codeStyle.extractor.values.ValuesExtractionResult;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.fixtures.OCMockProjectFixture;
import com.jetbrains.cidr.lang.formatting.OCFormattingTestCase;
import com.jetbrains.cidr.lang.settings.formatter.extractor.differ.OCExtractor;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.List;

public class CodeStyleExtractorStatisticsCollector
extends OCFormattingTestCase {
    private static final String delimiter = "----------------------------------------------";
    private static final String originalId = "ORIG";
    private static final String genId = "GEN";
    private static final String bfId = "BF";
    private static final String maxId = "MAX";
    private static final int iterationCount = 3;

    private static void report(PrintStream stream, String text2, String id, int diff) {
        stream.println(id);
        stream.println(delimiter);
        stream.println(text2);
        stream.println(delimiter);
        if (!id.equals(originalId)) {
            stream.println(diff);
            stream.println(delimiter);
        }
    }

    private static void reportBestAndAverage(PrintStream stream, int genDiff, int bfDiff, String genText, String bfText, int bfAverage) {
        stream.println(maxId);
        stream.println(delimiter);
        stream.println(genId);
        stream.println(genDiff);
        stream.println(delimiter);
        stream.println(genText);
        stream.println(delimiter);
        stream.println(bfId);
        stream.println(bfDiff);
        stream.println(bfAverage);
        stream.println(delimiter);
        stream.println(bfText);
        stream.println(delimiter);
    }

    public CodeStyleExtractorStatisticsCollector() {
        super("code_styles/code_styles.yaml");
    }

    private void processExample(String targetName) throws FileNotFoundException {
        CodeStyleSettings settings = this.getCodeStyleSettings();
        settings.setRightMargin(LanguageUtils.getInstance().getConfigLanguage(), 120);
        OCWorkspace workspace = ((OCMockProjectFixture)this.myProjectFixture).getWorkspace();
        CodeInsightTestFixture fixture = ((CidrCodeInsightFixture)this.myCodeInsightFixture).getFixture();
        OCExtractor extractor = new OCExtractor();
        PrintStream totalLog = new PrintStream(new FileOutputStream("CodeStyleExtractionShortStats.txt"));
        for (int i = 0; i < 3; ++i) {
            totalLog.println("Gathering statistics for " + targetName + " iteration " + i);
            PrintStream stream = new PrintStream(new FileOutputStream("CodeStyleExtractionStatistics_" + targetName + "_" + i));
            ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex().iterateContent(file -> {
                if (file.isDirectory() || file.getName().equals("local.h")) {
                    return true;
                }
                List configurationsForFile = workspace.getConfigurationsForFile(file);
                for (OCResolveConfiguration config : configurationsForFile) {
                    if (!config.getName().equals(targetName)) continue;
                    fixture.openFileInEditor(file);
                    String fileName = this.getFile().getName();
                    String origText = this.getFile().getText();
                    CodeStyleExtractorStatisticsCollector.report(stream, origText, "ORIG -> " + file.getName(), 0);
                    CodeStyleSettings genSettings = settings.clone();
                    GenProcessor genProcessor = new GenProcessor((LangCodeStyleExtractor)extractor);
                    Gens gensResContainer = genProcessor.runWithProgress(this.getProject(), genSettings, this.getFile(), null);
                    DifferBase resDiffer = extractor.getDiffer(this.getProject(), this.getFile(), genSettings);
                    int gensDiff = resDiffer.getDifference((ValuesExtractionResult)gensResContainer);
                    String gensText = resDiffer.reformattedText();
                    CodeStyleExtractorStatisticsCollector.report(stream, gensText, genId, gensDiff);
                    totalLog.println(fileName + ": Genetic diff = " + gensDiff);
                    int bruteForceIterations = Generation.GEN_COUNT;
                    BruteForceProcessor bruteForceProcessor = new BruteForceProcessor((LangCodeStyleExtractor)extractor);
                    CodeStyleSettings bruteForceSettings = settings.clone();
                    int best = Integer.MAX_VALUE;
                    int average = 0;
                    String bestText = "";
                    for (int j = 0; j < bruteForceIterations; ++j) {
                        ValuesExtractionResult bfResContainer = bruteForceProcessor.runWithProgress(this.getProject(), bruteForceSettings, this.getFile(), null);
                        DifferBase bfDiffer = extractor.getDiffer(this.getProject(), this.getFile(), bruteForceSettings);
                        int bfDiff = bfDiffer.getDifference(bfResContainer);
                        totalLog.println(fileName + ": Brute force iteration " + j + " diff = " + bfDiff);
                        String bfText = bfDiffer.reformattedText();
                        CodeStyleExtractorStatisticsCollector.report(stream, bfText, bfId, bfDiff);
                        if (bfDiff < best) {
                            best = bfDiff;
                            bestText = bfText;
                        }
                        average += bfDiff;
                        bruteForceProcessor.randomizeSettings(bruteForceSettings, LanguageUtils.getInstance().getConfigLanguage());
                    }
                    totalLog.println(fileName + ": GenDiff = " + gensDiff + " BfDiffBest = " + best + " BfDiffAverage = " + average);
                    CodeStyleExtractorStatisticsCollector.reportBestAndAverage(stream, gensDiff, best, gensText, bestText, average);
                }
                return true;
            });
        }
    }

    public void testGoogleStyle() throws Exception {
        this.processExample("Google");
    }

    public void testGNUStyle() throws Exception {
        this.processExample("GNU");
    }

    public void testStroustrupStyle() throws Exception {
        this.processExample("Stroustrup");
    }

    public void testAllmanStyle() throws Exception {
        this.processExample("Allman");
    }

    public void testWhitesmithsStyle() throws Exception {
        this.processExample("Whitesmiths");
    }

    public void testKRStyle() throws Exception {
        this.processExample("KR");
    }

    public void testQTStyle() throws Exception {
        this.processExample("QT");
    }
}

