/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution;

import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrProjectDependentFixtureBase;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CLionRunConfigurationTestMixin
extends CidrProjectDependentFixtureBase {
    public RunManagerEx getRunManager();

    public void setRunManager(@NotNull RunManagerEx var1);

    public Project getProject();

    @Override
    default public void afterProjectOpened() throws Exception {
        this.setRunManager(RunManagerEx.getInstanceEx((Project)this.getProject()));
    }

    default public void assertNoConfigs() {
        TestCase.assertTrue((boolean)this.getRunManager().getAllSettings().isEmpty());
        TestCase.assertNull((Object)this.getRunManager().getSelectedConfiguration());
    }

    default public void assertConfigs(Config ... expected) {
        this.assertConfigs((RunnerAndConfigurationSettings)ContainerUtil.getFirstItem((List)this.getRunManager().getAllSettings()), expected);
    }

    default public void assertConfigs(RunnerAndConfigurationSettings selected, Config ... expected) {
        this.assertConfigsNoSelectionCheck(expected);
        TestCase.assertEquals((String)"Incorrectly selected configuration", (Object)selected, (Object)this.getRunManager().getSelectedConfiguration());
    }

    default public void assertConfigsNoSelectionCheck(Config ... expected) {
        List actual = ContainerUtil.map((Collection)this.getRunManager().getAllSettings(), settings -> {
            CidrRunConfiguration configuration = (CidrRunConfiguration)settings.getConfiguration();
            return new Config(settings.getName(), configuration.getTargetAndConfigurationData());
        });
        UsefulTestCase.assertOrderedEquals(actual, expected);
    }

    @NotNull
    default public RunnerAndConfigurationSettings getConfig(String name) {
        RunnerAndConfigurationSettings result = this.getRunManager().findConfigurationByName(name);
        TestCase.assertNotNull((String)("Config not found: " + name), (Object)result);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = result;
        if (runnerAndConfigurationSettings == null) {
            CLionRunConfigurationTestMixin.$$$reportNull$$$0(0);
        }
        return runnerAndConfigurationSettings;
    }

    default public RunnerAndConfigurationSettings addConfig(@NotNull String name, @Nullable BuildTargetAndConfigurationData data, ConfigurationType type) {
        if (name == null) {
            CLionRunConfigurationTestMixin.$$$reportNull$$$0(1);
        }
        return (RunnerAndConfigurationSettings)WriteAction.computeAndWait(() -> {
            ConfigurationFactory factory = type.getConfigurationFactories()[0];
            RunnerAndConfigurationSettings configuration = this.getRunManager().createConfiguration(factory.createTemplateConfiguration(this.getProject()), factory);
            ((CidrRunConfiguration)configuration.getConfiguration()).setTargetAndConfigurationData(data);
            configuration.setName(name);
            this.getRunManager().addConfiguration(configuration);
            return configuration;
        });
    }

    default public void setConfigData(String configName, @Nullable BuildTargetAndConfigurationData data) {
        ((CMakeAppRunConfiguration)this.getConfig(configName).getConfiguration()).setTargetAndConfigurationData(data);
    }

    public static Config config(@NotNull String targetName, @Nullable String configurationName) {
        if (targetName == null) {
            CLionRunConfigurationTestMixin.$$$reportNull$$$0(2);
        }
        return CLionRunConfigurationTestMixin.config(targetName, targetName, configurationName);
    }

    public static Config config(@NotNull String runConfigurationName, @Nullable String targetName, @Nullable String buildConfigurationName) {
        if (runConfigurationName == null) {
            CLionRunConfigurationTestMixin.$$$reportNull$$$0(3);
        }
        return new Config(runConfigurationName, CLionRunConfigurationTestMixin.data(targetName, buildConfigurationName));
    }

    public static Config config(@NotNull String runConfigurationName, @Nullable String projectName, @Nullable String targetName, @Nullable String buildConfigurationName) {
        if (runConfigurationName == null) {
            CLionRunConfigurationTestMixin.$$$reportNull$$$0(4);
        }
        return new Config(runConfigurationName, CLionRunConfigurationTestMixin.data(projectName, targetName, buildConfigurationName));
    }

    public static BuildTargetAndConfigurationData data(@Nullable String targetName, @Nullable String configurationName) {
        return CLionRunConfigurationTestMixin.data("test", targetName, configurationName);
    }

    public static BuildTargetAndConfigurationData data(@Nullable String projectName, @Nullable String targetName, @Nullable String configurationName) {
        return new BuildTargetAndConfigurationData(projectName, targetName, configurationName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/CLionRunConfigurationTestMixin";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfigurationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/CLionRunConfigurationTestMixin";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addConfig";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "config";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    public static class Config {
        public static final Config[] EMPTY_ARRAY = new Config[0];
        @NotNull
        private final String configName;
        @Nullable
        private final BuildTargetAndConfigurationData data;

        public Config(@NotNull String configName, @Nullable BuildTargetAndConfigurationData data) {
            if (configName == null) {
                Config.$$$reportNull$$$0(0);
            }
            this.configName = configName;
            this.data = data;
        }

        public String toString() {
            return "Config{configName='" + this.configName + "', data=" + String.valueOf(this.data) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Config config = (Config)o;
            if (!this.configName.equals(config.configName)) {
                return false;
            }
            return !(this.data != null ? !this.data.equals((Object)config.data) : config.data != null);
        }

        public int hashCode() {
            int result = this.configName.hashCode();
            result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configName", "com/jetbrains/cidr/cpp/execution/CLionRunConfigurationTestMixin$Config", "<init>"));
        }
    }
}

