/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerTestTreeView;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrTestCase;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.CidrContextRunConfigurationFixture;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.OCTestExecution;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.function.Supplier;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrContextConfigurationTestCase<PROJECT_FIXTURE extends CidrProjectFixture, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixture<EXECUTION_FIXTURE>>
extends CidrTestCase<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE, CidrCodeInsightFixture> {
    protected CidrContextRunConfigurationFixture myFrameworkFixture;

    @Override
    protected void setUpFixtures() throws Exception {
        super.setUpFixtures();
        this.myFrameworkFixture = new CidrContextRunConfigurationFixture(this);
    }

    @Override
    @NotNull
    public FileSymbolTablesCache.SymbolsProperties.SymbolsKind shouldBuildSymbolTables() {
        FileSymbolTablesCache.SymbolsProperties.SymbolsKind symbolsKind = FileSymbolTablesCache.SymbolsProperties.SymbolsKind.ONLY_USED;
        if (symbolsKind == null) {
            CidrContextConfigurationTestCase.$$$reportNull$$$0(0);
        }
        return symbolsKind;
    }

    @Nullable
    protected RunnerAndConfigurationSettings createContextConfiguration(@NotNull PsiElement element, @NotNull Class<? extends RunConfigurationProducer> runConfigurationProducerClass, @Nullable SimpleDataContext.Builder contextBuilder) {
        if (element == null) {
            CidrContextConfigurationTestCase.$$$reportNull$$$0(1);
        }
        if (runConfigurationProducerClass == null) {
            CidrContextConfigurationTestCase.$$$reportNull$$$0(2);
        }
        ConfigurationContext context2 = this.createContext(element, contextBuilder == null ? SimpleDataContext.builder() : contextBuilder);
        return CidrContextConfigurationTestCase.createContextConfiguration(context2, runConfigurationProducerClass);
    }

    @Nullable
    protected static RunnerAndConfigurationSettings createContextConfiguration(@NotNull ConfigurationContext context2, @NotNull Class<? extends RunConfigurationProducer> runConfigurationProducerClass) {
        RunConfigurationProducer producer;
        ConfigurationFromContext fromContext;
        if (context2 == null) {
            CidrContextConfigurationTestCase.$$$reportNull$$$0(3);
        }
        if (runConfigurationProducerClass == null) {
            CidrContextConfigurationTestCase.$$$reportNull$$$0(4);
        }
        return (fromContext = (producer = RunConfigurationProducer.getInstance(runConfigurationProducerClass)).findOrCreateConfigurationFromContext(context2)) == null ? null : fromContext.getConfigurationSettings();
    }

    @NotNull
    protected ConfigurationContext createContext(@NotNull PsiElement element, @NotNull SimpleDataContext.Builder contextBuilder) {
        if (element == null) {
            CidrContextConfigurationTestCase.$$$reportNull$$$0(5);
        }
        if (contextBuilder == null) {
            CidrContextConfigurationTestCase.$$$reportNull$$$0(6);
        }
        DataContext dataContext = contextBuilder.add(CommonDataKeys.PROJECT, (Object)this.getProject()).add(PlatformCoreDataKeys.MODULE, (Object)ModuleUtilCore.findModuleForPsiElement((PsiElement)element)).add(Location.DATA_KEY, (Object)PsiLocation.fromPsiElement((PsiElement)element)).build();
        ConfigurationContext configurationContext = ConfigurationContext.getFromContext((DataContext)dataContext, (String)"unknown");
        if (configurationContext == null) {
            CidrContextConfigurationTestCase.$$$reportNull$$$0(7);
        }
        return configurationContext;
    }

    public static void assertValidity(@NotNull CidrRunConfiguration config, @Nullable String expectedError) throws RuntimeConfigurationException {
        block4: {
            if (config == null) {
                CidrContextConfigurationTestCase.$$$reportNull$$$0(8);
            }
            try {
                config.checkConfiguration();
                if (expectedError != null) {
                    CidrContextConfigurationTestCase.fail((String)("Error expected: " + expectedError));
                }
            }
            catch (RuntimeConfigurationException e) {
                if (expectedError != null && e.getMessage().equals(expectedError)) break block4;
                throw e;
            }
        }
    }

    public void assertReusingExistingConfiguration(PsiElement element) {
        RunnerAndConfigurationSettings settings = this.createContextConfiguration(element);
        RunManagerImpl.getInstanceImpl((Project)this.getProject()).addConfiguration(settings);
        try {
            CidrContextConfigurationTestCase.assertSame((Object)settings, (Object)this.createContextConfiguration(element));
            if (element instanceof LeafElement) {
                element = element.getParent();
            }
            CidrContextConfigurationTestCase.assertSame((Object)settings, (Object)this.createContextConfiguration(PsiTreeUtil.findChildOfType((PsiElement)element, PsiWhiteSpace.class)));
        }
        finally {
            RunManagerImpl.getInstanceImpl((Project)this.getProject()).removeConfiguration(settings);
        }
    }

    public void assertCreatingFromMultipleTestResults(String pattern, PsiElement psiElement, final SMTestLocator locator, final String ... paths) {
        SMTRunnerTestTreeView testTreeView = new SMTRunnerTestTreeView(){

            public TreePath @Nullable [] getSelectionPaths() {
                TreePath[] res = new TreePath[paths.length];
                for (int i = 0; i < res.length; ++i) {
                    res[i] = new TreePath(i);
                }
                return res;
            }

            @NotNull
            public SMTestProxy getSelectedTest(@NotNull TreePath selectionPath) {
                if (selectionPath == null) {
                    1.$$$reportNull$$$0(0);
                }
                Integer i = (Integer)selectionPath.getLastPathComponent();
                SMTestProxy test = new SMTestProxy("test" + i, false, paths[i]);
                test.setLocator(locator);
                SMTestProxy sMTestProxy = test;
                if (sMTestProxy == null) {
                    1.$$$reportNull$$$0(1);
                }
                return sMTestProxy;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "selectionPath";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/execution/CidrContextConfigurationTestCase$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/execution/CidrContextConfigurationTestCase$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSelectedTest";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getSelectedTest";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        SimpleDataContext.Builder contextBuilder = SimpleDataContext.builder().add(SMTRunnerTestTreeView.SM_TEST_RUNNER_VIEW, (Object)testTreeView);
        CidrTestRunConfiguration config = (CidrTestRunConfiguration)this.createContextConfiguration(psiElement, contextBuilder).getConfiguration();
        CidrContextConfigurationTestCase.assertEquals((Object)CidrTestRunConfigurationData.Mode.PATTERN, (Object)config.getTestData().getTestMode());
        CidrContextConfigurationTestCase.assertEquals((String)pattern, (String)config.getTestData().getTestPattern());
    }

    protected static void assertTargetForRunConfiguration(@NotNull CidrRunConfiguration configuration, @Nullable String expectedTargetName) {
        if (configuration == null) {
            CidrContextConfigurationTestCase.$$$reportNull$$$0(9);
        }
        BuildTargetAndConfigurationData buildConfig = configuration.getTargetAndConfigurationData();
        CidrContextConfigurationTestCase.assertNotNull((Object)buildConfig);
        CidrContextConfigurationTestCase.assertEquals((String)expectedTargetName, (String)buildConfig.target.targetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isCanceledWhileProcessed(boolean needFastRespond, boolean areSymbolsLoaded, @NotNull Computable<Void> computable) {
        if (computable == null) {
            CidrContextConfigurationTestCase.$$$reportNull$$$0(10);
        }
        Boolean symbolsLoadedInTests = FileSymbolTablesCache.getForceSymbolsLoadedInTests();
        EmptyProgressIndicator progress = new EmptyProgressIndicator();
        try {
            FileSymbolTablesCache.forceSymbolsLoadedInTests((Boolean)areSymbolsLoaded);
            Supplier<Void> producer = () -> CidrContextConfigurationTestCase.lambda$isCanceledWhileProcessed$0(computable, (ProgressIndicator)progress);
            if (needFastRespond) {
                OCTestExecution.executeWithCachedValuesFast(producer);
            } else {
                OCTestExecution.executeWithRealValuesSlow(producer);
            }
        }
        finally {
            FileSymbolTablesCache.forceSymbolsLoadedInTests((Boolean)symbolsLoadedInTests);
        }
        return progress.isCanceled();
    }

    public static void checkConfig(@NotNull CidrTestRunConfiguration config, @Nullable String expectedPattern, @Nullable String expectedSuite, @Nullable String expectedTest, @NotNull CidrTestRunConfigurationData.Mode expectedMode, @NotNull String expectedConfName) {
        if (config == null) {
            CidrContextConfigurationTestCase.$$$reportNull$$$0(11);
        }
        if (expectedMode == null) {
            CidrContextConfigurationTestCase.$$$reportNull$$$0(12);
        }
        if (expectedConfName == null) {
            CidrContextConfigurationTestCase.$$$reportNull$$$0(13);
        }
        CidrContextConfigurationTestCase.assertEquals((String)expectedPattern, (String)config.getTestData().getTestPattern());
        CidrContextConfigurationTestCase.assertEquals((String)expectedSuite, (String)config.getTestData().getTestSuite());
        CidrContextConfigurationTestCase.assertEquals((String)expectedTest, (String)config.getTestData().getTestName());
        CidrContextConfigurationTestCase.assertEquals((Object)expectedMode, (Object)config.getTestData().getTestMode());
        CidrContextConfigurationTestCase.assertEquals((String)expectedConfName, (String)config.getName());
    }

    @NotNull
    public PROJECT_FIXTURE getProjectFixture() {
        CidrProjectFixture cidrProjectFixture = (CidrProjectFixture)this.myProjectFixture;
        if (cidrProjectFixture == null) {
            CidrContextConfigurationTestCase.$$$reportNull$$$0(14);
        }
        return (PROJECT_FIXTURE)cidrProjectFixture;
    }

    public RunnerAndConfigurationSettings createContextConfiguration(PsiElement element) {
        return this.createContextConfiguration(element, null);
    }

    public abstract RunnerAndConfigurationSettings createContextConfiguration(PsiElement var1, @Nullable SimpleDataContext.Builder var2);

    private static /* synthetic */ Void lambda$isCanceledWhileProcessed$0(Computable computable, ProgressIndicator progress) {
        return (Void)ProgressManager.getInstance().runProcess(computable, progress);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/CidrContextConfigurationTestCase";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfigurationProducerClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextBuilder";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedMode";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedConfName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldBuildSymbolTables";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/CidrContextConfigurationTestCase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createContext";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectFixture";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createContextConfiguration";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "assertValidity";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "assertTargetForRunConfiguration";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isCanceledWhileProcessed";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkConfig";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13 -> new IllegalArgumentException(string);
        };
    }
}

