/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.TestAnnotationInfoList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class TestAnnotationHolder
extends TestAnnotationInfoList {
    public static final String CIDR_CHECK_RANGES_IN_ANNOTATIONS = "#define __CIDR_CHECK_RANGES_IN_ANNOTATIONS\n";
    private final PsiFile myFile;
    private final CidrCodeInsightFixture myCodeInsightFixture;
    private String errorMessage;
    private String warningMessage;
    private final List<IntentionAction> quickFixes = new LinkedList<IntentionAction>();
    private final Set<String> quickFixNames = new HashSet<String>();
    private final List<TextRange> ranges = new LinkedList<TextRange>();
    private boolean checked;

    public TestAnnotationHolder(CidrCodeInsightFixture codeInsightFixture, PsiFile file) {
        this.myCodeInsightFixture = codeInsightFixture;
        this.myFile = file;
    }

    @NotNull
    public List<IntentionAction> getQuickFixes() {
        List<IntentionAction> list = this.quickFixes;
        if (list == null) {
            TestAnnotationHolder.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            TestAnnotationHolder.$$$reportNull$$$0(1);
        }
        return psiFile;
    }

    @NotNull
    private String getRangeText(TextRange range) {
        String fileText = this.myFile.getText();
        if (!fileText.startsWith(CIDR_CHECK_RANGES_IN_ANNOTATIONS)) {
            return "";
        }
        if (range.getStartOffset() < 0) {
            return "[bad_start]";
        }
        if (range.getEndOffset() > fileText.length()) {
            return "[bad_end]";
        }
        String string = "[" + range.substring(fileText) + "]";
        if (string == null) {
            TestAnnotationHolder.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void checkAnnotations() {
        if (!this.checked) {
            this.checked = true;
            for (TestAnnotationInfoList.AnnotationInfo annotation : this.myAnnotationHolder) {
                @NotNull HighlightSeverity severity = annotation.severity;
                @NotNull TextRange range = annotation.range;
                @Nullable Object message = annotation.message;
                if (message != null) {
                    message = this.getRangeText(range) + (String)message;
                    if (severity == HighlightSeverity.ERROR) {
                        this.errorMessage = this.errorMessage != null ? this.errorMessage + "; " + (String)message : message;
                    } else if (severity == HighlightSeverity.WARNING || severity == HighlightSeverity.INFORMATION) {
                        this.warningMessage = this.warningMessage != null ? this.warningMessage + "; " + (String)message : message;
                    }
                }
                this.ranges.add(range);
            }
        }
    }

    @Override
    public void createQuickFix(@Nullable Segment annotation, @NotNull IntentionAction intentionAction) {
        String name;
        if (intentionAction == null) {
            TestAnnotationHolder.$$$reportNull$$$0(3);
        }
        if (intentionAction.isAvailable(this.myCodeInsightFixture.getProject(), this.myCodeInsightFixture.getEditor(), this.myFile) && this.quickFixNames.add(name = intentionAction.getText())) {
            this.quickFixes.add(intentionAction);
        }
    }

    public void assertRange(@NotNull TextRange range) {
        if (range == null) {
            TestAnnotationHolder.$$$reportNull$$$0(4);
        }
        this.checkAnnotations();
        Assert.assertFalse((String)"No clang annotations found", (boolean)this.ranges.isEmpty());
        Assert.assertEquals((String)"Several clang annotations found", (long)1L, (long)this.ranges.size());
        Assert.assertEquals((String)"IncorrectRange", (Object)range, (Object)this.ranges.get(0));
    }

    public void assertError(@NotNull String message, boolean isRegexp) {
        if (message == null) {
            TestAnnotationHolder.$$$reportNull$$$0(5);
        }
        this.checkAnnotations();
        Assert.assertTrue((String)("OK instead of Error '" + message + "'"), (this.warningMessage != null || this.errorMessage != null ? 1 : 0) != 0);
        if (this.errorMessage == null) {
            Assert.fail((String)("Warning '" + this.warningMessage + "' instead of Error '" + message + "'"));
        }
        if (message.equals("__ANY_MESSAGE")) {
            return;
        }
        if (isRegexp) {
            Assert.assertTrue((String)("'" + this.errorMessage + "' does not match '" + message + "'"), (boolean)this.errorMessage.matches(message));
        } else {
            Assert.assertEquals((String)("'" + this.errorMessage + "' instead of '" + message + "'"), (Object)message, (Object)this.errorMessage);
        }
    }

    public void assertWarning(@NotNull String message, boolean isRegexp) {
        if (message == null) {
            TestAnnotationHolder.$$$reportNull$$$0(6);
        }
        this.checkAnnotations();
        Assert.assertTrue((String)("OK instead of Warning '" + message + "'"), (this.warningMessage != null || this.errorMessage != null ? 1 : 0) != 0);
        if (this.warningMessage == null) {
            Assert.fail((String)("Error '" + this.errorMessage + "' instead of Warning '" + message + "'"));
        }
        if (message.equals("__ANY_MESSAGE")) {
            return;
        }
        if (isRegexp) {
            Assert.assertTrue((String)("'" + this.warningMessage + "' does not match '" + message + "'"), (boolean)this.warningMessage.matches(message));
        } else {
            Assert.assertEquals((String)("'" + this.warningMessage + "' instead of '" + message + "'"), (Object)message, (Object)this.warningMessage);
        }
    }

    public void assertWarningOrError(@NotNull String message, boolean isRegexp) {
        String anyMessage;
        if (message == null) {
            TestAnnotationHolder.$$$reportNull$$$0(7);
        }
        this.checkAnnotations();
        Assert.assertTrue((String)("OK instead of Warning or Error '" + message + "'"), (this.warningMessage != null || this.errorMessage != null ? 1 : 0) != 0);
        String string = anyMessage = this.errorMessage != null ? this.errorMessage : this.warningMessage;
        if (isRegexp) {
            Assert.assertTrue((String)("'" + anyMessage + "' does not match '" + message + "'"), (boolean)anyMessage.matches(message));
        } else {
            Assert.assertEquals((String)("'" + anyMessage + "' instead of '" + message + "'"), (Object)message, (Object)anyMessage);
        }
    }

    public void assertOK() {
        this.checkAnnotations();
        this.assertNoErrors();
        this.assertNoWarnings();
    }

    public void assertNoWarnings() {
        this.checkAnnotations();
        Assert.assertNull((String)("Warning '" + this.warningMessage + "' instead of OK"), (Object)this.warningMessage);
    }

    public void assertNoErrors() {
        this.checkAnnotations();
        Assert.assertNull((String)("Error '" + this.errorMessage + "' instead of OK"), (Object)this.errorMessage);
    }

    @Nullable
    public String getWarningMessage() {
        this.checkAnnotations();
        return this.warningMessage;
    }

    @Nullable
    public String getErrorMessage() {
        this.checkAnnotations();
        return this.errorMessage;
    }

    public void clear() {
        this.checked = false;
        this.errorMessage = null;
        this.warningMessage = null;
        this.ranges.clear();
        this.quickFixes.clear();
        this.quickFixNames.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/TestAnnotationHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentionAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeText";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/TestAnnotationHolder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createQuickFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "assertRange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "assertError";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "assertWarning";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "assertWarningOrError";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

