/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.CLSAbstractFileEntry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.MockClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCompileCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangLocalWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.LocalWorkspaceFile;
import java.io.File;
import java.net.URISyntaxException;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public final class CLSTestUtils {
    public static void addFiles(@NotNull ClangLocalWorkspace localWs, @NotNull ClangRemoteWorkspace remoteWs, CLSAbstractFileEntry ... entries) {
        if (localWs == null) {
            CLSTestUtils.$$$reportNull$$$0(0);
        }
        if (remoteWs == null) {
            CLSTestUtils.$$$reportNull$$$0(1);
        }
        for (CLSAbstractFileEntry entry : entries) {
            localWs.modifyWithRead(entry.virtualFile.getUrl(), lwf -> {
                entry.applyToLocal((LocalWorkspaceFile)lwf);
                if (entry.finished) {
                    remoteWs.modify(lwf.getUrl(), rwf -> entry.applyToRemote((LocalWorkspaceFile)lwf, (RemoteWorkspaceFile)rwf));
                }
            });
        }
    }

    @NotNull
    public static MockClangIdeFacade addFiles(@NotNull ClangUrlConverter converter, @NotNull MockClangIdeFacade facade, CLSAbstractFileEntry ... entries) {
        if (converter == null) {
            CLSTestUtils.$$$reportNull$$$0(2);
        }
        if (facade == null) {
            CLSTestUtils.$$$reportNull$$$0(3);
        }
        for (int i = 0; i < entries.length; ++i) {
            CLSAbstractFileEntry entry = entries[i];
            facade.addOrReplace(new MockClangIdeFacade.FileEntry(entry.virtualFile, "blabla" + i, entry.modified, CLSTestUtils.createDummyCompilationCommand(converter.toUri(new File(entry.virtualFile.getPath()), true), i), "bla" + i, null));
        }
        MockClangIdeFacade mockClangIdeFacade = facade;
        if (mockClangIdeFacade == null) {
            CLSTestUtils.$$$reportNull$$$0(4);
        }
        return mockClangIdeFacade;
    }

    public static int howManyMacrosFiles(@NotNull ClangDaemonContext context2) throws URISyntaxException {
        if (context2 == null) {
            CLSTestUtils.$$$reportNull$$$0(5);
        }
        int counter = 0;
        for (String url : context2.getLocalWorkspace().getRegisteredUrls()) {
            if (!ClangRequestsHelper.isMacroFile((ClangDaemonContext)context2, (String)url)) continue;
            ++counter;
        }
        return counter;
    }

    @NotNull
    private static ClionCompileCommandParams createDummyCompilationCommand(@NotNull String uri, int index) {
        if (uri == null) {
            CLSTestUtils.$$$reportNull$$$0(6);
        }
        return new ClionCompileCommandParams(uri, uri, "bla" + index, Collections.emptyList(), "/dev/null", true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localWs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteWs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/CLSTestUtils";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/CLSTestUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addFiles";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "howManyMacrosFiles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDummyCompilationCommand";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

