/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.Location;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.CidrTargetConfigurationHelper;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCTargetConfigurationHelper
implements CidrTargetConfigurationHelper {
    private static final Key<Pair<Boolean, Long>> ourIsEntryPoint = Key.create((String)"Is entry point");
    private static final Key<Pair<Boolean, Long>> ourFileHasEntryPoint = Key.create((String)"file.has.entry.point");

    public boolean isInEntryPointBody(@NotNull Location location) {
        if (location == null) {
            OCTargetConfigurationHelper.$$$reportNull$$$0(0);
        }
        return OCTargetConfigurationHelper.isInEntryPointBody(location.getPsiElement());
    }

    @RequiresBackgroundThread
    public static boolean hasEntryPoint(PsiFile psiFile) {
        PsiFile file;
        ThreadingAssertions.assertBackgroundThread();
        if (file instanceof OCFile) {
            Pair<Boolean, Long> entryVersion = OCTargetConfigurationHelper.getEntryPointData((PsiElement)file, ourFileHasEntryPoint, () -> {
                Object[] children = (PsiElement[])ReadAction.compute(() -> file.getChildren());
                PsiElement function = (PsiElement)ContainerUtil.find((Object[])children, element -> OCTargetConfigurationHelper.isEntryPoint(element));
                if (function != null) {
                    return true;
                }
                return null;
            });
            return entryVersion != null && entryVersion.first == Boolean.TRUE;
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean isEntryPoint(@Nullable PsiElement maybeMainDecl) {
        if (maybeMainDecl instanceof OCFunctionDefinition) {
            Pair<Boolean, Long> entryVersion = OCTargetConfigurationHelper.getEntryPointData(maybeMainDecl, ourIsEntryPoint, () -> {
                OCFunctionSymbol symbol = ((OCFunctionDefinition)maybeMainDecl).getSymbol();
                if (symbol != null && symbol.getKind() == OCSymbolKind.FUNCTION_DECLARATION) {
                    return symbol.isMainFunction();
                }
                return null;
            });
            return entryVersion != null && entryVersion.first == Boolean.TRUE;
        }
        return false;
    }

    public static boolean isInEntryPointBody(@NotNull PsiElement element) {
        if (element == null) {
            OCTargetConfigurationHelper.$$$reportNull$$$0(1);
        }
        return OCTargetConfigurationHelper.isInEntryPointBody(element, null);
    }

    private static boolean isInEntryPointBody(@NotNull PsiElement element, @Nullable PsiElement topParent) {
        if (element == null) {
            OCTargetConfigurationHelper.$$$reportNull$$$0(2);
        }
        for (PsiElement current = element; current != null; current = current.getParent()) {
            if (current instanceof PsiFile || current == topParent) {
                return false;
            }
            if (current instanceof OCMacroCall && topParent == null) {
                Ref ref = new Ref();
                PsiElement macroAsParent = current;
                ((OCMacroCall)current).processExpansionLeaves((Processor<? super PsiElement>)((Processor)leaf -> {
                    boolean inEP = OCTargetConfigurationHelper.isInEntryPointBody(leaf, macroAsParent);
                    if (inEP) {
                        ref.set((Object)Boolean.TRUE);
                        return false;
                    }
                    return true;
                }));
                if (ref.get() != Boolean.TRUE) continue;
                return true;
            }
            if (!OCTargetConfigurationHelper.isEntryPoint(current)) continue;
            return true;
        }
        return false;
    }

    private static Pair<Boolean, Long> getEntryPointData(@NotNull PsiElement element, Key<Pair<Boolean, Long>> key, Supplier<Boolean> computeRunnable) {
        Boolean res;
        if (element == null) {
            OCTargetConfigurationHelper.$$$reportNull$$$0(3);
        }
        Pair entryVersion = (Pair)key.get((UserDataHolder)element);
        long version = FileSymbolTablesCache.getInstance(element.getProject()).getOutOfBlockModificationTracker().getModificationCount();
        if (entryVersion != null && ((Long)entryVersion.second).equals(version)) {
            return entryVersion;
        }
        if ((!ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode()) && (res = computeRunnable.get()) != null) {
            entryVersion = Pair.pair((Object)res, (Object)version);
            key.set((UserDataHolder)element, (Object)entryVersion);
        }
        if (entryVersion != null && ((Long)entryVersion.second).equals(version)) {
            return entryVersion;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/OCTargetConfigurationHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isInEntryPointBody";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getEntryPointData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

