/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCMacroParameterInfoHandler
implements ParameterInfoHandler<OCMacroCall, OCMacroSymbol> {
    public void showParameterInfo(@NotNull OCMacroCall element, @NotNull CreateParameterInfoContext context) {
        List<OCMacroCallArgument> arguments;
        if (element == null) {
            OCMacroParameterInfoHandler.$$$reportNull$$$0(0);
        }
        if (context == null) {
            OCMacroParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if (!(arguments = element.getArguments()).isEmpty()) {
            context.showHint((PsiElement)element, arguments.get(0).getTextRange().getStartOffset(), (ParameterInfoHandler)this);
        }
    }

    public OCMacroCall findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        OCMacroCall call;
        if (context == null) {
            OCMacroParameterInfoHandler.$$$reportNull$$$0(2);
        }
        if ((call = OCMacroParameterInfoHandler.findMacroCall(context.getFile(), context.getOffset(), context.getParameterListStart())) != null) {
            OCMacroSymbol macro = call.resolveToSymbol();
            if (macro == null) {
                OCLog.LOG.error("can't resolve macro for '" + call.getText() + "'", new Attachment[]{new Attachment("file.mm", call.getContainingFile().getText())});
            }
            context.setItemsToShow(new Object[]{macro});
            return call;
        }
        return null;
    }

    @Nullable
    private static OCMacroCall findMacroCall(PsiFile file, int offset, int startOffset) {
        PsiElement element;
        if (startOffset == -1) {
            startOffset = offset;
        }
        PsiElement element1 = file.findElementAt(offset);
        PsiElement element2 = file.findElementAt(startOffset);
        PsiElement psiElement = element = element1 != null && element2 != null ? PsiTreeUtil.findCommonContext((PsiElement)element1, (PsiElement)element2) : null;
        if (element == null) {
            return null;
        }
        while (element != null && !(element instanceof OCMacroCall)) {
            if (element instanceof OCBlockExpression || element instanceof OCLambdaExpression) {
                return null;
            }
            if (element instanceof OCArgumentList && Registry.is((String)"clang.parameter.info")) {
                return null;
            }
            element = element.getContext();
        }
        if (element == null) {
            return null;
        }
        OCMacroCall macroCall = (OCMacroCall)element;
        OCReferenceElement re = macroCall.getMacroReferenceElement();
        return re == null || re.getRangeWithMacros().containsOffset(offset) ? null : macroCall;
    }

    public OCMacroCall findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            OCMacroParameterInfoHandler.$$$reportNull$$$0(3);
        }
        return OCMacroParameterInfoHandler.findMacroCall(context.getFile(), context.getOffset(), context.getParameterListStart());
    }

    public void updateParameterInfo(@NotNull OCMacroCall call, @NotNull UpdateParameterInfoContext context) {
        if (call == null) {
            OCMacroParameterInfoHandler.$$$reportNull$$$0(4);
        }
        if (context == null) {
            OCMacroParameterInfoHandler.$$$reportNull$$$0(5);
        }
        int offset = context.getEditor().getCaretModel().getOffset();
        if (!call.getRangeWithMacros().contains(offset)) {
            context.removeHint();
            return;
        }
        int index = 0;
        for (ASTNode child = call.getNode().getFirstChildNode(); child != null && child.getStartOffset() < offset; child = child.getTreeNext()) {
            if (child.getElementType() != OCLexerTokenTypes.COMMA) continue;
            ++index;
        }
        context.setCurrentParameter(index);
        Object[] objects = context.getObjectsToView();
        for (int i = 0; i < objects.length; ++i) {
            OCMacroSymbol macro = (OCMacroSymbol)objects[i];
            OCMacroCall.ParameterCheckResult checkResult = call.checkParameters(macro);
            context.setUIComponentEnabled(i, checkResult.getActualCount() <= checkResult.getAllowedCount());
        }
    }

    public void updateUI(OCMacroSymbol macro, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            OCMacroParameterInfoHandler.$$$reportNull$$$0(6);
        }
        StringBuilder buffer = new StringBuilder();
        List<String> paramNames = macro.getUserFriendlyParameterNames();
        int paramCount = paramNames.size();
        int currentParameter = Math.min(context.getCurrentParameterIndex(), paramCount - 1);
        int highlightStartOffset = -1;
        int highlightEndOffset = -1;
        if (paramCount == 0) {
            buffer.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        } else {
            for (int j = 0; j < paramCount; ++j) {
                int startOffset = buffer.length();
                buffer.append(paramNames.get(j));
                int endOffset = buffer.length();
                if (j < paramCount - 1) {
                    buffer.append(", ");
                }
                if (j != currentParameter || !context.isUIComponentEnabled()) continue;
                highlightStartOffset = startOffset;
                highlightEndOffset = endOffset;
            }
        }
        context.setupUIComponentPresentation(buffer.toString(), highlightStartOffset, highlightEndOffset, !context.isUIComponentEnabled(), false, false, context.getDefaultParameterColor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/editor/OCMacroParameterInfoHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showParameterInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForParameterInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateParameterInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateUI";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

