/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class OCSurroundUtil {
    private static final Logger LOG = Logger.getInstance(OCSurroundUtil.class);

    static PsiElement[] moveDeclarationsOut(PsiElement block, PsiElement[] statements, boolean generateInitializers) {
        try {
            PsiManager psiManager = block.getManager();
            Project project = psiManager.getProject();
            ArrayList<PsiElement> array = new ArrayList<PsiElement>();
            for (PsiElement statement : statements) {
                OCDeclarationStatement declaration;
                if (statement instanceof OCDeclarationStatement && OCSurroundUtil.needToDeclareOut(statements, declaration = (OCDeclarationStatement)statement)) {
                    OCDeclarationStatement newDeclaration;
                    List<OCDeclarator> elements = declaration.getDeclaration().getDeclarators();
                    for (OCDeclarator element : elements) {
                        OCExpression initializer = element.getInitializer();
                        if (initializer == null) continue;
                        String name = element.getName();
                        OCExpressionStatement assignment = (OCExpressionStatement)OCElementFactory.statementFromText(name + "=x;", element);
                        assignment = (OCExpressionStatement)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)assignment);
                        OCAssignmentExpression expr = (OCAssignmentExpression)assignment.getExpression();
                        OCChangeUtil.replaceHandlingMacros(expr.getSourceExpression(), initializer);
                        assignment = (OCExpressionStatement)block.addAfter((PsiElement)assignment, (PsiElement)declaration);
                        array.add(assignment);
                    }
                    if (!array.isEmpty()) {
                        PsiElement firstStatement = (PsiElement)array.get(0);
                        newDeclaration = (OCDeclarationStatement)block.addBefore((PsiElement)declaration, firstStatement);
                        OCChangeUtil.delete(declaration);
                    } else {
                        newDeclaration = declaration;
                    }
                    OCDeclaration dcl = newDeclaration.getDeclaration();
                    elements = dcl.getDeclarators();
                    for (OCDeclarator var : elements) {
                        OCExpression initializer = var.getInitializer();
                        if (initializer == null) continue;
                        if (!generateInitializers) {
                            OCChangeUtil.delete(initializer);
                            continue;
                        }
                        String newText = OCElementFactory.declarationText(Collections.emptyList(), var.getName(), var.getType(), var.getResolvedType().getDefaultValue(OCResolveContext.forPsi(var)), var, null, false);
                        OCDeclarationStatement newStmt = (OCDeclarationStatement)OCElementFactory.statementFromText(newText, block);
                        OCChangeUtil.replaceHandlingMacros(var, newStmt.getDeclaration().getDeclarators().get(0));
                    }
                    continue;
                }
                if (OCElementUtil.getElementType(statement) == TokenType.WHITE_SPACE) continue;
                array.add(statement);
            }
            return PsiUtilCore.toPsiElementArray(array);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return statements;
        }
    }

    private static boolean needToDeclareOut(PsiElement[] statements, OCDeclarationStatement statement) {
        List<OCDeclarator> elements = statement.getDeclaration().getDeclarators();
        PsiElement lastStatement = statements[statements.length - 1];
        int endOffset = lastStatement.getTextRange().getEndOffset();
        for (PsiElement psiElement : elements) {
            GlobalSearchScope projectScope;
            Object[] refs;
            if (!(psiElement instanceof OCDeclarator) || !ContainerUtil.exists((Object[])(refs = (PsiReference[])ReferencesSearch.search((PsiElement)psiElement, (SearchScope)(projectScope = OCSearchScope.getProjectSourcesScope(psiElement.getProject())), (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY)), e -> e.getElement().getTextOffset() > endOffset)) continue;
            return true;
        }
        return false;
    }
}

