/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.util.OCSimplifyUtil;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OCConvertToIfIntentionActionBase
extends PsiElementBaseIntentionAction {
    protected void invoke(OCExpression expression, OCExpression condition, OCExpression positiveExpression, OCExpression negativeExpression) {
        Document document;
        PsiElement element;
        condition = OCParenthesesUtils.diveIntoParentheses(condition);
        positiveExpression = OCParenthesesUtils.diveIntoParentheses(positiveExpression);
        negativeExpression = OCParenthesesUtils.diveIntoParentheses(negativeExpression);
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{OCStatement.class, OCDeclarator.class});
        OCStatement statement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, OCStatement.class, (boolean)false);
        if (expression == null || statement == null) {
            return;
        }
        @NlsSafe StringBuilder builder = new StringBuilder("if (");
        OCExpression conditionalExprWithParens = OCParenthesesUtils.topmostParenthesized(expression);
        if (condition != null) {
            builder.append(condition.getTextWithMacros());
        }
        builder.append(") {\n");
        if (parent instanceof OCDeclarator) {
            OCDeclarator declarator = (OCDeclarator)parent;
            OCExpression initializer = declarator.getInitializer();
            builder.append(declarator.getName()).append("=");
            OCConvertToIfIntentionActionBase.appendElementText(builder, initializer, conditionalExprWithParens, positiveExpression);
            builder.append(";\n}\nelse {\n").append(declarator.getName()).append("=");
            OCConvertToIfIntentionActionBase.appendElementText(builder, initializer, conditionalExprWithParens, negativeExpression);
            builder.append(";\n}");
            OCChangeUtil.delete(initializer);
        } else {
            OCConvertToIfIntentionActionBase.appendElementText(builder, statement, conditionalExprWithParens, positiveExpression);
            builder.append("}\nelse {\n");
            OCConvertToIfIntentionActionBase.appendElementText(builder, statement, conditionalExprWithParens, negativeExpression);
            builder.append("\n}");
        }
        OCIfStatement ifStatement = (OCIfStatement)OCElementFactory.statementFromText(builder.toString(), expression, true);
        PsiElement psiElement = element = parent instanceof OCDeclarator ? OCChangeUtil.addAfter(statement.getParent(), ifStatement, statement) : OCChangeUtil.replaceHandlingMacros(statement, ifStatement);
        if (element instanceof OCIfStatement && (document = element.getContainingFile().getViewProvider().getDocument()) != null) {
            PsiDocumentManager.getInstance((Project)element.getProject()).doPostponedOperationsAndUnblockDocument(document);
            OCConvertToIfIntentionActionBase.simplify(((OCIfStatement)element).getThenBranch());
            OCConvertToIfIntentionActionBase.simplify(((OCIfStatement)element).getElseBranch());
        }
    }

    private static void simplify(@Nullable PsiElement element) {
        if (element == null) {
            return;
        }
        IntentionAction fix = OCSimplifyUtil.getSimplifyFix(element);
        if (fix != null) {
            fix.invoke(element.getProject(), null, element.getContainingFile());
        }
    }

    private static void appendElementText(StringBuilder builder, PsiElement element, OCExpression elementToReplace, OCExpression replacement) {
        if (element == elementToReplace) {
            if (OCParenthesesUtils.isParenthesesNeededInReplacing(elementToReplace, replacement)) {
                builder.append('(').append(OCElementUtil.getTextWithMacros(replacement)).append(')');
            } else {
                builder.append(OCElementUtil.getTextWithMacros(replacement));
            }
        } else {
            List<PsiElement> children = OCElementUtil.getAllChildren(element);
            if (!children.isEmpty()) {
                for (PsiElement child : children) {
                    OCConvertToIfIntentionActionBase.appendElementText(builder, child, elementToReplace, replacement);
                }
            } else if (!OCElementUtil.isPartOfMacroSubstitution(element)) {
                builder.append(OCElementUtil.getTextWithMacros(element));
            }
        }
    }
}

