/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.serialization;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.modulemap.ModuleMapLog;
import com.jetbrains.cidr.lang.modulemap.ModuleMapRoot;
import com.jetbrains.cidr.lang.modulemap.ModuleMapUtil;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapPlatformType;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleInfo;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapAssembledPack;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapReference;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleReference;
import com.jetbrains.cidr.lang.modulemap.serialization.SerializedModuleMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J(\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0002J&\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\u0016H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/serialization/ValidPackCollector;", "", "deserializedPacks", "", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapAssembledPack;", "refToSerializedModuleMap", "", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapReference;", "Lcom/jetbrains/cidr/lang/modulemap/serialization/SerializedModuleMap;", "ignoreSetupErrors", "", "<init>", "(Ljava/util/List;Ljava/util/Map;Z)V", "collectValidPacks", "collectDependencies", "serializedModuleMap", "moduleMapRoot", "Lcom/jetbrains/cidr/lang/modulemap/ModuleMapRoot;", "forceIgnoreErrors", "removeDirtyMaps", "pack", "dirtyPredicate", "Lkotlin/Function1;", "dependencies", "Lkotlin/sequences/Sequence;", "getDependencies", "(Lcom/jetbrains/cidr/lang/modulemap/serialization/SerializedModuleMap;)Lkotlin/sequences/Sequence;", "intellij.c.core"})
@SourceDebugExtension(value={"SMAP\nValidPackCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValidPackCollector.kt\ncom/jetbrains/cidr/lang/modulemap/serialization/ValidPackCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,104:1\n1617#2,9:105\n1869#2:114\n1870#2:116\n1626#2:117\n827#2:127\n855#2,2:128\n1#3:115\n2275#4,2:118\n561#5:120\n546#5,6:121\n*S KotlinDebug\n*F\n+ 1 ValidPackCollector.kt\ncom/jetbrains/cidr/lang/modulemap/serialization/ValidPackCollector\n*L\n49#1:105,9\n49#1:114\n49#1:116\n49#1:117\n91#1:127\n91#1:128,2\n49#1:115\n85#1:118,2\n90#1:120\n90#1:121,6\n*E\n"})
public final class ValidPackCollector {
    @NotNull
    private final List<ModuleMapAssembledPack> deserializedPacks;
    @NotNull
    private final Map<ModuleMapReference, SerializedModuleMap> refToSerializedModuleMap;
    private final boolean ignoreSetupErrors;

    public ValidPackCollector(@NotNull List<ModuleMapAssembledPack> deserializedPacks, @NotNull Map<ModuleMapReference, SerializedModuleMap> refToSerializedModuleMap, boolean ignoreSetupErrors) {
        Intrinsics.checkNotNullParameter(deserializedPacks, (String)"deserializedPacks");
        Intrinsics.checkNotNullParameter(refToSerializedModuleMap, (String)"refToSerializedModuleMap");
        this.deserializedPacks = deserializedPacks;
        this.refToSerializedModuleMap = refToSerializedModuleMap;
        this.ignoreSetupErrors = ignoreSetupErrors;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ModuleMapAssembledPack> collectValidPacks() {
        void $this$mapNotNullTo$iv$iv;
        MultiMap dependencyMap = new MultiMap();
        Set dirtyMaps = new LinkedHashSet();
        for (ModuleMapAssembledPack pack : this.deserializedPacks) {
            for (Object serializedModuleMap : pack.getData().getAllMaps()) {
                boolean forceIgnoreErrors = pack.isBundledModuleMap((SerializedModuleMap)serializedModuleMap);
                List<SerializedModuleMap> dependencies = this.collectDependencies((SerializedModuleMap)serializedModuleMap, pack.getModuleMapRoot(), forceIgnoreErrors);
                if (dependencies != null) {
                    for (SerializedModuleMap dependency : dependencies) {
                        dependencyMap.putValue((Object)dependency, serializedModuleMap);
                    }
                    continue;
                }
                dirtyMaps.add(serializedModuleMap);
            }
        }
        if (dirtyMaps.isEmpty()) {
            return this.deserializedPacks;
        }
        ArrayDeque<SerializedModuleMap> workset2 = new ArrayDeque<SerializedModuleMap>(dirtyMaps);
        while (!((Collection)workset2).isEmpty()) {
            Collection dependentRoots;
            SerializedModuleMap dirtyMap = (SerializedModuleMap)workset2.pop();
            Intrinsics.checkNotNullExpressionValue((Object)dependencyMap.get((Object)dirtyMap), (String)"get(...)");
            for (SerializedModuleMap map2 : dependentRoots) {
                Intrinsics.checkNotNull((Object)map2);
                if (!dirtyMaps.add(map2)) continue;
                workset2.add(map2);
            }
        }
        Function1 dirtyPredicate = arg_0 -> ValidPackCollector.collectValidPacks$lambda$0(dirtyMaps, arg_0);
        Iterable $this$mapNotNull$iv = this.deserializedPacks;
        boolean $i$f$mapNotNull = false;
        Iterable map2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ModuleMapAssembledPack it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ModuleMapAssembledPack pack = (ModuleMapAssembledPack)element$iv$iv;
            boolean bl2 = false;
            if (this.removeDirtyMaps(pack, (Function1<? super SerializedModuleMap, Boolean>)dirtyPredicate) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<SerializedModuleMap> collectDependencies(SerializedModuleMap serializedModuleMap, ModuleMapRoot moduleMapRoot, boolean forceIgnoreErrors) {
        List result = new ArrayList();
        Sequence<ModuleMapReference> dependencies = this.getDependencies(serializedModuleMap);
        for (ModuleMapReference dependencyRef : dependencies) {
            SerializedModuleMap dependency = this.refToSerializedModuleMap.get(dependencyRef);
            if (dependency == null) {
                if (this.ignoreSetupErrors || forceIgnoreErrors) {
                    if (StringsKt.endsWith$default((String)dependencyRef.getModuleMapRootReference().getUid-knzGXSs(), (String)"include/c++/v1:false", (boolean)false, (int)2, null)) continue;
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        ModuleMapLog.LOG.error("Missing dependency: " + dependencyRef + " of root " + ModuleMapUtil.getRootText(moduleMapRoot));
                        continue;
                    }
                    ModuleMapLog.LOG.warn("Missing dependency: " + dependencyRef + " of root " + ModuleMapUtil.getRootText(moduleMapRoot));
                    continue;
                }
                if (ModuleMapLog.LOG.isTraceEnabled()) {
                    ModuleMapLog.LOG.trace("Missing dependency: " + dependencyRef + " of root " + ModuleMapUtil.getRootText(moduleMapRoot));
                }
                return null;
            }
            result.add(dependency);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final ModuleMapAssembledPack removeDirtyMaps(ModuleMapAssembledPack pack, Function1<? super SerializedModuleMap, Boolean> dirtyPredicate) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNotTo$iv$iv2;
        boolean bl;
        Object object;
        block5: {
            Sequence<SerializedModuleMap> $this$none$iv = pack.getData().getAllMaps();
            boolean $i$f$none = false;
            object = $this$none$iv.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                if (!((Boolean)dirtyPredicate.invoke(element$iv)).booleanValue()) continue;
                bl = false;
                break block5;
            }
            bl = true;
        }
        if (bl) {
            return pack;
        }
        SerializedModuleMap serializedModuleMap = pack.getData().getGlobalMap();
        Object globalMap = serializedModuleMap != null ? (!((Boolean)dirtyPredicate.invoke(object = serializedModuleMap)).booleanValue() ? object : null) : null;
        Map<ModuleMapPlatformType, SerializedModuleMap> $this$filterNot$iv = pack.getData().getBundledMaps();
        boolean $i$f$filterNot = false;
        Map<ModuleMapPlatformType, SerializedModuleMap> map2 = $this$filterNot$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        Iterator iterator2 = $this$filterNotTo$iv$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            SerializedModuleMap map3 = (SerializedModuleMap)entry.getValue();
            if (((Boolean)dirtyPredicate.invoke((Object)map3)).booleanValue()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map bundledMaps = destination$iv$iv;
        Iterable $this$filterNot$iv2 = pack.getData().getProjectMaps();
        boolean $i$f$filterNot2 = false;
        destination$iv$iv = $this$filterNot$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo2 = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            if (((Boolean)dirtyPredicate.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List projectMaps = (List)destination$iv$iv2;
        if (globalMap == null && projectMaps.isEmpty() && bundledMaps.isEmpty()) {
            return null;
        }
        return new ModuleMapAssembledPack(new ModuleMapAssembledPack.AssembledData.NonEmptyData((SerializedModuleMap)globalMap, bundledMaps, projectMaps), pack.getModuleMapRoot(), pack.getHash-B2c4rzk(), null);
    }

    private final Sequence<ModuleMapReference> getDependencies(SerializedModuleMap $this$dependencies) {
        return SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)$this$dependencies.getModuleInfos()), ValidPackCollector::_get_dependencies_$lambda$3), ValidPackCollector::_get_dependencies_$lambda$4));
    }

    private static final boolean collectValidPacks$lambda$0(Set $dirtyMaps, SerializedModuleMap map2) {
        Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
        return $dirtyMaps.contains(map2);
    }

    private static final Iterable _get_dependencies_$lambda$3(ModuleInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDependencies();
    }

    private static final ModuleMapReference _get_dependencies_$lambda$4(ModuleReference it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getModuleMapReference();
    }
}

