/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.navigation.OCSymbolPresentation;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00000\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001b\u001a\u00020\u0015H\u0016J\u0011\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u001f\u001a\u00020\u0015H\u0016J\b\u0010 \u001a\u00020\u0019H\u0002J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\u001d\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010$\u001a\u00020\u00112\b\u0010\u001e\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006'"}, d2={"Lcom/jetbrains/cidr/lang/navigation/OCSymbolNavigationItem;", "Lcom/intellij/navigation/PsiElementNavigationItem;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "", "symbol", "Lcom/jetbrains/cidr/lang/symbols/OCSymbol;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/jetbrains/cidr/lang/symbols/OCSymbol;Lcom/intellij/openapi/project/Project;)V", "getSymbol", "()Lcom/jetbrains/cidr/lang/symbols/OCSymbol;", "getProject", "()Lcom/intellij/openapi/project/Project;", "navigate", "", "requestFocus", "", "canNavigate", "canNavigateToSource", "getName", "", "getPresentation", "Lcom/jetbrains/cidr/lang/navigation/OCSymbolPresentation;", "getTargetElement", "Lcom/jetbrains/cidr/lang/symbols/OCSymbolHolderVirtualPsiElement;", "getData", "dataId", "compareTo", "", "other", "toString", "createFakePsiElement", "component1", "component2", "copy", "equals", "", "hashCode", "intellij.c.core"})
public final class OCSymbolNavigationItem
implements PsiElementNavigationItem,
DataProvider,
Comparable<OCSymbolNavigationItem> {
    @NotNull
    private final OCSymbol symbol;
    @NotNull
    private final Project project;

    public OCSymbolNavigationItem(@NotNull OCSymbol symbol, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.symbol = symbol;
        this.project = project;
    }

    @NotNull
    public final OCSymbol getSymbol() {
        return this.symbol;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void navigate(boolean requestFocus) {
        this.createFakePsiElement().navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.createFakePsiElement().canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @NotNull
    public String getName() {
        String string = this.symbol.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public OCSymbolPresentation getPresentation() {
        return new OCSymbolPresentation(this.symbol, this.project);
    }

    @NotNull
    public OCSymbolHolderVirtualPsiElement getTargetElement() {
        return this.createFakePsiElement();
    }

    @Nullable
    public OCSymbolHolderVirtualPsiElement getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return CommonDataKeys.PSI_ELEMENT.is(dataId) ? this.createFakePsiElement() : null;
    }

    @Override
    public int compareTo(@NotNull OCSymbolNavigationItem other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return OCSymbol.PRESENTABLE_NAME_COMPARATOR.compare(this.symbol, other.symbol);
    }

    @NotNull
    public String toString() {
        return this.getPresentation().getPresentableText();
    }

    private final OCSymbolHolderVirtualPsiElement createFakePsiElement() {
        return new OCSymbolHolderVirtualPsiElement(this.symbol, this.project);
    }

    @NotNull
    public final OCSymbol component1() {
        return this.symbol;
    }

    @NotNull
    public final Project component2() {
        return this.project;
    }

    @NotNull
    public final OCSymbolNavigationItem copy(@NotNull OCSymbol symbol, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new OCSymbolNavigationItem(symbol, project);
    }

    public static /* synthetic */ OCSymbolNavigationItem copy$default(OCSymbolNavigationItem oCSymbolNavigationItem, OCSymbol oCSymbol, Project project, int n, Object object) {
        if ((n & 1) != 0) {
            oCSymbol = oCSymbolNavigationItem.symbol;
        }
        if ((n & 2) != 0) {
            project = oCSymbolNavigationItem.project;
        }
        return oCSymbolNavigationItem.copy(oCSymbol, project);
    }

    public int hashCode() {
        int result = this.symbol.hashCode();
        result = result * 31 + this.project.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OCSymbolNavigationItem)) {
            return false;
        }
        OCSymbolNavigationItem oCSymbolNavigationItem = (OCSymbolNavigationItem)other;
        if (!Intrinsics.areEqual((Object)this.symbol, (Object)oCSymbolNavigationItem.symbol)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.project, (Object)oCSymbolNavigationItem.project);
    }
}

