/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.introduce;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.daemon.OCConstantExpressionVisitor;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseExpressionInplaceIntroducer;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConstantInplaceIntroducer
extends OCBaseExpressionInplaceIntroducer<OCDeclarator, OCExpression> {
    private JCheckBox myStaticCB;
    private JCheckBox myConstexprCB;
    private JCheckBox myAutoCB;

    public OCConstantInplaceIntroducer(Project project, Editor editor, OCExpression expression, List<OCExpression> occurrences, @NlsContexts.Command String refactoringName) {
        super(project, editor, expression, occurrences, OCDeclarator.class, OCExpression.class, refactoringName);
    }

    private static boolean supportsAutoType(@NotNull PsiFile file) {
        if (file == null) {
            OCConstantInplaceIntroducer.$$$reportNull$$$0(0);
        }
        return OCCompilerFeaturesHelper.supportsCAutoType(file) || OCCompilerFeaturesHelper.supportsCxxAutoType(file);
    }

    private static boolean supportsConstexpr(@NotNull PsiFile file) {
        if (file == null) {
            OCConstantInplaceIntroducer.$$$reportNull$$$0(1);
        }
        return OCCompilerFeaturesHelper.supportsCConstexpr(file) || OCCompilerFeaturesHelper.supportsCxxConstexpr(file);
    }

    @Override
    public void configurePanel() {
        super.configurePanel();
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Editor)this.myEditor).getCustomSettings(OCCodeStyleSettings.class);
        OCFile containingFile = ((OCExpression)this.myExpr).getContainingOCFile();
        this.myStaticCB = this.createCheckBox(OCRefactoringBundle.message("refactoring.introduce.constant.static.declaration", new Object[0]), settings.INTRODUCE_STATIC_CONSTS, () -> {
            settings.INTRODUCE_STATIC_CONSTS = this.myStaticCB.isSelected();
            this.rebuildDeclaration();
        });
        this.myConstexprCB = this.createCheckBox(OCRefactoringBundle.message("refactoring.introduce.constant.constexpr.declaration", new Object[0]), settings.INTRODUCE_CONSTEXPR_CONSTS, () -> {
            settings.INTRODUCE_CONSTEXPR_CONSTS = this.myConstexprCB.isSelected();
            this.rebuildDeclaration();
        });
        this.myConstexprCB.setVisible(OCConstantInplaceIntroducer.supportsConstexpr(containingFile));
        this.myAutoCB = this.createCheckBox(OCRefactoringBundle.message("refactoring.introduce.constant.auto.declaration", new Object[0]), settings.INTRODUCE_AUTO_CONSTS, () -> {
            settings.INTRODUCE_AUTO_CONSTS = this.myAutoCB.isSelected();
            this.rebuildDeclaration();
        });
        this.myAutoCB.setVisible(OCConstantInplaceIntroducer.supportsAutoType(containingFile));
    }

    private void rebuildDeclaration() {
        OCDeclarator declarator = (OCDeclarator)this.getVariable();
        if (declarator != null) {
            OCDeclaration newDeclaration = this.createDeclaration(declarator.getName(), declarator.getInitializer());
            OCChangeUtil.replaceHandlingMacros(declarator.getParent(), newDeclaration);
        }
    }

    @Override
    protected OCSymbolKind getDeclaratorKind() {
        return OCSymbolKind.GLOBAL_VARIABLE;
    }

    @Override
    @Nullable
    protected String checkExpression(OCExpression expression) {
        String message = this.checkType();
        if (message != null) {
            return message;
        }
        if (!new OCConstantExpressionVisitor(){

            @Override
            protected boolean isConstDeclarator(OCReferenceExpression expression, OCSymbol symbol) {
                return super.isConstDeclarator(expression, symbol) && symbol.isGlobal();
            }
        }.isConstant(expression)) {
            return OCRefactoringBundle.message("selected.expression.cannot.be.a.constant.initializer", new Object[0]);
        }
        return null;
    }

    @Override
    public PsiElement evaluateAnchor() {
        OCElement parent = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)this.getCommonContext(), (boolean)false, (Class[])new Class[]{OCCppNamespace.class, OCFile.class});
        return parent != null ? this.findAnchor(parent) : null;
    }

    private OCDeclaration createDeclaration(String name, OCExpression initializer) {
        OCFile containingFile = ((OCExpression)this.myExpr).getContainingOCFile();
        ArrayList<String> modifiers = new ArrayList<String>();
        if (this.myStaticCB.isSelected()) {
            modifiers.add("static");
        }
        if (this.myConstexprCB.isSelected() && OCConstantInplaceIntroducer.supportsConstexpr(containingFile)) {
            modifiers.add("constexpr");
        }
        OCType type = this.myAutoCB.isSelected() && OCConstantInplaceIntroducer.supportsAutoType(containingFile) ? new OCAutoType().cloneWithConstModifier(this.myProject) : this.myExprType.cloneWithConstModifier(this.myProject);
        Object declarationText = OCElementFactory.declarationText(modifiers, name, type, "0", initializer, null, false);
        if (((String)(declarationText = OCElementFactory.declarationFromText((String)declarationText, initializer, true).getTextWithMacros())).endsWith("0;")) {
            declarationText = ((String)declarationText).substring(0, ((String)declarationText).length() - 2) + initializer.getTextWithMacros() + ";";
        } else {
            LOG.error((String)declarationText);
        }
        return OCElementFactory.declarationFromText((String)declarationText, initializer);
    }

    private OCDeclaration doIntroduce(String name, boolean isPreview) {
        OCExpression mainExpression = (OCExpression)this.getMainExpression();
        PsiElement anchor = this.getAnchor();
        OCDeclaration declarationInFragment = this.createDeclaration(name, mainExpression);
        OCDeclaration declarationInFile = OCChangeUtil.addBefore(this.getAnchorParent(anchor, isPreview), declarationInFragment, anchor);
        OCChangeUtil.addNewLineIfNeed(declarationInFile, true);
        if (isPreview) {
            this.setVariable(declarationInFile.getDeclarators().get(0));
        }
        return declarationInFile;
    }

    @Override
    protected void introduceForPreview(String name) {
        this.doIntroduce(name, true);
    }

    @Override
    protected void introduceForReal(String name) {
        OCDeclaration declaration = this.doIntroduce(name, false);
        OCImportSymbolFix.fixAllSymbolsRecursively(declaration);
        for (OCExpression expression : (OCExpression[])this.myOccurrences) {
            OCChangeUtil.replaceHandlingMacros(expression, OCElementFactory.expressionFromText(name, expression));
        }
    }

    @Override
    @NotNull
    protected String getFeatureID() {
        return "refactoring.introduceConstant";
    }

    @Override
    public PsiElement getPreviewElement(OCDeclarator element) {
        return element.getParent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "file";
        objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/introduce/OCConstantInplaceIntroducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "supportsAutoType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "supportsConstexpr";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

