/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbolImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithParentAndSubstitution;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbolImpl;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCUnknownExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCExceptionSpecificationInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFunctionSymbol
extends OCTemplateSymbolImpl
implements OCSymbolWithParentAndSubstitution {
    public static final String ATTRIBUTE_IMPLICIT_BRIDGING = "ImplicitBridging";
    public static final Set<String> ENTRY_POINTS = Set.of("main", "wmain", "WinMain", "wWinMain");
    private OCFunctionType myType;
    @Nullable
    private List<? extends OCTypeArgument> myTemplateSpecialization;
    private OCSymbolKind myKind;
    private int myPropertiesAndAttributes;
    @NotNull
    private OCTypeSubstitution mySubstitution;
    private List<Object> myDefaultValues;
    @Nullable
    private OCSymbol myUsingParent;

    public OCFunctionSymbol() {
        this.mySubstitution = OCTypeSubstitution.ID;
    }

    /*
     * WARNING - void declaration
     */
    public OCFunctionSymbol(@Nullable VirtualFile file, long offset, @Nullable OCSymbolWithQualifiedName container, @NotNull OCQualifiedName name, @NotNull List<OCTypeParameterSymbol> templateParameters, @Nullable List<? extends OCTypeArgument> templateSpecialization, int functionProperties, int functionAttributes, @NotNull List<String> attributes, @NotNull OCFunctionType type, @NotNull List<Object> defaultValues, OCSymbolKind kind, @Nullable OCVisibility oCVisibility) {
        void visibility;
        if (name == null) {
            OCFunctionSymbol.$$$reportNull$$$0(0);
        }
        if (templateParameters == null) {
            OCFunctionSymbol.$$$reportNull$$$0(1);
        }
        if (attributes == null) {
            OCFunctionSymbol.$$$reportNull$$$0(2);
        }
        if (type == null) {
            OCFunctionSymbol.$$$reportNull$$$0(3);
        }
        if (defaultValues == null) {
            OCFunctionSymbol.$$$reportNull$$$0(4);
        }
        super(file, offset, container, name, templateParameters, attributes, (OCVisibility)visibility);
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myType = type;
        this.myTemplateSpecialization = templateSpecialization;
        this.myDefaultValues = defaultValues;
        this.myKind = kind;
        this.myPropertiesAndAttributes = functionProperties | functionAttributes;
    }

    protected OCFunctionSymbol(@NotNull OCFunctionSymbol origin, @NotNull OCTypeSubstitution substitution, @Nullable OCSymbolWithQualifiedName parent) {
        if (origin == null) {
            OCFunctionSymbol.$$$reportNull$$$0(5);
        }
        if (substitution == null) {
            OCFunctionSymbol.$$$reportNull$$$0(6);
        }
        super(origin.getContainingFile(), origin.getComplexOffset(), parent, origin.getQualifiedName(), origin.getTemplateParameters(), origin.getAttributes(), origin.getVisibility());
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myType = origin.myType;
        this.myDefaultValues = origin.myDefaultValues;
        this.myTemplateSpecialization = origin.myTemplateSpecialization;
        this.myKind = origin.myKind;
        this.myPropertiesAndAttributes = origin.myPropertiesAndAttributes;
        this.mySubstitution = substitution;
    }

    @Override
    @NotNull
    public OCFunctionSymbol cloneWithSubstitution(@NotNull OCTypeSubstitution substitution, @Nullable OCSymbolWithQualifiedName parent) {
        if (substitution == null) {
            OCFunctionSymbol.$$$reportNull$$$0(7);
        }
        return new OCFunctionSymbol(this, substitution, parent);
    }

    @Override
    public boolean isConst() {
        return this.myType.isConst();
    }

    public boolean isVolatile() {
        return this.myType.isVolatile();
    }

    public boolean isConstexpr() {
        return this.hasAttribute(OCSymbolAttribute.CONSTEXPR);
    }

    public boolean isConsteval() {
        return this.hasAttribute(OCSymbolAttribute.CONSTEVAL);
    }

    public boolean isVirtual() {
        return this.hasAttribute(OCSymbolAttribute.VIRTUAL);
    }

    @Override
    public boolean isStatic() {
        return this.hasAttribute(OCSymbolAttribute.STATIC);
    }

    public boolean isExplicit() {
        return this.hasAttribute(OCSymbolAttribute.EXPLICIT);
    }

    public boolean isDefault() {
        return this.hasAttribute(OCSymbolAttribute.DEFAULT);
    }

    public boolean isDelete() {
        return this.hasAttribute(OCSymbolAttribute.DELETE);
    }

    @Override
    public boolean isFriend() {
        return this.hasAttribute(OCSymbolAttribute.FRIEND);
    }

    public boolean isFinal() {
        return this.hasAttribute(OCSymbolAttribute.FINAL);
    }

    public boolean isOverride() {
        return this.hasAttribute(OCSymbolAttribute.OVERRIDE);
    }

    public boolean isInline() {
        return this.hasAttribute(OCSymbolAttribute.INLINE);
    }

    public boolean isExtern() {
        return this.hasAttribute(OCSymbolAttribute.EXTERN);
    }

    public boolean isNoReturn() {
        return this.hasAttribute(OCSymbolAttribute.NORETURN) || super.hasAttribute("noreturn");
    }

    public boolean isCudaKernel() {
        return this.hasAttribute("global");
    }

    public boolean isPureVirtual() {
        return this.hasProperty(Property.IS_PURE_VIRTUAL);
    }

    public boolean isCppConversionOperator() {
        return this.hasProperty(Property.IS_CONVERSION_OPERATOR);
    }

    @Override
    public boolean isTemplateSymbol() {
        return this.hasProperty(Property.IS_TEMPLATE);
    }

    public boolean isCppOperator() {
        return this.hasProperty(Property.IS_OPERATOR);
    }

    public boolean isUDL() {
        return this.hasProperty(Property.IS_UDL);
    }

    @Override
    public boolean isFromUsing() {
        return this.hasProperty(Property.IS_FROM_USING);
    }

    public boolean isVararg() {
        return this.myType.isVararg();
    }

    public boolean hasAttribute(@NotNull OCSymbolAttribute attr) {
        if (attr == null) {
            OCFunctionSymbol.$$$reportNull$$$0(8);
        }
        return (this.myPropertiesAndAttributes & attr.getMask()) != 0;
    }

    public boolean hasProperty(@NotNull Property property) {
        if (property == null) {
            OCFunctionSymbol.$$$reportNull$$$0(9);
        }
        return (this.myPropertiesAndAttributes & property.getMask()) != 0;
    }

    public boolean isCppMemberOperator(@NotNull OCResolveContext context) {
        if (context == null) {
            OCFunctionSymbol.$$$reportNull$$$0(10);
        }
        return this.isCppOperator() && this.isMember(context, false);
    }

    public boolean isCppNonMemberOperator(@NotNull OCResolveContext context) {
        if (context == null) {
            OCFunctionSymbol.$$$reportNull$$$0(11);
        }
        return this.isCppOperator() && !this.isCppMemberOperator(context);
    }

    public void setType(OCFunctionType type) {
        this.myType = type;
    }

    public void setDefaultValues(@NotNull List<Object> defaultValues) {
        if (defaultValues == null) {
            OCFunctionSymbol.$$$reportNull$$$0(12);
        }
        this.myDefaultValues = defaultValues;
    }

    @Nullable
    public OCFunctionDeclaration locateFunctionDefinition(@NotNull Project project) {
        PsiElement declarator;
        if (project == null) {
            OCFunctionSymbol.$$$reportNull$$$0(13);
        }
        PsiElement parent = (declarator = this.locateDefinition(project)) != null ? declarator.getParent() : null;
        return parent instanceof OCFunctionDeclaration ? (OCFunctionDeclaration)parent : null;
    }

    @Override
    @Nullable
    public List<OCTypeArgument> getTemplateSpecialization() {
        return this.myTemplateSpecialization != null ? List.copyOf(this.myTemplateSpecialization) : null;
    }

    public boolean isCppConstructor() {
        return this.getKind().isConstructorOrDestructor() && !this.isCppDestructor();
    }

    public boolean isCppDestructor() {
        return this.getName().startsWith("~");
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCFunctionSymbol.$$$reportNull$$$0(14);
        }
        if (first == null) {
            OCFunctionSymbol.$$$reportNull$$$0(15);
        }
        if (second == null) {
            OCFunctionSymbol.$$$reportNull$$$0(16);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCFunctionSymbol f = (OCFunctionSymbol)first;
        OCFunctionSymbol s = (OCFunctionSymbol)second;
        if (f.myPropertiesAndAttributes != s.myPropertiesAndAttributes) {
            return false;
        }
        if (!Comparing.equal((Object)((Object)f.myKind), (Object)((Object)s.myKind))) {
            return false;
        }
        if (!Comparing.equal(f.myDefaultValues, s.myDefaultValues)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        if (!c.equalLists(f.myTemplateParameters, s.myTemplateParameters)) {
            return false;
        }
        if (!c.equalLists(f.myTemplateSpecialization, s.myTemplateSpecialization)) {
            return false;
        }
        return c.equalObjects(f.myType, s.myType);
    }

    @Nullable
    public OCFunctionSymbol getDeclarationInParent(@NotNull OCResolveContext context) {
        if (context == null) {
            OCFunctionSymbol.$$$reportNull$$$0(17);
        }
        if (this.isPredeclaration() && !this.isFriend()) {
            return this;
        }
        OCSymbolWithQualifiedName owner = this.getResolvedOwner(context);
        Ref result = new Ref(null);
        if (owner instanceof OCNamespaceSymbol) {
            OCType resolvedType = this.getResolvedType(context);
            ((OCNamespaceSymbol)owner).processMembers(this.getName(), (Processor<? super OCSymbol>)((Processor)symbol -> {
                if (symbol instanceof OCFunctionSymbol) {
                    OCType symbolType = symbol.getType().resolve(context);
                    if (!new OCTypeEqualityVisitor(symbolType, true, context).equal(resolvedType)) {
                        return true;
                    }
                    result.set((Object)((OCFunctionSymbol)symbol));
                    return false;
                }
                return true;
            }));
        }
        return (OCFunctionSymbol)result.get();
    }

    public boolean resolveIsFriendOrStatic(@NotNull OCResolveContext context) {
        if (context == null) {
            OCFunctionSymbol.$$$reportNull$$$0(18);
        }
        if (this.isFriendOrStatic() || this.getQualifier() == null) {
            return this.isFriendOrStatic();
        }
        OCFunctionSymbol predef = this.getDeclarationInParent(context);
        return predef != null && predef.isFriendOrStatic();
    }

    public boolean resolveIsStatic(@NotNull OCResolveContext context) {
        if (context == null) {
            OCFunctionSymbol.$$$reportNull$$$0(19);
        }
        if (this.isStatic() || this.getQualifier() == null) {
            return this.isStatic();
        }
        OCFunctionSymbol predef = this.getDeclarationInParent(context);
        return predef != null && predef.isStatic();
    }

    @Override
    public void updateOffset(int start, int lengthShift) {
        super.updateOffset(start, lengthShift);
        for (OCTypeParameterSymbol templateParameter : this.myTemplateParameters) {
            templateParameter.updateOffset(start, lengthShift);
        }
    }

    @Override
    public void compact() {
        super.compact();
        this.myType.compact();
        this.myTemplateSpecialization = ContainerUtil.trimToSize(this.myTemplateSpecialization);
        this.myDefaultValues = ContainerUtil.trimToSize(this.myDefaultValues);
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = this.myKind;
        if (oCSymbolKind == null) {
            OCFunctionSymbol.$$$reportNull$$$0(20);
        }
        return oCSymbolKind;
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        boolean isConst = this.myParent instanceof OCStructSymbol && !this.isCppConstructor() && !this.isCppDestructor() && this.isConst();
        return OCIcons.getFunctionIcon(this.isFriendOrStatic(), this.isPureVirtual(), isConst, this.getVisibility());
    }

    @Override
    public Icon computeFullIconNow(@Nullable PsiElement symbolElement, @NotNull Project project) {
        Icon result;
        if (project == null) {
            OCFunctionSymbol.$$$reportNull$$$0(21);
        }
        if ((result = super.computeFullIconNow(symbolElement, project)) == null) {
            return null;
        }
        if (symbolElement instanceof OCDeclarator) {
            PsiElement parent = symbolElement.getParent();
            symbolElement = parent instanceof OCFunctionDeclaration ? (OCFunctionDeclaration)parent : null;
        }
        return OCTestFrameworks.isTestMethodOrFunction(this, symbolElement, project) ? OCIcons.getTestIcon(result) : result;
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        OCTypeSubstitution oCTypeSubstitution = this.mySubstitution;
        if (oCTypeSubstitution == null) {
            OCFunctionSymbol.$$$reportNull$$$0(22);
        }
        return oCTypeSubstitution;
    }

    @NotNull
    public OCFunctionSymbol setProperty(Property property) {
        OCFunctionSymbol result = (OCFunctionSymbol)this.cloneWithSubstitution(this.getSubstitution());
        result.myPropertiesAndAttributes |= property.getMask();
        OCFunctionSymbol oCFunctionSymbol = result;
        if (oCFunctionSymbol == null) {
            OCFunctionSymbol.$$$reportNull$$$0(23);
        }
        return oCFunctionSymbol;
    }

    @NotNull
    public OCFunctionSymbol setVisibility(OCVisibility visibility) {
        this.myVisibility = visibility;
        OCFunctionSymbol oCFunctionSymbol = this;
        if (oCFunctionSymbol == null) {
            OCFunctionSymbol.$$$reportNull$$$0(24);
        }
        return oCFunctionSymbol;
    }

    public OCFunctionSymbol setUsingParent(OCSymbol usingParent) {
        this.myUsingParent = usingParent;
        return this;
    }

    @Override
    @Nullable
    public OCSymbol getUsingParent() {
        if (this.isFromUsing()) {
            return this.myUsingParent;
        }
        return null;
    }

    public int getFunctionAttributes() {
        return 0xFFFFFF & this.myPropertiesAndAttributes;
    }

    public int getFunctionProperties() {
        return 0xFF000000 & this.myPropertiesAndAttributes;
    }

    @Override
    @NotNull
    public OCFunctionType getType() {
        OCFunctionType oCFunctionType = (OCFunctionType)this.mySubstitution.substitute(this.myType);
        if (oCFunctionType == null) {
            OCFunctionSymbol.$$$reportNull$$$0(25);
        }
        return oCFunctionType;
    }

    @NotNull
    public OCFunctionType getTypeWithoutSubstitution() {
        OCFunctionType oCFunctionType = this.myType;
        if (oCFunctionType == null) {
            OCFunctionSymbol.$$$reportNull$$$0(26);
        }
        return oCFunctionType;
    }

    @NotNull
    private List<OCDeclaratorSymbol> buildParameterSymbols() {
        ArrayList<OCDeclaratorSymbol> params = new ArrayList<OCDeclaratorSymbol>();
        List<OCType> parameterTypes = this.myType.getParameterTypes(true);
        List<String> parameterNames = this.myType.getParameterNames();
        for (int i = 0; i < parameterTypes.size(); ++i) {
            Object value;
            String name = parameterNames != null && i < parameterNames.size() ? parameterNames.get(i) : "";
            int defaultValueIndex = i + this.myDefaultValues.size() - parameterTypes.size();
            OCExpressionSymbol initializer = defaultValueIndex >= 0 ? ((value = this.myDefaultValues.get(defaultValueIndex)) instanceof OCExpressionSymbol ? (OCExpressionSymbol)value : new OCUnknownExpressionSymbol(this.myFile, -1L, value.toString())) : null;
            params.add(new OCDeclaratorSymbolImpl(this.myFile, -1L, this.dropSubstitutionTransitive(), OCQualifiedName.with(name), Collections.emptyList(), parameterTypes.get(i), OCSymbolKind.PARAMETER, initializer, Collections.emptyList(), Collections.emptyList(), OCDeclaratorSymbol.Property.IS_ENCODED_PARAM_INDEX.getMask(), i, null, null));
        }
        ArrayList<OCDeclaratorSymbol> arrayList = params;
        if (arrayList == null) {
            OCFunctionSymbol.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @NotNull
    public List<OCDeclaratorSymbol> getParameterSymbols() {
        List<OCDeclaratorSymbol> list = this.mySubstitution.substitute(this.buildParameterSymbols());
        if (list == null) {
            OCFunctionSymbol.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    public List<OCDeclaratorSymbol> getParameterSymbols(@NotNull OCResolveContext context) {
        if (context == null) {
            OCFunctionSymbol.$$$reportNull$$$0(29);
        }
        ArrayList<OCDeclaratorSymbol> result = new ArrayList<OCDeclaratorSymbol>();
        for (OCDeclaratorSymbol param : this.mySubstitution.substitute(this.buildParameterSymbols(), context)) {
            OCType paramType = param.getType().getTerminalType();
            if (paramType instanceof OCVariadicType) {
                int expansionsCnt = OCArgumentsList.expandVariadicTypes(Collections.singletonList(paramType), context).size();
                for (int i = 0; i < expansionsCnt; ++i) {
                    result.add(param);
                }
                continue;
            }
            result.add(param);
        }
        ArrayList<OCDeclaratorSymbol> arrayList = result;
        if (arrayList == null) {
            OCFunctionSymbol.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    public List<Object> getDefaultValues() {
        return this.myDefaultValues;
    }

    public int getNonInitializedParametersCount(@Nullable OCResolveContext context) {
        String name = this.getName();
        if (!(!name.equals("operator++") && !name.equals("operator--") || context != null && context.getElement() instanceof OCReferenceElement && ((OCReferenceElement)context.getElement()).getName().startsWith("operator"))) {
            return 0;
        }
        return OCTypeUtils.getNonInitializedParametersCount(this.getParameterSymbols(), context);
    }

    @Override
    @NotNull
    public OCType getEffectiveType(@NotNull Project project) {
        if (project == null) {
            OCFunctionSymbol.$$$reportNull$$$0(31);
        }
        OCType oCType = this.mySubstitution.substitute(this.myType.getReturnType());
        if (oCType == null) {
            OCFunctionSymbol.$$$reportNull$$$0(32);
        }
        return oCType;
    }

    public OCType getEffectiveType(@NotNull PsiElement context) {
        if (context == null) {
            OCFunctionSymbol.$$$reportNull$$$0(33);
        }
        return OCTypeUtils.changeTypeReferences(this.getEffectiveType(context.getProject()), OCSymbolReference.getLocalReference(this.getName(), context));
    }

    @Override
    @NotNull
    public OCType getEffectiveResolvedType(@NotNull OCResolveContext context) {
        OCType type;
        if (context == null) {
            OCFunctionSymbol.$$$reportNull$$$0(34);
        }
        OCType result = (type = this.getResolvedType(context)) instanceof OCFunctionType ? ((OCFunctionType)type).getReturnType() : type;
        OCType oCType = this.mySubstitution.substitute(result);
        if (oCType == null) {
            OCFunctionSymbol.$$$reportNull$$$0(35);
        }
        return oCType;
    }

    public boolean canBeCalledWithoutArguments() {
        return this.getNonInitializedParametersCount(null) == 0;
    }

    public boolean isSpecialConstructor(@NotNull OCResolveContext context) {
        if (context == null) {
            OCFunctionSymbol.$$$reportNull$$$0(36);
        }
        return this.isCppConstructor() && (OCResolveOverloadsUtil.isCopyOrMoveConstructorOrOperator(this, context) || this.getNonInitializedParametersCount(context) == 0);
    }

    public boolean isMainFunction() {
        return ENTRY_POINTS.contains(this.getName()) && this.getQualifierParent() == null && this.getQualifier() == null;
    }

    public boolean isWinMainFunction() {
        return this.isMainFunction() && !"main".equals(this.getName());
    }

    @Override
    @NotNull
    public String getKindUppercase(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCFunctionSymbol.$$$reportNull$$$0(37);
        }
        String string = this.isCppDestructor() ? OCBundle.message("symbol.kind.name.uppercase.destructor", new Object[0]) : super.getKindUppercase(context);
        if (string == null) {
            OCFunctionSymbol.$$$reportNull$$$0(38);
        }
        return string;
    }

    @Override
    @NotNull
    public String getKindLowercase(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCFunctionSymbol.$$$reportNull$$$0(39);
        }
        String string = this.isCppDestructor() ? OCBundle.message("symbol.kind.name.lowercase.destructor", new Object[0]) : super.getKindLowercase(context);
        if (string == null) {
            OCFunctionSymbol.$$$reportNull$$$0(40);
        }
        return string;
    }

    @Override
    @NotNull
    public String getSignature(@NotNull Project project) {
        if (project == null) {
            OCFunctionSymbol.$$$reportNull$$$0(41);
        }
        StringBuilder buffer = new StringBuilder();
        String typeText = this.getType().getReturnType().getName();
        buffer.append(typeText);
        if (!typeText.endsWith("*")) {
            buffer.append(" ");
        }
        buffer.append(this.getName());
        buffer.append(this.getParametersSignature(project));
        this.getType().getCVQualifiers().appendCVQualifiers(buffer);
        String string = buffer.toString();
        if (string == null) {
            OCFunctionSymbol.$$$reportNull$$$0(42);
        }
        return string;
    }

    @NotNull
    public String getParametersSignature(@NotNull Project project) {
        if (project == null) {
            OCFunctionSymbol.$$$reportNull$$$0(43);
        }
        StringBuilder buffer = new StringBuilder();
        if (this.isCudaKernel()) {
            buffer.append("<<<>>>");
        }
        buffer.append('(');
        boolean isFirst = true;
        for (OCDeclaratorSymbol param : this.getParameterSymbols()) {
            if (!isFirst) {
                buffer.append(", ");
            }
            buffer.append(param.getSignature(project));
            isFirst = false;
        }
        buffer.append(')');
        String string = buffer.toString();
        if (string == null) {
            OCFunctionSymbol.$$$reportNull$$$0(44);
        }
        return string;
    }

    public String getNiceAttributes() {
        ArrayList<String> words = new ArrayList<String>();
        for (OCSymbolAttribute oCSymbolAttribute : OCSymbolAttribute.values()) {
            if (!this.hasAttribute(oCSymbolAttribute)) continue;
            words.add(StringUtil.toLowerCase((String)oCSymbolAttribute.name()));
        }
        for (Enum enum_ : Property.values()) {
            if (!this.hasProperty((Property)enum_)) continue;
            words.add(enum_.name().substring(3));
        }
        return "\u300a" + StringUtil.join(words, (String)" ") + "\u300b";
    }

    @Override
    public String toString() {
        return String.valueOf((Object)this.getKind()) + this.getNiceAttributes() + "[" + this.getName() + "]@" + (String)(this.getContainingFile() != null ? this.getContainingFile().getName() + ":" : "") + this.getOffset();
    }

    @Override
    @NotNull
    public String getPresentableText() {
        String string = this.getSignatureWithoutParamNames();
        if (string == null) {
            OCFunctionSymbol.$$$reportNull$$$0(45);
        }
        return string;
    }

    @NotNull
    public String getSignatureWithoutParamNames() {
        return this.getSignatureWithoutParamNamesImpl(false, true, null);
    }

    @NotNull
    public String getSignatureWithoutParamNames(boolean fullyQualifiedName, boolean addReturnType, @NotNull OCResolveContext context) {
        if (context == null) {
            OCFunctionSymbol.$$$reportNull$$$0(46);
        }
        return this.getSignatureWithoutParamNamesImpl(fullyQualifiedName, addReturnType, context);
    }

    private void addExceptionSpecification(@NotNull StringBuilder buffer) {
        if (buffer == null) {
            OCFunctionSymbol.$$$reportNull$$$0(47);
        }
        OCExceptionSpecificationInfo esi = this.getType().getExceptionSpecification();
        switch (esi.getSpecificationKind()) {
            case None: {
                break;
            }
            case MSAny: {
                buffer.append(" throw(...)");
                break;
            }
            case DynamicNone: {
                buffer.append(" throw()");
                break;
            }
            case Dynamic: {
                buffer.append(" throw(");
                List<OCType> throwTypes = esi.getThrowTypes();
                String typesStr = StringUtil.join(throwTypes, OCType::getName, (String)",");
                buffer.append(typesStr);
                buffer.append(")");
                break;
            }
            case BasicNoexcept: {
                buffer.append(" noexcept");
                break;
            }
            case ComputedNoexcept: {
                buffer.append(" noexcept()");
            }
        }
    }

    @NotNull
    private String getSignatureWithoutParamNamesImpl(boolean fullyQualifiedName, boolean addReturnType, @Nullable OCResolveContext context) {
        StringBuilder buffer = new StringBuilder();
        if (fullyQualifiedName) {
            assert (context != null);
            buffer.append(this.getNameWithParent(context));
        } else {
            buffer.append(this.getName());
        }
        buffer.append(this.getParamsSignatureWithoutNames());
        OCFunctionType functionType = this.getType();
        functionType.getCVQualifiers().appendCVQualifiers(buffer);
        if (functionType.isLValueRef()) {
            buffer.append(" &");
        }
        if (functionType.isRValueRef()) {
            buffer.append(" &&");
        }
        this.addExceptionSpecification(buffer);
        if (addReturnType && !this.isCppConstructor()) {
            buffer.append(" : ");
            if (this.isConstexpr()) {
                buffer.append("constexpr ");
            }
            if (this.isConsteval()) {
                buffer.append("consteval ");
            }
            OCType returnType = this.getReturnType();
            buffer.append(returnType.getName());
        }
        String string = buffer.toString();
        if (string == null) {
            OCFunctionSymbol.$$$reportNull$$$0(48);
        }
        return string;
    }

    @NotNull
    public OCType getReturnType() {
        OCFunctionType functionType = this.getType();
        OCType returnType = functionType.getReturnType();
        if (this.isConstexpr() && returnType instanceof OCAutoType) {
            OCType incomplType = ((OCAutoType)returnType).getIncompleteType();
            OCType oCType = incomplType != null ? incomplType : returnType;
            if (oCType == null) {
                OCFunctionSymbol.$$$reportNull$$$0(49);
            }
            return oCType;
        }
        OCType oCType = returnType;
        if (oCType == null) {
            OCFunctionSymbol.$$$reportNull$$$0(50);
        }
        return oCType;
    }

    @NotNull
    public String getParamsSignatureWithoutNames() {
        StringBuilder buffer = new StringBuilder();
        if (this.isCudaKernel()) {
            buffer.append("<<<>>>");
        }
        buffer.append('(');
        boolean isFirst = true;
        for (OCDeclaratorSymbol param : this.getParameterSymbols()) {
            if (!isFirst) {
                buffer.append(", ");
            }
            buffer.append(param.getType().getName());
            isFirst = false;
        }
        buffer.append(")");
        String string = buffer.toString();
        if (string == null) {
            OCFunctionSymbol.$$$reportNull$$$0(51);
        }
        return string;
    }

    @Override
    public boolean isDefinition() {
        return super.isDefinition() || this.isDefault() || this.isDelete();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 20, 22, 23, 24, 25, 26, 27, 28, 30, 32, 35, 38, 40, 42, 44, 45, 48, 49, 50, 51 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateParameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValues";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitution";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 29: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 21: 
            case 31: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitution";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "setProperty";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "setVisibility";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeWithoutSubstitution";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "buildParameterSymbols";
                break;
            }
            case 28: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterSymbols";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveType";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveResolvedType";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindUppercase";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindLowercase";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignature";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersSignature";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatureWithoutParamNamesImpl";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnType";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamsSignatureWithoutNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithSubstitution";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasAttribute";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasProperty";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isCppMemberOperator";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isCppNonMemberOperator";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultValues";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "locateFunctionDefinition";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationInParent";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveIsFriendOrStatic";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolveIsStatic";
                break;
            }
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "computeFullIconNow";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getParameterSymbols";
                break;
            }
            case 31: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveType";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveResolvedType";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isSpecialConstructor";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getKindUppercase";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getKindLowercase";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getSignature";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getParametersSignature";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getSignatureWithoutParamNames";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addExceptionSpecification";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 20, 22, 23, 24, 25, 26, 27, 28, 30, 32, 35, 38, 40, 42, 44, 45, 48, 49, 50, 51 -> new IllegalStateException(string);
        };
    }

    public static final class Property
    extends Enum<Property> {
        public static final /* enum */ Property IS_TEMPLATE = new Property();
        public static final /* enum */ Property IS_OPERATOR = new Property();
        public static final /* enum */ Property IS_PURE_VIRTUAL = new Property();
        public static final /* enum */ Property IS_CONVERSION_OPERATOR = new Property();
        public static final /* enum */ Property IS_UDL = new Property();
        public static final /* enum */ Property IS_FROM_USING = new Property();
        public static final int DEFAULT = 0;
        private static final /* synthetic */ Property[] $VALUES;

        public static Property[] values() {
            return (Property[])$VALUES.clone();
        }

        public static Property valueOf(String name) {
            return Enum.valueOf(Property.class, name);
        }

        public int getMask() {
            assert (this.ordinal() < 8);
            return 1 << 31 - this.ordinal();
        }

        private static /* synthetic */ Property[] $values() {
            return new Property[]{IS_TEMPLATE, IS_OPERATOR, IS_PURE_VIRTUAL, IS_CONVERSION_OPERATOR, IS_UDL, IS_FROM_USING};
        }

        static {
            $VALUES = Property.$values();
        }
    }
}

