/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.scheduling;

import com.google.common.collect.ImmutableList;
import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.cidr.lang.symbols.symtable.scheduling.UtilKt;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0015B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J#\u0010\r\u001a\u00028\u00002\u0014\u0010\u000e\u001a\u0010\u0012\u0002\b\u00030\u000fR\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0004\u00a2\u0006\u0002\u0010\u0010J&\u0010\u0011\u001a\u00020\u0012*\u0006\u0012\u0002\b\u00030\n2\u0014\u0010\u0013\u001a\u0010\u0012\u0002\b\u00030\u000fR\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0004J\u001e\u0010\u0014\u001a\u00020\u0012*\u0006\u0012\u0002\b\u00030\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0004R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareJob;", "O", "", "estimatedWorksetSize", "", "<init>", "(I)V", "workerQuota", "callerWorkset", "Ljava/util/Deque;", "Ljava/util/concurrent/CountedCompleter;", "shouldPrioritize", "", "run", "rootWorker", "Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareJob$IterativeWorker;", "(Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareJob$IterativeWorker;)Ljava/lang/Object;", "forkAsPending", "", "worker", "scheduleOnCallerAsPending", "IterativeWorker", "intellij.c.core"})
@ApiStatus.Experimental
public abstract class CallerAwareJob<O> {
    private final int workerQuota;
    @NotNull
    private final Deque<CountedCompleter<O>> callerWorkset;
    private boolean shouldPrioritize;

    public CallerAwareJob(int estimatedWorksetSize) {
        this.workerQuota = UtilKt.calculateWorkerQuota(estimatedWorksetSize);
        this.callerWorkset = new ConcurrentLinkedDeque();
    }

    protected final O run(@NotNull IterativeWorker<?> rootWorker) {
        Intrinsics.checkNotNullParameter(rootWorker, (String)"rootWorker");
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"getInstance(...)");
        ProgressManager progressManager2 = progressManager;
        if (progressManager2 instanceof CoreProgressManager) {
            this.shouldPrioritize = ((CoreProgressManager)progressManager2).isCurrentThreadPrioritized();
        }
        rootWorker.fork();
        while (!rootWorker.isDone()) {
            while (true) {
                CountedCompleter<O> callerWorker;
                ProgressManager.checkCanceled();
                if (this.callerWorkset.poll() == null) break;
                try {
                    callerWorker.compute();
                }
                catch (Throwable t) {
                    callerWorker.completeExceptionally(t);
                }
            }
            rootWorker.stealJob();
        }
        return (O)rootWorker.join();
    }

    protected final void forkAsPending(@NotNull CountedCompleter<?> $this$forkAsPending, @NotNull IterativeWorker<?> worker) {
        Intrinsics.checkNotNullParameter($this$forkAsPending, (String)"<this>");
        Intrinsics.checkNotNullParameter(worker, (String)"worker");
        $this$forkAsPending.addToPendingCount(1);
        worker.fork();
    }

    protected final void scheduleOnCallerAsPending(@NotNull CountedCompleter<?> $this$scheduleOnCallerAsPending, @NotNull CountedCompleter<O> worker) {
        Intrinsics.checkNotNullParameter($this$scheduleOnCallerAsPending, (String)"<this>");
        Intrinsics.checkNotNullParameter(worker, (String)"worker");
        $this$scheduleOnCallerAsPending.addToPendingCount(1);
        this.callerWorkset.push(worker);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00a4\u0004\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u00028\u00000\u0003B%\u0012\f\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\f2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u0006H\u0002J(\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00028\u00010\u0000R\b\u0012\u0004\u0012\u00028\u00000\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u0006H$J\u0018\u0010\u0012\u001a\u00020\f2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u0006H$J\b\u0010\u0013\u001a\u00020\fH$R\u001c\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareJob$IterativeWorker;", "I", "", "Ljava/util/concurrent/CountedCompleter;", "parent", "initialWorkset", "Lcom/google/common/collect/ImmutableList;", "<init>", "(Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareJob;Ljava/util/concurrent/CountedCompleter;Lcom/google/common/collect/ImmutableList;)V", "getInitialWorkset", "()Lcom/google/common/collect/ImmutableList;", "stealJob", "", "compute", "firstWorkset", "newWorker", "Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareJob;", "workset", "process", "processingFinished", "intellij.c.core"})
    @SourceDebugExtension(value={"SMAP\nCallerAwareJob.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallerAwareJob.kt\ncom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareJob$IterativeWorker\n+ 2 util.kt\ncom/jetbrains/cidr/lang/symbols/symtable/scheduling/UtilKt\n*L\n1#1,121:1\n30#2,5:122\n48#2,4:127\n*S KotlinDebug\n*F\n+ 1 CallerAwareJob.kt\ncom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareJob$IterativeWorker\n*L\n87#1:122,5\n93#1:127,4\n*E\n"})
    protected abstract class IterativeWorker<I>
    extends CountedCompleter<O> {
        @NotNull
        private final ImmutableList<? extends I> initialWorkset;

        public IterativeWorker(@NotNull CountedCompleter<?> parent, ImmutableList<? extends I> initialWorkset) {
            Intrinsics.checkNotNullParameter(initialWorkset, (String)"initialWorkset");
            super(parent);
            this.initialWorkset = initialWorkset;
        }

        @NotNull
        protected final ImmutableList<? extends I> getInitialWorkset() {
            return this.initialWorkset;
        }

        public final void stealJob() {
            if (ForkJoinTask.getQueuedTaskCount() > 0) {
                this.helpComplete(1);
            } else if (ForkJoinPool.commonPool().getQueuedTaskCount() > 0L || ForkJoinPool.commonPool().hasQueuedSubmissions()) {
                Semaphore s = new Semaphore(1);
                ApplicationManager.getApplication().executeOnPooledThread(() -> IterativeWorker.stealJob$lambda$1(s));
                s.waitFor(100L);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void compute() {
            void quota$iv;
            void $this$splitWorkset$iv;
            ImmutableList<? extends I> immutableList = this.initialWorkset;
            int n = CallerAwareJob.this.workerQuota;
            CallerAwareJob callerAwareJob = CallerAwareJob.this;
            boolean $i$f$splitWorkset = false;
            ImmutableList workset$iv = $this$splitWorkset$iv;
            while (UtilKt.access$splitWorkset(workset$iv, (int)quota$iv) != null) {
                ImmutableList right$iv;
                Pair pair;
                ImmutableList left$iv = (ImmutableList)pair.component1();
                ImmutableList it = right$iv = (ImmutableList)pair.component2();
                boolean bl = false;
                callerAwareJob.forkAsPending(this, this.newWorker(it));
                workset$iv = left$iv;
            }
            void firstWorkset = workset$iv;
            if (firstWorkset.isEmpty()) {
                this.processingFinished();
                return;
            }
            boolean shouldPrioritize$iv = CallerAwareJob.this.shouldPrioritize;
            boolean $i$f$prioritize = false;
            if (shouldPrioritize$iv) {
                ProgressManager.getInstance().computePrioritized(new ThrowableComputable(this, (ImmutableList)firstWorkset){
                    final /* synthetic */ IterativeWorker this$0;
                    final /* synthetic */ ImmutableList $firstWorkset$inlined;
                    {
                        this.this$0 = iterativeWorker;
                        this.$firstWorkset$inlined = immutableList;
                    }

                    public final Unit compute() {
                        boolean bl = false;
                        IterativeWorker.access$compute(this.this$0, this.$firstWorkset$inlined);
                        return Unit.INSTANCE;
                    }
                });
            } else {
                boolean bl = false;
                this.compute((ImmutableList)firstWorkset);
            }
        }

        private final void compute(ImmutableList<? extends I> firstWorkset) {
            this.process(firstWorkset);
            this.processingFinished();
        }

        @NotNull
        protected abstract IterativeWorker<I> newWorker(@NotNull ImmutableList<? extends I> var1);

        protected abstract void process(@NotNull ImmutableList<? extends I> var1);

        protected abstract void processingFinished();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void stealJob$lambda$1(Semaphore $s) {
            AutoCloseable autoCloseable = (AutoCloseable)ThreadContext.resetThreadContext();
            Throwable throwable = null;
            try {
                AccessToken it = (AccessToken)autoCloseable;
                boolean bl = false;
                boolean bl2 = ForkJoinPool.commonPool().awaitQuiescence(0L, TimeUnit.MILLISECONDS);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            $s.up();
        }
    }
}

