/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.Predicate;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCDeductionCandidateSymbol;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.v2.TypeProperties;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolBase;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeductionGuideSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCInitializerSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLambdaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCGenericParameterSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.FindConstructorResult;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCDeferredType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCArrayToPointerChanger;
import com.jetbrains.cidr.lang.types.visitors.OCBooleanTypeVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCNonPrimitiveTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeUnificationVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCTypeUtils {
    @NotNull
    private static final DeepHashingStrategy DEEP_EQUAL_HASHING_STRATEGY = new DeepHashingStrategy();

    @NotNull
    public static <T> HashingStrategy<T> deepEqualHashingStrategy() {
        DeepHashingStrategy deepHashingStrategy = DEEP_EQUAL_HASHING_STRATEGY;
        if (deepHashingStrategy == null) {
            OCTypeUtils.$$$reportNull$$$0(0);
        }
        return deepHashingStrategy;
    }

    @NotNull
    public static <T> Set<T> newSymbolWithSubstitutionSet() {
        return new ObjectOpenCustomHashSet(new Hash.Strategy<T>(){

            public int hashCode(T symbol) {
                if (symbol == null) {
                    return 0;
                }
                return symbol.hashCode() * 31 + (symbol instanceof OCSymbolWithSubstitution ? ((OCSymbolWithSubstitution)symbol).getSubstitution().hashCode() : 0);
            }

            public boolean equals(T o1, T o2) {
                return DeepEqual.equalObjects(o1, o2);
            }
        });
    }

    @NotNull
    public static Set<Pair<OCSymbolReference, OCTypeSubstitution>> newReferenceWithSubstitutionSet() {
        Set set = CollectionFactory.createCustomHashingStrategySet((HashingStrategy)DEEP_EQUAL_HASHING_STRATEGY);
        if (set == null) {
            OCTypeUtils.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public static Map<OCTypeParameterSymbol, OCTypeArgument> newTypeParameterMap() {
        Map map2 = CollectionFactory.createCustomHashingStrategyMap((HashingStrategy)DEEP_EQUAL_HASHING_STRATEGY);
        if (map2 == null) {
            OCTypeUtils.$$$reportNull$$$0(2);
        }
        return map2;
    }

    @NotNull
    public static <T extends OCTypeArgument> Set<T> newTypeSet() {
        Set set = CollectionFactory.createCustomHashingStrategySet((HashingStrategy)DEEP_EQUAL_HASHING_STRATEGY);
        if (set == null) {
            OCTypeUtils.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public static Map<OCType, OCType> newTypesMap() {
        Map map2 = CollectionFactory.createCustomHashingStrategyMap((HashingStrategy)DEEP_EQUAL_HASHING_STRATEGY);
        if (map2 == null) {
            OCTypeUtils.$$$reportNull$$$0(4);
        }
        return map2;
    }

    @NotNull
    public static <TKey, TValue> ConcurrentMap<TKey, TValue> newDeepEqualityMap() {
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap(OCTypeUtils.deepEqualHashingStrategy());
        if (concurrentMap == null) {
            OCTypeUtils.$$$reportNull$$$0(5);
        }
        return concurrentMap;
    }

    public static boolean areSignaturesEqual(@NotNull OCSymbolWithQualifiedName s1, @NotNull OCSymbolWithQualifiedName s2, @NotNull OCResolveContext context, boolean checkFunctionReturnTypes) {
        if (s1 == null) {
            OCTypeUtils.$$$reportNull$$$0(6);
        }
        if (s2 == null) {
            OCTypeUtils.$$$reportNull$$$0(7);
        }
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(8);
        }
        return OCTypeUtils.areSignaturesEqual(s1, s2, context, checkFunctionReturnTypes, false);
    }

    public static boolean isSignaturesConformsTo(@NotNull OCSymbolWithQualifiedName s1, @NotNull OCSymbolWithQualifiedName s2, @NotNull OCResolveContext context, boolean checkFunctionReturnTypes) {
        if (s1 == null) {
            OCTypeUtils.$$$reportNull$$$0(9);
        }
        if (s2 == null) {
            OCTypeUtils.$$$reportNull$$$0(10);
        }
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(11);
        }
        return OCTypeUtils.areSignaturesEqual(s1, s2, context, checkFunctionReturnTypes, true);
    }

    private static boolean areSignaturesEqual(@NotNull OCSymbolWithQualifiedName s1, @NotNull OCSymbolWithQualifiedName s2, @NotNull OCResolveContext context, boolean checkFunctionReturnTypes, boolean conformsTo) {
        List templateParams2;
        if (s1 == null) {
            OCTypeUtils.$$$reportNull$$$0(12);
        }
        if (s2 == null) {
            OCTypeUtils.$$$reportNull$$$0(13);
        }
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(14);
        }
        if ((s1 instanceof OCTemplateSymbol && ((OCTemplateSymbol)((Object)s1)).isTemplateSymbol()) != (s2 instanceof OCTemplateSymbol && ((OCTemplateSymbol)((Object)s2)).isTemplateSymbol())) {
            return false;
        }
        OCQualifiedName fqn1 = s1.getResolvedQualifiedName(false, false, context);
        OCQualifiedName fqn2 = s2.getResolvedQualifiedName(false, false, context);
        if (fqn1 == null || fqn2 == null || !fqn1.equals(fqn2)) {
            return false;
        }
        List parentTemplateParams1 = s1.getParent() == s2.getParent() && s1.getParent() instanceof OCTemplateSymbol ? ((OCTemplateSymbol)((Object)s1.getParent())).getTemplateParameters() : Collections.emptyList();
        List parentTemplateParams2 = s1.getParent() == s2.getParent() && s2.getParent() instanceof OCTemplateSymbol ? ((OCTemplateSymbol)((Object)s2.getParent())).getTemplateParameters() : Collections.emptyList();
        List templateParams1 = s1 instanceof OCTemplateSymbol ? ((OCTemplateSymbol)((Object)s1)).getTemplateParameters() : Collections.emptyList();
        List<Object> list = templateParams2 = s2 instanceof OCTemplateSymbol ? ((OCTemplateSymbol)((Object)s2)).getTemplateParameters() : Collections.emptyList();
        if (templateParams1.size() != templateParams2.size()) {
            return false;
        }
        Map<OCTypeParameterSymbol, OCTypeArgument> map2 = OCTypeUtils.newTypeParameterMap();
        OCType t1 = (s1 instanceof OCFunctionSymbol ? ((OCFunctionSymbol)s1).getTypeWithoutSubstitution() : s1.getType()).resolve(context);
        OCType t2 = (s2 instanceof OCFunctionSymbol ? ((OCFunctionSymbol)s2).getTypeWithoutSubstitution() : s2.getType()).resolve(context);
        if (!new OCTypeUnificationVisitor(false, checkFunctionReturnTypes, false, false, false, t2, null, map2, null, context).unify(t1, t2).isUnified()) {
            return false;
        }
        if (conformsTo) {
            return true;
        }
        if (!new OCTypeUnificationVisitor(false, checkFunctionReturnTypes, false, false, false, t1, null, new HashMap<OCTypeParameterSymbol, OCTypeArgument>(), null, context).unify(t2, t1).isUnified()) {
            return false;
        }
        block0: for (Map.Entry<OCTypeParameterSymbol, OCTypeArgument> each : map2.entrySet()) {
            if (!(each.getValue() instanceof OCTypeParameterType)) {
                return false;
            }
            OCTypeParameterSymbol key = each.getKey();
            OCTypeParameterSymbol value = ((OCTypeParameterType)each.getValue()).getSymbol();
            if (!(s1.getParent() != s2.getParent() || Objects.equals(key.getName(), value.getName()) || templateParams1.contains(key) || templateParams2.contains(value))) {
                return false;
            }
            while (key != null && value != null) {
                if (templateParams1.indexOf(key) != templateParams2.indexOf(value)) {
                    return false;
                }
                if (parentTemplateParams1.indexOf(key) != parentTemplateParams2.indexOf(value)) {
                    return false;
                }
                if (!(key instanceof OCTypeParameterTypeSymbol) || !(value instanceof OCTypeParameterTypeSymbol)) continue block0;
                key = ((OCTypeParameterTypeSymbol)key).getQualifierTypeParameter();
                value = ((OCTypeParameterTypeSymbol)value).getQualifierTypeParameter();
            }
        }
        for (int i = 0; i < templateParams1.size(); ++i) {
            OCType pt1 = ((OCTypeParameterSymbol)templateParams1.get(i)).getType().resolve(context);
            OCType pt2 = ((OCTypeParameterSymbol)templateParams2.get(i)).getType().resolve(context);
            if (pt1 instanceof OCTypeParameterType && pt2 instanceof OCTypeParameterType || pt1.equals(pt2, true, context)) continue;
            return false;
        }
        return true;
    }

    public static OCType getExtractExpressionType(OCType type, @NotNull PsiElement context, boolean disallowConst) {
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(15);
        }
        return OCTypeUtils.getExtractExpressionType(type, context, disallowConst, false);
    }

    public static OCType getExtractExpressionType(OCType type, @NotNull PsiElement context, boolean disallowConst, boolean forceReferenceMode) {
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(16);
        }
        if ((type = type.resolve(context)) instanceof OCArrayType) {
            OCArrayType array = (OCArrayType)type;
            type = OCPointerType.to(array.getRefType(), array.getARCAttribute(), array.getClassQualifier(), false, false);
        }
        if (OCTypeUtils.isPassableByReference(type, forceReferenceMode, context)) {
            return OCCppReferenceType.to(disallowConst ? type : type.cloneWithConstModifier(context.getProject()));
        }
        if (!disallowConst && type instanceof OCCppReferenceType) {
            return OCCppReferenceType.to(((OCCppReferenceType)type).getRefType().cloneWithConstModifier(context.getProject()));
        }
        if (!disallowConst && type instanceof OCPointerType && !(type instanceof OCBlockPointerType) && !type.isPointerToObject()) {
            return OCPointerType.to(((OCPointerType)type).getRefType().cloneWithConstModifier(context.getProject()));
        }
        return type;
    }

    public static boolean isPassableByReference(OCType type, boolean forceReferenceMode, PsiElement context) {
        return (forceReferenceMode || type instanceof OCStructType && ((OCStructType)type).getKind() != OCSymbolKind.ENUM || type instanceof OCReferenceType) && !OCCodeInsightUtil.isInPlainOldC(context);
    }

    @Nullable
    public static OCType getCollectionItemType(@NotNull OCType collectionType, final @NotNull OCResolveContext context) {
        OCProtocolSymbol protocol;
        OCObjectType objectType;
        OCClassSymbol symbol;
        if (collectionType == null) {
            OCTypeUtils.$$$reportNull$$$0(17);
        }
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(18);
        }
        if (collectionType instanceof OCObjectType && (symbol = (objectType = (OCObjectType)collectionType).getClassSymbol()) != null && (protocol = (OCProtocolSymbol)OCSymbolBase.findSymbolDefinition("NSFastEnumeration", OCSymbolKind.PROTOCOL, context.getProject(), symbol.getContainingFile())) != null && objectType.implementsProtocol(protocol)) {
            CommonProcessors.FindFirstProcessor<OCMethodSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

                protected boolean accept(OCMethodSymbol o) {
                    OCType returnType = o.getReturnType(context.getProject()).resolve(context);
                    if (returnType instanceof OCPointerType) {
                        returnType = ((OCPointerType)returnType).getRefType();
                    }
                    if (!(returnType instanceof OCObjectType)) {
                        return false;
                    }
                    return "NSEnumerator".equals(((OCObjectType)returnType).getClassName());
                }
            };
            Iterator<String> methodNamesIterator = Arrays.asList("keyEnumerator", "objectEnumerator", null).iterator();
            while (!processor2.isFound() && methodNamesIterator.hasNext()) {
                objectType.processMembers(methodNamesIterator.next(), OCMethodSymbol.class, processor2, true, false);
            }
            if (processor2.isFound()) {
                OCTypeArgument argument;
                List<OCGenericParameterSymbol> parameters;
                OCInterfaceSymbol interfaceSymbol;
                OCMethodSymbol value = (OCMethodSymbol)processor2.getFoundValue();
                assert (value != null);
                OCType returnType = value.getReturnType(context.getProject()).resolve(context);
                if (returnType instanceof OCPointerType) {
                    returnType = ((OCPointerType)returnType).getRefType();
                }
                if ((interfaceSymbol = ((OCObjectType)returnType).getInterface()) != null && !(parameters = interfaceSymbol.getGenericParameters()).isEmpty() && (argument = interfaceSymbol.getSubstitution().getSubstitutionFor(parameters.get(0))) instanceof OCType) {
                    return (OCType)argument;
                }
            }
        }
        return null;
    }

    public static OCType decayType(@NotNull OCType type, @NotNull Project project) {
        if (type == null) {
            OCTypeUtils.$$$reportNull$$$0(19);
        }
        if (project == null) {
            OCTypeUtils.$$$reportNull$$$0(20);
        }
        return OCTypeUtils.decayType(type, project, true);
    }

    public static OCType decayType(@NotNull OCType type, @NotNull Project project, boolean removeCV) {
        if (type == null) {
            OCTypeUtils.$$$reportNull$$$0(21);
        }
        if (project == null) {
            OCTypeUtils.$$$reportNull$$$0(22);
        }
        if (type instanceof OCArrayType) {
            type = OCArrayToPointerChanger.INSTANCE.visitArrayType((OCArrayType)type);
        }
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        if (type instanceof OCFunctionType) {
            type = OCPointerType.to(type);
        }
        return removeCV ? type.cloneWithoutCVQualifiers(project) : type;
    }

    public static boolean isInstanceOfTypeResolved(@Nullable OCExpression expression, Class<? extends OCType> ... typeClasses) {
        if (typeClasses == null) {
            OCTypeUtils.$$$reportNull$$$0(23);
        }
        if (expression == null) {
            return false;
        }
        return OCTypeUtils.isInstanceOfTypeResolved(expression, OCResolveContext.forPsi(expression), typeClasses);
    }

    public static boolean isInstanceOfTypeResolved(@Nullable OCExpression expression, @NotNull OCResolveContext resolveContext, Class<? extends OCType> ... typeClasses) {
        if (resolveContext == null) {
            OCTypeUtils.$$$reportNull$$$0(24);
        }
        if (typeClasses == null) {
            OCTypeUtils.$$$reportNull$$$0(25);
        }
        return OCTypeUtils.isInstanceOfType(OCTypeUtils.getResolvedCppReferencedType(expression, resolveContext), typeClasses);
    }

    @Nullable
    public static OCType getResolvedCppReferencedType(@Nullable OCExpression expression, @NotNull OCResolveContext resolveContext) {
        if (resolveContext == null) {
            OCTypeUtils.$$$reportNull$$$0(26);
        }
        return expression != null ? OCTypeUtils.getResolvedCppReferencedType(expression.getResolvedType(resolveContext), resolveContext) : null;
    }

    @NotNull
    public static OCType getResolvedCppReferencedType(@NotNull OCType type, @NotNull OCResolveContext resolveContext) {
        if (type == null) {
            OCTypeUtils.$$$reportNull$$$0(27);
        }
        if (resolveContext == null) {
            OCTypeUtils.$$$reportNull$$$0(28);
        }
        OCType resolvedType = type.resolve(resolveContext);
        OCType oCType = OCTypeUtils.getCppReferencedType(resolvedType);
        if (oCType == null) {
            OCTypeUtils.$$$reportNull$$$0(29);
        }
        return oCType;
    }

    @Contract(value="!null -> !null")
    @Nullable
    public static OCType getCppReferencedType(@Nullable OCType type) {
        if (type instanceof OCCppReferenceType) {
            return ((OCCppReferenceType)type).getRefType();
        }
        return type;
    }

    public static boolean isCppReferenceType(@Nullable OCType type) {
        return type instanceof OCCppReferenceType;
    }

    public static boolean isInstanceOfType(@Nullable OCType type, Class<? extends OCType> ... typeClasses) {
        if (typeClasses == null) {
            OCTypeUtils.$$$reportNull$$$0(30);
        }
        if (type == null) {
            return false;
        }
        for (Class<? extends OCType> typeClass : typeClasses) {
            if (!typeClass.isInstance(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isIntegralType(@Nullable OCType type) {
        return type instanceof OCIntType;
    }

    public static boolean isEnumType(@Nullable OCType type) {
        return type instanceof OCStructType && ((OCStructType)type).isEnum();
    }

    @Nullable
    public static <T extends OCType> T getAs(@NotNull Class<T> cls, @Nullable OCType type) {
        if (cls == null) {
            OCTypeUtils.$$$reportNull$$$0(31);
        }
        if (type != null && cls.isAssignableFrom(type.getClass())) {
            return (T)type;
        }
        return null;
    }

    @NotNull
    public static OCType doSwitchImplicitConversion(@NotNull OCSwitchStatement swtch, @NotNull OCType switchType) {
        if (swtch == null) {
            OCTypeUtils.$$$reportNull$$$0(32);
        }
        if (switchType == null) {
            OCTypeUtils.$$$reportNull$$$0(33);
        }
        OCResolveContext context = OCResolveContext.forPsi(swtch);
        if (switchType instanceof OCCppReferenceType) {
            switchType = ((OCCppReferenceType)switchType).getRefType();
        }
        if (!(switchType instanceof OCStructType)) {
            if (switchType.isIntegerCompatible(context)) {
                OCIntType oCIntType = OCIntType.INT;
                if (oCIntType == null) {
                    OCTypeUtils.$$$reportNull$$$0(34);
                }
                return oCIntType;
            }
            OCType oCType = switchType;
            if (oCType == null) {
                OCTypeUtils.$$$reportNull$$$0(35);
            }
            return oCType;
        }
        OCStructType clsTy = (OCStructType)switchType;
        if (clsTy.isEnum()) {
            OCStructType oCStructType = clsTy;
            if (oCStructType == null) {
                OCTypeUtils.$$$reportNull$$$0(36);
            }
            return oCStructType;
        }
        Pair<OCType, OCFunctionSymbol> conversionRes = OCTypeCompatibilityVisitor.convertByOperator(clsTy, false, true, context, (Predicate<OCType>)((Predicate)type -> OCTypeUtils.isIntegralType(type) || OCTypeUtils.isEnumType(type)));
        if (conversionRes == null) {
            OCType oCType = switchType;
            if (oCType == null) {
                OCTypeUtils.$$$reportNull$$$0(37);
            }
            return oCType;
        }
        if (!OCVisibility.isVisible((OCSymbol)conversionRes.second, swtch, null, context.getProject())) {
            OCType oCType = switchType;
            if (oCType == null) {
                OCTypeUtils.$$$reportNull$$$0(38);
            }
            return oCType;
        }
        OCType oCType = (OCType)conversionRes.first;
        if (oCType == null) {
            OCTypeUtils.$$$reportNull$$$0(39);
        }
        return oCType;
    }

    public static int getNonVariadicParametersCount(List<? extends OCType> parameterTypes) {
        int count = 0;
        for (OCType oCType : parameterTypes) {
            if (oCType instanceof OCVariadicType || oCType instanceof OCEllipsisType) continue;
            ++count;
        }
        return count;
    }

    @NotNull
    public static List<Object> getDefaultValues(boolean isConstexpr, @NotNull List<OCDeclaratorSymbol> paramSymbols) {
        if (paramSymbols == null) {
            OCTypeUtils.$$$reportNull$$$0(40);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = paramSymbols.size() - 1; i >= 0 && paramSymbols.get(i).hasInitializer(); --i) {
            OCInitializerSymbol initializer = paramSymbols.get(i).getInitializer();
            if (isConstexpr) {
                result.add(0, initializer);
                continue;
            }
            result.add(0, initializer.getPresentableName());
        }
        ArrayList<Object> arrayList = result;
        if (arrayList == null) {
            OCTypeUtils.$$$reportNull$$$0(41);
        }
        return arrayList;
    }

    public static int getNonInitializedParametersCount(@NotNull List<OCDeclaratorSymbol> parameterSymbols, @Nullable OCResolveContext context) {
        if (parameterSymbols == null) {
            OCTypeUtils.$$$reportNull$$$0(42);
        }
        int result = 0;
        for (OCDeclaratorSymbol param : parameterSymbols) {
            OCType paramType = param.getType();
            if (context != null) {
                paramType = paramType.resolve(context.clone());
            }
            if (param.hasInitializer() || paramType instanceof OCEllipsisType || paramType instanceof OCVoidType) break;
            if (paramType instanceof OCVariadicType) {
                List<OCType> expanded;
                if (context == null || (expanded = OCArgumentsList.expandVariadicTypes(Collections.singletonList(paramType), context)).size() == 1 && ContainerUtil.getFirstItem(expanded) == paramType) continue;
                result += expanded.size();
                continue;
            }
            ++result;
        }
        return result;
    }

    public static boolean hasAutoInside(@NotNull OCType type) {
        if (type == null) {
            OCTypeUtils.$$$reportNull$$$0(43);
        }
        return type.accept(new OCBooleanTypeVisitor(){

            @Override
            public Boolean visitAutoType(OCAutoType type) {
                return type.getExpressionSymbol() == null && type.getExpressionElement() == null;
            }
        });
    }

    @NotNull
    public static OCType replaceAutoTypesWithTypeParameters(@NotNull OCType type, final @NotNull Map<OCType, OCType> map2, @NotNull Project project) {
        if (type == null) {
            OCTypeUtils.$$$reportNull$$$0(44);
        }
        if (map2 == null) {
            OCTypeUtils.$$$reportNull$$$0(45);
        }
        if (project == null) {
            OCTypeUtils.$$$reportNull$$$0(46);
        }
        OCType oCType = type.accept(new OCNonPrimitiveTypeCloneVisitor(){

            @Override
            public OCType visitAutoType(OCAutoType type) {
                OCTypeParameterTypeSymbol autoSymbol = new OCTypeParameterTypeSymbol(null, map2.size(), "auto", null, Collections.emptyList(), null, false, true, true, null);
                OCTypeParameterType.ReplacedAutoType newType = new OCTypeParameterType.ReplacedAutoType(autoSymbol, type.isConst(), type.isVolatile());
                map2.put(type, newType);
                return newType;
            }
        });
        if (oCType == null) {
            OCTypeUtils.$$$reportNull$$$0(47);
        }
        return oCType;
    }

    public static boolean isUnresolvedLambdaAutoType(@Nullable OCType type) {
        return type instanceof OCAutoType && ((OCAutoType)type).needsAutoParamsResolving();
    }

    @Nullable
    public static OCType resolveLambdaAutoType(@NotNull OCType type, @NotNull OCResolveContext context, @NotNull OCArgumentsList<? extends OCTypeOwner> argumentsList, boolean failIfNotUnified) {
        OCExpressionSymbol symbol;
        if (type == null) {
            OCTypeUtils.$$$reportNull$$$0(48);
        }
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(49);
        }
        if (argumentsList == null) {
            OCTypeUtils.$$$reportNull$$$0(50);
        }
        if ((symbol = ((OCAutoType)type).getExpressionSymbol()) instanceof OCLambdaExpressionSymbol) {
            return ((OCLambdaExpressionSymbol)symbol).getResolvedType(context, argumentsList, failIfNotUnified);
        }
        return type;
    }

    @Nullable
    public static OCType resolveLambdaAutoType(@NotNull OCType lType, @NotNull OCType rType, @NotNull OCResolveContext context) {
        if (lType == null) {
            OCTypeUtils.$$$reportNull$$$0(51);
        }
        if (rType == null) {
            OCTypeUtils.$$$reportNull$$$0(52);
        }
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(53);
        }
        if (lType.getTerminalType() instanceof OCFunctionType) {
            OCArgumentsList arguments = new OCArgumentsList(((OCFunctionType)lType.getTerminalType()).getParameterTypes(), null);
            OCType resolvedType = OCTypeUtils.resolveLambdaAutoType(rType, context, arguments, false);
            if (resolvedType != null && resolvedType.getTerminalType() instanceof OCFunctionType) {
                return resolvedType;
            }
            ((OCAutoType)rType).setNeedsAutoParamsResolving(false);
            return rType.resolve(context);
        }
        OCExpressionSymbol expressionSymbol = ((OCAutoType)rType).getExpressionSymbol();
        if (expressionSymbol != null) {
            return expressionSymbol.getResolvedType(context);
        }
        return rType;
    }

    public static boolean isSameOrDerivedFrom(OCType derived, OCType base, @NotNull OCResolveContext context) {
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(54);
        }
        return TypeProperties.hasSameUnqualifiedType(derived, base, context) || TypeProperties.IsDerivedFrom(derived, base, context);
    }

    public static boolean isOrIsDerivedFromSpecializationOf(OCType derived, OCType base, @NotNull OCResolveContext context) {
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(55);
        }
        if (!(base instanceof OCStructType) || !(derived instanceof OCStructType)) {
            return false;
        }
        if (!OCTypeUtils.isPrimaryTemplate((OCStructType)base) || OCTypeUtils.isPrimaryTemplate((OCStructType)derived)) {
            return false;
        }
        if (TypeProperties.hasSameUnqualifiedType(derived, base, context)) {
            return true;
        }
        for (OCStructSymbol derivedSymbol : ((OCStructType)derived).getStructs()) {
            Ref result = new Ref((Object)false);
            derivedSymbol.processAllBaseClasses((symbol, visibility) -> {
                if (symbol instanceof OCStructSymbol && !OCTypeUtils.isPrimaryTemplate((OCStructSymbol)symbol) && TypeProperties.hasSameUnqualifiedType(symbol.getResolvedType(context), base, context)) {
                    result.set((Object)true);
                    return false;
                }
                return true;
            }, context);
            if (!((Boolean)result.get()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimaryTemplate(OCStructType type) {
        return OCTypeUtils.isPrimaryTemplate(type.getSymbol());
    }

    public static boolean isPrimaryTemplate(OCStructSymbol symbol) {
        return symbol.isTemplateSymbol() && symbol.getSubstitution().isEmpty();
    }

    public static boolean isPolymorphic(@NotNull OCType type, @NotNull OCResolveContext context) {
        if (type == null) {
            OCTypeUtils.$$$reportNull$$$0(56);
        }
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(57);
        }
        return type.isCppStructType(context) && !((OCStructType)type).processMembers(null, (Processor<? super OCSymbol>)((Processor)symbol -> !(symbol instanceof OCFunctionSymbol) || !((OCFunctionSymbol)symbol).isVirtual()), context);
    }

    public static OCType getSymbolType(@Nullable OCSymbol symbol, @NotNull OCResolveContext context) {
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(58);
        }
        return OCTypeUtils.getSymbolType(symbol, null, context);
    }

    public static OCType getSymbolType(@Nullable OCSymbol symbol, @Nullable OCSymbolReference reference, @NotNull OCResolveContext context) {
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(59);
        }
        if (symbol instanceof OCStructSymbol) {
            return new OCFunctionType(OCVoidType.instance(), Collections.emptyList());
        }
        OCType type = symbol != null ? symbol.getType() : OCUnknownType.INSTANCE;
        type = OCTypeUtils.changeTypeReferences(type, reference, context);
        return type instanceof OCVariadicType ? ((OCVariadicType)type).getUnderlyingType() : type;
    }

    @NotNull
    public static OCType deduceDeclaratorTemplateArguments(@NotNull OCStructType type, OCType unresolvedType, @NotNull OCDeclaratorSymbol symbol, @NotNull OCResolveContext context) {
        OCStructSymbol structSymbol;
        if (type == null) {
            OCTypeUtils.$$$reportNull$$$0(60);
        }
        if (symbol == null) {
            OCTypeUtils.$$$reportNull$$$0(61);
        }
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(62);
        }
        if ((structSymbol = type.getSymbol()).isTemplateSymbol() && !structSymbol.isSpecialization() && structSymbol.getSubstitution().isEmpty()) {
            boolean isListInitialization;
            List<OCExpressionSymbol> initializers;
            OCInitializerSymbol initializerSymbol = symbol.getInitializer();
            if (initializerSymbol != null) {
                initializers = initializerSymbol.getArguments();
                isListInitialization = initializerSymbol.isListInitializer();
            } else {
                initializers = Collections.emptyList();
                isListInitialization = false;
            }
            OCArgumentsList<OCExpressionSymbol> arguments = OCArgumentsList.expandVariadicExpressions(initializers, context);
            return OCTypeUtils.deduceClassTemplateArguments(type, unresolvedType, arguments, isListInitialization, context, symbol.getContainingFile(), symbol.getComplexOffset());
        }
        OCStructType oCStructType = type;
        if (oCStructType == null) {
            OCTypeUtils.$$$reportNull$$$0(63);
        }
        return oCStructType;
    }

    @NotNull
    public static OCType deduceClassTemplateArguments(@NotNull OCStructType type, OCType unresolvedType, OCArgumentsList<?> arguments, boolean isListInitialization, @NotNull OCResolveContext context, @Nullable VirtualFile file, long complexOffset) {
        if (type == null) {
            OCTypeUtils.$$$reportNull$$$0(64);
        }
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(65);
        }
        OCStructSymbol structSymbol = type.getSymbol();
        if (type.getArguments() == null && OCTypeUtils.hasNonDeducedClassTemplateArguments(structSymbol)) {
            OCStructSymbol deducedTypeSymbol;
            OCType deducedType;
            OCFunctionSymbol deductionFunction = OCTypeUtils.findDeductionCandidate(structSymbol, arguments, context, isListInitialization, file, complexOffset);
            OCType oCType = deducedType = deductionFunction != null ? deductionFunction.getEffectiveResolvedType(context) : null;
            if (deducedType instanceof OCStructType && !OCTypeUtils.hasNonDeducedClassTemplateArguments(deducedTypeSymbol = ((OCStructType)deducedType).getSymbol())) {
                if (unresolvedType instanceof OCReferenceType) {
                    List<OCTypeArgument> templateArguments = deducedTypeSymbol.getTemplateArguments(context);
                    OCSymbolReference reference = ((OCReferenceType)unresolvedType).getReference().cloneWithArguments(templateArguments);
                    deducedType = ((OCReferenceType)unresolvedType).cloneWithReference(reference).resolve(context);
                }
                OCType oCType2 = deducedType.cloneWithCVQualifiers(type.getCVQualifiers(), context.getProject());
                if (oCType2 == null) {
                    OCTypeUtils.$$$reportNull$$$0(66);
                }
                return oCType2;
            }
        }
        OCStructType oCStructType = type;
        if (oCStructType == null) {
            OCTypeUtils.$$$reportNull$$$0(67);
        }
        return oCStructType;
    }

    private static boolean hasNonDeducedClassTemplateArguments(OCStructSymbol structSymbol) {
        return structSymbol.isTemplateSymbol() && !structSymbol.isSpecialization() && structSymbol.getSubstitution().isEmpty();
    }

    @Nullable
    private static OCFunctionSymbol findDeductionCandidate(final @NotNull OCStructSymbol structSymbol, @NotNull OCArgumentsList<?> arguments, @NotNull OCResolveContext context, boolean isListInitialization, @Nullable VirtualFile file, long complexOffset) {
        if (structSymbol == null) {
            OCTypeUtils.$$$reportNull$$$0(68);
        }
        if (arguments == null) {
            OCTypeUtils.$$$reportNull$$$0(69);
        }
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(70);
        }
        final HashSet<OCSymbol> deductionCandidates = new HashSet<OCSymbol>();
        CommonProcessors.CollectProcessor<OCSymbol> collector = new CommonProcessors.CollectProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol constructorSymbol) {
                if (constructorSymbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)constructorSymbol).isCppConstructor()) {
                    OCDeductionCandidateSymbol candidate = OCDeductionCandidateSymbol.createFromConstructor(structSymbol, (OCFunctionSymbol)constructorSymbol);
                    return deductionCandidates.add(candidate);
                }
                return false;
            }
        };
        structSymbol.processConstructors((Processor<? super OCFunctionSymbol>)collector);
        OCSymbolReference.SymbolFilter guildeFilter = symbol -> {
            if (!(symbol instanceof OCDeductionGuideSymbol)) {
                return false;
            }
            return OCResolveUtil.isEarlierInCodeWithComplexOffset(symbol, file, complexOffset);
        };
        List<OCSymbol> guides = OCSymbolReference.getGlobalReference(OCQualifiedName.with(structSymbol.getType().getName()), null, null, -1L, guildeFilter).resolveToSymbols(context);
        for (OCSymbol guide : guides) {
            if (!(guide instanceof OCDeductionGuideSymbol)) continue;
            OCDeductionCandidateSymbol candidate = OCDeductionCandidateSymbol.createFromDeductionGuide(structSymbol, (OCDeductionGuideSymbol)guide);
            deductionCandidates.add(candidate);
        }
        deductionCandidates.add(structSymbol);
        FindConstructorResult overloadResult = OCResolveOverloadsUtil.resolveConstructorOverloads(structSymbol.getType(), deductionCandidates, arguments, false, isListInitialization, true, context, null);
        return overloadResult.getSymbol();
    }

    public static OCType changeTypeReferences(@NotNull OCType type, @Nullable OCSymbolReference reference) {
        if (type == null) {
            OCTypeUtils.$$$reportNull$$$0(71);
        }
        return OCTypeUtils.changeTypeReferences(type, reference, null);
    }

    public static OCType changeTypeReferences(@NotNull OCType type, final @Nullable OCSymbolReference reference, final @Nullable OCResolveContext context) {
        if (type == null) {
            OCTypeUtils.$$$reportNull$$$0(72);
        }
        if (reference != null) {
            type = OCTypeCloneVisitor.cloneType(type, new OCTypeCloneVisitor(false){

                @Override
                public OCType visitReferenceType(OCReferenceType type) {
                    if (context != null && context.getResolvingTypeNames().contains(type.getReference().getQualifiedName().dropArguments())) {
                        return type;
                    }
                    return this.cloneReferenceType(type, type.getReference().cloneWithOffset(reference));
                }

                @Override
                public OCType visitDeferredType(OCDeferredType type) {
                    if (context == null) {
                        return super.visitDeferredType(type);
                    }
                    return type.getActualType(context).accept(this);
                }
            });
        }
        return type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 30, 31, 32, 33, 40, 42, 43, 44, 45, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 64, 65, 68, 69, 70, 71, 72 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/types/OCTypeUtils";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 49: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 62: 
            case 65: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectionType";
                break;
            }
            case 19: 
            case 21: 
            case 27: 
            case 43: 
            case 44: 
            case 48: 
            case 56: 
            case 60: 
            case 64: 
            case 71: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: 
            case 22: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 23: 
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeClasses";
                break;
            }
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "swtch";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchType";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramSymbols";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterSymbols";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentsList";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structSymbol";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "deepEqualHashingStrategy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "newReferenceWithSubstitutionSet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "newTypeParameterMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "newTypeSet";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "newTypesMap";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "newDeepEqualityMap";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/types/OCTypeUtils";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedCppReferencedType";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "doSwitchImplicitConversion";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValues";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceAutoTypesWithTypeParameters";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "deduceDeclaratorTemplateArguments";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "deduceClassTemplateArguments";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "areSignaturesEqual";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isSignaturesConformsTo";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getExtractExpressionType";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionItemType";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "decayType";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceOfTypeResolved";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedCppReferencedType";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceOfType";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getAs";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "doSwitchImplicitConversion";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValues";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getNonInitializedParametersCount";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "hasAutoInside";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "replaceAutoTypesWithTypeParameters";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "resolveLambdaAutoType";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isSameOrDerivedFrom";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isOrIsDerivedFromSpecializationOf";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isPolymorphic";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolType";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "deduceDeclaratorTemplateArguments";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "deduceClassTemplateArguments";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "findDeductionCandidate";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "changeTypeReferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 30, 31, 32, 33, 40, 42, 43, 44, 45, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 64, 65, 68, 69, 70, 71, 72 -> new IllegalArgumentException(string);
        };
    }

    private static class DeepHashingStrategy
    implements HashingStrategy<Object> {
        private DeepHashingStrategy() {
        }

        public int hashCode(@Nullable Object object) {
            return object == null ? 0 : object.hashCode();
        }

        public boolean equals(@Nullable Object o1, @Nullable Object o2) {
            return DeepEqual.equalObjects(o1, o2);
        }
    }
}

