/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.ui.OCFileChooserDialog;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCReferenceEditor
extends ReferenceEditorWithBrowseButton {
    public OCReferenceEditor(ActionListener browseActionListener, EditorTextField editorTextField, Function<String, Document> factory) {
        super(browseActionListener, editorTextField, factory);
    }

    public static OCReferenceEditor createFileReferencesEditor(final @NotNull OCFile file) {
        if (file == null) {
            OCReferenceEditor.$$$reportNull$$$0(0);
        }
        final Ref result = Ref.create(null);
        List configurations = OCWorkspace.getInstance((Project)file.getProject()).getConfigurationsForFile(file.getVirtualFile());
        List sources = ContainerUtil.concat((Iterable)ContainerUtil.map((Collection)configurations, OCResolveConfiguration::getSources));
        ClassCompletionProvider completionProvider = new ClassCompletionProvider(sources);
        TextFieldWithAutoCompletion textField = new TextFieldWithAutoCompletion(file.getProject(), (TextFieldWithAutoCompletionListProvider)completionProvider, false, null);
        Function documentFactory = arg_0 -> OCReferenceEditor.lambda$createFileReferencesEditor$0((EditorTextField)textField, arg_0);
        result.set((Object)new OCReferenceEditor(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCFileChooserDialog dialog = new OCFileChooserDialog(OCRefactoringBundle.message("dialog.title.choose.containing.class", new Object[0]), file.getProject());
                dialog.showDialog();
                if (dialog.isOK()) {
                    OCFile selectedFile = (OCFile)dialog.getSelected();
                    ((OCReferenceEditor)((Object)result.get())).setText(selectedFile.getName());
                }
            }
        }, (EditorTextField)textField, (Function<String, Document>)documentFactory));
        return (OCReferenceEditor)((Object)result.get());
    }

    private static Document createNamespaceReferencesDocument(@NotNull OCFile file, @NotNull String text) {
        if (file == null) {
            OCReferenceEditor.$$$reportNull$$$0(1);
        }
        if (text == null) {
            OCReferenceEditor.$$$reportNull$$$0(2);
        }
        OCCodeFragment fragment = OCElementFactory.qualifiedIdCodeFragment(text, PsiTreeUtil.getDeepestLast((PsiElement)file));
        OCSymbolGroupContext symbolContext = new OCSymbolGroupContext("completion context", new OCSymbolKind[0]){

            @Override
            public boolean isSuitableSymbol(OCSymbol symbol) {
                return super.isSuitableSymbol(symbol) && (!(symbol instanceof OCNamespaceSymbol) || !((OCNamespaceSymbol)symbol).isQualifiedContainer());
            }
        };
        symbolContext.addSymbolContext(OCSymbolKind.NAMESPACE);
        symbolContext.addSymbolContext(OCSymbolKind.NAMESPACE_ALIAS);
        fragment.setCompletionFilter(symbolContext);
        return PsiDocumentManager.getInstance((Project)file.getProject()).getDocument((PsiFile)fragment);
    }

    public static EditorTextField createNamespaceReferencesEditor(@NotNull OCFile file, @NotNull String text) {
        if (file == null) {
            OCReferenceEditor.$$$reportNull$$$0(3);
        }
        if (text == null) {
            OCReferenceEditor.$$$reportNull$$$0(4);
        }
        return new EditorTextField(OCReferenceEditor.createNamespaceReferencesDocument(file, text), file.getProject(), (FileType)OCFileType.INSTANCE);
    }

    public static void setReferencesEditorContext(@NotNull EditorTextField field, @NotNull OCFile file) {
        if (field == null) {
            OCReferenceEditor.$$$reportNull$$$0(5);
        }
        if (file == null) {
            OCReferenceEditor.$$$reportNull$$$0(6);
        }
        field.setDocument(OCReferenceEditor.createNamespaceReferencesDocument(file, field.getText()));
    }

    @Nullable
    public OCFile getFile(@NotNull Project project) {
        if (project == null) {
            OCReferenceEditor.$$$reportNull$$$0(7);
        }
        return (OCFile)ContainerUtil.getFirstItem(OCSearchUtil.getProjectOCFilesByName(project, this.getText()));
    }

    private static /* synthetic */ Document lambda$createFileReferencesEditor$0(EditorTextField textField, String s) {
        textField.setText(s);
        return textField.getDocument();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/ui/OCReferenceEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createFileReferencesEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createNamespaceReferencesDocument";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createNamespaceReferencesEditor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setReferencesEditorContext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ClassCompletionProvider
    extends TextFieldWithAutoCompletionListProvider<VirtualFile> {
        protected ClassCompletionProvider(@Nullable Collection<VirtualFile> variants) {
            super(variants);
        }

        protected Icon getIcon(@NotNull VirtualFile file) {
            if (file == null) {
                ClassCompletionProvider.$$$reportNull$$$0(0);
            }
            return null;
        }

        @NotNull
        protected String getLookupString(@NotNull VirtualFile file) {
            if (file == null) {
                ClassCompletionProvider.$$$reportNull$$$0(1);
            }
            String string = file.getName();
            if (string == null) {
                ClassCompletionProvider.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected String getTailText(@NotNull VirtualFile file) {
            VirtualFile parent;
            if (file == null) {
                ClassCompletionProvider.$$$reportNull$$$0(3);
            }
            return (parent = file.getParent()) != null ? parent.getPath() : null;
        }

        protected String getTypeText(@NotNull VirtualFile file) {
            if (file == null) {
                ClassCompletionProvider.$$$reportNull$$$0(4);
            }
            return null;
        }

        public int compare(VirtualFile file1, VirtualFile file2) {
            return file1.getName().compareTo(file2.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/ui/OCReferenceEditor$ClassCompletionProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/ui/OCReferenceEditor$ClassCompletionProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getLookupString";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getTailText";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getTypeText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

