/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution;

import com.intellij.clion.embedded.execution.EmbeddedSettingsState;
import com.intellij.clion.embedded.execution.ui.EmbeddedSettingsUI;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EmbeddedSettingsConfigurable
implements SearchableConfigurable {
    private EmbeddedSettingsUI settingsUI = null;

    @NotNull
    public String getId() {
        return "com.jetbrains.cidr.embedded.config";
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"configurable.EmbeddedSettingsConfigurable.display.name", (Object[])new Object[0]);
    }

    public boolean isModified() {
        EmbeddedSettingsState state = EmbeddedSettingsState.getInstance();
        if (state == null) {
            return true;
        }
        return !StringUtil.equalsTrimWhitespaces((CharSequence)this.settingsUI.openOcdLocation.getText(), (CharSequence)state.openOcdLocation) || !StringUtil.equalsTrimWhitespaces((CharSequence)this.settingsUI.stm32CubeMXLocation.getText().trim(), (CharSequence)state.stm32CubeMXLocation) || !StringUtil.equalsTrimWhitespaces((CharSequence)this.settingsUI.stm32CubeCLTLocation.getText(), (CharSequence)state.stm32CubeCLTLocation);
    }

    public void apply() {
        EmbeddedSettingsState state = EmbeddedSettingsState.getInstance();
        if (state != null) {
            state.openOcdLocation = this.settingsUI.openOcdLocation.getText().trim();
            state.stm32CubeMXLocation = this.settingsUI.stm32CubeMXLocation.getText().trim();
            state.stm32CubeCLTLocation = this.settingsUI.stm32CubeCLTLocation.getText().trim();
        }
    }

    public void disposeUIResources() {
        this.settingsUI = null;
    }

    @Nullable
    public JComponent createComponent() {
        this.settingsUI = new EmbeddedSettingsUI();
        return this.settingsUI.createPanel();
    }

    public void reset() {
        EmbeddedSettingsState state = EmbeddedSettingsState.getInstance();
        this.settingsUI.openOcdLocation.setText(state.openOcdLocation);
        this.settingsUI.stm32CubeMXLocation.setText(state.stm32CubeMXLocation);
        this.settingsUI.stm32CubeCLTLocation.setText(state.stm32CubeCLTLocation);
    }

    @Nullable
    public String getHelpTopic() {
        return "settings.embeddedtools";
    }
}

