/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution;

import com.intellij.clion.embedded.execution.debugtargets.st.STLinkDebugTargetEditor;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\u001a\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u0003\u001a\u000e\u0010\b\u001a\u00020\u0001H\u0086@\u00a2\u0006\u0002\u0010\t\u001a\u0010\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0086@\u00a2\u0006\u0002\u0010\t\u001a\n\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0086@\u00a2\u0006\u0002\u0010\t\"\u0010\u0010\u0000\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0003\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"DEFAULT_OPENOCD_LOCATION", "Ljava/nio/file/Path;", "DEFAULT_STM32CUBEMX_LOCATION", "STM32CUBECLT_BASE_LOCATION", "findExecutableInPath", "", "name", "defaultPath", "detectOpenOCD", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "detectSTM32CubeMX", "detectSTM32CubeCLTFromEnv", "detectSTM32CubeCLT", "intellij.clion.embedded"})
public final class EmbeddedSettingsDetectionKt {
    @JvmField
    @NotNull
    public static final Path DEFAULT_OPENOCD_LOCATION;
    @JvmField
    @NotNull
    public static final Path DEFAULT_STM32CUBEMX_LOCATION;
    @JvmField
    @NotNull
    public static final Path STM32CUBECLT_BASE_LOCATION;

    @Contract(value="_, !null -> !null")
    private static final String findExecutableInPath(String name, String defaultPath) {
        File file;
        if (SystemInfo.isWindows) {
            return PathEnvironmentVariableUtil.findExecutableInWindowsPath((String)name, (String)defaultPath);
        }
        File file2 = file = PathEnvironmentVariableUtil.findInPath((String)name);
        return file2 == null ? defaultPath : file2.getAbsolutePath();
    }

    @Nullable
    public static final Object detectOpenOCD(@NotNull Continuation<? super Path> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>(null){
            int label;

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        String string = ((Object)EmbeddedSettingsDetectionKt.DEFAULT_OPENOCD_LOCATION).toString();
                        String string2 = EmbeddedSettingsDetectionKt.access$findExecutableInPath("openocd", string);
                        Intrinsics.checkNotNull((Object)string2);
                        Path path = Paths.get(string2, new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                        return path;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public static final Object detectSTM32CubeMX(@NotNull Continuation<? super Path> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>(null){
            int label;

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (Files.isExecutable(EmbeddedSettingsDetectionKt.DEFAULT_STM32CUBEMX_LOCATION)) {
                            return EmbeddedSettingsDetectionKt.DEFAULT_STM32CUBEMX_LOCATION;
                        }
                        if (SystemInfo.isWindows) {
                            Path path = Paths.get("C:\\Program Files\\STMicroelectronics\\STM32Cube\\STM32CubeMX\\STM32CubeMX.exe", new String[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                            Path fallback = path;
                            if (Files.isExecutable(fallback)) {
                                return fallback;
                            }
                        }
                        return null;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private static final Path detectSTM32CubeCLTFromEnv() {
        String fromEnv = EnvironmentUtil.getValue((String)"STM32CLT_PATH");
        if (fromEnv != null) {
            Path path = Paths.get(fromEnv, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }
        String fromPath = EmbeddedSettingsDetectionKt.findExecutableInPath(STLinkDebugTargetEditor.Companion.getGDBSERVER_EXECUTABLE(), null);
        if (fromPath != null) {
            Path path = Paths.get(fromPath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path.getParent().getParent().getParent();
        }
        return null;
    }

    @Nullable
    public static final Object detectSTM32CubeCLT(@NotNull Continuation<? super Path> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>(null){
            int label;

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = fromEnv = EmbeddedSettingsDetectionKt.access$detectSTM32CubeCLTFromEnv();
                        if (v0 != null) {
                            return v0;
                        }
                        it /* !! */  = var4_3 /* !! */  = EmbeddedSettingsDetectionKt.STM32CUBECLT_BASE_LOCATION;
                        $i$a$-takeIf-EmbeddedSettingsDetectionKt$detectSTM32CubeCLT$2$1 = false;
                        v1 = new LinkOption[]{};
                        v2 = var3_6 = Files.isDirectory(it /* !! */ , Arrays.copyOf(v1, v1.length)) != false ? var4_3 /* !! */  : null;
                        if (var3_6 == null || (var4_3 /* !! */  = PathsKt.listDirectoryEntries((Path)var3_6, (String)"STM32CubeCLT*")) == null) ** GOTO lbl29
                        it /* !! */  = var4_3 /* !! */ ;
                        $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            it = (Path)element$iv;
                            $i$a$-firstOrNull-EmbeddedSettingsDetectionKt$detectSTM32CubeCLT$2$2 = false;
                            v3 = new LinkOption[]{};
                            if (!Files.isDirectory(it, Arrays.copyOf(v3, v3.length))) continue;
                            v4 = element$iv;
                            ** GOTO lbl27
                        }
                        v4 = null;
lbl27:
                        // 2 sources

                        v5 = v4;
                        ** GOTO lbl30
lbl29:
                        // 1 sources

                        v5 = null;
lbl30:
                        // 2 sources

                        return v5;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static final /* synthetic */ String access$findExecutableInPath(String name, String defaultPath) {
        return EmbeddedSettingsDetectionKt.findExecutableInPath(name, defaultPath);
    }

    public static final /* synthetic */ Path access$detectSTM32CubeCLTFromEnv() {
        return EmbeddedSettingsDetectionKt.detectSTM32CubeCLTFromEnv();
    }

    static {
        Path path;
        Path path2;
        Path path3;
        if (SystemInfo.isWindows || SystemInfo.isMac) {
            String string = SystemProperties.getUserHome();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserHome(...)");
            Path path4 = Paths.get(string, new String[0]);
            path3 = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
        } else {
            Path path5 = Paths.get("/usr/bin/openocd", new String[0]);
            path3 = path5;
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"get(...)");
        }
        DEFAULT_OPENOCD_LOCATION = path3;
        if (SystemInfo.isWindows) {
            String string = SystemProperties.getUserHome();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserHome(...)");
            Path path6 = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"get(...)");
            Path path7 = path6.resolve("AppData\\Local\\Programs\\STM32CubeMX\\STM32CubeMX.exe");
            path2 = path7;
            Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"resolve(...)");
        } else if (SystemInfo.isMac) {
            Path path8 = Paths.get("/Applications/STMicroelectronics/STM32CubeMX.app/Contents/Resources/STM32CubeMX", new String[0]);
            path2 = path8;
            Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"get(...)");
        } else {
            String string = SystemProperties.getUserHome();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserHome(...)");
            Path path9 = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"get(...)");
            Path path10 = path9.resolve("STM32CubeMX/STM32CubeMX");
            path2 = path10;
            Intrinsics.checkNotNullExpressionValue((Object)path10, (String)"resolve(...)");
        }
        DEFAULT_STM32CUBEMX_LOCATION = path2;
        if (SystemInfo.isWindows) {
            Path path11 = Paths.get("C:\\ST", new String[0]);
            path = path11;
            Intrinsics.checkNotNullExpressionValue((Object)path11, (String)"get(...)");
        } else if (SystemInfo.isMac) {
            Path path12 = Paths.get("/opt/ST", new String[0]);
            path = path12;
            Intrinsics.checkNotNullExpressionValue((Object)path12, (String)"get(...)");
        } else {
            Path path13 = Paths.get("/opt/st", new String[0]);
            path = path13;
            Intrinsics.checkNotNullExpressionValue((Object)path13, (String)"get(...)");
        }
        STM32CUBECLT_BASE_LOCATION = path;
    }
}

